<?php
use Elementor\Element_Base;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Schemes\Color;
use Elementor\Schemes\Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;

defined('ABSPATH') || die();

class Mo_Elementor_Custom_Controls {

	public static function init() {
        add_action( 'elementor/element/column/section_advanced/after_section_end', [ __CLASS__, 'add_controls_section' ], 1 );
		add_action( 'elementor/element/section/section_advanced/after_section_end', [ __CLASS__, 'add_controls_section' ], 1 );
        add_action( 'elementor/element/container/section_layout/after_section_end', [ __CLASS__, 'add_controls_section' ], 1 );

		add_action( 'elementor/frontend/before_render', [ __CLASS__, 'before_section_render' ], 1 );
        
        // Mo Annimations
        add_action( 'elementor/element/after_section_end', function( $element, $section_id ) {

            if (
                ( $element->get_name() === 'container' && 'section_layout' === $section_id) ||
                'section_advanced' === $section_id ||
                '_section_style' === $section_id
            ) {

                $element->start_controls_section(
                    'mo-custom_animations',
                    [
                        'label' => __( 'Animations', 'saga' ),
                        'tab' => Controls_Manager::TAB_ADVANCED,
                    ]
                );
                mo_content_animation( $element ); // call content animation options

                $element->end_controls_section();
            }
        }, 10, 2 );
	}
    public static function add_controls_section( Element_Base $element) {

        $is_container = 'container' === $element->get_name();
        $is_section = 'section' === $element->get_name();

        if ( $is_container || $is_section ) {

            $element->start_controls_section(
                'mo_custom_row_heading',
                [
                    'label' => __( 'Section Options', 'saga' ),
                    'tab'   => Controls_Manager::TAB_LAYOUT,
                ]
            );

                $page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers( 'page' );
			    $page_settings_model = $page_settings_manager->get_model( get_the_ID() );

                $element->add_control(
                    'mo_bgcolor_data_attr',
                    [
                        'label' => __( 'Background Mod', 'saga' ),
                        'type' => Controls_Manager::CHOOSE,
                        'options' => [
                            'default-auto' => [
                                'title' => __( 'Automatic', 'saga' ),
                                'icon' => 'fa fa-adjust',
                            ],
                            'dark' => [
                                'title' => __( 'Dark', 'saga' ),
                                'icon' => 'fa fa-moon',
                            ],
                            'light' => [
                                'title' => __( 'Light', 'saga' ),
                                'icon' => 'fa fa-sun',
                            ],
                        ],
                        'default' => 'default-auto',
                        'toggle' => false,
                    ]
                );
                $element->add_control(
                    'mo_row_divider',
                    [
                        'label' => __( 'Row Divider', 'saga' ),
                        'type' => Controls_Manager::SELECT,
                        'options' => array(
                            'style0'  => esc_html__('none', 'saga'),
                            'style1_top'     => esc_html__('Style 1 top', 'saga'),
                            'style1_bottom'  => esc_html__('Style 1 bottom', 'saga'),
                            'style2_top'     => esc_html__('Style 2 top', 'saga'),
                            'style2_bottom'  => esc_html__('Style 2 bottom', 'saga'),
                            'style3_top'     => esc_html__('Style 3 top', 'saga'),
                            'style3_bottom'  => esc_html__('Style 3 bottom', 'saga'),
                        ),
                        'default' => 'style0',
                        'toggle' => false,
                    ]
                );
            $element->end_controls_section();
        }
	}

	public static function before_section_render( Element_Base $element ) {

         // Section bgcolor
		if ( $element->get_settings( 'mo_bgcolor_data_attr' ) && 'default-auto' !== $element->get_settings( 'mo_bgcolor_data_attr' ) ) {
            $element->add_render_attribute( '_wrapper', [
                'data-section-bgcolor' => $element->get_settings( 'mo_bgcolor_data_attr' ),
            ] );
        }

         // Section divider
		if ( $element->get_settings( 'mo_row_divider' ) && 'style0' !== $element->get_settings( 'mo_row_divider' ) ) {
            $element->add_render_attribute( '_wrapper', [
                'data-section-divider' => $element->get_settings( 'mo_row_divider' ),
            ] );
        }

         // Animation
         if ( $element->get_settings( 'mo-custom_animation' ) ) {
           
            $ca_preset_values = array();
            $ca_opts = $ca_from_values = $ca_to_values = array();
            $animation_targets = array();

            $animation_preset = $element->get_settings( 'mo-ca_preset' );
            $ca_ease = $element->get_settings( 'mo-ca_settings_ease' );
            $ca_direction = $element->get_settings( 'mo-ca_settings_direction' );
            $ca_duration = $element->get_settings( 'mo-ca_settings_duration' )['size'];
            $ca_stagger = $element->get_settings( 'mo-ca_settings_stagger' )['size'];
            $ca_start_delay = $element->get_settings( 'mo-ca_settings_start_delay' )['size'];

            $ca_opts['addChildTimelines'] = false;

            switch ( $element->get_name() ){
                case 'container': 
                    array_push($animation_targets, ':scope > .elementor-element:not(.mo-exclude-parent-ca) > .elementor-widget-container');
                    array_push($animation_targets, ':scope .e-container:not([data-parallax]) > .elementor-element > .elementor-widget-container');
                    array_push($animation_targets, ':scope > .elementor-widget-heading-fancy .mo-split-lines .mo-lines .split-inner');
                    array_push($animation_targets, ':scope > .elementor-widget-heading-fancy .mo-split-words .mo-words .split-inner');
                    array_push($animation_targets, ':scope > .elementor-widget-heading-fancy .mo-split-chars .mo-chars .split-inner');
                    array_push($animation_targets, ':scope > .elementor-widget-mo_custom_menu .mo-fancy-menu > ul > li');
                    array_push($animation_targets, ':scope .e-container:not([data-parallax]) > .elementor-widget-heading-fancy .mo-split-lines .mo-lines .split-inner');
                    array_push($animation_targets, ':scope .e-container:not([data-parallax]) > .elementor-widget-heading-fancy .mo-split-words .mo-words .split-inner');
                    array_push($animation_targets, ':scope .e-container:not([data-parallax]) > .elementor-widget-heading-fancy .mo-split-chars .mo-chars .split-inner');
                    array_push($animation_targets, ':scope .e-container:not([data-parallax]) > .elementor-widget-mo_custom_menu .mo-fancy-menu > ul > li');
                case 'section': 
                    array_push($animation_targets, ':scope > .elementor-container > .elementor-column');
                break;
                case 'column':
                    array_push($animation_targets, ':scope > .elementor-widget-wrap > .elementor-element > .elementor-widget-container');
                    array_push($animation_targets, ':scope > .elementor-widget-wrap > .elementor-section > .elementor-container > .elementor-column > .elementor-widget-wrap > .elementor-element:not(.mo-el-has-inner-anim) > .elementor-widget-container');
                    array_push($animation_targets, ':scope > .elementor-widget-wrap > .elementor-widget-heading-fancy .mo-split-lines .mo-lines .split-inner');
                    array_push($animation_targets, ':scope > .elementor-widget-wrap > .elementor-widget-heading-fancy .mo-split-words .mo-words .split-inner');
                    array_push($animation_targets, ':scope > .elementor-widget-wrap > .elementor-widget-heading-fancy .mo-split-chars .mo-chars .split-inner');
                    array_push($animation_targets, ':scope > .elementor-widget-wrap > .elementor-widget-mo_custom_menu .mo-fancy-menu > ul > li');
                break;
                default:
                    if( $element->get_name() === 'heading-fancy' && $element->get_settings( 'enable_split' ) ){
                        
                        $split_type = $element->get_settings( 'split_type' );

                        if ( $split_type === 'lines' ){
                            array_push($animation_targets, '.mo-split-lines .mo-lines .split-inner');
                        } else if ( $split_type === 'words' ){
                            array_push($animation_targets, '.mo-split-words .mo-words .split-inner');
                        } else if ( $split_type === 'chars, words' ){
                            array_push($animation_targets, '.mo-split-chars .mo-chars .split-inner');
                        }
                    } else if ( $element->get_name() === 'mo_custom_menu' ) {
                        array_push($animation_targets, ':scope .mo-fancy-menu > ul > li');
                    } else {
                        array_push($animation_targets, ':scope > .elementor-widget-container');
                    }
                break;
            }

            $ca_opts['animationTarget'] = implode(', ', $animation_targets);
            
            if ( !empty( $ca_duration ) && $ca_duration !== 1.6 ) {
                $ca_opts['duration'] = (float) ($ca_duration * 1000);
            }
            if( !empty( $ca_start_delay ) && $ca_start_delay !== 0 ) {
                $ca_opts['startDelay'] = (float) ($ca_start_delay * 1000);
            }
            if ( !empty( $ca_stagger ) && $ca_stagger !== 0.16 ) {
                $ca_opts['delay'] = (float) ($ca_stagger * 1000);
            }
            if ( $ca_ease !== 'power4.out' ) {
                $ca_opts['ease'] = $ca_ease;
            }
            if ( $ca_direction !== 'forward' ) {
                $ca_opts['direction'] = $ca_direction;
            }
            
            if( 'custom' !== $animation_preset ) {

                $defined_animations = array(

                    'Fade In' => array(
                        'from' => array( 'opacity' => 0 ),
                        'to'   => array( 'opacity' => 1 ),
                    ),
                    'Fade In Down' => array(
                        'from' => array( 'opacity' => 0, 'translateY' => -150 ),
                        'to'   => array( 'opacity' => 1, 'translateY' => 0 ),
                    ),
                    'Fade In Up' => array(
                        'from' => array( 'opacity' => 0, 'translateY' => 150 ),
                        'to'   => array( 'opacity' => 1, 'translateY' => 0 ),
                    ),
                    'Fade In Left' => array(
                        'from' => array( 'opacity' => 0, 'translateX' => -150 ),
                        'to'   => array( 'opacity' => 1, 'translateX' => 0 ),
                    ),
                    'Fade In Right' => array(
                        'from' => array( 'opacity' => 0, 'translateX' => 150 ),
                        'to'   => array( 'opacity' => 1, 'translateX' => 0 ),
                    ),
                    'Flip In Y' => array(
                        'from' => array( 'opacity' => 0, 'translateX' => 150, 'rotationY' => 30 ),
                        'to'   => array( 'opacity' => 1, 'translateX' => 0, 'rotationY' => 0 ),
                    ),
                    'Flip In X' => array(
                        'from' => array( 'opacity' => 0, 'translateY' => 150, 'rotationX' => -30 ),
                        'to'   => array( 'opacity' => 1, 'translateY' => 0, 'rotationX' => 0 ),
                    ),
                    'Scale Up' => array(
                        'from' => array( 'opacity' => 0, 'scale' => 0.75 ),
                        'to'   => array( 'opacity' => 1, 'scale' => 1 ),
                    ),
                    'Scale Down' => array(
                        'from' => array( 'opacity' => 0, 'scale' => 1.25 ),
                        'to'   => array( 'opacity' => 1, 'scale' => 1 ),
                    ),
            
                );
                
                $ca_preset_values = $defined_animations[ $animation_preset ];
                $ca_from_values = $ca_preset_values['from'];
                $ca_to_values = $ca_preset_values['to'];
            }
            else {

                // From values
                $ca_from_x = $element->get_settings( 'mo-ca_from_x' );
                $ca_from_y = $element->get_settings( 'mo-ca_from_y' );
                $ca_from_z = $element->get_settings( 'mo-ca_from_z' );

                $ca_from_scaleX = $element->get_settings( 'mo-ca_from_scaleX' );
                $ca_from_scaleY = $element->get_settings( 'mo-ca_from_scaleY' );

                $ca_from_rotationX = $element->get_settings( 'mo-ca_from_rotationX' );
                $ca_from_rotationY = $element->get_settings( 'mo-ca_from_rotationY' );
                $ca_from_rotationZ = $element->get_settings( 'mo-ca_from_rotationZ' );

                $ca_from_transformOriginX = $element->get_settings( 'mo-ca_from_transformOriginX' );
                $ca_from_transformOriginY = $element->get_settings( 'mo-ca_from_transformOriginY' );
                $ca_from_transformOriginZ = $element->get_settings( 'mo-ca_from_transformOriginZ' );
                
                $ca_from_opacity = $element->get_settings( 'mo-ca_from_opacity' );
            
                // To values
                $ca_to_x = $element->get_settings( 'mo-ca_to_x' );
                $ca_to_y = $element->get_settings( 'mo-ca_to_y' );
                $ca_to_z = $element->get_settings( 'mo-ca_to_z' );

                $ca_to_scaleX = $element->get_settings( 'mo-ca_to_scaleX' );
                $ca_to_scaleY = $element->get_settings( 'mo-ca_to_scaleY' );

                $ca_to_rotationX = $element->get_settings( 'mo-ca_to_rotationX' );
                $ca_to_rotationY = $element->get_settings( 'mo-ca_to_rotationY' );
                $ca_to_rotationZ = $element->get_settings( 'mo-ca_to_rotationZ' );

                $ca_to_transformOriginX = $element->get_settings( 'mo-ca_to_transformOriginX' );
                $ca_to_transformOriginY = $element->get_settings( 'mo-ca_to_transformOriginY' );
                $ca_to_transformOriginZ = $element->get_settings( 'mo-ca_to_transformOriginZ' );
                
                $ca_to_opacity = $element->get_settings( 'mo-ca_to_opacity' );

                if ( !empty( $ca_from_x ) && !empty( $ca_to_x ) && $ca_from_x != $ca_to_x ) {
                    $ca_from_values['x'] = $ca_from_x['size'].$ca_from_x['unit'];
                    $ca_to_values['x'] = $ca_to_x['size'].$ca_to_x['unit'];
                }
                if ( !empty( $ca_from_y ) && !empty( $ca_to_y ) && $ca_from_y != $ca_to_y ) {
                    $ca_from_values['y'] = $ca_from_y['size'].$ca_from_y['unit'];
                    $ca_to_values['y'] = $ca_to_y['size'].$ca_to_y['unit'];
                }
                if ( !empty( $ca_from_z ) && !empty( $ca_to_z ) && $ca_from_z != $ca_to_z ) {
                    $ca_from_values['z'] = $ca_from_z['size'].$ca_from_z['unit'];
                    $ca_to_values['z'] = $ca_to_z['size'].$ca_to_z['unit'];
                }
                
                if ( !empty( $ca_from_scaleX ) && !empty( $ca_to_scaleX ) && $ca_from_scaleX != $ca_to_scaleX ) {
                    $ca_from_values['scaleX'] = (float) $ca_from_scaleX['size'];
                    $ca_to_values['scaleX'] = (float) $ca_to_scaleX['size'];
                }
                if ( !empty( $ca_from_scaleY ) && !empty( $ca_to_scaleY ) && $ca_from_scaleY != $ca_to_scaleY ) {
                    $ca_from_values['scaleY'] = (float) $ca_from_scaleY['size'];
                    $ca_to_values['scaleY'] = (float) $ca_to_scaleY['size'];
                }
    
                if ( !empty( $ca_from_rotationX ) && !empty( $ca_to_rotationX ) && $ca_from_rotationX != $ca_to_rotationX ) {
                    $ca_from_values['rotationX'] = (int) $ca_from_rotationX['size'];
                    $ca_to_values['rotationX'] = (int) $ca_to_rotationX['size'];
                }
                if ( !empty( $ca_from_rotationY ) && !empty( $ca_to_rotationY ) && $ca_from_rotationY != $ca_to_rotationY ) {
                    $ca_from_values['rotationY'] = (int) $ca_from_rotationY['size'];
                    $ca_to_values['rotationY'] = (int) $ca_to_rotationY['size'];
                }
                if ( !empty( $ca_from_rotationZ ) && !empty( $ca_to_rotationZ ) && $ca_from_rotationZ != $ca_to_rotationZ ) {
                    $ca_from_values['rotationZ'] = (int) $ca_from_rotationZ['size'];
                    $ca_to_values['rotationZ'] = (int) $ca_to_rotationZ['size'];
                }
    
                if ( !empty( $ca_from_opacity ) && !empty( $ca_to_opacity ) && $ca_from_opacity != $ca_to_opacity ) {
                    $ca_from_values['opacity'] = (float) $ca_from_opacity['size'];
                    $ca_to_values['opacity'] = (float) $ca_to_opacity['size'];
                }
            
                $ca_from_toriginX = isset( $ca_from_transformOriginX ) && ! empty( $ca_from_transformOriginX ) ? $ca_from_transformOriginX['size'].$ca_from_transformOriginX['unit'] : '';
                $ca_from_toriginY = isset( $ca_from_transformOriginY ) && ! empty( $ca_from_transformOriginY ) ? $ca_from_transformOriginY['size'].$ca_from_transformOriginY['unit'] : '';
                $ca_from_toriginZ = isset( $ca_from_transformOriginZ ) && ! empty( $ca_from_transformOriginZ ) ? $ca_from_transformOriginZ['size'].$ca_from_transformOriginZ['unit'] : '';
            
                $ca_to_toriginX = isset( $ca_to_transformOriginX ) && ! empty( $ca_to_transformOriginX ) ? $ca_to_transformOriginX['size'].$ca_to_transformOriginX['unit'] : '';
                $ca_to_toriginY = isset( $ca_to_transformOriginY ) && ! empty( $ca_to_transformOriginY ) ? $ca_to_transformOriginY['size'].$ca_to_transformOriginY['unit'] : '';
                $ca_to_toriginZ = isset( $ca_to_transformOriginZ ) && ! empty( $ca_to_transformOriginZ ) ? $ca_to_transformOriginZ['size'].$ca_to_transformOriginZ['unit'] : '';

                if (
                    ! empty( $ca_from_toriginX ) && ! empty( $ca_from_toriginY ) && ! empty( $ca_from_toriginZ ) &&
                    ! empty( $ca_to_toriginX ) && ! empty( $ca_to_toriginY ) && ! empty( $ca_to_toriginZ )
                ) {

                    $ca_from_values['transformOrigin'] = $ca_from_toriginX . ' ' . $ca_from_toriginY . ' ' . $ca_from_toriginZ;
                    $ca_to_values['transformOrigin'] = $ca_to_toriginX . ' ' . $ca_to_toriginY . ' ' . $ca_to_toriginZ;

                    if ( $ca_from_values['transformOrigin'] == $ca_to_values['transformOrigin'] ) {
                        unset($ca_from_values['transformOrigin']);
                        unset($ca_to_values['transformOrigin']);
                    }

                }
            }

            $ca_opts['initValues'] = !empty( $ca_from_values ) ? $ca_from_values : array();
            $ca_opts['animations'] = !empty( $ca_to_values ) ? $ca_to_values : array();

            $element->add_render_attribute( '_wrapper', [
                'data-custom-animations' => 'true',
                'data-ca-options' => stripslashes( wp_json_encode( $ca_opts ) ),
            ] );

        }
	}
}
Mo_Elementor_Custom_Controls::init();