<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

class MOElement_Teams_Carousel extends MOElement_Base{

    public function get_name() {
        return 'mo-teams-carousel';
    }
    public function get_title() {
        return __('Teams Carousel', 'saga');
    }
    public function get_icon() {
        return 'eicon-person';
    }
    public function get_keywords() {
        return [ 'team', 'content', 'carousel' ];
    }
    public function get_script_depends() {
      return [
          'jquery.owl.carousel',
          'saga.elements',
      ];
    }
    public function get_style_depends() {
      return array('owl-carousel-css');
    }
    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_Team',
            [
                'label' => __('Content', 'saga'),
            ]
        );
        $this->add_control( 
            'style',
            array(
                'label'   => esc_html__( 'Style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                  'tpl1' => esc_html__('Style 1', 'saga'),
                  'tpl2' => esc_html__('Style 2', 'saga'),
                  'tpl3' => esc_html__('Style 3', 'saga'),
                ],
				'default' => 'tpl1',
            )
         );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
			'team_name',
			[
				'label'       => __('Name', 'saga'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Mona Zaghloul', 'saga'),
			]
		);
		$repeater->add_control(
			'team_position',
			[
                'label'   => __('Position', 'saga'),
                'default' => esc_html__('Developer', 'saga'),
                'type'    => Controls_Manager::TEXT,
			]
		);
        $repeater->add_control(
			'team_image',
			[
				'label' => __( 'Choose Image', 'saga' ),
				'type' => Controls_Manager::MEDIA,
				//'default' => ['url' => Elementor\Utils::get_placeholder_image_src(),],
			]
		);
        $this->add_control(
            'teams',
            [
                'label'       => __('Team Item', 'saga'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '',
                'default'     => array(
                    array(
                        'team_name'     => esc_html__( 'Mona zaghloul', 'saga' ),
                        'team_position' => esc_html__( 'Web Developer', 'saga' ),
                        'team_image'    => [
                            'url' => SAGA_URI . 'elementor/assets/images/team.png',
                        ]
                    ),
                    array(
                        'team_name'     => esc_html__( 'Mai Kamal', 'saga' ),
                        'team_position' => esc_html__( 'CEO Develpoment', 'saga' ),
                        'team_image'    => [
                            'url' => SAGA_URI . 'elementor/assets/images/team.png',
                        ]
                    ),
                    array(
                        'team_name'     => esc_html__( 'Mahmoud Mo', 'saga' ),
                        'team_position' => esc_html__( 'UI Developer', 'saga' ),
                        'team_image'    => [
                            'url' => SAGA_URI . 'elementor/assets/images/team.png',
                        ]
                    ),
                    array(
                        'team_name'     => esc_html__( 'Sara El Said', 'saga' ),
                        'team_position' => esc_html__( 'Web Designer', 'saga' ),
                        'team_image'    => [
                            'url' => SAGA_URI . 'elementor/assets/images/team.png',
                        ]
                    ),
                ),
            ]
        );
        $this->end_controls_section();
        $this->add_control_carousel(false);
    }
    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
          include $this->get_template('mo-teams-carousel.php');
        print '</div>';
      }
}