<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

class MOElement_Marquee_Carousel extends MOElement_Base{

    public function get_name() {
        return 'mo-marquee';
    }
    public function get_title() {
        return __('Marquee', 'saga');
    }
    public function get_icon() {
        return 'eicon-person';
    }
    public function get_keywords() {
        return [ 'marquee', 'content', 'carousel' ];
    }
    public function get_script_depends() {
      return [
          'jquery.owl.carousel',
          'saga.elements',
      ];
    }
    public function get_style_depends() {
      return array('owl-carousel-css');
    }
    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_marquee',
            [
                'label' => __('Content', 'saga'),
            ]
        );
        $this->add_control( 
            'style',
            array(
                'label'   => esc_html__( 'Style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                  'tpl1' => esc_html__('Style 1', 'saga'),
                  'tpl2' => esc_html__('Style 2', 'saga'),
                  'tpl3' => esc_html__('Style 3', 'saga'),
                ],
				'default' => 'tpl1',
            )
         );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
			'marquee_name',
			[
				'label'       => __('Title', 'saga'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Mona Zaghloul', 'saga'),
			]
		);
        $this->add_control(
            'marquee',
            [
                'label'       => __('Marquee Item', 'saga'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '',
                'default'     => array(
                    array(
                        'marquee_name'     => esc_html__( 'I was super happy when I got the package! It’s the best skin care product I’ve ever used!', 'saga' ),
                    ),
                    array(
                        'marquee_name'     => esc_html__( 'I feel amazing when I use Saga Cosmetics.', 'saga' ),
                    ),
                ),
            ]
        );
        $this->end_controls_section();


        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Style', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'color',
			[
				'label' => __( 'Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .mo-marquee.tpl1 .marquee-title, {{WRAPPER}} .mo-marquee.tpl2 .marquee-title' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mo-marquee.tpl3 .marquee-title' => '-webkit-text-stroke-color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'bg_color',
			[
				'label' => __( 'Background Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .mo-marquee' => 'background: {{VALUE}};',
				],
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
				'label' => __( 'Typography', 'saga' ),
				'selector' => '{{WRAPPER}} .mo-marquee .marquee-title',
			]
		);
		$this->end_controls_section();
       // $this->add_control_carousel(false);
    }
    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
        $settings = $this->get_settings_for_display();
        printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
          include $this->get_template('mo-marquee-carousel.php');
        print '</div>';
      }
}