<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

class MOElement_List_Number extends MOElement_Base{

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'mo-list-number';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('List Number', 'saga');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-bullet-list';
    }

    public function get_keywords() {
        return [ 'list', 'number' ];
    }

    public function get_script_depends() {
      return [];
    }

    public function get_style_depends() {
      return array();
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_list',
            [
                'label' => __('Number List', 'saga'),
            ]
        );
        $this->add_control(
            'list_items',
            [
                'label'       => __('Content Item', 'saga'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => [
                    [
                        'name'        => 'title',
                        'label'       => __('Title', 'saga'),
                        'type'        => Controls_Manager::TEXT,
                        'default'     => esc_html__('Services for a global network of creators.', 'saga'),
                        'label_block' => true,
                    ],
                    [
                        'name'    => 'content',
                        'label'   => __('Content', 'saga'),
                        'type'    => Controls_Manager::TEXTAREA,
                    ],
                   
                ],
                'title_field' => '{{{ title }}}',
                'default'     => array(
                    array(
                        'title'     => esc_html__('Services for a global network of creators', 'saga' ),
                    ),
                    array(
                        'title'     => esc_html__('About our workspace offering' ),
                    ),
                ),
            ]
        );
        $this->end_controls_section();

        $this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Style', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'style',
            array(
                'label'   => esc_html__( 'Style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                  'style1' => esc_html__('Style 1', 'saga'),
                  'style2' => esc_html__('Style 2', 'saga'),
                  'style3' => esc_html__('Style 3', 'saga'),
                  'style4' => esc_html__('Style 4', 'saga'),
                  'style5' => esc_html__('Style 5', 'saga'),
                  'style6' => esc_html__('Style 6', 'saga')
                ]
            )
         );
        $this->add_control(
			'color',
			[
				'label' => __( 'Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .list-style li h4' => 'color: {{VALUE}};',
				]
			]
		);
        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'saga' ),
				'selector' => '{{WRAPPER}} .list-style li h4',
			]
		);
        $this->end_controls_section();
    }

    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
      $settings = $this->get_settings_for_display();
      printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
      include $this->get_template('mo-list-number.php');
      print '</div>';
    }
}