<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Css_Filter;
use Elementor\Repeater;

/**
 * Elementor heading widget.
 *
 * Elementor widget that displays an eye-catching headlines.
 *
 * @since 1.0.0
 */
    class MOElement_Image extends MOElement_Base{
	public function get_name() {
		return 'mo-image';
	}
	public function get_title() {
		return __( 'Image Fancy', 'saga' );
	}
	public function get_icon() {
		return 'eicon-image mo-element';
	}
	public function get_keywords() {
		return [ 'image', 'fancy', 'gallery' ];
	}
	public function get_script_depends() {
		return [
			'saga.elements',
		];
	 }
	/**
	 * Register heading widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		// General Section
		$this->start_controls_section(
			'general_section',
			[
				'label' => __( 'General', 'saga' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
		$this->add_control(
			'image',
			[
				'label' => __( 'Image', 'saga' ),
				'type' => Controls_Manager::MEDIA,
			]
		);
		$this->add_responsive_control(
			'image_align',
			[
				'label' => __( 'Alignment', 'saga' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'saga' ),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'saga' ),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'saga' ),
						'icon' => 'eicon-text-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy-container' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'img_link',
			[
				'label' => __( 'Link', 'saga' ),
				'type' => Controls_Manager::URL,
				'placeholder' => __( 'https://your-link.com', 'saga' ),
				'separator' => 'before',
			]
		);
		$this->add_control(
			'enable_lightbox',
			[
				'label' => __( 'Add lightbox?', 'saga' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'saga' ),
				'label_off' => __( 'Off', 'saga' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);
		$this->end_controls_section();
		

		// Size
		$this->start_controls_section(
			'size_section',
			[
				'label' => __( 'Size', 'saga' ),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);

		$this->add_group_control(
			Group_Control_Image_Size::get_type(),
			[
				'name' => 'thumbnail', 
				'exclude' => [ 
					'woocommerce_thumbnail',
					'woocommerce_single',
					'woocommerce_gallery_thumbnail',
					'shop_catalog',
					'shop_single',
					'shop_thumbnail',
				 ],
				'include' => [],
				'default' => 'full',
			]
		);
		$this->add_responsive_control(
			'mo-width',
			[
				'label' => esc_html__( 'Width', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%', 'px', 'vw' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy .mo-img-fancy-container figure' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'mo-max-width',
			[
				'label' => esc_html__( 'Max Width', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => '%',
				],
				'tablet_default' => [
					'unit' => '%',
				],
				'mobile_default' => [
					'unit' => '%',
				],
				'size_units' => [ '%', 'px', 'vw' ],
				'range' => [
					'%' => [
						'min' => 1,
						'max' => 100,
					],
					'px' => [
						'min' => 1,
						'max' => 1000,
					],
					'vw' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy .mo-img-fancy-container figure' => 'max-width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'mo-height',
			[
				'label' => esc_html__( 'Height', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'unit' => 'px',
				],
				'tablet_default' => [
					'unit' => 'px',
				],
				'mobile_default' => [
					'unit' => 'px',
				],
				'size_units' => [ 'px', 'vh' ],
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 500,
					],
					'vh' => [
						'min' => 1,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy .mo-img-fancy-container figure' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'custom_image_size',
			[
				'label' => __( 'Percentage image size', 'saga' ),
				'type' => Controls_Manager::NUMBER,
				'placeholder' => __( 'ex: 50', 'saga' ),
				'description' => __( 'Choose the image size based on its container.', 'saga' ),
				'selectors' => [
					'{{WRAPPER}}' => 'width: auto',
					'{{WRAPPER}} .mo-img-fancy-container' => 'width: {{VALUE}}%',
				]
			]
		);
		$this->end_controls_section();

		// Style
		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Style', 'saga' ),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);
		$this->add_group_control(
			Group_Control_Css_Filter::get_type(),
			[
				'name' => 'mo-css_filters',
				'selector' => '{{WRAPPER}} img',
			]
		);
		// Opacity
		$this->add_control(
			'mo-opacity',
			[
				'label' => __( 'Opacity', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.05,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy' => 'opacity: {{SIZE}}',
				],
				'separator' => 'before'
			]
		);
		$this->add_control(
			'mo-hover_opacity',
			[
				'label' => __( 'Hover opacity', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.05,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy:hover' => 'opacity: {{SIZE}}',
				],
			]
		);
		// Roundness
		$this->add_control(
			'enable_roudness',
			[
				'label' => __( 'Add roundness?', 'saga' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'saga' ),
				'label_off' => __( 'Off', 'saga' ),
				'return_value' => 'yes',
				'default' => '',
				'separator' => 'before',
			]
		);
		$this->add_control(
			'image_roudness',
			[
				'label' => __( 'Border radius', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => '2px',
				'options' => [
					'2px'  => __( '2px', 'saga' ),
					'4px'  => __( '4px', 'saga' ),
					'5px'  => __( '5px', 'saga' ),
					'6px'  => __( '6px', 'saga' ),
					'8px'  => __( '8px', 'saga' ),
					'10px' => __( '10px', 'saga' ),
					'20px' => __( '20px', 'saga' ),
					'25px' => __( '25px', 'saga' ),
					'50px' => __( '50px', 'saga' ),
					'50em' => __( '50em (Circle)', 'saga' ),
				],
				'condition' => [
					'enable_roudness' => 'yes'
				],
				'selectors' => [
					'{{WRAPPER}} figure, {{WRAPPER}} figure img' => 'border-radius: {{VALUE}};',
				],
			]
		);
		// Shadow
		$this->add_control(
			'enable_image_shadow',
			[
				'label' => __( 'Add shadow?', 'saga' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'saga' ),
				'label_off' => __( 'Off', 'saga' ),
				'return_value' => 'yes',
				'default' => '',
				'separator' => 'before',
			]
		);
		$this->add_control(
			'shadow_style',
			[
				'label' => __( 'Shadow', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => '1',
				'options' => [
					'1' => __( 'Shadow Depth 1', 'saga' ),
					'2' => __( 'Shadow Depth 2', 'saga' ),
					'3' => __( 'Shadow Depth 3', 'saga' ),
					'4' => __( 'Shadow Depth 4', 'saga' ),
				],
				'condition' => [
					'enable_image_shadow' => 'yes'
				]
			]
		);
        // Overlay
		$this->add_control(
			'enable_overlay_bg',
			[
				'label' => __( 'Add overlay background', 'saga' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'saga' ),
				'label_off' => __( 'Off', 'saga' ),
				'return_value' => 'yes',
				'default' => '',
				'separator' => 'before'
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'overlay_bg',
				'label' => __( 'Background', 'saga' ),
				'types' => [ 'classic', 'gradient' ],
				'exclude' => ['classic' => 'image'],
				'selector' => '{{WRAPPER}} .mo-img-fancy-overlay-bg',
				'condition' => [
					'enable_overlay_bg' => 'yes'
				]
			]
		);
		$this->end_controls_section();
		
		//  Effect
		$this->start_controls_section(
			'effect_section',
			[
				'label' => __( 'Effect', 'saga' ),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);
		// Reveal effect 
		$this->add_control(
			'enable_reveal',
			[
				'label' => __( 'Reveal effect', 'saga' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'saga' ),
				'label_off' => __( 'Off', 'saga' ),
				'return_value' => 'yes',
				'default' => '',
				
			]
		);
		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'reveal_color',
				'label' => __( 'Background', 'saga' ),
				'types' => [ 'classic' ],
				'exclude' => [ 'image' ],
				'selector' => '{{WRAPPER}} .block-revealer__element',
				'condition' => [
					'enable_reveal' => 'yes'
				]
			]
		);
		$this->add_control(
			'reveal_direction',
			[
				'label' => __( 'Direction', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'lr',
				'options' => [
					'lr' => __( 'Left - Right', 'saga' ),
					'tb' => __( 'Top - Bottom', 'saga' ),
					'rl' => __( 'Right - Left', 'saga' ),
					'bt' => __( 'Bottom - Top', 'saga' ),
				],
				'condition' => [
					'enable_reveal' => 'yes'
				]
			]
		);
		// Float effect 
		$this->add_control(
			'enable_float_effect',
			[
				'label' => __( 'Floating effect?', 'saga' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'saga' ),
				'label_off' => __( 'Off', 'saga' ),
				'return_value' => 'yes',
				'default' => '',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'float_animate_from',
			[
				'label' => __( 'Float animate from', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'default' => '0%',
				'condition' => [
					'enable_float_effect' => 'yes'
				],
				'render_type' => 'template',
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy[data-float]' => '--float-animate-from: {{VALUE}}'
				]
			]
		);

		$this->add_control(
			'float_animate_to',
			[
				'label' => __( 'Float animate to', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'default' => '3%',
				'condition' => [
					'enable_float_effect' => 'yes'
				],
				'render_type' => 'template',
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy[data-float]' => '--float-animate-to: {{VALUE}}'
				]
			]
		);

		$this->add_control(
			'float_delay',
			[
				'label' => __( 'Float delay', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'default' => '0s',
				'condition' => [
					'enable_float_effect' => 'yes'
				],
				'render_type' => 'template',
				'description' => __( 'Float starting delay. value can be in seconds or milliseconds. e.g. 0.5s or 500ms.', 'saga' ),
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy[data-float]' => '--float-delay: {{VALUE}}'
				]
			]
		);

		$this->add_control(
			'float_easing',
			[
				'label' => __( 'Float easing', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'ease',
				'options' => [
					'ease' => __( 'Ease', 'saga' ),
					'ease-in' => __( 'Ease In', 'saga' ),
					'ease-out' => __( 'Ease Out', 'saga' ),
					'ease-in-out' => __( 'Ease In Out', 'saga' ),
					'custom_ease' => __( 'Custom Ease', 'saga' ),
				],
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy[data-float]' => '--float-animation-ease: {{VALUE}}'
				],
				'condition' => [
					'enable_float_effect' => 'yes'
				]
			]
		);

		$this->add_control(
			'float_custom_ease',
			[
				'label' => __( 'Custom float easing', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy[data-float]' => '--float-animation-ease: {{VALUE}}'
				],
				'condition' => [
					'float_easing' => 'custom_ease'
				]
			]
		);
        // Hover 3D
		$this->add_control(
			'enable_hover3d',
			[
				'label' => __( 'Enable hover 3d?', 'saga' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'saga' ),
				'label_off' => __( 'Off', 'saga' ),
				'return_value' => 'yes',
				'default' => '',
				'separator' => 'before',
			]
		);

		$this->add_control(
			'hover3d_stacking_factor',
			[
				'label' => __( 'Stacking factor, use integer number', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'default' => '1',
				'condition' => [
					'enable_hover3d' => 'yes'
				]
			]
		);
		$this->end_controls_section();


		// Side Label
		$this->start_controls_section(
			'sidelabel_section',
			[
				'label' => __( 'Side label', 'saga' ),
				'tab' => Controls_Manager::TAB_CONTENT
			]
		);
		$this->add_control(
			'enable_side_label',
			[
				'label' => __( 'Add side label', 'saga' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'saga' ),
				'label_off' => __( 'Off', 'saga' ),
				'return_value' => 'yes',
				'default' => '',
			]
		);
		$this->add_control(
			'label',
			[
				'label' => __( 'Side label', 'saga' ),
				'type' => Controls_Manager::TEXTAREA,
				'condition' => [
					'enable_side_label' => 'yes'
				]
			]
		);
		$this->add_control(
			'label_side',
			[
				'label' => __( 'Content alignment', 'saga' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'mo-img-fancy-content-fixed-left' => [
						'title' => __( 'Left', 'saga' ),
						'icon' => 'eicon-h-align-left',
					],
					'mo-img-fancy-content-fixed-right' => [
						'title' => __( 'Right', 'saga' ),
						'icon' => 'eicon-h-align-right',
					],
				],
				'default' => 'mo-img-fancy-content-fixed-left',
				'toggle' => false,
				'condition' => [
					'enable_side_label' => 'yes'
				]
			]
		);
		$this->add_control(
			'label_pos',
			[
				'label' => __( 'Content alignment', 'saga' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => __( 'Start', 'saga' ),
						'icon' => 'eicon-v-align-top',
					],
					'center' => [
						'title' => __( 'Center', 'saga' ),
						'icon' => 'eicon-v-align-middle',
					],
					'end' => [
						'title' => __( 'End', 'saga' ),
						'icon' => 'eicon-v-align-bottom',
					],
				],
				'default' => 'center',
				'toggle' => false,
				'condition' => [
					'enable_side_label' => 'yes',
					'enable_side_label_overlay' => '',
				]
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'label_typography',
				'label' => __( 'Typography', 'saga' ),
				'selector' => '{{WRAPPER}} .mo-img-fancy-content p',
				'condition' => [
					'enable_side_label' => 'yes'
				]
			]
		);

		$this->add_control(
			'enable_side_label_overlay',
			[
				'label' => __( 'Side label overlay', 'saga' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'On', 'saga' ),
				'label_off' => __( 'Off', 'saga' ),
				'return_value' => 'mo-img-fancy-content-fixed-in',
				'default' => '',
				'condition' => [
					'enable_side_label' => 'yes'
				]
			]
		);
		
		$this->add_control(
			'label_color',
			[
				'label' => __( 'Label color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy-content-fixed-left,{{WRAPPER}} .mo-img-fancy-content-fixed-right' => 'color: {{VALUE}}',
				],
				'condition' => [
					'enable_side_label' => 'yes'
				]
			]
		);

		$this->add_control(
			'label_overlay_bgcolor',
			[
				'label' => __( 'Overlay background color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .mo-img-fancy-content-fixed-in' => 'background: {{VALUE}}',
				],
				'condition' => [
					'enable_side_label' => 'yes',
					'enable_side_label_overlay!' => ''
				]
			]
		);
		$this->end_controls_section();
	}

protected function get_data_options() {
    $settings = $this->get_settings_for_display();
    $opts = array();
    $shadow = $settings['enable_image_shadow'];
    $shadow_style = $settings['shadow_style'];
    $hover3d = $settings['enable_hover3d'];
    if( $settings['enable_image_shadow'] ) {
        $opts[] = 'data-shadow-style="' . $shadow_style . '"';
    }
    if( $hover3d ) {
        $opts[] = 'data-hover3d="true"';
    }
    if( empty( $opts ) ) {
        return;
    }
    return implode( ' ', $opts );	
}

protected function get_data_float_effect() {
    $settings = $this->get_settings_for_display();
    $enable_float_effect = $settings['enable_float_effect'];
    $float_easing = $settings['float_easing'];
    $float_custom_ease = $settings['float_custom_ease'];
    $easing = $float_easing;
    if( $float_easing === 'custom_ease' && ! empty($float_custom_ease) ) {
        $easing = $float_custom_ease;
    }
    if ( $enable_float_effect ) {
        return 'data-float="' . $easing . '"';
    }
}

protected function get_data_stacking_factor() {
    $settings = $this->get_settings_for_display();
    $hover3d = $settings['enable_hover3d'];
    $hover3d_stacking_factor = $settings['hover3d_stacking_factor'];
    if( $hover3d === 'yes' ) {
        return 'data-stacking-factor="' . $hover3d_stacking_factor . '"';
    }
}

protected function get_reveal_data() {
    $settings = $this->get_settings_for_display();
    $reveal = $settings['enable_reveal'];
    $data = array();
    if( $reveal ) {
        $reveal_opts = array( 'direction' => $settings['reveal_direction'] );
        $data[] = 'data-reveal="true"';
        $data[] = 'data-reveal-options=\'' . wp_json_encode( $reveal_opts ) . '\'';
    }
    if ( empty( $data ) ) {
        return;
    }
    return implode( ' ', $data );	
}

protected function get_label($pos) {
    $settings = $this->get_settings_for_display();
    if (
        (
            $pos === 'before' &&
            $settings['enable_side_label_overlay'] === 'mo-img-fancy-content-fixed-in'
        ) ||
        (
            $pos === 'inside' &&
            $settings['enable_side_label_overlay'] !== 'mo-img-fancy-content-fixed-in'
        )
    ) {
        return;
    }
    $label = $settings['label'];
    $side = $settings['label_side'];
    $side_overlay = 'mo-img-fancy-content-fixed ' . $settings['enable_side_label_overlay'];
    if( empty( $label ) ) {
        return;
    }
    printf( '<div class="mo-img-fancy-content %s %s"><div class="mo-img-fancy-content-inner"><p>%s</p></div></div>', esc_attr( $side ), $side_overlay, wp_kses_post( $label ) );		

}


protected function get_overlay_bg() {
    $settings = $this->get_settings_for_display();
    if( !$settings['enable_overlay_bg'] ) {
        return '';
    }
    echo '<span class="mo-overlay mo-img-fancy-overlay-bg"></span>';
}

protected function get_overlay_link() {
    $settings = $this->get_settings_for_display();
    $link['href'] =  $settings['img_link']['url'];
    if ( !empty( $link['href'] ) ) {
          printf( '<a href="%s" class="mo-overlay"></a>', $link['href']);
    }
}

protected function get_lightbox_link() {
    $settings = $this->get_settings_for_display();
    $link['href'] =  $settings['img_link']['url'];
	$lightbox = $settings['enable_lightbox'];
    if ( empty( $link['href'] ) && $lightbox ) {
        printf( '<a href="%s" class="mo-overlay"></a>', wp_get_attachment_image_url( $settings['image']['id'], 'full', false ) );
    } 
}

/**
 * Render heading widget output on the frontend.
 *
 * Written in PHP and used to generate the final HTML.
 *
 * @since 1.0.0
 * @access protected
 */
protected function render() {
    $settings = $this->get_settings_for_display();
    $wrapper_class = array(
        'mo-img-fancy ', $settings['enable_hover3d'] === 'yes' ? 'perspective' : '',
    );
    $container_class = array(
        'mo-img-fancy-container ',
        'align-items-' . ($settings['label_pos'] ? $settings['label_pos'] : 'center ') ,
        $settings['enable_hover3d'] === 'yes' ? 'transform-style-3d ' : '',
    );
?>

<div class="<?php foreach($wrapper_class as $w_class){ echo $w_class . "\n";} ?>" <?php echo $this->get_data_options(); ?> <?php echo $this->get_data_float_effect() ?> >
		<div class="<?php foreach($container_class as $class){ echo $class;} ?>">
		<?php $this->get_label('before') ?>
		<figure <?php echo $this->get_data_stacking_factor() ?> <?php echo $this->get_reveal_data(); ?> >
			<?php echo Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image' ); ?>
			<?php $this->get_overlay_bg(); ?>
			<?php $this->get_label('inside') ?>
			<?php $this->get_overlay_link(); ?>
			<?php $this->get_lightbox_link(); ?>
		</figure>
			
	</div>
</div>

<?php
  }
}