<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
/**
 * Elementor icon box widget.
 *
 * Elementor widget that displays an icon, a headline and a text.
 *
 * @since 1.0.0
 */
class MOElement_Counter extends MOElement_Base {  

	/**
	 * Get widget name.
	 *
	 * Retrieve icon box widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'mo-counter';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve icon box widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Counter', 'saga' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve icon box widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-icon-box';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'counter', 'icon' ];
	}

	public function get_script_depends() {
      return [
		 'jquery.waypoint',
         'jquery.count_to',
         'jquery.appear',
		 'saga.elements',
      ];
   }

	/**
	 * Register icon box widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'saga' ),
			]
		);
		$this->add_control(
			'style',
			[
				'label' => __( 'Style', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style1'  => __( 'Style 1', 'saga' ),
					'style2'  => __( 'Style 2', 'saga' ),
					'style3'  => __( 'Style 3', 'saga' ),
					'style4'  => __( 'Style 4', 'saga' ),
				],
				'default' => 'style1',
			]
		);
		$this->add_control(
			'number',
			[
				'label' => __( 'Number', 'saga' ),
				'type' => Controls_Manager::NUMBER,
				'default' => 110
			]
		);
		$this->add_control(
			'symbol',
			[
				'label' => __( 'Symbol', 'saga' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'title',
			[
				'label' => __( 'Title', 'saga' ),
				'type' => Controls_Manager::TEXT,
			]
		);
		$this->add_control(
			'description',
			[
				'label' => __( 'Description', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'default' => __( 'This is the heading', 'saga' ),
				'placeholder' => __( 'Enter your title', 'saga' ),
				'label_block' => true,
			]
		);
		$this->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon Class', 'saga' ),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-home',
					'library' => 'fa-solid',
				],
			]
		);
		$this->end_controls_section();


		// Style Icon
		$this->start_controls_section(
			'section_style_icon',
			[
				'label' => __( 'Icon', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Icon Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .counter-number .icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .counter-number .icon svg' => 'fill: {{VALUE}};'
				],
			]
		);

		$this->add_control(
			'icon_color_hover',
			[
				'label' => __( 'Hover | Icon Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .counter-number:hover .icon i' => 'color: {{VALUE}};',
					'{{WRAPPER}} .counter-number:hover .icon svg' => 'fill: {{VALUE}};'
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Icon Size', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 70
				],
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .counter-number .icon i' => 'font-size: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .counter-number .icon svg' => 'width: {{SIZE}}{{UNIT}};'
				],
			]
		);
		$this->end_controls_section();

		// Number Text
		$this->start_controls_section(
			'sectionn_number_style',
			[
				'label' => __( 'Number Text', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
			'number_text_color',
			[
				'label' => __( 'Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .counter-number h3, .counter-number .symbol' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_responsive_control(
			'number_bottom_space',
			[
				'label' => __( 'Font size', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 40,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .counter-number h3, .counter-number symbol' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render icon box widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
         include $this->get_template('mo-counter.php');
      print '</div>';
	}
}