<?php
if ( ! isset( $content_width ) ) $content_width = 900;
if ( ! function_exists( 'wp_body_open' ) ) {
	function wp_body_open() {
			do_action( 'wp_body_open' );
	}
}
if ( ! function_exists( 'saga_setup' ) ) {
	function saga_setup() {
		global $saga_options;
		load_theme_textdomain( 'saga', get_template_directory() . '/languages' );
		// Add Custom Header.
		add_theme_support('custom-header');
		// Add RSS feed links to <head> for posts and comments.
		add_theme_support( 'automatic-feed-links' );
		// Enable support for Post Thumbnails, and declare sizes.
		add_theme_support( 'post-thumbnails' );
		// Theme resize image
		add_image_size( 'saga-small' , 720, 520, array( 'center', 'center' ) );  
		add_image_size( 'saga-medium',  720, 720 , array( 'center', 'center' ) );
		add_image_size( 'saga-lg-height' , 720 );  // 780 pixels wide (and unlimited height)

		add_image_size( 'saga-full'  , 1500, 730, true ); //header carousel
		add_image_size( 'saga-team' , 263 , 331, true );
		add_image_size( 'saga-thumb' , 100 , 100, true );
		
		
		//Enable support for Title Tag
		 add_theme_support( "title-tag" );
		// This theme uses wp_nav_menu() in locations.
		register_nav_menus( array(
			'main_navigation'  => __( 'Main Menu','saga' ),
		) );
		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form', 'gallery', 'caption' ) );
		/*
		 * Enable support for Post Formats.
		 * See http://codex.wordpress.org/Post_Formats
		 */
		add_theme_support( 'post-formats', array(
			'video', 'audio', 'quote', 'link', 'gallery',
		) );
		//Support Gutenberg
		add_theme_support( 'gutenberg', array( 'wide-images' => true ));
		add_theme_support( 'responsive-embeds' );
		add_theme_support( 'wp-block-styles' );
		add_theme_support( 'align-wide' );
		add_theme_support( 'editor-styles' );
		
		// This theme allows users to set a custom background.
		add_theme_support( 'custom-background', apply_filters( 'saga_custom_background_args', array(
			'default-color' => 'f5f5f5',
		) ) );
		// Add support for featured content.
		add_theme_support( 'featured-content', array(
			'featured_content_filter' => 'saga_get_featured_posts',
			'max_posts' => 6,
		) );
		
		// This theme uses its own gallery styles.
		add_filter( 'use_default_gallery_style', '__return_false' );
	}
}
add_action( 'after_setup_theme', 'saga_setup' );

/*-----------------------------------------------*
  Customize Body Class
/*-----------------------------------------------*/
function saga_body_class( $classes ) {
	global $saga_options;
	$body_layout =& $saga_options["body_layout"];
    if ( $body_layout == 'boxed' || ( get_post_meta( get_the_ID(), 'tb_body_layout', true ) == 'boxed' ) ) 
      {
		$classes[] = 'boxed';
      }
	  elseif( $body_layout == 'lines' || ( get_post_meta( get_the_ID(), 'tb_body_layout', true ) == 'lines' ) )
	  {
		$classes[] = 'lines';
      }
	   elseif( $body_layout == 'shapes' || ( get_post_meta( get_the_ID(), 'tb_body_layout', true ) == 'shapes' ) )
	  {
		$classes[] = 'shapes';
      }
	  else {
		$classes[] = 'wide';
	  }
    return $classes;
}
add_filter( 'body_class', 'saga_body_class' );

/*-----------------------------------------------*
  dark mode
/*-----------------------------------------------*/
function saga_dark_mode( $classes ) {
	global $saga_options;
	//$dark_mode = (int) isset($saga_options['dark_mode'])? $saga_options['dark_mode']: 1;
	$dark_mode = 'active-light-mode';
	$dark_mode = isset($saga_options['dark_mode']) && $saga_options['dark_mode'];

	if ( $dark_mode ){ $classes[] = 'dark-mode-on'; }
    return $classes;
}
add_filter( 'body_class', 'saga_dark_mode' );



/*-----------------------------------------------*
  cursor
/*-----------------------------------------------*/
function saga_cursor() {
    global $saga_options;
    $cursor_layout =& $saga_options["select_cursor"];
	$tb_cursor = get_post_meta(get_the_ID(), 'tb_select_cursor', true)?get_post_meta(get_the_ID(), 'tb_select_cursor', true):'global';
	$cursor_layout = $tb_cursor=='global'?$cursor_layout:$tb_cursor;
    switch ($cursor_layout) {
		case 'style1': 
             echo '<div class="mouse-cursor style1"></div>';
            break;
        case 'style2':
             echo '<div class="mouse-cursor style2"></div>';
            break;
		case 'style3':
             echo '<div class="mouse-cursor style3"></div>';
            break;
		case 'style4':
			echo '<div class="mouse-cursor style4"></div>';
			break;
    }
}
/*-----------------------------------------------*
  Logo
/*-----------------------------------------------*/
if (!function_exists('saga_logo')) {
	function saga_logo() {
		global $saga_options;
		$logo_white = $logo_main_page = '';
		$logo = $logo_page = get_post_meta(get_the_ID(), 'tb_logo', true);
		if(!empty($logo_page)) { $logo_main_page = 'logo_page'; }
		if($logo == '') {
			$logo = isset($saga_options['tb_logo']['url']) && $saga_options['tb_logo']['url'] ? $saga_options['tb_logo']['url'] : SAGA_URI_PATH.'/assets/images/logo.png';
			if (isset($saga_options['tb_logo_white']['url']) && $saga_options['tb_logo_white']['url'] != ""){ $logo_white = $saga_options['tb_logo_white']['url'];}else{ $logo_white =  SAGA_URI_PATH.'/assets/images/logo-white.png'; };
		}
		if(!empty($logo_white)) {
			echo '<img class="Logo_white" src="'.esc_url($logo_white).'" alt="'.esc_attr__('logo','saga').'" />';
		}
		echo '<img class="logo '.esc_attr($logo_main_page).'" src="'.esc_url($logo).'" alt="'.esc_attr__('logo','saga').'"/>';
	}
}

/*-----------------------------------------------*
  Header , Footer
/*-----------------------------------------------*/
function saga_header() {
    global $saga_options;
    $header_layout =& $saga_options["tb_header_layout"];
	$tb_header = get_post_meta(get_the_ID(), 'tb_header', true)?get_post_meta(get_the_ID(), 'tb_header', true):'global';
	$header_layout = $tb_header=='global'?$header_layout:$tb_header;
    switch ($header_layout) {
        case 'sidepanel':
            get_template_part('framework/headers/header', 'v1');
            break;
		case 'header-v2':
            get_template_part('framework/headers/header', 'v2');
            break;
		case 'header-v3':
            get_template_part('framework/headers/header', 'v3');
            break;
		case 'header-v4':
            get_template_part('framework/headers/header', 'v4');
            break;
		case 'header-v5':
            get_template_part('framework/headers/header', 'v5');
            break;
		case 'header-v6':
            get_template_part('framework/headers/header', 'v6');
            break;
	    case 'header-v7':
            get_template_part('framework/headers/header', 'v7');
            break;		
		default :
			get_template_part('framework/headers/header', 'v2');
			break;
    }
}
function saga_footer() {
    global $saga_options;
    $footer_layout =& $saga_options["tb_footer_layout"];
	$tb_footer = get_post_meta(get_the_ID(), 'tb_footer', true)?get_post_meta(get_the_ID(), 'tb_footer', true):'global';
	$footer_layout = $tb_footer=='global'?$footer_layout:$tb_footer;
    switch ($footer_layout) {
		case 'footer-v0':
            get_template_part('framework/footers/footer', 'v0');
            break;
        case 'footer-v1':
            get_template_part('framework/footers/footer', 'v1');
            break;
		case 'footer-v2':
            get_template_part('framework/footers/footer', 'v2');
            break;
		case 'footer-v3':
            get_template_part('framework/footers/footer', 'v3');
            break;
		case 'footer-v4':
            get_template_part('framework/footers/footer', 'v4');
            break;
		default :
			get_template_part('framework/footers/footer', 'v0');
			break;
    }
}
/*-----------------------------------------------*
  Page title
/*-----------------------------------------------*/
if (!function_exists('saga_page_title')) {
    function saga_page_title() { 
            ob_start();
			if( is_home() ){ esc_html__('Home', 'saga');
			}elseif(is_search()){ esc_html__('Search', 'saga');
            }elseif(is_404()){ esc_html__('Page Not Found ', 'saga');
            }elseif (!is_archive()) { the_title();
            } else { 
                if (is_category()){ single_cat_title();
				}elseif( get_post_type() == 'portfolio' || get_post_type() == 'product' || get_post_type() == 'team' || get_post_type() == 'Testimonials' ){ single_term_title();
				}elseif (is_tag()){ single_tag_title();
				}elseif (is_author()){ printf( esc_html__('Author: %s', 'saga'), '<span class="vcard">' . get_the_author() . '</span>');
				}elseif (is_day()){ printf( esc_html__('Day: %s', 'saga'), '<span>' . get_the_date() . '</span>');
				}elseif (is_month()){ printf( esc_html__('Month: %s', 'saga'), '<span>' . get_the_date() . '</span>');
				}elseif (is_year()){ printf( esc_html__('Year: %s', 'saga'), '<span>' . get_the_date() . '</span>');
				}elseif (is_tax('post_format', 'post-format-aside')){ esc_html__('Asides', 'saga');
				}elseif (is_tax('post_format', 'post-format-gallery')){ esc_html__('Galleries', 'saga');
				}elseif (is_tax('post_format', 'post-format-image')){ esc_html__('Images', 'saga');
				}elseif (is_tax('post_format', 'post-format-video')){ esc_html__('Videos', 'saga');
				}elseif (is_tax('post_format', 'post-format-quote')){ esc_html__('Quotes', 'saga');
				}elseif (is_tax('post_format', 'post-format-link')){ esc_html__('Links', 'saga');
				}elseif (is_tax('post_format', 'post-format-status')){ esc_html__('Statuses', 'saga');
				}elseif (is_tax('post_format', 'post-format-audio')){ esc_html__('Audios', 'saga');
				}elseif (is_tax('post_format', 'post-format-chat')){ esc_html__('Chats', 'saga');
				}else{ esc_html__('Archives', 'saga');
                }
            }
            return ob_get_clean();
    }
}
/*-----------------------------------------------*
  Page breadcrumb 
/*-----------------------------------------------*/
if (!function_exists('saga_page_breadcrumb')) {
    function saga_page_breadcrumb($delimiter) {
            ob_start();
            $home = esc_html__('Home', 'saga');
            global $post;
            $homeLink = esc_url( home_url('/') );
			if( is_home() ){
				esc_html__('Home', 'saga');
			}else{
				echo '<a href="' . $homeLink . '">' . $home . '</a> ' . $delimiter . ' ';
			}
            if ( is_category() ) {
                $thisCat = get_category(get_query_var('cat'), false);
                if ($thisCat->parent != 0) echo get_category_parents($thisCat->parent, TRUE, ' ' . $delimiter . ' ');
                echo '<span class="current">' . esc_html__('Archive by category: ', 'saga') . single_cat_title('', false) . '</span>';
            } elseif ( is_search() ) {
                echo '<span class="current">' . esc_html__('Search results for: ', 'saga') . get_search_query() . '</span>';
            } elseif ( is_day() ) {
                echo '<a href="' . get_month_link(get_the_time('Y'),get_the_time('m')) . '">' . get_the_time('F').' '. get_the_time('Y') . '</a> ' . $delimiter . ' ';
                echo '<span class="current">' . get_the_time('d') . '</span>';
            } elseif ( is_month() ) {
                echo '<span class="current">' . get_the_time('F'). ' '. get_the_time('Y') . '</span>';
            } elseif ( is_single() && !is_attachment() ) {
            if ( get_post_type() != 'post' ) {
                if(get_post_type() == 'portfolio'){
                    $terms = get_the_terms(get_the_ID(), 'project-type', '' , '' );
                    if($terms) {
                        the_terms(get_the_ID(), 'project-type', '' , ', ' );
                        echo ' ' . $delimiter . ' ' . '<span class="current">' . get_the_title() . '</span>';
                    }else{
                        echo '<span class="current">' . get_the_title() . '</span>';
                    }
                }elseif(get_post_type() == 'team'){
                    echo '<span class="current">' . get_the_title() . '</span>';
                }elseif(get_post_type() == 'testimonials'){
                    echo '<span class="current">' . get_the_title() . '</span>';
                }elseif(get_post_type() == 'product'){
                    $terms = get_the_terms(get_the_ID(), 'product_cat', '' , '' );
                    if($terms) {
                        the_terms(get_the_ID(), 'product_cat', '' , ', ' );
                        echo ' ' . $delimiter . ' ' . '<span class="current">' . get_the_title() . '</span>';
                    }else{
                        echo '<span class="current">' . get_the_title() . '</span>';
                    }
                }else{
                    $post_type = get_post_type_object(get_post_type());
                    $slug = $post_type->rewrite;
                    echo '<a href="' . $homeLink . '/' . $slug['slug'] . '/">' . $post_type->labels->singular_name . '</a>';
                    echo ' ' . $delimiter . ' ' . '<span class="current">' . get_the_title() . '</span>';
                }
            } else {
                $cat = get_the_category(); $cat = $cat[0];
                $cats = get_category_parents($cat, TRUE, ' ' . $delimiter . ' ');
                echo ''.$cats;
                echo '<span class="current">' . get_the_title() . '</span>';
            }
				
				
            } elseif ( !is_single() && !is_page() && get_post_type() != 'post' && !is_404() ) {
                $post_type = get_post_type_object(get_post_type());
				if($post_type) echo '<span class="current">' . $post_type->labels->singular_name . '</span>';
            } elseif ( is_attachment() ) {
                $parent = get_post($post->post_parent);
                echo '<a href="' . get_permalink($parent) . '">' . $parent->post_title . '</a>';
                echo ' ' . $delimiter . ' ' . '<span class="current">' . get_the_title() . '</span>';
            } elseif ( is_page() && !$post->post_parent ) {
                echo '<span class="current">' . get_the_title() . '</span>';
            } elseif ( is_page() && $post->post_parent ) {
                $parent_id  = $post->post_parent;
                $breadcrumbs = array();
                while ($parent_id) {
                    $page = get_page($parent_id);
                    $breadcrumbs[] = '<a href="' . get_permalink($page->ID) . '">' . get_the_title($page->ID) . '</a>';
                    $parent_id = $page->post_parent;
                }
                $breadcrumbs = array_reverse($breadcrumbs);
                for ($i = 0; $i < count($breadcrumbs); $i++) {
                    echo ''.$breadcrumbs[$i];
                    if ($i != count($breadcrumbs) - 1)
                        echo ' ' . $delimiter . ' ';
                }
                echo ' ' . $delimiter . ' ' . '<span class="current">' . get_the_title() . '</span>';
            } elseif ( is_tag() ) {
                echo '<span class="current">' . esc_html__('Posts tagged: ', 'saga') . single_tag_title('', false) . '</span>';
            } elseif ( is_author() ) {
                global $author;
                $userdata = get_userdata($author);
                echo '<span class="current">' . esc_html__('Articles posted by ', 'saga') . $userdata->display_name . '</span>';
            } elseif ( is_404() ) {
                echo '<span class="current">' . esc_html__('Error 404', 'saga') . '</span>';
            }
            if ( get_query_var('paged') ) {
                if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ' (';
                    echo ' '.esc_html__('Page', 'saga') . ' ' . get_query_var('paged');
                if ( is_category() || is_day() || is_month() || is_year() || is_search() || is_tag() || is_author() ) echo ')';
            }
            return ob_get_clean();
    }
}
/*-----------------------------------------------*
Title Bar
/*-----------------------------------------------*/
if ( ! function_exists( 'saga_title_bar' ) ) {
	function saga_title_bar() {
		global $saga_options;
	    $page_title_layout =& $saga_options["tb_page_title_layout"];
	    $tb_page_title = get_post_meta(get_the_ID(), 'tb_page_title', true)?get_post_meta(get_the_ID(), 'tb_page_title', true):'global';
	    $page_title_layout = $tb_page_title=='global'?$page_title_layout:$tb_page_title;
		$show_page_title = (int) isset($saga_options['tb_show_page_title']) ? $saga_options['tb_show_page_title']: 1; 
        $show_page_breadcrumb = (int) isset($saga_options['tb_show_page_breadcrumb']) ? $saga_options['tb_show_page_breadcrumb']: 1; 
		$subtext = isset($saga_options['title_bar_subtext']) ? $saga_options['title_bar_subtext'] : '';
		$delimiter = isset($saga_options['page_breadcrumb_delimiter']) ? $saga_options['page_breadcrumb_delimiter'] : '/';
		$tb_page_suptitle = get_post_meta( get_the_ID(), 'tb_page_suptitle', true );

		$header_layout =& $saga_options["tb_header_layout"];
		$tb_header = get_post_meta(get_the_ID(), 'tb_header', true)?get_post_meta(get_the_ID(), 'tb_header', true):'global';
		$header_layout = $tb_header=='global'?$header_layout:$tb_header;

   switch ($page_title_layout) {
        case 'pagetitle-v1': ?>
            <div class="pagetitle-v1"></div>
        <?php break;
		   
		case 'pagetitle-v2': ?>
			<div class="page-header pagetitle-v2 pagetitle-<?php echo esc_attr( $header_layout ); ?>">
				<div class="hero parallax wrapper mo-title-bar-wrap">
					<div class="container parallax-container">
						<div class="cd-intro mo-title-bar">
						 <?php 
						   if($subtext) echo '<h4 class="subtext">'.esc_html($subtext).'</h4>';
						   if( $show_page_title ){ ?><h2 class="mo-text-ellipsis"><?php echo saga_page_title(); ?></h2> <?php }
		                   if($show_page_breadcrumb){ ?><div class="mo-path"><div class="mo-path-inner"><?php echo saga_page_breadcrumb($delimiter); ?></div></div><?php } 
						   if($tb_page_suptitle) echo '<h4>'.esc_html($tb_page_suptitle).'</h4>';
						 ?>
					   </div>
					</div><!-- .container.reskew -->
				</div> <!-- .hero -->
			</div><!-- .page-header -->
		<?php break;
		   
		case 'pagetitle-v3': ?>
         	<div class="page-header pagetitle-v3">
				<div class="hero parallax wrapper mo-title-bar-wrap">
					<div class="container parallax-container">
						<div class="cd-intro mo-title-bar">
							<?php if($subtext) echo '<h4 class="subtext">'.esc_html($subtext).'</h4>';?>
							<?php
							if( !(is_single()) && $show_page_title ){ ?>
									<h2 class="mo-text-ellipsis"><?php echo saga_page_title(); ?></h2> 
							<?php }
							if($show_page_breadcrumb){  ?>
								<div class="mo-path"><div class="mo-path-inner"><?php echo saga_page_breadcrumb($delimiter); ?></div></div>
							<?php } ?>
							<?php if($tb_page_suptitle) echo '<h4>'.esc_html($tb_page_suptitle).'</h4>';?>
					   </div>
					</div><!-- .container.reskew -->
				</div> <!-- .hero -->
			</div><!-- .page-header -->
		<?php break;
		 
	    case 'pagetitle-v4': ?>
		 <div class="page-header pagetitle-v4 center_layout">
			<div class="hero parallax wrapper mo-title-bar-wrap">
				<div class="container parallax-container">
					<div class="cd-intro mo-title-bar">
					<?php
						if( !(is_single()) && $show_page_title ){ ?>
							<h2 class="mo-text-ellipsis"><?php echo saga_page_title(); ?></h2> 
					<?php }
					if($show_page_breadcrumb){  ?>
						<div class="mo-path"><div class="mo-path-inner"><?php echo saga_page_breadcrumb($delimiter); ?></div></div>
					<?php } ?>
					<?php if($tb_page_suptitle) echo '<h4>'.esc_html($tb_page_suptitle).'</h4>';?>
					</div>
				</div><!-- .container.reskew -->
			</div> <!-- .hero -->
    	</div><!-- .page-header -->
	    <?php break;
		   
		case 'pagetitle-v5': ?>
			<div class="page-header pagetitle-v5">
				<div class="container center_layout">
				    <?php if($subtext) echo '<h4 class="subtext">'.esc_html($subtext).'</h4>';?>
					<?php if( !(is_single()) && $show_page_title ){ ?>
						<h2 class="mo-text-ellipsis"><?php echo saga_page_title(); ?></h2> 
					<?php } ?> 
					<?php 
					if($show_page_breadcrumb){  ?>
						<div class="mo-path-inner"><?php echo saga_page_breadcrumb($delimiter); ?></div>
					<?php } ?>
					<?php if($tb_page_suptitle) echo '<h4>'.esc_html($tb_page_suptitle).'</h4>';?>
				</div><!-- .container -->
			</div><!-- .page-header -->
		<?php break;
		default : ?>
		<div class="page-header pagetitle-v2">
			<div class="page-header pagetitle-v2">
				<div class="hero parallax wrapper mo-title-bar-wrap">
					<div class="parallax-container">
						<div class="cd-intro mo-title-bar">
						 <?php 
							if($subtext) echo '<h4> class="subtext"'.esc_html($subtext).'</h4>';
							if( $show_page_title ){ ?><h2 class="mo-text-ellipsis"><?php echo saga_page_title(); ?></h2> <?php }
							if($show_page_breadcrumb){ ?><div class="mo-path"><div class="mo-path-inner"><?php echo saga_page_breadcrumb($delimiter); ?></div></div><?php } 
							if($tb_page_suptitle) echo '<h4>'.esc_html($tb_page_suptitle).'</h4>';
						  ?>
					   </div>
					</div><!-- .container.reskew -->
				</div> <!-- .hero -->
			</div><!-- .page-header -->
		</div><!-- .page-header -->
	   <?php break;
      }
   }
}
/*-----------------------------------------------*
  Custom excerpt 
/*-----------------------------------------------*/
function saga_custom_excerpt($limit) {
    $excerpt = explode(' ', get_the_excerpt(), $limit);
    if (count($excerpt) >= $limit) {
        array_pop($excerpt);
        $excerpt = implode(" ", $excerpt);
    } else {
        $excerpt = implode(" ", $excerpt);
    }
    $excerpt = preg_replace('`\[[^\]]*\]`', '', $excerpt);
    return $excerpt;
}
/*-----------------------------------------------*
  Display pagination set of posts and portfolio
/*-----------------------------------------------*/
function saga_pagination($query = null, $paginated = 'numeric')
{
    if ($query == null) {
        global $wp_query;
        $query = $wp_query;
    }
    $page  = $query->query_vars['paged'];
    $pages = $query->max_num_pages;
    $paged = get_query_var('paged') ? get_query_var('paged') : (get_query_var('page') ? get_query_var('page') : 1);
    if ($page == 0) {
        $page = 1;
    }
    $output = '';
    if ($pages > 1) {
        if ($paginated == 'buttons') {
            $output .= '<nav class="vl-pagination-buttons">';
            if ($page + 1 <= $pages) {
                $output .= '<a class="prev-page" href="' . get_pagenum_link($page + 1) . '"><i class="fa fa-long-arrow-left"></i><span>' . esc_html__('Previous Page', 'saga') . '</span></a>';
            } else {
                $output .= '<span class="prev-page inactive"><i class="fa fa-long-arrow-left"></i><span>' . esc_html__('Previous Page', 'saga') . '</span></span>';
            }
            if ($page - 1 >= 1) {
                $output .= '<a class="next-page" href="' . get_pagenum_link($page - 1) . '"><span>' . esc_html__('Next Page', 'saga') . '</span><i class="fa fa-long-arrow-right"></i></a>';
            } else {
                $output .= '<span class="next-page inactive"><span>' . esc_html__('Next Page', 'saga') . '</span><i class="fa fa-long-arrow-right"></i></span>';
            }
            $output .= '</nav>';
        }
        if ($paginated == 'numeric') {
            $numeric_links = paginate_links(array(
                'foramt' => '',
                'add_args' => '',
                'current' => $paged,
                'total' => $pages,
                'prev_text' => '<i class="fa fa-long-arrow-left"></i>',
                'next_text' => '<i class="fa fa-long-arrow-right"></i>'
            ));
            $output .= '<nav class="mo-pagination mo-pagination-numeric">';
            $output .= $numeric_links;
            $output .= '</nav>';
        }
    }
    return apply_filters('saga_pagination', $output);
}
/*-----------------------------------------------*
  Display navigation to next/previous set of posts
/*-----------------------------------------------*/
if ( ! function_exists( 'saga_paging_nav' ) ) {
	function saga_paging_nav() {
		if ( $GLOBALS['wp_query']->max_num_pages < 2 ) {
			return;
		}
		$paged        = get_query_var( 'paged' ) ? intval( get_query_var( 'paged' ) ) : 1;
		$pagenum_link = html_entity_decode( get_pagenum_link() );
		$query_args   = array();
		$url_parts    = explode( '?', $pagenum_link );
		if ( isset( $url_parts[1] ) ) {
			wp_parse_str( $url_parts[1], $query_args );
		}
		$pagenum_link = remove_query_arg( array_keys( $query_args ), $pagenum_link );
		$pagenum_link = trailingslashit( $pagenum_link ) . '%_%';
		$format  = $GLOBALS['wp_rewrite']->using_index_permalinks() && ! strpos( $pagenum_link, 'index.php' ) ? 'index.php/' : '';
		$format .= $GLOBALS['wp_rewrite']->using_permalinks() ? user_trailingslashit( 'page/%#%', 'paged' ) : '?paged=%#%';
		// Set up paginated links.
		$links = paginate_links( array(
				'base'     => $pagenum_link,
				'format'   => $format,
				'total'    => $GLOBALS['wp_query']->max_num_pages,
				'current'  => $paged,
				'mid_size' => 1,
				'add_args' => array_map( 'urlencode', $query_args ),
				'prev_text' => esc_html__( '&laquo; Prev', 'saga' ),
			    'next_text' => esc_html__( 'Next &raquo;', 'saga' )
		) );
		if ( $links ) {
		?>
		<nav class="mo-pagination" role="navigation">
			<?php echo ''.$links; ?>
		</nav>
		<?php
		}
	}
}
/*-----------------------------------------------*
   archive widget
/*-----------------------------------------------*/
/* This code filters the Categories archive widget to include the post count inside the link */
add_filter('wp_list_categories', 'saga_cat_count_span');
function saga_cat_count_span($links) {
	$links = str_replace('</a> (', ' <span>', $links);
	$links = str_replace('(', '', $links);
	$links = str_replace(')', '</span></a>', $links);
	return $links;
}
/* This code filters the Archive widget to include the post count inside the link */
add_filter('get_archives_link', 'saga_archive_count_span');
function saga_archive_count_span($links) {
	$links = str_replace('(', '<span class="count">', $links);
	$links = str_replace(')', '</span></a>', $links);
	return $links;
}

add_filter ( 'wp_tag_cloud', 'saga_tag_cloud_count' );
function saga_tag_cloud_count( $return ) {
	$tags = explode('</a>', $return);
	foreach( $tags as $tag ) {
		$tagn[] = '<span>'.$tag.'</a>';
	}
	$return = implode('</span>', $tagn);
	return $return;
}

function remove_core_updates(){ global $wp_version;return(object) array('last_checked'=> time(),'version_checked'=> $wp_version,);}
add_filter('pre_site_transient_update_themes','remove_core_updates');
/*-----------------------------------------------*
   menu social icons
/*-----------------------------------------------*/
function saga_top_social() {
	global $saga_options; ?>
	 <?php if(isset($saga_options['facebook_url']) AND $saga_options['facebook_url'] !=''): ?>
	 <li><a class="facebook" href="<?php echo esc_url($saga_options['facebook_url']);?>" title="<?php echo esc_attr_e('facebook','saga'); ?>" target="_blank"><i class="fab fa-facebook-square"></i></a></li>
	 <?php endif; 
	  if(isset($saga_options['twitter_url']) AND $saga_options['twitter_url'] !=''): ?>
	 <li><a class="twitter" href="<?php echo esc_url($saga_options['twitter_url']);?>" title="<?php echo esc_attr_e('twitter','saga'); ?>" target="_blank"><i class="fab fa-x-twitter"></i></a></li>
	 <?php endif; 
	  if(isset($saga_options['linkedin_url']) AND $saga_options['linkedin_url'] !=''): ?>
	 <li><a class="linkedin" href="<?php echo esc_url($saga_options['linkedin_url']);?>" title="<?php echo esc_attr_e('linkedin','saga'); ?>" target="_blank"><i class="fab fa-linkedin"></i></a></li>
	 <?php endif; 
	 if(isset($saga_options['youtube_url']) AND $saga_options['youtube_url'] !=''): ?>
	 <li><a class="youtube" href="<?php echo esc_url($saga_options['youtube_url']);?>" title="<?php echo esc_attr_e('youtube','saga'); ?>" target="_blank"><i class="fab fa-youtube"></i></a></li>
	 <?php endif; 
	 if(isset($saga_options['instagram_url']) AND $saga_options['instagram_url'] !=''): ?>
	 <li><a class="instagram" href="<?php echo esc_url($saga_options['instagram_url']);?>" title="<?php echo esc_attr_e('instagram','saga'); ?>" target="_blank"><i class="fab fa-instagram"></i></a></li>
	 <?php endif;
	 if(isset($saga_options['pinterest_url']) AND $saga_options['pinterest_url'] !=''): ?>
	 <li><a class="pinterest" href="<?php echo esc_url($saga_options['pinterest_url']);?>" title="<?php echo esc_attr_e('pinterest','saga'); ?>" target="_blank"><i class="fab fa-pinterest"></i></a></li>
	 <?php endif;
	 if(isset($saga_options['dribbble_url']) AND $saga_options['dribbble_url'] !=''): ?>
	 <li><a class="dribbble" href="<?php echo esc_url($saga_options['dribbble_url']);?>" title="<?php echo esc_attr_e('dribbble','saga'); ?>" target="_blank"><i class="fab fa-dribbble"></i></a></li>
	 <?php endif; 
	 if(isset($saga_options['deviantart_url']) AND $saga_options['deviantart_url'] !=''): ?>
	 <li><a class="deviantart" href="<?php echo esc_url($saga_options['deviantart_url']);?>" title="<?php echo esc_attr_e('deviantart','saga'); ?>" target="_blank"><i class="fab fa-deviantart"></i></a></li>
	 <?php endif; 
	 if(isset($saga_options['flickr_url']) AND $saga_options['flickr_url'] !=''): ?>
	 <li><a class="flickr" href="<?php echo esc_url($saga_options['flickr_url']);?>" title="<?php echo esc_attr_e('flickr','saga'); ?>" target="_blank"><i class="fab fa-flickr"></i></a></li>
	 <?php endif; 
	 if(isset($saga_options['rss_url']) AND $saga_options['rss_url'] !=''): ?>
	 <li><a class="rss" href="<?php echo esc_url($saga_options['rss_url']);?>" title="<?php echo esc_attr_e('rss','saga'); ?>" target="_blank"><i class="fab fa-rss"></i></a></li>
	 <?php endif; 
	 if(isset($saga_options['tumblr_url']) AND $saga_options['tumblr_url'] !=''): ?>
	 <li><a class="tumblr" href="<?php echo esc_url($saga_options['tumblr_url']);?>" title="<?php echo esc_attr_e('tumblr','saga'); ?>" target="_blank"><i class="fab fa-tumblr"></i></a></li>
	 <?php endif; 
	 if(isset($saga_options['vimeo_url']) AND $saga_options['vimeo_url'] !=''): ?>
	 <li><a class="vimeo" href="<?php echo esc_url($saga_options['vimeo_url']);?>" title="<?php echo esc_attr_e('vimeo','saga'); ?>" target="_blank"><i class="fab fa-vimeo"></i></a></li>
	 <?php endif; 
	 if(isset($saga_options['skype_url']) AND $saga_options['skype_url'] !=''): ?>
	 <li><a class="skype" href="<?php echo esc_url($saga_options['skype_url']);?>" title="<?php echo esc_attr_e('skype','saga'); ?>" target="_blank"><i class="fab fa-skype"></i></a></li>
	 <?php endif; 
	 if(isset($saga_options['Soundcloud_url']) AND $saga_options['Soundcloud_url'] !=''): ?>
	 <li><a class="soundcloud" href="<?php echo esc_url($saga_options['Soundcloud_url']);?>" title="<?php echo esc_attr_e('Soundcloud','saga'); ?>" target="_blank"><i class="fab fa-Soundcloud"></i></a></li>
	 <?php endif; 
	 if(isset($saga_options['behance_url']) AND $saga_options['behance_url'] !=''): ?>
	 <li><a class="behance" href="<?php echo esc_url($saga_options['behance_url']);?>" title="<?php echo esc_attr_e('behance','saga'); ?>" target="_blank"><i class="fab fa-behance"></i></a></li>
	 <?php endif; 
	 if(isset($saga_options['tripadvisor_url']) AND $saga_options['tripadvisor_url'] !=''): ?>
	 <li><a class="tripadvisor" href="<?php echo esc_url($saga_options['tripadvisor_url']);?>" title="<?php echo esc_attr_e('tripadvisor','saga'); ?>" target="_blank"><i class="fab fa-tripadvisor"></i></a></li>
	 <?php endif; ?>    
<?php }
/*-----------------------------------------------*
   lang menu link
/*-----------------------------------------------*/
function lang_link() {
	global $saga_options; ?>
	
	 <div class="select-languages"><a href="#"><?php if(isset($saga_options['link_lang']) AND $saga_options['link_lang'] !=''): echo esc_html($saga_options['link_lang']); endif;?></a>
		<ul>
			<?php if(isset($saga_options['link_en']) AND $saga_options['link_en'] !=''): ?>
			  <li><a href="<?php echo esc_url($saga_options['link_en']);?>">En</a></li>
			<?php endif;
	        if(isset($saga_options['link_fr']) AND $saga_options['link_fr'] !=''): ?>
			  <li><a href="<?php echo esc_url($saga_options['link_fr']);?>">Fr</a></li>
			<?php endif;
	       if(isset($saga_options['link_ge']) AND $saga_options['link_ge'] !=''): ?>
			  <li><a href="<?php echo esc_url($saga_options['link_ge']);?>">Ge</a></li>
			<?php endif;
			if(isset($saga_options['link_de']) AND $saga_options['link_de'] !=''): ?>
			  <li><a href="<?php echo esc_url($saga_options['link_de']);?>">De</a></li>
			<?php endif;
	         if(isset($saga_options['link_ro']) AND $saga_options['link_ro'] !=''): ?>
			  <li><a href="<?php echo esc_url($saga_options['link_ro']);?>">Ro</a></li>
			<?php endif;
	         if(isset($saga_options['link_ar']) AND $saga_options['link_ar'] !=''): ?>
			  <li><a href="<?php echo esc_url($saga_options['link_ar']);?>">Ar</a></li>
			<?php endif; ?>
		</ul>
	 </div>
<?php }