<?php
/*
 * Plugin Name: Saga Core
 * Plugin URI: https://motivoweb.com
 * Description: This is a plugin required for Saga wordpress theme from motivoweb 
 * Version: 2.4
 * Author: motivoweb
 * Author URI: https://motivoweb.com
 * License: GPLv1 or later
 * Text Domain: motivoweb
 */
define( 'SAGA_DIR', plugin_dir_path(__FILE__) );
define( 'SAGA_URI', plugin_dir_url(__FILE__) );
define( 'SAGA_INCLUDES', SAGA_DIR . "includes/" );
define( 'SAGA_ADMIN', SAGA_DIR . "admin/" );
define( 'SAGA_ADMIN_URI', SAGA_URI . "admin/" );
define( 'SAGA_ELEMENTOR_URI', SAGA_URI . "elementor/" );
define( 'SAGA_CSS', SAGA_URI . "assets/css/" );
define( 'SAGA_JS', SAGA_URI . "assets/js/" );
define( 'SAGA_IMAGES', SAGA_URI . "assets/images/" );
define( 'SAGA_TEMPLATES', SAGA_DIR . "templates" );

/* include functions.php */
require SAGA_INCLUDES . 'functions.php';

/* include Redux Options */
require SAGA_ADMIN . 'admin-init.php';

/*-----------------------------------------------*
Widgets
/*-----------------------------------------------*/
require_once SAGA_DIR.'widgets/abstract-widget.php';
require_once SAGA_DIR.'widgets/widgets.php';

/*-----------------------------------------------*
saga_core
/*-----------------------------------------------*/
/* use class saga_core */
new saga_core;
/* class saga_core */
class saga_core
{
	function __construct()
	{
		add_action( 'init', array( $this, 'saga_init' ) );
		add_action( 'admin_enqueue_scripts', array( $this, 'load_saga_core_style' ) );
	}
	function saga_init()
	{
		
	}
	function load_saga_core_style() {
        wp_register_style( 'saga-core-admin-css', SAGA_CSS . 'saga-core.admin.css', false, '1.0.0' );
        wp_enqueue_style( 'saga-core-admin-css' );
    	wp_enqueue_style( 'saga-font-icons',SAGA_CSS . 'font-icons.css', array(), '1.0.0' );
		
        wp_register_script( 'saga-core-admin-js', SAGA_JS . 'jquery.saga-core.admin.js', array( 'jquery' ), '1.0.0', true );
	    wp_enqueue_script( 'saga-core-admin-js' );
		wp_localize_script( 'saga-core-admin-js', 'saga_object', array( 'ajax_url' => admin_url('admin-ajax.php') ) );
	}
	
}

/*-----------------------------------------------*
elementor
/*-----------------------------------------------*/
require_once SAGA_DIR.'elementor/init.php';


/*-----------------------------------------------*
elementor
/*-----------------------------------------------*/
if(!function_exists('sagathemer_random_id')){
	function sagathemer_random_id($length=4){
	  $characters = '0123456789abcdefghijklmnopqrstuvwxyz';
	  $string = '';
	  for ($i = 0; $i < $length; $i++) {
		$string .= $characters[rand(0, strlen($characters) - 1)];
	  }
	  return $string;
	}
  }  
/*-----------------------------------------------*
rating testimonial elementor
/*-----------------------------------------------*/
   function mo_get_rating( $class = null, $rating = array() ) {
	$out = '';
	$rating = $rating['size'];
	if( empty( $rating ) ) {
		return;
	}
	$active = '';
	$out .= '<ul class="mo-star-rating ' . $class . '">';
	for( $i = 1; $i <= 5; $i++ ) {
		if( $i <= $rating ) {
			$active = ' active';
		}
		else {
			$active = '';
		}
		$out .= '<li><svg class="' . $active . '" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 576 512"><path fill="currentColor" d="M259.3 17.8L194 150.2 47.9 171.5c-26.2 3.8-36.7 36.1-17.7 54.6l105.7 103-25 145.5c-4.5 26.3 23.2 46 46.4 33.7L288 439.6l130.7 68.7c23.2 12.2 50.9-7.4 46.4-33.7l-25-145.5 105.7-103c19-18.5 8.5-50.8-17.7-54.6L382 150.2 316.7 17.8c-11.7-23.6-45.6-23.9-57.4 0z"/></svg></li> ';
	}
	$out .= '</ul>';
	echo $out;
}
/*-----------------------------------------------*
 Allow SVG
/*-----------------------------------------------*/
add_filter( 'wp_check_filetype_and_ext', function($data, $file, $filename, $mimes) {

	global $wp_version;
	if ( $wp_version !== '4.7.1' ) {
	   return $data;
	}
  
	$filetype = wp_check_filetype( $filename, $mimes );
  
	return [
		'ext'             => $filetype['ext'],
		'type'            => $filetype['type'],
		'proper_filename' => $data['proper_filename']
	];
  
  }, 10, 4 );
  
  function cc_mime_types( $mimes ){
	$mimes['svg'] = 'image/svg+xml';
	return $mimes;
  }
  add_filter( 'upload_mimes', 'cc_mime_types' );
  
  function fix_svg() {
	echo '<style type="text/css">
		  .attachment-266x266, .thumbnail img {
			   width: 100% !important;
			   height: auto !important;
		  }
		  </style>';
  }
  add_action( 'admin_head', 'fix_svg' );