<?php

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Image_Size;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Color;
use Elementor\Scheme_Typography;
use Elementor\Utils;
use Elementor\Control_Media;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Text_Shadow;
use Elementor\Group_Control_Background;
use Elementor\Repeater;


function mo_content_animation($mo){

	$section_title = __( 'Animate contents', 'saga' );
	
	if ( $mo->get_name() === 'section'){
		$section_title = __( 'Animate columns', 'saga' );
	} 

	$mo->add_control(
		'mo-custom_animation',
		[
			'label' => $section_title,
			'type' => Controls_Manager::SWITCHER,
			'label_on' => __( 'On', 'saga' ),
			'label_off' => __( 'Off', 'saga' ),
			'return_value' => 'yes',
			'default' => '',
			'separator' => 'before',
			'render_type' => 'none',
		]
	);
	$mo->add_control(
		'mo-ca_settings_popover',
		[
			'label' => __( 'Settings', 'saga' ),
			'type' => Controls_Manager::POPOVER_TOGGLE,
			'label_off' => __( 'Default', 'saga' ),
			'label_on' => __( 'Custom', 'saga' ),
			'return_value' => 'yes',
			'default' => 'yes',
			'condition' => [
				'mo-custom_animation' => 'yes'
			],
			'render_type' => 'none',
		]
	);

	// Animation Settings
	$mo->start_popover();
		$mo->add_control(
			'mo-ca_preset',
			[
				'label' => __( 'Animation Presets', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'custom',
				'options' => [
					'custom'  => __( 'Custom', 'saga' ),
					'Fade In'  => __( 'Fade In', 'saga' ),
					'Fade In Down'  => __( 'Fade In Down', 'saga' ),
					'Fade In Up'  => __( 'Fade In Up', 'saga' ),
					'Fade In Left'  => __( 'Fade In Left', 'saga' ),
					'Fade In Right'  => __( 'Fade In Right', 'saga' ),
					'Flip In Y'  => __( 'Flip In Y', 'saga' ),
					'Flip In X'  => __( 'Flip In X', 'saga' ),
					'Scale Up'  => __( 'Scale Up', 'saga' ),
					'Scale Down'  => __( 'Scale Down', 'saga' ),
				],
				'condition' => [
					'mo-ca_settings_popover' => 'yes'
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_settings_ease',
			[
				'label' => __( 'Easing', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => [ 'power4.out' ],
				'options' => [
					'linear' => 'linear',
					'power1.in' => 'power1.in',
					'power2.in' => 'power2.in',
					'power3.in' => 'power3.in',
					'power4.in' => 'power4.in',
					'sine.in' => 'sine.in',
					'expo.in' => 'expo.in',
					'circ.in' => 'circ.in',
					'back.in' => 'back.in',
					'bounce.in' => 'bounce.in',
					'elastic.in(1,0.2)' => 'elastic.in(1,0.2)',
					'power1.out' => 'power1.out',
					'power2.out' => 'power2.out',
					'power3.out' => 'power3.out',
					'power4.out' => 'power4.out',
					'sine.out' => 'sine.out',
					'expo.out' => 'expo.out',
					'circ.out' => 'circ.out',
					'back.out' => 'back.out',
					'bounce.out' => 'bounce.out',
					'elastic.out(1,0.2)' => 'elastic.out(1,0.2)',
					'power1.inOut' => 'power1.inOut',
					'power2.inOut' => 'power2.inOut',
					'power3.inOut' => 'power3.inOut',
					'power4.inOut' => 'power4.inOut',
					'sine.inOut' => 'sine.inOut',
					'expo.inOut' => 'expo.inOut',
					'circ.inOut' => 'circ.inOut',
					'back.inOut' => 'back.inOut',
					'bounce.inOut' => 'bounce.inOut',
					'elastic.inOut(1,0.2)' => 'elastic.inOut(1,0.2)',
				],
				'condition' => [
					'mo-ca_settings_popover' => 'yes'
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_settings_direction',
			[
				'label' => __( 'Direction', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'forward',
				'options' => [
					'forward' => __( 'Forward', 'saga' ),
					'backward' => __( 'Backward', 'saga' ),
					'random' => __( 'Random', 'saga' ),
				],
				'condition' => [
					'mo-ca_settings_popover' => 'yes'
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_settings_duration',
			[
				'label' => __( 'Duration', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 1.6,
				],
				'condition' => [
					'mo-ca_settings_popover' => 'yes'
				],
				'render_type' => 'none',
			]
		);
	
		$mo->add_control(
			'mo-ca_settings_stagger',
			[
				'label' => __( 'Stagger', 'saga' ),
				'description' => __( 'Delay between animated elements.', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 10,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => .16,
				],
				'condition' => [
					'mo-ca_settings_popover' => 'yes'
				],
				'render_type' => 'none',
			]
		);
	
		$mo->add_control(
			'mo-ca_settings_start_delay',
			[
				'label' => __( 'Start Delay', 'saga' ),
				'description' => __( 'Start delay of the animation.', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -0,
						'max' => 10,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 0,
				],
				'condition' => [
					'mo-ca_settings_popover' => 'yes'
				],
				'render_type' => 'none',
			]
		);
	$mo->end_popover();

	// From Options
	$mo->add_control(
		'mo-ca_from_popover',
		[
			'label' => __( 'Animate from', 'saga' ),
			'type' => Controls_Manager::POPOVER_TOGGLE,
			'label_off' => __( 'Default', 'saga' ),
			'label_on' => __( 'Custom', 'saga' ),
			'return_value' => 'yes',
			'default' => 'yes',
			'condition' => [
				'mo-custom_animation' => 'yes',
				'mo-ca_preset' => 'custom',
			],
			'render_type' => 'none',
		]
	);

	$mo->start_popover();
		$mo->add_control(
			'mo-ca_from_x',
			[
				'label' => __( 'Translate X', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
						'vw' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
						'vh' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
				],
				'default' => [
					'size' => 0,
				],
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_from_y',
			[
				'label' => __( 'Translate Y', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
						'vw' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
						'vh' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
				],
				'default' => [
					'size' => 0,
				],
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_from_z',
			[
				'label' => __( 'Translate Z', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1
					]
				],
				'default' => [
					'size' => 0,
				],
				'separator' => 'after',
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_from_scaleX',
			[
				'label' => __( 'Scale X', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 1,
				],
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_from_scaleY',
			[
				'label' => __( 'Scale Y', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 1,
				],
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'separator' => 'after',
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_from_rotationX',
			[
				'label' => __( 'Rotate X', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -360,
						'max' => 360,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 0,
				],
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_from_rotationY',
			[
				'label' => __( 'Rotate Y', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -360,
						'max' => 360,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 0,
				],
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_from_rotationZ',
			[
				'label' => __( 'Rotate Z', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -360,
						'max' => 360,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 0,
				],
				'separator' => 'after',
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);


		$mo->add_control(
			'mo-ca_from_opacity',
			[
				'label' => __( 'Opacity', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 1,
				],
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_from_transformOriginX',
			[
				'label' => __( 'Transform origin X', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
				],
				'default' => [
					'size' => 50,
					'unit' => '%',
				],
				'separator' => 'before',
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_from_transformOriginY',
			[
				'label' => __( 'Transform origin Y', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
				],
				'default' => [
					'size' => 50,
					'unit' => '%',
				],
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_from_transformOriginZ',
			[
				'label' => __( 'Transform origin Z', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1,
						],
				],
				'default' => [
					'size' => 0,
				],
				'separator' => 'after',
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);
	$mo->end_popover();

	// From Options
	$mo->add_control(
		'mo-ca_to_popover',
		[
			'label' => __( 'Animate to', 'saga' ),
			'type' => Controls_Manager::POPOVER_TOGGLE,
			'label_off' => __( 'Default', 'saga' ),
			'label_on' => __( 'Custom', 'saga' ),
			'return_value' => 'yes',
			'default' => 'yes',
			'condition' => [
				'mo-custom_animation' => 'yes',
				'mo-ca_preset' => 'custom',
			],
			'render_type' => 'none',
		]
	);

	$mo->start_popover();
		$mo->add_control(
			'mo-ca_to_x',
			[
				'label' => __( 'Translate X', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
						'vw' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
						'vh' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
				],
				'default' => [
					'size' => 0,
				],
				'condition' => [
					'mo-ca_to_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_to_y',
			[
				'label' => __( 'Translate Y', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%', 'vw', 'vh' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
						'vw' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
						'vh' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
				],
				'default' => [
					'size' => 0,
				],
				'condition' => [
					'mo-ca_to_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_to_z',
			[
				'label' => __( 'Translate Z', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1
					]
				],
				'default' => [
					'size' => 0,
				],
				'separator' => 'after',
				'condition' => [
					'mo-ca_to_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_to_scaleX',
			[
				'label' => __( 'Scale X', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 1,
				],
				'condition' => [
					'mo-ca_to_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_to_scaleY',
			[
				'label' => __( 'Scale Y', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 1,
				],
				'condition' => [
					'mo-ca_to_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'separator' => 'after',
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_to_rotationX',
			[
				'label' => __( 'Rotate X', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -360,
						'max' => 360,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 0,
				],
				'condition' => [
					'mo-ca_to_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_to_rotationY',
			[
				'label' => __( 'Rotate Y', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -360,
						'max' => 360,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 0,
				],
				'condition' => [
					'mo-ca_to_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_to_rotationZ',
			[
				'label' => __( 'Rotate Z', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => -360,
						'max' => 360,
						'step' => 1,
					],
				],
				'default' => [
					'size' => 0,
				],
				'separator' => 'after',
				'condition' => [
					'mo-ca_from_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);


		$mo->add_control(
			'mo-ca_to_opacity',
			[
				'label' => __( 'Opacity', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 1,
				],
				'condition' => [
					'mo-ca_to_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_to_transformOriginX',
			[
				'label' => __( 'Transform origin X', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
				],
				'default' => [
					'size' => 50,
					'unit' => '%',
				],
				'separator' => 'before',
				'condition' => [
					'mo-ca_to_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_to_transformOriginY',
			[
				'label' => __( 'Transform origin Y', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1,
						],
						'%' => [
							'min' => -100,
							'max' => 100,
							'step' => 0.1,
						],
				],
				'default' => [
					'size' => 50,
					'unit' => '%',
				],
				'condition' => [
					'mo-ca_to_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);

		$mo->add_control(
			'mo-ca_to_transformOriginZ',
			[
				'label' => __( 'Transform origin Z', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
							'min' => -500,
							'max' => 500,
							'step' => 1,
						],
				],
				'default' => [
					'size' => 0,
				],
				'separator' => 'after',
				'condition' => [
					'mo-ca_to_popover' => 'yes',
					'mo-ca_preset' => 'custom',
				],
				'render_type' => 'none',
			]
		);
	$mo->end_popover();

}