<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
/**
 * Elementor icon box widget.
 *
 * Elementor widget that displays an icon, a headline and a text.
 *
 * @since 1.0.0
 */
class MOElement_Video_Box extends MOElement_Base {  

	/**
	 * Get widget name.
	 *
	 * Retrieve icon box widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'mo-video-box';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve icon box widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Video Box', 'saga' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve icon box widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-icon-box';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'video', 'box' ];
	}
	public function get_script_depends() {
		return [
		   'saga.elements',
		];
	 }
	/**
	 * Register icon box widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_icon',
			[
				'label' => __( 'Content', 'saga' ),
			]
		);
		$this->add_control(
			'style',
			[
				'label' => __( 'style', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style-1' 		=> __( 'Style I', 'saga' ),
					'style-2' 		=> __( 'Style II', 'saga' ),
					'style-3' 		=> __( 'Style III', 'saga' )
				],
				'default' => 'style-1',
			]
		);
		$this->add_control(
			'link',
			[
				'label' => __( 'Link', 'saga' ),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'https://your-link.com', 'saga' ),
				'separator' => 'before',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_box_style',
			[
				'label' => __( 'Box Style', 'saga' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
            'box_primary_color',
            array(
                'label'   => esc_html__('Color', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'dark'        => esc_html__('Dark', 'saga'),
                    'primary'     => esc_html__('Primary', 'saga'),
                    'light'       => esc_html__('Light', 'saga'),
                    'grey'        => esc_html__('Grey', 'saga'),
                    'custom'      => esc_html__('Custom', 'saga'),
                ),
                'default' => 'dark',
            )
        );
        $this->add_control(
			'box_custom_background',
			[
				'label' => __( 'Custom Background Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .lightbox-video.video-button' => 'color: {{VALUE}};',
					'{{WRAPPER}} .video-button:after' => 'background: {{VALUE}};',
					'{{WRAPPER}} .mo-video-fancybox.style-2 .video-button' => 'border-color: {{VALUE}};',
					'{{WRAPPER}} .mo-video-fancybox.style-3 .video-button' => 'background: {{VALUE}};',
				],
                'condition' => array(
                    'box_primary_color' => 'custom',
                ),
			]
		);


		$this->add_control(
            'box_align',
            [
                'label' => __( 'Alignment', 'saga' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'saga' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'saga' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'saga' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
            ]
        );
		$this->end_controls_section();

		$this->start_controls_section(
			'section_style_icon',
			[
				'label' => __( 'Icon', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				
			]
		);
		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Size', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'default' => [
					'size' => 25
				],
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 50,
					],
				],
				'selectors' => [
					'{{WRAPPER}} a.video-button i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'icon_padding',
			[
				'label' => __( 'Padding', 'saga' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .mo-video-fancybox' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render icon box widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
         include $this->get_template('mo-video-box.php');
      print '</div>';
	}
}