<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

class MOElement_Teams extends MOElement_Base{

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'mo-teams';
    }
    public function get_title() {
        return __('Teams', 'saga');
    }

    public function get_keywords() {
        return [ 'team', 'content', 'grid' ];
    }

    public function get_icon() {
        return 'eicon-person';
    }

    public function get_script_depends() {
      return [];
    }

    public function get_style_depends() {
      return array();
    }
    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_list',
            [
                'label' => __('Content', 'saga'),
            ]
        );
        $this->add_control(
            'style',
            array(
                'label'   => esc_html__( 'Style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                  'tpl1' => esc_html__('Style 1', 'saga'),
                  'tpl2' => esc_html__('Style 2', 'saga'),
                  'tpl3' => esc_html__('Style 3', 'saga'),
                ],
				'default' => 'tpl1',
            )
        );
        $this->add_control(
            'name',
            array(
                'label'       => __('Name', 'saga'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Mona Zaghloul', 'saga'),
            )
        );

        $this->add_control(
            'position',
            array(
                'label'   => __('Position', 'saga'),
                'default' => esc_html__('Developer', 'saga'),
                'type'    => Controls_Manager::TEXT,
            )
        );

        $this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'saga' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);



        $repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'social_title',
			[
				'label'      => esc_html__('Title', 'saga'),
                'type'       => 'text',
                'show_label' => false,
			]
		);
		$repeater->add_control(
			'social_icon',
			[
				'label'      => esc_html__('Choose Icon', 'saga'),
                'type'       => 'icon',
                'show_label' => false,
			]
		);
		$repeater->add_control(
			'social_link',
			[
				'label'   => esc_html__('Social Link', 'saga'),
                'default' => '#',
                'type'    => Controls_Manager::TEXT,
			]
		);
       

        $this->add_control(
            'socials',
            [
                'label'       => __('Social Icon Item', 'saga'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => array(
                    array(
                        'social_title'      => esc_html__( 'Facebook', 'saga' ),
                        'social_icon'       => esc_html__( 'fa-brands fa-facebook', 'saga' ),
                        'social_link'       => '#',
                    ),
                    array(
                        'social_title'      => esc_html__( 'Twitter', 'saga' ),
                        'social_icon'       => esc_html__( 'fa-brands fa-x-twitter', 'saga' ),
                        'social_link'       => '#',
                    ),
                    array(
                        'social_title'      => esc_html__( 'Instagram', 'saga' ),
                        'social_icon'       => esc_html__( 'fa-brands fa-instagram', 'saga' ),
                        'social_link'       => '#',
                    ),
                    array(
                        'social_title'      => esc_html__( 'pinterest', 'saga' ),
                        'social_icon'       => esc_html__( 'fa-brands fa-pinterest', 'saga' ),
                        'social_link'       => '#',
                    ),
                ),
            ]
        );
        $this->end_controls_section();
    }
    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
      $settings = $this->get_settings_for_display();
      printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
      include $this->get_template('mo-teams.php');
      print '</div>';
    }
}