<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

class MOElement_Icon_Box extends MOElement_Base{

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'mo-icon-box';
    }

    /**
     * Get widget title.
     * @return string Widget title.
     */
    public function get_title() {
        return __('Icon Box', 'saga');
    }

    /**
     * Get widget icon.
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-favorite';
    }

    public function get_keywords() {
        return [ 'text', 'arrow' ];
    }
    public function get_script_depends() {
      return [];
    }

    public function get_style_depends() {
      return array();
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_list',
            [
                'label' => __('Content', 'saga'),
            ]
        );
        $this->add_control(
            'style',
            array(
                'label'   => esc_html__( 'Style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                  'style1' => esc_html__('Style 1', 'saga'),
                  'style2' => esc_html__('Style 2', 'saga'),
                  'style3' => esc_html__('Style 3', 'saga'),
                  'style4' => esc_html__('Style 4', 'saga'),
                  'style5' => esc_html__('Style 5', 'saga'),
                  'style6' => esc_html__('Style 6', 'saga'),
                  'style7' => esc_html__('Style 7', 'saga'),
                  'style8' => esc_html__('Style 8', 'saga'),
                  'style9' => esc_html__('Style 9', 'saga'),
                ],
				'default' => 'style1',
            )
         );
        $this->add_control(
            'selected_icon',
            [
                'label' => __( 'Icon', 'saga' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-chevron-right',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $this->add_control(
            'title',
            array(
                'label'       => __('Title', 'saga'),
                'type'        => Controls_Manager::TEXT,
                'default'     => esc_html__('Best project planning', 'saga'),
                'label_block' => true,
            )
        );
        $this->add_control(
            'content',
            array(
                'label'   => __('Content', 'saga'),
                'default' => esc_html__('Lorem ipsum is simply free dolor sit amet, consectetur notted.', 'saga'),
                'type'    => Controls_Manager::TEXTAREA,
            )
        );

        $this->add_control(
            'button_title',
            array(
                'label'   => esc_html__('Button title', 'saga'),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__('Read More', 'saga')
            )
        );
        $this->add_control(
            'button_link',
            [
                'label' => __( 'Link', 'saga' ),
                'type' => Controls_Manager::URL,
            ]
        );
        $this->end_controls_section();
        

         // Title Styling
        $this->start_controls_section(
            'section_style_icon',
            [
                'label' => __('Icon', 'saga'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_text_color',
            [
                'label'     => __('Icon Color', 'saga'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .icon-box-style1 .icon-wrap:before' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .icon-box-style1 .button.hr_primary:hover' => 'color: {{VALUE}};',

                    '{{WRAPPER}} .icon-box-style2 .icon-wrap i, {{WRAPPER}}  .icon-box-style2 .button.hr_primary:hover' => 'color:{{VALUE}};',
                    
                    '{{WRAPPER}} .icon-box-style3 .icon-wrap:before' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .icon-box-style3 .icon-wrap i' => 'color: {{VALUE}}!important;',
                    '{{WRAPPER}} .icon-box-style3 .icon-wrap svg path' => 'stroke:{{VALUE}};',

                    '{{WRAPPER}} .icon-box-style4 .icon-wrap svg path, {{WRAPPER}} .icon-box-style4 .icon-wrap svg line, {{WRAPPER}} .icon-box-style4 .icon-wrap svg circle, {{WRAPPER}} .icon-box-style4 .icon-wrap svg rect' => 'stroke:{{VALUE}};',
                    '{{WRAPPER}} .icon-box-style4 .icon-wrap i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .icon-box-style4:hover .title-wrap h6:before' => 'color: {{VALUE}};',

                    '{{WRAPPER}} .icon-box-style5 .icon-wrap:after, {{WRAPPER}} .icon-box-style5:after' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .icon-box-style5 .icon-wrap i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .icon-box-style5:hover' => 'border-color: {{VALUE}};',

                    '{{WRAPPER}} .icon-box-style6 .icon-wrap:before' => 'background:{{VALUE}};',
                    '{{WRAPPER}} .icon-box-style6:hover' => 'background:{{VALUE}};',
                    '{{WRAPPER}} .icon-box-style6 .icon-wrap svg' => 'stroke:{{VALUE}};',
                    '{{WRAPPER}} .icon-box-style6 .icon-wrap i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .icon-box-style6 .icon-wrap svg path' => 'stroke: {{VALUE}}!important;',

                    '{{WRAPPER}} .icon-box-style7 .icon-wrap:before' => 'background: {{VALUE}};',
                    '{{WRAPPER}} .icon-box-style7 .icon-wrap i, {{WRAPPER}} .icon-box-style7:hover .title-wrap h6:before' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .icon-box-style7 .icon-wrap svg path, {{WRAPPER}} .icon-box-style7 .button .arrows .arrow svg' => 'fill: {{VALUE}}!important; stroke: {{VALUE}}!important;',

                    '{{WRAPPER}} .icon-box-style8 .icon-wrap i' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .icon-box-style8 .icon-wrap svg path' => 'stroke: {{VALUE}}!important;',

                    '{{WRAPPER}} .icon-box-style9 .icon-wrap i, {{WRAPPER}} .icon-box-style9:hover .title-wrap h6:before' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .icon-box-style9:after' => 'background: {{VALUE}}!important;',
                    '{{WRAPPER}} .icon-box-style9 .icon-wrap svg path' => 'stroke: {{VALUE}}!important;',
                ],
            ]
        );

        $this->add_control(
            'icon_size',
            [
                'label'     => __('Icon Size', 'saga'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 35,
                ],
                'range' => [
                    'px' => [
                        'min' => 6,
                        'max' => 50,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .iconbox.icon-box-style1 .icon-wrap, {{WRAPPER}} .icon-box-style2 .icon-wrap i, {{WRAPPER}} .icon-box-style3 .icon-wrap i, {{WRAPPER}} .iconbox.icon-box-style4 .icon-wrap, {{WRAPPER}} .iconbox.icon-box-style5 .icon-wrap, {{WRAPPER}} .iconbox.icon-box-style6 .icon-wrap, {{WRAPPER}} .iconbox.icon-box-style7 .icon-wrap, {{WRAPPER}} .icon-box-style8 .icon-wrap i, {{WRAPPER}} .icon-box-style9 .icon-wrap i' => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .iconbox .icon-wrap svg' => 'width:{{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }
    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
      $settings = $this->get_settings_for_display();
      printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
      include $this->get_template('mo-icon-box.php');
      print '</div>';
    }
}