<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @author  WooThemes
 * @package WooCommerce/Templates
 * @version 8.6.0
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product, $woocommerce_loop;
// Ensure visibility
if ( ! $product || ! $product->is_visible() ) {
	return;
}

// Store loop count we're currently on
if ( empty( $woocommerce_loop['loop'] ) ) {
	$woocommerce_loop['loop'] = 0;
}
// Store column count for displaying the grid
if ( empty( $woocommerce_loop['columns'] ) ) {
	$woocommerce_loop['columns'] = apply_filters( 'loop_shop_columns', 4 );
}
// Layout grid/list;
$item_layout = 'grid';
if  (isset($_GET['mo_layout'])) {
	$item_layout = $_GET['mo_layout'];
}
// Increase loop count
$woocommerce_loop['loop']++;
// Extra post classes
$classes = array();
$classes[] = $item_layout;
if($item_layout == 'list') $woocommerce_loop['columns'] = 1;
if($item_layout == 'grid') $woocommerce_loop['columns'] = 3;
switch ($woocommerce_loop['columns']) {
	case 1:
		$classes[] = 'col-xs-12 col-sm-12 col-md-12';
		break;
	case 2:
		$classes[] = 'col-xs-12 col-sm-6 col-md-6';
		break;
	case 3:
		$classes[] = 'col-xs-12 col-sm-6 col-md-4';
		break;
	case 4:
		$classes[] = 'col-xs-12 col-sm-6 col-md-4';
		break;
	default:
		$classes[] = 'col-xs-12 col-sm-6 col-md-4';
		break;
} ?>

<?php
global $product; 
/* set on sale html */
$sale = '';
if ( $product->is_on_sale() ) {
	$sale = '<span class="onsale">' . esc_html__( 'Sale!', 'saga' ) . '</span>';
}

/* set price html */
$price_html = $product->get_price_html();

/* set btn add to cart */
$product_type = '';
if( $product->is_type( 'simple' ) ) {
	$product_type = 'simple';
} elseif( $product->is_type( 'grouped' ) ) {
	$product_type = 'grouped';
} elseif( $product->is_type( 'external' ) ) {
	$product_type = 'external';
} else {
	$product_type = 'variable';
}

$class = implode( ' ', array_filter( array(
				'button',
				'product_type_' . $product_type,
				$product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
				$product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : ''
		) ) );
$add_to_cart = sprintf( '<a rel="nofollow" href="%s" data-quantity="%s" data-product_id="%s" data-product_sku="%s" class="%s">%s</a>',
					esc_url( $product->add_to_cart_url() ),
					esc_attr( isset( $quantity ) ? $quantity : 1 ),
					esc_attr( $product->get_id() ),
					esc_attr( $product->get_sku() ),
					esc_attr( isset( $class ) ? $class : 'button' ),
					'<i class="fa fa-shopping-cart"></i>'
				);

/* set quickview html */
$quickview = do_shortcode('[motivo_quickview layout="woocommerce" pid="'.get_the_ID().'" icon="fa fa-search-plus" extra_class="bt-quickview"]');

/* set categories html */
$cats = get_the_term_list( get_the_ID(), 'product_cat', '', ' / ' );
?>
<div class="<?php echo esc_attr(implode(' ', $classes)); ?>">
	<article <?php post_class(); ?>>
		<div class="mo-thumb">
		    <a class="product-img-tpl" href="<?php the_permalink(); ?>">
			<?php
				//do_action('woocommerce_template_loop_product_link_open');
				do_action('woocommerce_show_product_loop_sale_flash');
				do_action('woocommerce_template_loop_product_thumbnail');
				//do_action('woocommerce_template_loop_product_link_close');
			?></a>
			<div class="mo-actions">
				<?php 
					do_action('woocommerce_template_loop_add_to_cart'); 
					$full = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) ); ?>
					<a class="lightbox-gallery" href="<?php echo esc_url($full); ?>"><i class="fa fa-search"></i></a>
			</div>
		</div>
		<div class="mo-content">
			<?php
				do_action('woocommerce_template_loop_product_link_open');
				do_action('woocommerce_template_loop_product_title');
				do_action('woocommerce_template_loop_product_link_close');
				do_action('woocommerce_template_loop_price');
				do_action('woocommerce_template_loop_rating');
			?>
		</div>
	</article>
</div>