<!DOCTYPE html>
<html <?php language_attributes( 'html' ); ?>>
<head>
    <meta charset="<?php echo esc_attr( get_bloginfo( 'charset' ) ) ?>">
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<link rel="profile" href="https://gmpg.org/xfn/11" />
    <?php global $saga_options;
	wp_head(); ?>
</head>
<body <?php body_class(); ?>>
<?php wp_body_open(); ?>
<div class="wrapper">
<?php $page_loader = (isset($saga_options["page_loader"])&&$saga_options["page_loader"])?$saga_options["page_loader"]: false;
	if($page_loader){ ?>
		<div id="preloader-wrapper" class="img-preloading" data-show-close-time="15000" data-max-load-time="0">
			<div class="loader-inner">
				<div id="loader">
					<div class="imgloading-container">
						<?php if (isset($saga_options['tb_logo']['url']) && $saga_options['tb_logo']['url'] != ""){ $logo = $saga_options['tb_logo']['url']; }?>
						<?php if(!empty($logo)) { echo '<span style="background-image: url('.esc_url($logo).');"></span>';} ?>
					</div>
					<?php if(!empty($logo)) { echo '<img src="'.esc_url($logo).'" data-no-lazy="1" class="skip-lazy" alt="'.esc_attr__('logo','saga').'" />'; }?>
				</div>
			</div>
			<div class="preloader-section section-up"></div>
			<div class="preloader-close" data-mo="parallax" data-mo-move="10"><span class="border-circle"></span></div>
	    </div>
	<?php } ?>
<?php saga_cursor(); ?>
<?php 
$body_layout =& $nubi_options["body_layout"];
if ( $body_layout == 'shapes' || ( get_post_meta( get_the_ID(), 'tb_body_layout', true ) == 'shapes' ) ) {?>
    <div id="particles-js"><canvas class="particles-js-canvas-el"></canvas></div>
<?php } ?>

<?php 
if ( $body_layout == 'lines' || ( get_post_meta( get_the_ID(), 'tb_body_layout', true ) == 'lines' ) ) {?>
	<div class="outer-lines">
		<div class="mo-grid-lines">
			<div class="mo-grid-line"></div>
			<div class="mo-grid-line"></div>
			<div class="mo-grid-line"></div>
		</div>
	</div>
<?php } ?>