<?php
/*-----------------------------------------------*
Define THEME
/*-----------------------------------------------*/
if (!defined('SAGA_URI_PATH')) define('SAGA_URI_PATH', get_template_directory_uri());
if (!defined('SAGA_ABS_PATH')) define('SAGA_ABS_PATH', get_template_directory());
if (!defined('SAGA_URI_PATH_FR')) define('SAGA_URI_PATH_FR', SAGA_URI_PATH.'/framework');
if (!defined('SAGA_ABS_PATH_FR')) define('SAGA_ABS_PATH_FR', SAGA_ABS_PATH.'/framework');
if (!defined('SAGA_URI_PATH_ADMIN')) define('SAGA_URI_PATH_ADMIN', SAGA_URI_PATH_FR.'/admin');
if (!defined('SAGA_ABS_PATH_ADMIN')) define('SAGA_ABS_PATH_ADMIN', SAGA_ABS_PATH_FR.'/admin');

/*-----------------------------------------------*
Register Default Fonts
/*-----------------------------------------------*/
function saga_fonts_url() {
    $font_url = '';
    if ( 'off' !== _x( 'on', 'Google font: on or off', 'saga' ) ) {
        $font_url = add_query_arg( 'family', urlencode('DM Sans|Fira Sans|Marcellus|Syne|Cabin|Inter|Barlow|Readex Pro|Cairo|Roboto'), "//fonts.googleapis.com/css" );
    }
    return $font_url;
}
/*-----------------------------------------------*
Enqueue Style , Script
/*-----------------------------------------------*/
function saga_enqueue_scripts() {
	global $saga_options;
	wp_enqueue_style( 'fonts', saga_fonts_url(), array(), '1.0.0');
	wp_enqueue_style( 'bootstrap', SAGA_URI_PATH. '/assets/css/bootstrap.min.css');
	wp_enqueue_style( 'owl-carousel', SAGA_URI_PATH. '/assets/css/owl-carousel.css' );
    wp_enqueue_style( 'saga-font-icons', SAGA_URI_PATH. '/assets/css/font-icons.css');
    wp_enqueue_style( 'saga-popup', SAGA_URI_PATH. '/assets/css/popup.css' );
	wp_enqueue_style( 'saga-animated', SAGA_URI_PATH. '/assets/css/animated.css' );
	wp_enqueue_style( 'saga-core', SAGA_URI_PATH. '/assets/css/core.css');
    //wp_enqueue_style( 'saga-style', SAGA_URI_PATH.'/assets/css/style.css' );
    wp_enqueue_style( 'saga-style', SAGA_URI_PATH.'/assets/css/style.min.css' );
    wp_enqueue_style( 'saga-wp-custom-style', SAGA_URI_PATH . '/assets/css/wp-custom-style.css');

    /* script */
	if (!class_exists('Woocommerce')) { wp_enqueue_script( 'saga-cookie', SAGA_URI_PATH. '/assets/js/cookie.js', array( 'jquery' ), false, true); }
    wp_enqueue_script( 'saga-scroll', SAGA_URI_PATH. '/assets/js/scroll.js', array( 'jquery' ), false, true);
	wp_enqueue_script( 'saga-switcher', SAGA_URI_PATH. '/assets/js/switcher.js', array( 'jquery' ), false, true);
	wp_enqueue_script( 'saga-magnific', SAGA_URI_PATH. '/assets/js/magnific.js', array( 'jquery' ), false, true);
    wp_enqueue_script( 'saga-custom', SAGA_URI_PATH. '/assets/js/custom.js', array( 'jquery' ), false, true );

	/*  Queue Comments reply js */
	if ( is_singular() && comments_open() && get_option('thread_comments') ){
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'saga_enqueue_scripts' );
/* Add Stylesheet And Script Backend */
function custom_admin_scripts(){
	wp_enqueue_script( 'saga-action', SAGA_URI_PATH_ADMIN.'/assets/js/action.js', array('jquery'), '', true  );
	wp_enqueue_style( 'saga-style-admin', SAGA_URI_PATH_ADMIN.'/assets/css/style-admin.css', false );
}
add_action( 'admin_enqueue_scripts', 'custom_admin_scripts');
/*------------------------------------------*
Framework , Theme Options
/*-----------------------------------------------*/
if( function_exists( 'saga_redux_setup' ) ) {
	saga_redux_setup( SAGA_ABS_PATH_ADMIN.'/options.php' );
}
require_once (SAGA_ABS_PATH_ADMIN.'/index.php');
require_once SAGA_ABS_PATH_FR . '/includes.php';

/* one click demo install */
require_once SAGA_ABS_PATH_FR.'/demo-install.php';

/* Init Functions */
function saga_init() {
	global $saga_options;
	require_once SAGA_ABS_PATH_FR.'/presets.php';
}
add_action( 'init', 'saga_init' );
/* This theme styles the visual editor to resemble the theme style */
function saga_after_setup_theme() {
	add_action( 'wp_enqueue_scripts', 'saga_enqueue_scripts', 99 );
	add_editor_style( 'framework/admin/assets/css/saga-editor.css' );
	if ( is_rtl() ) {
		add_editor_style( 'framework/admin/assets/css/saga-editor-rtl.css' );
	}
}
add_action( 'after_setup_theme', 'saga_after_setup_theme' );
/*-----------------------------------------------*
Template Functions
/*-----------------------------------------------*/
require_once SAGA_ABS_PATH_FR . '/template-functions.php';
require_once SAGA_ABS_PATH_FR . '/templates/post-functions.php';
/*-----------------------------------------------*
elementor
/*-----------------------------------------------*/
require_once(SAGA_ABS_PATH_FR . '/elementor/hooks.php');
/*-----------------------------------------------*
Register Sidebar
/*-----------------------------------------------*/
if (!function_exists('saga_RegisterSidebars')) {
	function saga_RegisterSidebars(){
		register_sidebar(array(
			'name' => esc_html__('Main Sidebar', 'saga'),
			'id' => 'saga-main-sidebar',
		    'description'   => esc_html__( 'This is default sidebar.', 'saga' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="wg-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => esc_html__('Blog Left Sidebar', 'saga'),
			'id' => 'saga-left-sidebar',
			'description'   => esc_html__( 'This is blog left sidebar.', 'saga' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="wg-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => esc_html__('Blog Right Sidebar', 'saga'),
			'id' => 'saga-right-sidebar',
			'description'   => esc_html__( 'This is blog right sidebar.', 'saga' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '</div>',
			'before_title' => '<h4 class="wg-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => esc_html__('Footer Widget 1', 'saga'),
			'id' => 'saga-footer-widget',
		    'description'   => esc_html__( 'This is footer widget sidebar.', 'saga' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '<div style="clear:both;"></div></div>',
			'before_title' => '<h4 class="wg-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => esc_html__('Footer Widget 2', 'saga'),
			'id' => 'saga-footer-widget-2',
		    'description'   => esc_html__( 'This is footer widget sidebar.', 'saga' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '<div style="clear:both;"></div></div>',
			'before_title' => '<h4 class="wg-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => esc_html__('Footer Widget 3', 'saga'),
			'id' => 'saga-footer-widget-3',
		    'description'   => esc_html__( 'This is footer widget sidebar.', 'saga' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '<div style="clear:both;"></div></div>',
			'before_title' => '<h4 class="wg-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => esc_html__('Footer Widget 4', 'saga'),
			'id' => 'saga-footer-widget-4',
		    'description'   => esc_html__( 'This is footer widget sidebar.', 'saga' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '<div style="clear:both;"></div></div>',
			'before_title' => '<h4 class="wg-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => esc_html__('Footer Widget 5', 'saga'),
			'id' => 'saga-footer-widget-5',
		    'description'   => esc_html__( 'This is footer widget sidebar.', 'saga' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '<div style="clear:both;"></div></div>',
			'before_title' => '<h4 class="wg-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => esc_html__('Footer Widget 6', 'saga'),
			'id' => 'saga-footer-widget-6',
		    'description'   => esc_html__( 'This is footer widget sidebar.', 'saga' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '<div style="clear:both;"></div></div>',
			'before_title' => '<h4 class="wg-title">',
			'after_title' => '</h4>',
		));
		register_sidebar(array(
			'name' => esc_html__('Footer Widget 7', 'saga'),
			'id' => 'saga-footer-widget-7',
		    'description'   => esc_html__( 'This is footer widget sidebar.', 'saga' ),
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget' => '<div style="clear:both;"></div></div>',
			'before_title' => '<h4 class="wg-title">',
			'after_title' => '</h4>',
		));
	if (class_exists ( 'Woocommerce' )) {
			register_sidebar(array(
				'name' => esc_html__('Shop Sidebar', 'saga'),
				'id' => 'saga-shop-sidebar',
				'before_widget' => '<div id="%1$s" class="widget %2$s">',
				'after_widget' => '</div>',
				'before_title' => '<h4 class="wg-title">',
				'after_title' => '</h4>',
			));
		}
	}
}
add_action( 'widgets_init', 'saga_RegisterSidebars' );
add_filter( 'use_widgets_block_editor', '__return_false' );

function year_shortcode () {
$year = date_i18n ('Y');
return $year;
}
add_shortcode ('year', 'year_shortcode');

/*-----------------------------------------------*
WooCommerce
/*-----------------------------------------------*/
if (class_exists('Woocommerce')) {
   require_once SAGA_ABS_PATH.'/woocommerce/wc-template-function.php';
   require_once SAGA_ABS_PATH.'/woocommerce/wc-template-hooks.php';
}?>

