<?php 
	$id = get_the_ID();
	$terms = wp_get_object_terms($id, 'category'); 
	if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) {
		$term_link = get_term_link($terms[0]->slug, 'category') ;
		$term_name = $terms[0]->name;
	}
?>
 <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
  <div class="grid-left-post">
   
    <div class="format-post">
		<?php if (has_post_thumbnail()) { ?>
		<figure> 
			<a href="<?php the_permalink(); ?>"><?php the_post_thumbnail('saga-small');?></a>
			<a class="cat-name" href="<?php echo esc_url($term_link) ?>"><?php echo esc_html($term_name) ?></a>
	    </figure>		
		<?php  } else{ ?>
		   <div class="empty_thumbnail"></div>
		<?php  } ?>
	</div>					
	<div class="content-post">
		<ul class="meta-post">
			<li class="date"><?php echo get_the_date(); ?></li>
			<li><div class="author"><?php echo get_the_author(); ?></div></li>
		</ul>
		<h3 class="post-title"><a href="<?php the_permalink(); ?>"> <?php the_title(); ?></a></h3>
		<p class="content"><?php echo saga_custom_excerpt(30); ?></p>
		<a class="btn-arrow" href="<?php echo get_the_permalink(); ?>"><span class="mo_btn_text"><svg><path stroke="null" d="m26.875,13.1l-1.275,-1.275l3.625,-3.625l0.85,-0.575l-0.1,-0.3l-1.025,0.125l-29.45,0.125l-0.125,-1.7l29.575,-0.25l1.025,0.15l0.1,-0.3l-0.85,-0.575l-3.625,-3.625l1.275,-1.275l5.9,5.9l0,1.3l-5.9,5.9z"></path></svg></span></a>
	</div>
  </div> 
</article>