<?php
/*-----------------------------------------------*
  Styling Options
/*-----------------------------------------------*/
function th_load_css() {
	global $saga_options;
	// Custom colors ( Stylesheet select )
	$th_theme_stylesheet =& $saga_options['th_select_stylesheet'];
	$select_stylesheet = get_post_meta(get_the_ID(),'tb_select_stylesheet',true);
	if($select_stylesheet) {
		$th_theme_stylesheet = $select_stylesheet;
	}
	if ( $th_theme_stylesheet != '' && $th_theme_stylesheet !== 'default.css'){
		wp_enqueue_style('saga-color-theme', SAGA_URI_PATH . '/assets/css/colors/'.$th_theme_stylesheet);
	}
}
add_action('wp_enqueue_scripts', 'th_load_css');
/*-----------------------------------------------*
  Style Inline
/*-----------------------------------------------*/
function saga_add_style_inline() {
	global $saga_options;
    $custom_style = null;
	/* Body background */
    $tb_background_color =& $saga_options['body_background']['background-color']; 
    $tb_background_image =& $saga_options['body_background']['background-image'];
    $tb_background_repeat =& $saga_options['body_background']['background-repeat'];
    $tb_background_position =& $saga_options['body_background']['background-position'];
    $tb_background_size =& $saga_options['body_background']['background-size'];
    $tb_background_attachment =& $saga_options['body_background']['background-attachment'];
	if($tb_background_color){
	   $custom_style .= "body{ background-color: $tb_background_color }";
	}
	if($tb_background_image){
		$custom_style .= "body{ background: url('$tb_background_image') $tb_background_repeat $tb_background_attachment $tb_background_position; background-size: $tb_background_size;}";
	}
	/* container-width */
	$mo_container_width =& $saga_options['container_width']['width'];
	if ( $mo_container_width != '') {
		$custom_style .= "@media (min-width:1490px){ .main-container, .page-header .parallax-container, .mo-blog-archive, .container.mo-path-inner, .page-header .container, footer .container, .mo-header-menu .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns4, .elementor-section.elementor-section-boxed>.elementor-container{ width:$mo_container_width !important; max-width:100% !important}}";
	}
	$tb_container_width = get_post_meta(get_the_ID(),'tb_container_width',true);
	if($tb_container_width!= 'global' || $tb_container_width = ''){  
		$custom_style .= "@media (min-width:1490px){ .main-container, .page-header .parallax-container, .mo-blog-archive, .container.mo-path-inner, .page-header .container,footer .container, .mo-header-menu .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns4, .elementor-section.elementor-section-boxed>.elementor-container{ width:$tb_container_width !important; max-width:100% !important }}";
	}
	/* Title bar background */
    $tb_title_bar_bg_color =& $saga_options['tb_title_bar_bg']['background-color'];
    $title_bar_bg_image =& $saga_options['tb_title_bar_bg']['background-image'];
	$bg_title_bar = get_post_meta(get_the_ID(),'tb_bg_title_bar',true);
	if($bg_title_bar) {
		$title_bar_bg_image = $bg_title_bar;
	}
    $title_bar_bg_repeat =& $saga_options['tb_title_bar_bg']['background-repeat'];
    $title_bar_bg_position =& $saga_options['tb_title_bar_bg']['background-position'];
    $title_bar_bg_size =& $saga_options['tb_title_bar_bg']['background-size'];
    $title_bar_bg_attachment =& $saga_options['tb_title_bar_bg']['background-attachment'];
	
	$custom_style .= ".page .wrapper.mo-title-bar-wrap { background-color: $tb_title_bar_bg_color !important;}";
	if($title_bar_bg_image !== ''){
		$custom_style .= "
		.single .wrapper.mo-title-bar-wrap , .mo-portfolio-article .wrapper.mo-title-bar-wrap { 
			 background-image: url('$title_bar_bg_image');
			 background-position: $title_bar_bg_position;
			 background-repeat: $title_bar_bg_repeat;
			 background-attachment:  $title_bar_bg_attachment;
			 background-size: $title_bar_bg_size;
		 }
		.page .wrapper.mo-title-bar-wrap { 
			 background-image: url('$title_bar_bg_image');
			 background-position: $title_bar_bg_position;
			 background-repeat: $title_bar_bg_repeat;
			 background-attachment:  $title_bar_bg_attachment;
			 background-size: $title_bar_bg_size;
		 }";
	 }
	 /* Font Primary */
	$mo_font_primary =& $saga_options['pri_font']['font-family'];
	$tb_font_primary = get_post_meta( get_the_ID(), 'tb_select_font', true );
	if($tb_font_primary != '' ) { $mo_font_primary = $tb_font_primary; }
	if ( $mo_font_primary) {
		$custom_style .= ".font-primary, h1, h2, h3, h4, h5, h6, #loading .loading-wrap .loader_txt, .sidepanel ul.menu li > a, .nav-sidepanel > ul > li > a, .single-header .post-title, .pricing-item.style1 .pricing .pricing-currency, .pricing-item.style2 .pricing .pricing-currency, .pricing-item.style3 .pricing .pricing-currency, .mo-testimonial-carousel.tpl1 .content, .mo-testimonial-carousel.tpl2 .content, .mo-testimonial-carousel.tpl5 .content, .vc_pie_chart_value, .vc_chart .vc_chart-legend li, .vc_tta-tabs.vc_tta .vc_tta-tabs-list .vc_tta-tab > a, .mo-countdown-clock .countdown-item-container .countdown-amount, .mo-countdown-clock .countdown-item-container .countdown-period, .page-header .mo-title-bar h2, .post-pagi .pagi_nav .nav_dir, .mo-team-article .mo-bio, .mo-products-grid.tpl2 .product .mo-thumb .onsale, .mo-product-carousel.tpl2 .product .mo-thumb .onsale, .mo-products-grid.tpl2 .product .mo-content .price, .mo-product-carousel.tpl2 .product .mo-content .price, .mo-single-add-to-cart > span, .mo-product-grid-item .mo-thumb .onsale, .mo-product-list-item .mo-thumb .onsale, .archive-product .grid .product .mo-thumb .onsale, .archive-product .grid .product .mo-thumb .mo-actions .added_to_cart, .archive-product .list .product .mo-thumb .onsale, .single-product .mo-product-item .mo-thumb .onsale, .single-product .mo-product-item .mo-content .cart.variations_form .woocommerce-variation-description, .single-product div.product .woocommerce-tabs ul.tabs > li a, .single-product .mo-related .products .grid .product .mo-thumb .onsale, .woocommerce table.shop_table th, .woocommerce-cart .main-content .woocommerce table.shop_table tbody tr td.product-item a, .woocommerce-cart .main-content .woocommerce .cart-collaterals .cart_totals .shipping-wrap .woocommerce-shipping-calculator > p input, .woocommerce-cart .main-content .woocommerce .cart-collaterals .cart_totals .shipping-wrap .woocommerce-shipping-calculator > p select, .woocommerce-cart .main-content .woocommerce .cart-collaterals .cart_totals .grand-total .total-wrap > ul > li.shipping div ul > li label span, .woocommerce-account .woocommerce-MyAccount-navigation ul li, .woocommerce-account .woocommerce form.login .form-row label, .woocommerce-account .woocommerce form.lost_reset_password .form-row label, .woocommerce-error > a, .woocommerce-info > a, .woocommerce-message > a, .footer .wg-title, .footer .wg-title a{ font-family:'$mo_font_primary' !important;} ";
	}
	/* Font Family */
	$mo_font_family =& $saga_options['sec_font']['font-family']; 
	$tb_font_family = get_post_meta( get_the_ID(), 'tb_select_font_sec', true );
	if($tb_font_family != '' ) { $mo_font_family = $tb_font_family; }
	if($mo_font_family){
		$custom_style .= ".font-family, body, p, .process-box .content .entry-content>p, .entry-content li, .single-post p, .mo-header-menu .mo-menu-list > ul > li > ul > li > a, .mo-header-menu .mo-menu-list > ul > li > ul > li > ul > li > a, .button, .mo-title-box h5, .service .content, .image-box .sup-title, .image-box .content, .portfolio-filter a, .portfolio-effect1 .caption-inner p.term, .portfolio-effect2 .content-block h6, .portfolio-effect3 .details p, .portfolio-effect4 .perspective-caption p.term, .team-title h6, .mo-testimonial-carousel .testimonial-title h6, .counter-number .content, .counter-number.style3 h6{ font-family: '$mo_font_family'; }";
	}
	/* arl_font */
	$mo_font_rtl =& $saga_options['arl_font']['font-family']; 
	if($mo_font_rtl){
	$custom_style .= "body.rtl .font-primary, body.rtl h1, body.rtl h2, body.rtl h3, body.rtl h4,body.rtl h5,body.rtl h6, body.rtl .sidepanel ul.menu li > a, body.rtl .nav-sidepanel > ul > li > a, body.rtl .single-header .post-title, body.rtl .pricing-item.style1 .pricing .pricing-currency, body.rtl .pricing-item.style2 .pricing .pricing-currency, body.rtl .pricing-item.style3 .pricing .pricing-currency, body.rtl .mo-testimonial-carousel.tpl1 .content, body.rtl .mo-testimonial-carousel.tpl2 .content, body.rtl .mo-testimonial-carousel.tpl5 .content,body.rtl .mo-countdown-clock .countdown-item-container .countdown-amount, body.rtl .mo-countdown-clock .countdown-item-container .countdown-period, body.rtl .page-header .mo-title-bar h2, body.rtl .post-pagi .pagi_nav .nav_dir, body.rtl .mo-team-article .mo-bio, body.rtl .mo-products-grid.tpl2 .product .mo-thumb .onsale,  body.rtl.mo-product-carousel.tpl2 .product .mo-thumb .onsale, body.rtl .mo-products-grid.tpl2 .product .mo-content .price, body.rtl .mo-product-carousel.tpl2 .product .mo-content .price, body.rtl .mo-single-add-to-cart > span, body.rtl .mo-product-grid-item .mo-thumb .onsale, body.rtl .mo-product-list-item .mo-thumb .onsale, body.rtl .archive-product .grid .product .mo-thumb .onsale, body.rtl .archive-product .grid .product .mo-thumb .mo-actions .added_to_cart, body.rtl .archive-product .list .product .mo-thumb .onsale, body.rtl .single-product .mo-product-item .mo-thumb .onsale, body.rtl .single-product .mo-product-item .mo-content .cart.variations_form .woocommerce-variation-description, body.rtl .single-product div.product .woocommerce-tabs ul.tabs > li a, body.rtl .single-product .mo-related .products .grid .product .mo-thumb .onsale, body.rtl .woocommerce table.shop_table th,  body.rtl .woocommerce-cart .main-content .woocommerce table.shop_table tbody tr td.product-item a, body.rtl .woocommerce-cart .main-content .woocommerce .cart-collaterals .cart_totals .shipping-wrap .woocommerce-shipping-calculator > p input,  body.rtl .woocommerce-cart .main-content .woocommerce .cart-collaterals .cart_totals .shipping-wrap .woocommerce-shipping-calculator > p select, body.rtl .woocommerce-cart .main-content .woocommerce .cart-collaterals .cart_totals .grand-total .total-wrap > ul > li.shipping div ul > li label span, body.rtl .woocommerce-account .woocommerce-MyAccount-navigation ul li, body.rtl .woocommerce-account .woocommerce form.login .form-row label, body.rtl .woocommerce-account .woocommerce form.lost_reset_password .form-row label, body.rtl .woocommerce-error > a, .woocommerce-info > a, body.rtl .woocommerce-message > a, body.rtl .footer .wg-title, body.rtl .footer .wg-title a,
		body.rtl .font-family, body.rtl, body.rtl p, body.rtl .process-box .content .entry-content>p, body.rtl .entry-content li, body.rtl .single-post p, body.rtl .mo-header-menu .mo-menu-list > ul > li > ul > li > a, body.rtl .mo-header-menu .mo-menu-list > ul > li > ul > li > ul > li > a, .button, body.rtl .mo-title-box h5,body.rtl .service .content, body.rtl .image-box .sup-title, body.rtl .image-box .content, body.rtl .portfolio-filter a, body.rtl .portfolio-effect1 .caption-inner p.term, body.rtl .portfolio-effect2 .content-block h6, body.rtl .portfolio-effect3 .details p, body.rtl .portfolio-effect4 .perspective-caption p.term, body.rtl .team-title h6, body.rtl .mo-testimonial-carousel .testimonial-title h6, body.rtl .counter-number .content, body.rtl .counter-number.style3 h6, body.rtl #mo_header .mo-menu-list > ul > li > a, body.rtl #mo_header .mo-search-sidebar > a, body.rtl #mo_header .select-languages > a{ font-family: '$mo_font_rtl' !important; }";	}
		
		/* tbody background COLOR*/
	$body_background_color = get_post_meta( get_the_ID(), 'tb_body_background', true );
	if($body_background_color) {
       $custom_style .= "body, .main-content, .internal-content{ background-color: $body_background_color; }";
	}
	//$th_primary_color //$th_main_color;
	$main_color =& $saga_options['th_primary_color'];
	if( $main_color != '' ){
		$custom_style .= ":root {--color-primary: $main_color;";
	}
	/* portfolio container width */
	$mo_portfolio_container_width =& $saga_options['portfolio_container_width']['width'];
	if ( $mo_portfolio_container_width != '') {
		$custom_style .= ".mo-portfolio-article.portfolio-full .container, .mo-portfolio-article.portfolio-parallax .container{ max-width:$mo_portfolio_container_width !important;}";
	}
	//tb_footer(v1)
	$tb_footer_v1_backgroud  =& $saga_options['tb_footer_backgroud']['background-color'];
    $tb_footer_v1_typography =& $saga_options['tb_footer_typography']['color'];
	if($tb_footer_v1_backgroud !== '' && $tb_footer_v1_typography !== '' ){
		$custom_style .= " .footer_v1 .mc4wp-form { color:$tb_footer_v1_typography !important;} .footer_v1 input, .footer_v1 .input_field , .footer_v1 select , .footer_v1 .widget_calendar .calendar_wrap table caption, .footer_v1 .widget_calendar .calendar_wrap table td, .footer_v1 .widget_calendar .calendar_wrap table th { border-color:$tb_footer_v1_typography !important;}";}
	//tb_footer(v2)
	$tb_footer_v2_backgroud  =& $saga_options['tb_footer_v2_backgroud']['background-color'];
    $tb_footer_v2_title_typography =& $saga_options['tb_footer_v2_title_typography']['color'];
	$tb_footer_v2_typography =& $saga_options['tb_footer_v2_typography']['color'];
	if($tb_footer_v2_backgroud !== '' && $tb_footer_v2_typography !== '' && $tb_footer_v2_title_typography !== '' ){
		$custom_style .= " .footer_v2 .mc4wp-form { color:$tb_footer_v2_typography !important;} .footer_v2 input, .footer_v2 .input_field , .footer_v2 select , .footer_v2 .widget_calendar .calendar_wrap table caption, .footer_v2 .widget_calendar .calendar_wrap table td, .footer_v2 .widget_calendar .calendar_wrap table th { border-color:$tb_footer_v2_typography !important;}";
	}
    wp_add_inline_style( 'saga-wp-custom-style', $custom_style );
}
add_action( 'wp_enqueue_scripts', 'saga_add_style_inline' );