<?php
/**
 * Demo Import Data
 * @package saga
 * @version 1.1
 */
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}
function saga_import_files() {
    return array(
      array(
        'import_file_name' => 'Demo Import',
        'local_import_file' => trailingslashit(get_template_directory()) . 'demo-data/main-demo/content.xml',
        'local_import_widget_file' => trailingslashit(get_template_directory()) .  'demo-data/main-demo/widgets.wie',
        'local_import_redux' => array(
            array(
                'file_path' => trailingslashit(get_template_directory()) . 'demo-data/main-demo/settings.json',
                'option_name' => 'saga_options',
            ),
        ),
       'import_preview_image_url'   =>  SAGA_URI_PATH . '/demo-data/main-demo/screen-image.jpg',
        'import_notice'              => esc_html__( 'After you import this demo, you will have to setup the slider separately.', 'saga' ),
        'preview_url'                => 'https://motivoweb.com/saga/',
      ),
    );
}
add_filter( 'pt-ocdi/import_files', 'saga_import_files' );

function saga_after_import_setup() {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );
    set_theme_mod( 'nav_menu_locations', array(
            'main_navigation' => $main_menu->term_id,
        )
    );
    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home page 1' );
    $blog_page_id  = get_page_by_title( 'Blog' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'page_for_posts', $blog_page_id->ID );
}
add_action( 'pt-ocdi/after_import', 'saga_after_import_setup' );