<?php
    /**
     * ReduxFramework Sample Config File
     * For full documentation, please visit: http://docs.reduxframework.com/
     */
    if ( ! class_exists( 'Redux' ) ) {
        return;
    }
    $opt_name = "saga_options";
    $opt_name = apply_filters( 'redux_demo/opt_name', $opt_name );
    $theme = wp_get_theme(); // For use with some settings. Not necessary.
    $args = array(
        'opt_name'             => $opt_name,
        'display_name'         => $theme->get( 'Name' ),
        'display_version'      => $theme->get( 'Version' ),
		'menu_type'            => 'submenu',
        'menu_title'           => esc_html__( 'Theme Options', 'saga' ),
		'page_title'           => esc_html__( 'Theme Options', 'saga' ),
        'google_api_key'       => '',
		'google_update_weekly' => false,
		'async_typography'     => true,
        'admin_bar'            => true,
        'dev_mode'             => false,
		'update_notice'        => false,
		'show_options_object'  => false,
		'customizer'           => false, 
        'page_parent'          => 'themes.php',
        'page_permissions'     => 'manage_options',
        'show_import_export'   => true,
        'output'               => true,
    );
    Redux::setArgs( $opt_name, $args );
	// -> START General
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'General', 'saga' ),
		'icon'   => 'el-icon-cogs',
		'fields' => array(
			array(
                'id'       => 'body_layout',
                'type'     => 'button_set',
                'title'    => esc_html__( 'Layout', 'saga' ),
                'subtitle' => esc_html__( 'Body layout with wide or boxed.', 'saga' ),
                'options'  => array(
					'wide' => esc_html__( 'Wide', 'saga' ),
                    'boxed'=> esc_html__( 'Boxed', 'saga' ),
					'lines'=> esc_html__( 'lines', 'saga' ),
                ),
                'default'  => esc_html__( 'wide', 'saga' ),
            ),
		   array(
				'id' => 'container_width',
				'title' => 'Container Width',
		        'subtitle' => esc_html__('in pixels.', 'saga'),
				'type' => 'dimensions',
			    'units' => array('px'),
				'height' => false,
				'default' => array(
	            	'units' => 'px',
				    'width' => '1240'
				)
			),
			array(
				'id'       => 'page_loader',
				'type'     => 'switch',
				'title'    => esc_html__( 'Page Loader', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable page loader.', 'saga' ),
				'default'  => true,
			),
		    array(
				'id'       => 'select_cursor',
				'type'     => 'select',
				'title'    => esc_html__( 'Mouse Cursor', 'saga' ),
				'subtitle' => esc_html__( 'Select your mouse cursor style.', 'saga' ),
				'options'  => array(
		              'normal' => esc_html__( 'Default', 'saga' ), 
		              'style1' => esc_html__( 'Style1' , 'saga' ), 
					  'style2' => esc_html__( 'Style2' , 'saga' ),
		              'style3' => esc_html__( 'Style3' , 'saga' ),
					  'style4' => esc_html__( 'Style4' , 'saga' ),
				  ),
				'default'  => 'normal',
			),
			array(
				'id'       => 'dark_mode',
				'type'     => 'switch',
				'title'    => esc_html__( 'Dark Mode', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable dark mode.', 'saga' ),
				'default'  => false,
				'description' => esc_html__( 'Clear the cache after switching between light and dark mode.', 'saga' ),
			),
		 )
	) );
	// -> START Color
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Color', 'saga' ),
        'id'     => 'color',
        'icon'   => 'el el-brush',
		'fields' => array(
			array(
				'id'       => 'th_select_stylesheet',
				'type'     => 'select',
				'title'    => esc_html__( 'Theme Stylesheet', 'saga' ),
				'subtitle' => esc_html__( 'Select your themes alternative color scheme.', 'saga' ),
				'options'  => array(
		              ''            =>  esc_html__( 'default', 'saga' ),
		              'blue.css'    =>  esc_html__( 'Blue'   , 'saga' ),
		              'purple.css'  =>  esc_html__( 'Purple' , 'saga' ),
					  'red.css'     =>  esc_html__( 'Red'    , 'saga' ),
					  'orange.css'  =>  esc_html__( 'Orange' , 'saga' ),
					  'green.css'   =>  esc_html__( 'Green'  , 'saga' ),
					  'gold.css'    =>  esc_html__( 'Gold'   , 'saga' ),
					  'cyan.css'    =>  esc_html__( 'Cyan'   , 'saga' ),
				  ),
		         'default'  => '',
			),
			array(
				'id'       => 'th_primary_color',
				'type'     => 'color',
				'title'    => esc_html__('Primary Color', 'saga'),
				'subtitle' => esc_html__('Controls primary color items. (default: #e60000).', 'saga'),
				'default'  => '',
				'validate' => 'color',
			),
			array(
				'id'       => 'body_background',
				'type'     => 'background',
				'title'    => esc_html__('Body Background', 'saga'),
				'subtitle' => esc_html__('Body background with image, color, etc.', 'saga'),
				'output'      => array('body , .main-content , .internal-content'),
				'background-image'      => false,
				'background-repeat'     => false,
				'background-attachment' => false,
				'background-position'   => false,
				'background-image'      => false,
				'background-size'       => false,
				'transparent'           => false,
		        'default'  => array(
					'background-color' => '#fff',
				),
			),
		 )
    ) );

	// -> START Typography
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Typography', 'saga' ),
        'id'     => 'typography',
		'icon'   => 'el el-font',
        'fields' => array(
			array (
				'id'           => 'pri_font',
				'type'         => 'typography', 
				'title'        => esc_html__( 'Primary Font Options', 'saga' ),
				'google'       => true, 
				'font-backup'  => true,
				'line-height'  => false,
				'text-align'   => false,
				'font-style'   => false,
				'font-weight'  => false,
				'font-size'    => false,
				'subsets'      => false,
				'subtitle'     => esc_html__('Typography option for Heading font.', 'saga'),
				'output'       => array('.font-primary'),
				'default'      => array (
				   'font-family' => 'Fira Sans',
				   'color'       => '#101828', 
				),
			 ),
			 array (
				'id'           => 'sec_font',
				'type'         => 'typography', 
				'title'        => esc_html__( 'Secondary Font Options', 'saga' ),
				'google'       => true, 
				'font-backup'  => true,
				'line-height'  => false,
				'text-align'   => false,
				'font-style'   => false,
				'font-weight'  => false,
				'font-size'    => false,
				'subsets'      => false,
				'subtitle'     => esc_html__('Typography option for secondary font.', 'saga'),
				'output'       => array('.font-family, body, .entry-content>p, .entry-content li'),
				'default'      => array (
				   'font-family' => 'Roboto', 
				   'color'       => '#6a7c92', 
				),
			 ),
			array (
				'id'           => 'arl_font',
				'type'         => 'typography', 
				'title'        => esc_html__( 'RTL Font Options', 'saga' ),
				'google'       => true, 
				'font-backup'  => true,
				'line-height'  => false,
				'text-align'   => false,
				'font-style'   => false,
				'font-weight'  => false,
				'font-size'    => false,
				'subsets'      => false,
				'color'        => false,
				'subtitle'     => esc_html__('Typography option for RTL font.', 'saga'),
				'output'       => array('body.rtl'),
				'default'      => array (
					'font-family' => 'Cairo', 
				),
			),
			array(
				'id'          => 'h1_font',
				'type'        => 'typography', 
				'title'       => esc_html__('H1 Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('h1'),
				'units'       =>'px',
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '600',  
					'font-family' => 'Roboto',  
					'google'      => true,
					'font-size'   => '54px',
					'line-height' => '48px'
				),
			),
			array(
				'id'          => 'h2_font',
				'type'        => 'typography', 
				'title'       => esc_html__('H2 Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('h2'),
				'units'       =>'px',
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '600',  
					'font-family' => 'Fira Sans',  
					'google'      => true,
					'font-size'   => '42px', 
					'line-height' => '48px'
				),
			),
			array(
				'id'          => 'h3_font',
				'type'        => 'typography', 
				'title'       => esc_html__('H3 Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('h3'),
				'units'       =>'px',
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '600',  
					'font-family' => 'Fira Sans',
					'google'      => true,
					'font-size'   => '36px', 
					'line-height' => '42px'
				),
			),
			array(
				'id'          => 'h4_font',
				'type'        => 'typography', 
				'title'       => esc_html__('H4 Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('h4'),
				'units'       =>'px',
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '600',  
					'font-family' => 'Fira Sans', 
					'google'      => true,
					'font-size'   => '30px', 
					'line-height' => '36px',
				),
			),
			array(
				'id'          => 'h5_font',
				'type'        => 'typography', 
				'title'       => esc_html__('H5 Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('h5'),
				'units'       =>'px',
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '600',  
					'font-family' => 'Fira Sans', 
					'google'      => true,
					'font-size'   => '24px', 
					'line-height' => '30px',
				),
			),
			array(
				'id'          => 'h6_font',
				'type'        => 'typography', 
				'title'       => esc_html__('H6 Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('h6'),
				'units'       =>'px',
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '600',  
					'font-family' => 'Fira Sans',  
					'google'      => true,
					'font-size'   => '18px', 
					'line-height' => '24px',
				),
			),
			array(
				'id'          => 'body_font',
				'type'        => 'typography', 
				'title'       => esc_html__('Post Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.single .entry-content>p'),
				'units'       =>'px',
				'default'     => array(
					'font-weight' => '400', 
					'font-family' => 'Roboto', 
					'google'      => true,
					'font-size'   => '17px', 
					'line-height' => '28px',
					'letter-spacing' => '0'
				),
			),
        )
    ) );
	
	// -> START Logo
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Logo', 'saga' ),
        'id'     => 'logo',
        'icon'   => 'el el-icon-viadeo',
		'fields' => array(
			array(
				'id'       => 'tb_logo',
				'type'     => 'media',
				'url'      => true,
				'title'    => esc_html__('Logo', 'saga'),
				'subtitle' => esc_html__('Select an image file for your logo.', 'saga'),
				'default'  => array('url'	=> SAGA_URI_PATH.'/assets/images/logo.png'),
			),
		   array(
				'id'       => 'tb_logo_white',
				'type'     => 'media',
				'url'      => true,
				'title'    => esc_html__('Logo white', 'saga'),
				'subtitle' => esc_html__('Select an image file for your white logo.', 'saga'),
				'default'  => array('url'	=> SAGA_URI_PATH.'/assets/images/logo-white.png'),
			),
			array(
				'subtitle' => esc_html__('in pixels.', 'saga'),
				'id' => 'logo_height',
				'title' => 'Logo Height',
				'type' => 'dimensions',
			    'units' => array('px'),
				'width' => false,
				'output' => array('.mo-header-v1 .logo img , .mo-header-v2 .mo-logo img , .mo-header-v3 .mo-logo img , .mo-header-v4 .mo-logo img , .mo-header-v5 .mo-logo img , .mo-header-v6 .mo-logo img , .mo-header-v7 .mo-logo img, .mo-header-onepage .mo-logo img, .mo-left-navigation .mo-header-menu .mo-logo img, .navigation img.Logo_white, .navigation .logo.logo_page, .loading-wrap .logotype'),
				'default' => array(
	            	'units' => 'px',
				   'height' => '37px'
				)
			),
		)
    ) );
	
	// -> START Header
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Header', 'saga' ),
        'id'     => 'header',
        'icon'   => 'el el-credit-card',
		'fields' => array(
			array( 
				'id'       => 'tb_header_layout',
				'type'     => 'image_select',
				'title'    => esc_html__('Header Layout', 'saga'),
				'subtitle' => esc_html__('Select header layout in your site.', 'saga'),
				'options'  => array(
					'sidepanel'	=> array(
						'alt'   => 'Header V1',
						'img'   => SAGA_URI_PATH.'/assets/images/headers/header-v1.png'
					),
					'header-v2'	=> array(
						'alt'   => 'Header V2',
						'img'   => SAGA_URI_PATH.'/assets/images/headers/header-v2.png'
					),
					'header-v3'	=> array(
						'alt'   => 'Header V3',
						'img'   => SAGA_URI_PATH.'/assets/images/headers/header-v3.png'
					),
					'header-v4'	=> array(
						'alt'   => 'Header V4',
						'img'   => SAGA_URI_PATH.'/assets/images/headers/header-v4.png'
					),
					'header-v5'	=> array(
						'alt'   => 'Header V5',
						'img'   => SAGA_URI_PATH.'/assets/images/headers/header-v5.png'
					),
					'header-v6'	=> array(
						'alt'   => 'Header V6',
						'img'   => SAGA_URI_PATH.'/assets/images/headers/header-v6.png'
					),
		            'header-v7'	=> array(
						'alt'   => 'Header V7',
						'img'   => SAGA_URI_PATH.'/assets/images/headers/header-v7.png'
					),
				),
				'default' => 'header-v2'
			),
		)
    ) );
	
		// -> START Main Menu
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Main Menu', 'saga' ),
        'id'     => 'main_menu',
        'icon'   => 'el el-icon-list',
    ) );
	
	// -> START Main Menu Header V1
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Menu Header V1', 'saga' ),
        'id'     => 'main_menu_v1',
        'subsection' => true,
		'fields' => array(
		    array(
				'id'       => 'fixed_main_menu_v1',
				'type'     => 'switch',
				'title'    => esc_html__( 'Fixed Menu', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable fixed menu.', 'saga' ),
				'default'  => false,
			),
			array(
				'id'       => 'width_main_menu_v1',
				'type'     => 'button_set',
				'title'    => esc_html__( 'Width Menu', 'saga' ),
				'options'  => array(
                    'full'=> esc_html__( 'Full', 'saga' ), 
                    'main-container' => esc_html__( 'Container', 'saga' ),
                ),
                'default'  => 'main-container'
			),
			array(
                'id'       => 'menu_color_v1',
                'type'     => 'button_set',
                'title'    => esc_html__('Menu Color Mode ', 'saga'),
                'options'  => array(
                    'color-white'=> esc_html__( 'White', 'saga' ), 
                    'color-dark' => esc_html__( 'Dark', 'saga' ),
                ),
                'default'  => 'color-white'
            ),
			array(
				'id'       => 'menu_bgcolor_open_v1',
				'type'     => 'background',
				'title'    => esc_html__('Background Opne Nav', 'saga'),
				'subtitle' => esc_html__('Controls background color open menu. (default:#0E1117).', 'saga'),
				'default'  => array(
					'background-color' => '#0E1117',
				),
				'validate' => 'background',
				'output'   => array('.mo-sidepanel-v1.sidepanel'),
			),
			array(
				'id'          => 'menu_first_level',
				'type'        => 'typography', 
				'title'       => esc_html__('Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-header-v1 .nav-sidepanel > ul > li > a, .mo-header-v1 .nav-sidepanel > ul ul li a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#fff', 
					'font-family' => 'Fira Sans',  
					'google'      => true,
					'line-height' => '57px',
		            'font-size'   => '50px',
		            'font-weight' => '600',  
					'letter-spacing' => '0'
				),
			),
			array(
				'id'=>'menu_other_v1',
				'type' => 'button_set',
				'title' => esc_html__('Menu Right Icons', 'saga'),
				'multi' => true,
				'options'=> array(
					'social'    => esc_html__('Social', 'saga'),
					'button'    => esc_html__('Button', 'saga'),
					'switcher'  => esc_html__('Switcher', 'saga'),
				),
				'default' => array('button','switcher'),      
			),
			array(
				'id'       => 'menu_but_txt_v1',
				'type'     => 'text',
				'title'    => esc_html__('Menu Left Button', 'saga'),
				'subtitle' => esc_html__('Please, Enter menu right button name.', 'saga'),
				'required' => array('menu_other_v1','=', 'button'),
		        'default'  => 'Get A Quote',     
			),
		    array(
				'id'       => 'menu_but_link_v1',
				'type'     => 'text',
				'title'    => esc_html__('Menu Left Button Link', 'saga'),
				'subtitle' => esc_html__('Please, Enter menu right button link.', 'saga'),
				'required' => array('menu_other_v1','=', 'button'),
				'default'  => '#',     
			),
		)
    ) );
	
	// -> START Main Menu Header V2
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Menu Header V2', 'saga' ),
        'id'     => 'main_menu_v2',
        'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'stick_main_menu_v2',
				'type'     => 'switch',
				'title'    => esc_html__( 'Stick Menu', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable stick menu.', 'saga' ),
				'default'  => true,
			),
			array(
				'id'          => 'menu_first_level_v2',
				'type'        => 'typography', 
				'title'       => esc_html__('First Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-header-v2 .mo-menu-list > ul > li > a , .mo-header-v2 .mo-search-sidebar > a , .mo-header-v2 .select-languages > a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828',
					'font-family' => 'Fira Sans',    
					'google'      => true,
		            'line-height' => '28px',
		            'font-size'   => '15px',
					'letter-spacing' => '0'
				),
			),
			array(
				'id'       => 'bg_main_menu_v2',
				'type'     => 'background',
				'title'    => esc_html__('Background', 'saga'),
				'subtitle' => esc_html__('Controls background color (default:#fff).', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				),
				'output'   => array('.mo-header-v2 .mo-header-menu'),
			),
		    array(
				'id'          => 'menu_sub_level_v2',
				'type'        => 'typography', 
				'title'       => esc_html__('Sub Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-header-v2 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > a, .mo-header-v2 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul > li > a, .mo-header-v2 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > a, .mo-header-v2 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns2 > li > ul > li > a, .mo-header-v2 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns3 > li > ul > li > a, .mo-header-v2 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns4 > li > ul > li > a, .mo-header-v2 .mo-cart-content .total, .mo-header-v2 .mo-cart-content .cart_list.product_list_widget .mini_cart_item > a, .mo-header-v2 .mo-cart-header > a, .mo-header-v2 .mo-search-header > a, .mo-header-v2 .mo-cart-content .quantity, .mo-header-v2 .select-languages ul a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '400', 
					'font-family' => 'Roboto',  
					'google'      => true,
					'font-size'   => '14px', 
					'line-height' => '23px',
					'letter-spacing' => '0',
				),
			),
			array(
				'id'       => 'bg_main_menu_sub_level_v2',
				'type'     => 'background',
				'title'    => esc_html__('Background Sub Level', 'saga'),
				'subtitle' => esc_html__('Controls background color (default:#171a1d).', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				),
				'output'   => array('.mo-header-v2 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul , .mo-header-v2 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > ul, .mo-header-v2 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul, .mo-header-v2 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul, .mo-header-v2 .mo-cart-content , .mo-header-v2 .header_search, .mo-header-v2 .select-languages ul'),
			),
			array(
				'id'       => 'bg_stick_main_menu_v2',
				'type'     => 'background',
				'title'    => esc_html__('Stick Background', 'saga'),
				'subtitle' => esc_html__('Controls background color (default:#fff).', 'saga'),
				'default'  => array(
					'background-color' => 'rgba(255, 255, 255, 0.946)',
				),
				'output'   => array('.mo-stick-active .mo-header-v2.mo-header-stick .mo-header-menu'),
				'required' => array('stick_main_menu_v2','=', true),
			),
			array(
				'id'=>'menu_other_v2',
				'type' => 'button_set',
				'title' => esc_html__('Menu Right Icons', 'saga'),
				'multi' => true,
				'options'=> array(
					'lang'      => esc_html__('Lang', 'saga'), 
		            'cart'      => esc_html__('Cart', 'saga'),
					'search'    => esc_html__('Search', 'saga'),
					'button'    => esc_html__('Button', 'saga'),
					'call'      => esc_html__('Call Button', 'saga'),
					'switcher'  => esc_html__('Switcher', 'saga'),
				),
				'default' => array('button','call'),      
			),
			array(
				'id'       => 'menu_but_txt_v2',
				'type'     => 'text',
				'title'    => esc_html__('Menu Left Button', 'saga'),
				'subtitle' => esc_html__('Please, Enter menu right button name.', 'saga'),
				'required' => array('menu_other_v2','=', 'button'),
		        'default'  => 'Get A Quote',     
			),
		    array(
				'id'       => 'menu_but_link_v2',
				'type'     => 'text',
				'title'    => esc_html__('Menu Left Button Link', 'saga'),
				'subtitle' => esc_html__('Please, Enter menu right button link.', 'saga'),
				'required' => array('menu_other_v2','=', 'button'),
				'default'  => '#',     
			),
			array(
				'id'       => 'menu_other_call_ques_v2',
				'type'     => 'text',
				'title'    => esc_html__('Call Button text', 'saga'),
				'subtitle' => esc_html__('Please, Enter call text in the side of button.', 'saga'),
				'required' => array('menu_other_v2','=', 'call'),
				'default'  => 'Have Any Questions?',
			),
				array(
				'id'       => 'menu_other_call_v2',
				'type'     => 'text',
				'title'    => esc_html__('Button', 'saga'),
				'subtitle' => esc_html__('Please, Enter call button name.', 'saga'),
				'required' => array('menu_other_v2','=', 'call'),
				'default'  => '+020.098.456',
			),
			array(
				'id'       => 'menu_other_call_link_v2',
				'type'     => 'text',
				'title'    => esc_html__('Button Link (Menu Right)', 'saga'),
				'subtitle' => esc_html__('Please, Enter call button link.', 'saga'),
				'required' => array('menu_other_v2','=', 'call'),
				'default'  => 'tel:+020.098.456',
			),
			array(
				'id'       => 'sidepanelv2',
				'type'     => 'switch',
				'title'    => esc_html__( 'Sidepanel', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable Sidepanel.', 'saga' ),
				'default'  => false,
			),
	     )
    ) );
	// -> START Main Menu Header V3
	Redux::setSection( $opt_name, array(
		'title'  => esc_html__( 'Menu Header V3', 'saga' ),
		'id'     => 'main_menu_v3',
		'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'stick_main_menu_v3',
				'type'     => 'switch',
				'title'    => esc_html__( 'Stick Menu', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable stick menu.', 'saga' ),
				'default'  => true,
			),
			array(
				'id'          => 'menu_first_level_v3',
				'type'        => 'typography', 
				'title'       => esc_html__('First Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-header-v3 .mo-menu-list > ul > li > a , .mo-header-v3 .mo-search-sidebar > a , .mo-header-v3 .select-languages > a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828',
					'font-family' => 'Fira Sans',    
					'google'      => true,
					'line-height' => '28px',
					'font-size'   => '15px',
					'letter-spacing' => '0'
				),
			),
			array(
				'id'       => 'bg_main_menu_v3',
				'type'     => 'background',
				'title'    => esc_html__('Background', 'saga'),
				'subtitle' => esc_html__('Controls background color (default:#fff).', 'saga'),
				'default'  => array(
					'background-color' => '',
				),
				'output'   => array('.mo-header-v3 .mo-header-menu'),
			),
			array(
				'id'          => 'menu_sub_level_v3',
				'type'        => 'typography', 
				'title'       => esc_html__('Sub Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-header-v3 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > a, .mo-header-v3 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul > li > a, .mo-header-v3 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > a, .mo-header-v3 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns2 > li > ul > li > a, .mo-header-v3 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns3 > li > ul > li > a, .mo-header-v3 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns4 > li > ul > li > a, .mo-header-v3 .mo-cart-content .total, .mo-header-v3 .mo-cart-content .cart_list.product_list_widget .mini_cart_item > a, .mo-header-v3 .mo-cart-header > a, .mo-header-v3 .mo-search-header > a, .mo-header-v3 .mo-cart-content .quantity, .mo-header-v3 .select-languages ul a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '400', 
					'font-family' => 'Roboto',  
					'google'      => true,
					'font-size'   => '14px', 
					'line-height' => '23px',
					'letter-spacing' => '0',
				),
			),
			array(
				'id'       => 'bg_main_menu_sub_level_v3',
				'type'     => 'background',
				'title'    => esc_html__('Background Sub Level', 'saga'),
				'subtitle' => esc_html__('Controls background color (default:#171a1d).', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				),
				'output'   => array('.mo-header-v3 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul, .mo-header-v3 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > ul, .mo-header-v3 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul, .mo-header-v3 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul, .mo-header-v3 .mo-cart-content , .mo-header-v3 .header_search, .mo-header-v3 .select-languages ul'),
			),
			array(
				'id'       => 'bg_stick_main_menu_v3',
				'type'     => 'background',
				'title'    => esc_html__('Stick Background', 'saga'),
				'subtitle' => esc_html__('Controls background color (default:#fff).', 'saga'),
				'default'  => array(
					'background-color' => 'rgba(255, 255, 255, 0.946)',
				),
				'output'   => array('.mo-stick-active .mo-header-v3.mo-header-stick .mo-header-menu'),
				'required' => array('stick_main_menu_v3','=', true),
			),
			array(
				'id'=>'menu_other_v3',
				'type' => 'button_set',
				'title' => esc_html__('Menu Right Icons', 'saga'),
				'multi' => true,
				'options'=> array(
					'lang'      => esc_html__('Lang', 'saga'), 
					'cart'      => esc_html__('Cart', 'saga'),
					'search'    => esc_html__('Search', 'saga'),
					'button'    => esc_html__('Button', 'saga'),
					'social'    => esc_html__('Social', 'saga'),
					'switcher'  => esc_html__('Switcher', 'saga'),
					
				),
				'default' => array('social','switcher'),      
			),
			array(
				'id'       => 'menu_but_txt_v3',
				'type'     => 'text',
				'title'    => esc_html__('Menu Left Button', 'saga'),
				'subtitle' => esc_html__('Please, Enter menu right button name.', 'saga'),
				'required' => array('menu_other_v3','=', 'button'),
				'default'  => 'Get A Quote',     
			),
			array(
				'id'       => 'menu_but_link_v3',
				'type'     => 'text',
				'title'    => esc_html__('Menu Left Button Link', 'saga'),
				'subtitle' => esc_html__('Please, Enter menu right button link.', 'saga'),
				'required' => array('menu_other_v3','=', 'button'),
				'default'  => '#',     
			),
			array(
				'id'       => 'sidepanelv3',
				'type'     => 'switch',
				'title'    => esc_html__( 'Sidepanel', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable Sidepanel.', 'saga' ),
				'default'  => false,
			),
		 )
	) );
   // -> START Main Menu Header V4
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Menu Header V4', 'saga' ),
        'id'     => 'main_menu_v4',
        'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'stick_main_menu_v4',
				'type'     => 'switch',
				'title'    => esc_html__( 'Stick Menu', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable stick menu.', 'saga' ),
				'default'  => true,
			),
			array(
				'id'       => 'bg_main_menu_v4',
				'type'     => 'background',
				'title'    => esc_html__('Background Header', 'saga'),
				'subtitle' => esc_html__('Controls background color (default: transparent).', 'saga'),
				'default'  => array(
					'background-color' => '',
				),
				'output'   => array('.mo-header-v4 .mo-header-menu , .mo-header-v4 #lang > ul li > ul'),
			),
			array(
				'id'       => 'bg_main_menu_sub_level_v4',
				'type'     => 'background',
				'title'    => esc_html__('Background Sub Level', 'saga'),
				'subtitle' => esc_html__('Controls background color (default: #041026).', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				),
				'output'   => array('.mo-header-v4 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul , .mo-header-v4 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > ul, .mo-header-v4 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul, .mo-header-v4 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul, .mo-header-v4 .mo-cart-content , .mo-header-v4 .header_search'),
			),
			array(
				'id'       => 'bg_stick_main_menu_v4',
				'type'     => 'background',
				'title'    => esc_html__('Stick Background', 'saga'),
				'subtitle' => esc_html__('Controls background color (default: #fff).', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				),
				'output'   => array('.mo-stick-active .mo-header-v4.mo-header-stick .mo-header-menu'),
				'required' => array('stick_main_menu_v4','=', true),
			),
			array(
				'id'          => 'menu_first_level_v4',
				'type'        => 'typography', 
				'title'       => esc_html__('First Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-header-v4 .mo-menu-list > ul > li > a, .mo-header-v4 .mo-search-header > a , .mo-header-v4 .mo-cart-header > a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828',
					'font-family' => "Fira Sans", 
					'google'      => true,
					'font-size'   => '15px', 
					'line-height' => '20px',
					'letter-spacing' => '0'
				),
			),
			array(
				'id'          => 'menu_sub_level_v4',
				'type'        => 'typography', 
				'title'       => esc_html__('Sub Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      	=> array('.mo-header-v4 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > a, .mo-header-v4 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul > li > a, .mo-header-v4 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > a, .mo-header-v4 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns2 > li > ul > li > a, .mo-header-v4 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns3 > li > ul > li > a, .mo-header-v4 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns4 > li > ul > li > a, .mo-header-v4 .mo-cart-content .total , .mo-header-v4 .mo-cart-content .cart_list.product_list_widget .mini_cart_item > a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '400', 
					'font-family' => 'Roboto', 
					'google'      => true,
					'font-size'   => '14px', 
					'line-height' => '23px',
					'letter-spacing' => '0'
				),
			),
		    array(
				'id'          => 'stick_menu_first_level_v4',
				'type'        => 'typography', 
				'title'       => esc_html__('First Level Font Options in stick menu', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-stick-active .mo-header-v4.mo-header-stick .mo-menu-list > ul > li > a , .mo-stick-active .mo-header-v4.mo-header-stick .mo-search-header > a , .mo-stick-active .mo-header-v4.mo-header-stick .mo-cart-header > a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828',
					'font-family' => "Roboto", 
					'google'      => true,
					'font-size'   => '15px', 
					'line-height' => '20px',
					'letter-spacing' => '0'
				),
		        'required' => array('stick_main_menu_v4','=', true),
			),
            
			array(
				'id'=>'menu_other_v4',
				'type' => 'button_set',
				'title' => esc_html__('Right Icons (Menu)', 'saga'),
				'multi' => true,
				'options'=> array(
					'search'    => esc_html__('Search', 'saga'),
					'sidepanel' => esc_html__('Sidepanel', 'saga'),
		            'cart'      => esc_html__('Cart', 'saga'),
					'button'    => esc_html__('Button', 'saga'),
					'switcher'  => esc_html__('Switcher', 'saga'),
				),
				'default' => array('button','search'),                            
			),
			array(
				'id'       => 'menu_other_btn_txt_v4',
				'type'     => 'text',
				'title'    => esc_html__('Button Title', 'saga'),
				'required' => array('menu_other_v4','=', 'button'),
				'default'  => 'Get In Touch',
			),
			array(
				'id'       => 'menu_other_btn_link_v4',
				'type'     => 'text',
				'title'    => esc_html__('Button Link', 'saga'),
				'required' => array('menu_other_v4','=', 'button'),
				'default'  => '#',
			),
			array(
				'id'          => 'menu_top_level_v4',
				'type'        => 'typography', 
				'title'       => esc_html__('Top Menu Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-header-v4 .mo-header-top, .mo-header-v4 .mo-header-top .contact_info a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#fff',
					'font-weight' => '400',  
					'font-family' => "Roboto", 
					'google'      => true,
					'font-size'   => '14px', 
					'line-height' => '20px',
					'letter-spacing' => '0'
				),
			),
            array(
				'id'=>'menu_top_v4',
				'type' => 'button_set',
				'title' => esc_html__('Menu Top', 'saga'),
				'multi' => true,
				'options'=> array(
					'lang'      => esc_html__('Lang', 'saga'),    
					'social'    => esc_html__('Social', 'saga'),
					'phone'     => esc_html__('Phone', 'saga'),
					'email'     => esc_html__('Email', 'saga'),
					'time'      => esc_html__('Time', 'saga'),
					'address'   => esc_html__('Address', 'saga'),
					'info'      => esc_html__('Info', 'saga'),
				),
				'default' => array('phone','email','social','info' ),                            
			 ),
             array(
				'id'       => 'menu_top_phone_v4',
				'type'     => 'text',
				'title'    => esc_html__('Top Menu Phone', 'saga'),
				'subtitle' => esc_html__('Please, Enter top menu phone number.', 'saga'),
				'required' => array('menu_top_v4','=', 'phone'),
				'default'  => '+020 768 65 79',
			),
			array(
				'id'       => 'menu_top_email_v4',
				'type'     => 'text',
				'title'    => esc_html__('Top Menu Email', 'saga'),
				'subtitle' => esc_html__('Please, Enter top menu email address.', 'saga'),
				'required' => array('menu_top_v4','=', 'email'),
				'default'  => 'Info@motivo.com',
			),
			array(
				'id'       => 'menu_top_time_v4',
				'type'     => 'text',
				'title'    => esc_html__('Top Menu Time', 'saga'),
				'subtitle' => esc_html__('Please, Enter top menu work time.', 'saga'),
				'required' => array('menu_top_v4','=', 'time'),
			),
            array(
				'id'       => 'menu_top_address_v4',
				'type'     => 'text',
				'title'    => esc_html__('Top Menu Address', 'saga'),
				'subtitle' => esc_html__('Please, Enter top menu location.', 'saga'),
				'required' => array('menu_top_v4','=', 'address'),
				'default'  => '<a href="#">Get in touch</a>',
			),
			array(
				'id'       => 'menu_top_info_v4',
				'type'     => 'text',
				'title'    => esc_html__('Top Menu Info', 'saga'),
				'subtitle' => esc_html__('Please, Enter top menu left info.', 'saga'),
				'required' => array('menu_top_v4','=', 'info')
			),
		)
    ) );
		
	// -> START Main Menu Header V5
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Menu Header V5', 'saga' ),
        'id'     => 'main_menu_v5',
        'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'bg_main_menu_v5',
				'type'     => 'background',
				'title'    => esc_html__('Menu Background', 'saga'),
				'subtitle' => esc_html__('Controls background color (default: transparent).', 'saga'),
				'default'  => array(
					'background-color' => '',
				), 
				'output'   => array('.mo-header-v5 .mo-header-menu'),
			),
		    array(
				'id'          => 'menu_first_level_v5',
				'type'        => 'typography', 
				'title'       => esc_html__('First Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-header-v5 .mo-menu-list > ul > li > a , .mo-header-v5 .select-languages > a, .mo-header-v5 .mo-search-header > a, .mo-header-v5 .mo-cart-header > a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#fff',
					'font-family' => 'Fira Sans', 
					'google'      => true,
		 			'line-height' => '80px',
		            'font-size'   => '17px',
					'letter-spacing' => '0'
				),
			),
		    array(
				'id'       => 'bg_main_menu_sub_level_v5',
				'type'     => 'background',
				'title'    => esc_html__('Background Sub Level', 'saga'),
				'subtitle' => esc_html__('Controls background color (default: #868686).', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				),
				'output'   => array('.mo-header-v5 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul ,.mo-header-v5 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > ul,.mo-header-v5 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul, .mo-header-v5 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul,.mo-header-v5 .mo-cart-content , .mo-header-v5 .header_search'),
			),
		    array(
				'id'          => 'menu_sub_level_v5',
				'type'        => 'typography', 
				'title'       => esc_html__('Sub Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      	=> array('.mo-header-v5 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > a, .mo-header-v5 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul > li > a, .mo-header-v5 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > a, .mo-header-v5 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns2 > li > ul > li > a, .mo-header-v5 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns3 > li > ul > li > a, .mo-header-v5 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns4 > li > ul > li > a, .mo-header-v5 .mo-cart-content .total , .mo-header-v5 .mo-cart-content .cart_list.product_list_widget .mini_cart_item > a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828', 
					'font-family' => 'Roboto', 
					'google'      => true,
					'font-size'   => '15px', 
					'line-height' => '23px',
					'letter-spacing' => '0'
				),
		   ),
		   array(
				'id'       => 'stick_main_menu_v5',
				'type'     => 'switch',
				'title'    => esc_html__( 'Stick Menu', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable stick menu.', 'saga' ),
				'default'  => true,
			),
			array(
				'id'       => 'bg_stick_menu_v5',
				'type'     => 'background',
				'title'    => esc_html__('Stick Menu Background', 'saga'),
				'subtitle' => esc_html__('Controls background color (default: #fff.', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				), 
				'output'   => array('.mo-stick-active .mo-header-v5.mo-header-stick .mo-header-menu:before'),
				'required' => array('stick_main_menu_v5','=', true),
			),
		    array(
				'id'=>'menu_other_v5',
				'type' => 'button_set',
				'title' => esc_html__('Menu Right Icons', 'saga'),
				'multi' => true,
				'options'=> array(
					'lang'      => esc_html__('Lang', 'saga'),    
					'social'    => esc_html__('Social', 'saga'),
					'search'    => esc_html__('Search', 'saga'),
					'cart'      => esc_html__('Cart', 'saga'),
					'sidepanel' => esc_html__('Sidepanel', 'saga'),
					'button'    => esc_html__('Button', 'saga'),
					'switcher'  => esc_html__('Switcher', 'saga'),
				),
				'default' => array('button'),                            
			 ),
    		array(
				'id'       => 'menu_other_but_ques_v5',
				'type'     => 'text',
				'title'    => esc_html__('Button text', 'saga'),
				'subtitle' => esc_html__('Please, Enter menu right text in the side of button.', 'saga'),
				'required' => array('menu_other_v5','=', 'button'),
				'default'  => 'Have Any Questions?',
			),
				array(
				'id'       => 'menu_other_but_v5',
				'type'     => 'text',
				'title'    => esc_html__('Button', 'saga'),
				'subtitle' => esc_html__('Please, Enter menu right button name.', 'saga'),
				'required' => array('menu_other_v5','=', 'button'),
				'default'  => '+020.098.456',
			),
			array(
				'id'       => 'menu_other_but_link_v5',
				'type'     => 'text',
				'title'    => esc_html__('Button Link (Menu Right)', 'saga'),
				'subtitle' => esc_html__('Please, Enter menu right button link.', 'saga'),
				'required' => array('menu_other_v5','=', 'button'),
				'default'  => 'tel:+020.098.456',
			),
		 )
    ) );
	
	// -> START Main Menu Header V6
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Menu Header V6', 'saga' ),
        'id'     => 'main_menu_v6',
        'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'stick_main_menu_v6',
				'type'     => 'switch',
				'title'    => esc_html__( 'Stick Menu', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable stick menu.', 'saga' ),
				'default'  => true,
			),
		    array(
				'id'       => 'bg_main_menu_v6',
				'type'     => 'background',
				'title'    => esc_html__('Background Main Menu', 'saga'),
				'subtitle' => esc_html__('Controls background color (default:#fff ).', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				), 
				'output'   => array('.mo-header-v6 .mo-header-menu , .mo-header-v6 .mo-header-top.t_motivo, .mo-header-v6 #lang > ul li > ul'),
			),
			array(
				'id'       => 'bg_main_menu_sub_level_v6',
				'type'     => 'background',
				'title'    => esc_html__('Background Sub Level', 'saga'),
				'subtitle' => esc_html__('Controls background color (default: #041026).', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				),
				'output'   => array('.mo-header-v6 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul, .mo-header-v6 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > ul, .mo-header-v6 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul, .mo-header-v6 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul,.mo-header-v6 .header_search , .mo-header-v6 .mo-cart-content'),
			),
			array(
				'id'       => 'bg_stick_main_menu_v6',
				'type'     => 'background',
				'title'    => esc_html__('Stick Background', 'saga'),
				'subtitle' => esc_html__('Controls background color (default:rgba(0,0,0,0.7) ).', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				),
				'output'   => array('.mo-stick-active .mo-header-v6.mo-header-stick .mo-header-menu , .mo-stick-active .mo-header-v6.mo-header-stick .mo-header-top.t_motivo , .mo-stick-active .mo-header-v6.mo-header-stick #lang > ul li > ul'),
				'required' => array('stick_main_menu_v6','=', true),
			),
			array(
				'id'          => 'menu_first_level_v6',
				'type'        => 'typography', 
				'title'       => esc_html__('First Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-header-v6 .mo-menu-list > ul > li > a , .mo-header-v6 .mo-search-header > a, .mo-header-v6 .mo-cart-header > a,  .mo-header-v6 .select-languages > a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828',
					'font-family' => "Fira Sans", 
					'google'      => true,
					'font-size'   => '15px', 
					'line-height' => '20px',
					'letter-spacing' => '0'
				),
			),
			array(
				'id'          => 'menu_sub_level_v6',
				'type'        => 'typography', 
				'title'       => esc_html__('Sub Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      	=> array('.mo-header-v6 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > a, .mo-header-v6 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul > li > a, .mo-header-v6 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > a, .mo-header-v6 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns2 > li > ul > li > a, .mo-header-v6 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns3 > li > ul > li > a, .mo-header-v6 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns4 > li > ul > li > a,.mo-header-v6 .mo-cart-content .total , .mo-header-v6 .mo-cart-content .cart_list.product_list_widget .mini_cart_item > a '),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '400', 
					'font-family' => 'Roboto', 
					'google'      => true,
					'font-size'   => '14px', 
					'line-height' => '23px',
					'letter-spacing' => '0'
				),
			),
			array(
				'id'=>'menu_other_v6',
				'type' => 'button_set',
				'title' => esc_html__('Menu Right Icons', 'saga'),
				'multi' => true,
				'options'=> array(
					'lang'      => esc_html__('Lang', 'saga'),    
					'social'    => esc_html__('Social', 'saga'),
					'search'    => esc_html__('Search', 'saga'),
					'cart'      => esc_html__('Cart', 'saga'),
					'sidepanel' => esc_html__('Sidepanel', 'saga'),
					'button'    => esc_html__('Button', 'saga'),
					'switcher'  => esc_html__('Switcher', 'saga'),
				),
		        'default' => array('social','button', 'sidepanel', 'switcher'),              
			 ),
			 array(
				'id'       => 'menu_other_but_v6',
				'type'     => 'text',
				'title'    => esc_html__('Button text (Menu Right)', 'saga'),
				'subtitle' => esc_html__('Please, Enter text button.', 'saga'),
				'required' => array('menu_other_v6','=', 'button'),
				'default'  => 'Get In Touch',
			),
		    array(
				'id'       => 'menu_other_but_link_v6',
				'type'     => 'text',
				'title'    => esc_html__('Button Link (Menu Right)', 'saga'),
				'subtitle' => esc_html__('Please, Enter link button .', 'saga'),
				'required' => array('menu_other_v6','=', 'button'),
				'default'  => '#',
			),
		)
    ) );

    // -> START Main Menu Header V7
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Menu Header V7', 'saga' ),
        'id'     => 'main_menu_v7',
        'subsection' => true,
		'fields' => array(
			array(
				'id'       => 'stick_main_menu_v7',
				'type'     => 'switch',
				'title'    => esc_html__( 'Stick Menu', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable stick menu.', 'saga' ),
				'default'  => true,
			),
		
		    array(
				'id'       => 'bg_main_menu_v7',
				'type'     => 'background',
				'title'    => esc_html__('Background', 'saga'),
				'subtitle' => esc_html__('Controls background color (default: transparent).', 'saga'),
				'default'  => array(
					'background-color' => '',
				),
				'output'   => array('.mo-header-v7 .mo-header-top , .mo-header-v7 .mo-header-menu , .mo-header-v7 #lang > ul li > ul'),
			),
			array(
				'id'       => 'bg_main_menu_sub_level_v7',
				'type'     => 'background',
				'title'    => esc_html__('Background Sub Level', 'saga'),
				'subtitle' => esc_html__('Controls background color (default: #041026).', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				),
				'output'   => array('.mo-header-v7 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul , .mo-header-v7 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > ul, .mo-header-v7 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul,.mo-header-v7 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul, .mo-header-v7 .mo-cart-content , .mo-header-v7 .header_search'),
			),
			array(
				'id'       => 'bg_stick_main_menu_v7',
				'type'     => 'background',
				'title'    => esc_html__('Stick Background', 'saga'),
				'subtitle' => esc_html__('Controls background color (default: #fff).', 'saga'),
				'default'  => array(
					'background-color' => '#fff',
				),
				'output'   => array('.mo-stick-active .mo-header-v7.mo-header-stick .mo-header-menu'),
				'required' => array('stick_main_menu_v7','=', true),
			),
			array(
				'id'          => 'menu_first_level_v7',
				'type'        => 'typography', 
				'title'       => esc_html__('First Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-header-v7 .mo-menu-list > ul > li > a , .mo-header-v7 .mo-search-header > a , .mo-header-v7 .mo-cart-header > a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#fff',
					'font-weight' => '700',  
					'font-family' => "Fira Sans", 
					'google'      => true,
					'font-size'   => '15px', 
					'line-height' => '28px',
					'letter-spacing' => '0'
				),
			),
			array(
				'id'          => 'menu_sub_level_v7',
				'type'        => 'typography', 
				'title'       => esc_html__('Sub Level Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      	=> array('.mo-header-v7 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > a, .mo-header-v7 .mo-menu-list > ul > li.menu-item-has-children.nomega-menu-item > ul > li > ul > li > a, .mo-header-v7 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul > li > a, .mo-header-v7 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns2 > li > ul > li > a, .mo-header-v7 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns3 > li > ul > li > a, .mo-header-v7 .mo-menu-list > ul > li.menu-item-has-children.mega-menu-item > ul.columns4 > li > ul > li > a , .mo-header-v7 .mo-cart-content .total , .mo-header-v7 .mo-cart-content .cart_list.product_list_widget .mini_cart_item > a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '400', 
					'font-family' => 'Roboto', 
					'google'      => true,
					'font-size'   => '14px', 
					'line-height' => '23px',
					'letter-spacing' => '0'
				),
			),
		    array(
				'id'          => 'stick_menu_first_level_v7',
				'type'        => 'typography', 
				'title'       => esc_html__('First Level Font Options in stick menu', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.mo-stick-active .mo-header-v7.mo-header-stick .mo-menu-list > ul > li > a , .mo-stick-active .mo-header-v7.mo-header-stick .mo-search-header > a , .mo-stick-active .mo-header-v7.mo-header-stick .mo-cart-header > a'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828',
					'font-weight' => '600',  
					'font-family' => "Roboto", 
					'google'      => true,
					'font-size'   => '15px', 
					'line-height' => '20px',
					'letter-spacing' => '0'
				),
		        'required' => array('stick_main_menu_v7','=', true),
			),

			array(
				'id'=>'menu_top_v7',
				'type' => 'button_set',
				'title' => esc_html__('Menu Top', 'saga'),
				'multi' => true,
				'options'=> array(
					'phone'     => esc_html__('Phone', 'saga'),
					'time'      => esc_html__('Time', 'saga'),
					'email'     => esc_html__('Email', 'saga'),
					'address'   => esc_html__('Address', 'saga'),
				),
				'default' => array('phone','address','time' ),                            
			 ),
             array(
				'id'       => 'menu_top_phone_v7',
				'type'     => 'text',
				'title'    => esc_html__('Top Menu Phone', 'saga'),
				'subtitle' => esc_html__('Please, Enter top menu phone number.', 'saga'),
				'default'  => 'Call Us: (02) 123-451-98 (Sat – Thursday)',
				'required' => array('menu_top_v7','=', 'phone')
			),
			array(
				'id'       => 'menu_top_email_v7',
				'type'     => 'text',
				'title'    => esc_html__('Top Menu Email', 'saga'),
				'subtitle' => esc_html__('Please, Enter top menu email address.', 'saga'),
				'default'  => 'Mail us for help:Info@motivo.com',
				'required' => array('menu_top_v7','=', 'email')
			),
			array(
				'id'       => 'menu_top_time_v7',
				'type'     => 'text',
				'title'    => esc_html__('Top Menu Time', 'saga'),
				'subtitle' => esc_html__('Please, Enter top menu work time.', 'saga'),
				'default'  => 'Mon - Fri: 8:00 am - 07.00pm Closed on Weekends',
				'required' => array('menu_top_v7','=', 'time')
			),
            array(
				'id'       => 'menu_top_address_v7',
				'type'     => 'text',
				'title'    => esc_html__('Top Menu Address', 'saga'),
				'default'  => esc_html__('1010 Avenue of the Moon New York, NY 10018 US.', 'saga'),
				'required' => array('menu_top_v7','=', 'address')
			),
            array(
				'id'=>'menu_other_v7',
				'type' => 'button_set',
				'title' => esc_html__('Menu Right Icons', 'saga'),
				'multi' => true,
				'options'=> array(
					'sidepanel' => esc_html__('Sidepanel', 'saga'),
					'search'    => esc_html__('Search', 'saga'),
					'cart'      => esc_html__('Cart', 'saga'),
					'button'    => esc_html__('Button', 'saga'),
					'lang'      => esc_html__('Lang', 'saga'),  
					'social'    => esc_html__('Social', 'saga'),
					'info'      => esc_html__('Info', 'saga'),
					'switcher'  => esc_html__('Switcher', 'saga'),
				),
				'default' => array('button','social'),                                       
			 ),
		     array(
				'id'       => 'menu_other_but_v7',
				'type'     => 'text',
				'title'    => esc_html__('Menu Right Button', 'saga'),
				'subtitle' => esc_html__('Please, Enter menu right button name.', 'saga'),
				'default'  => 'Free Consultant',
				'required' => array('menu_other_v7','=', 'button')
			),
		    array(
				'id'       => 'menu_other_but_link_v7',
				'type'     => 'text',
				'title'    => esc_html__('Menu Right Button Link', 'saga'),
				'subtitle' => esc_html__('Please, Enter menu right button link.', 'saga'),
				'default'  => '#',
				'required' => array('menu_other_v7','=', 'button')
			),
			array(
				'id'       => 'menu_top_info_v7',
				'type'     => 'text',
				'title'    => esc_html__('Top Menu Info', 'saga'),
				'subtitle' => esc_html__('Please, Enter top menu left info.', 'saga'),
				'default'  => 'Call us for a quote <a href="#">(010) 89 444</a>',
				'required' => array('menu_other_v7','=', 'info')
			),
		)
    ) );

	// -> START Main Menu sidepanel
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Meun Sidepanel', 'saga' ),
        'id'     => 'menu_sidepanel',
        'subsection' => true,
		'fields' => array(
           array(
				'id'       => 'sidepanel_content',
				'type'     => 'button_set',
		 		'title'    => esc_html__('Sidepanel Content', 'saga'),
		        'subtitle' => esc_html__('Controls sidepanl info', 'saga'),
		        'multi' => true,
				'options'=> array(
					'txt'      => esc_html__('txt', 'saga'), 
					'social'   => esc_html__('Social', 'saga'),
				),
				'default' => array('txt', 'social') 
			),
			array(
				'id'       => 'sidepanel_txt',
				'type'     => 'editor',
				'title'    => esc_html__('Top Menu Info', 'saga'),
				'subtitle' => esc_html__('Please, Enter top menu left info.', 'saga'),
				'default'  => 'Are you need IT Support Engineer? <a href="#">Free Consultant</a>',
				'required' => array('sidepanel_content','=', 'txt')
			),
		)
    ) );
    
	// -> START Main Menu Header Left Navigation
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Meun Lang Icon', 'saga' ),
        'id'     => 'menu_lang_icon',
        'subsection' => true,
		'fields' => array(
			array(
				'id'      => 'link-lang',
				'type'    => 'multi_text',
				'title'   => esc_html__( 'Languages Link', 'saga' ),
				'desc'    => esc_html__( 'Add Main Languages link', 'saga' ),
				'show_empty' => true,
				'default' => array( 'En', ),
			),
		     array(
				'id'    => 'link_lang',
				'type'  => 'text',
				'title' => esc_html__('Main languages Name', 'saga' ),
		        'default'  => 'En',
				'desc'  => esc_html__('Add Main Languages Name', 'saga' ),
			),
			 array(
				'id'    => 'link_en',
				'type'  => 'text',
				'title' => esc_html__('English Link', 'saga' ),
				'desc'  => esc_html__('Your English Link', 'saga' ),
			),
			array(
				'id'    => 'link_fr',
				'type'  => 'text',
				'title' => esc_html__('French Link', 'saga' ),
				'desc'  => esc_html__('Your French Link', 'saga' ),
			),
			array(
				'id'    => 'link_ge',
				'type'  => 'text',
				'title' => esc_html__('German Link', 'saga' ),
				'desc'  => esc_html__('Your German Link', 'saga' ),
			),
		    array(
				'id'    => 'link_de',
				'type'  => 'text',
				'title' => esc_html__('Deutsch Link', 'saga' ),
				'desc'  => esc_html__('Your Deutsch Link', 'saga' ),
			),
		    array(
				'id'    => 'link_ro',
				'type'  => 'text',
				'title' => esc_html__('Romanian Link', 'saga' ),
				'desc'  => esc_html__('Your Romanian Link', 'saga' ),
			), 
		    array(
				'id'    => 'link_ar',
				'type'  => 'text',
				'title' => esc_html__('Arabic Link', 'saga' ),
				'desc'  => esc_html__('Your Arabic Link', 'saga' ),
			),
		)
    ) );

	// -> START Footer
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Footer', 'saga' ),
        'id'     => 'footer',
        'icon'   => 'el el-credit-card',
		'fields' => array(
			array( 
				'id'       => 'tb_footer_layout',
				'type'     => 'image_select',
				'title'    => esc_html__('Footer Layout', 'saga'),
				'subtitle' => esc_html__('Select footer layout in your site.', 'saga'),
				'options'  => array(
	            	'footer-v0'	=> array(
						'alt'   => 'Footer V0',
						'img'   => SAGA_URI_PATH.'/assets/images/footers/footer-v0.jpg'
					),
					'footer-v1'	=> array(
						'alt'   => 'Footer V1',
						'img'   => SAGA_URI_PATH.'/assets/images/footers/footer-v1.jpg'
					),
					'footer-v2'	=> array(
						'alt'   => 'Footer V2',
						'img'   => SAGA_URI_PATH.'/assets/images/footers/footer-v2.jpg'
					),
					'footer-v3'	=> array(
						'alt'   => 'Footer V3',
						'img'   => SAGA_URI_PATH.'/assets/images/footers/footer-v3.jpg'
					),
		            'footer-v4'	=> array(
						'alt'   => 'Footer V4',
						'img'   => SAGA_URI_PATH.'/assets/images/footers/footer-v4.jpg'
					),
				),
				'default' => 'footer-v1'
			),
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Footer V1', 'saga' ),
        'id'     => 'footer_v1',
        'subsection' => true,
		'fields' => array(
			array(
				'id' => 'tb_footer_margin',
				'title' => esc_html__('Footer Margin', 'saga'),
				'subtitle' => esc_html__('Please, Enter margin.', 'saga'),
				'type' => 'spacing',
				'mode' => 'margin',
				'units' => array('px'),
				'output' => array('.footer_v1'),
				'default' => array(
					'margin-top'     => '0px', 
					'margin-right'   => '0px', 
					'margin-bottom'  => '0px', 
					'margin-left'    => '0px',
					'units'          => 'px', 
				)
			),
			array(
				'id' => 'tb_footer_padding',
				'title' => esc_html__('Footer Padding', 'saga'),
				'subtitle' => esc_html__('Please, Enter padding.', 'saga'),
				'type' => 'spacing',
				'units' => array('px'),
				'output' => array('.footer_v1'),
				'default' => array(
					'padding-top'     => '0px', 
					'padding-right'   => '0px', 
					'padding-bottom'  => '0px', 
					'padding-left'    => '0px',
					'units'           => 'px', 
				)
			),
			array(
				'id'       => 'tb_footer_backgroud',
				'type'     => 'background',
				'title'    => esc_html__('Footer Background', 'saga'),
				'subtitle' => esc_html__('background with image, color, etc.', 'saga'),
				'output'    => array('.footer_v1 , .footer_v1 select  , .footer_v1 select option'), 
				'default'  => array(
					'background-color' => '#101828',
				)
			),
			array(
				'id'          => 'tb_footer_title_typography',
				'type'        => 'typography', 
				'title'       => esc_html__('Font Options title', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.footer_v1 .wg-title'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#fff',
					'font-weight' => '600',  
					'font-family' => "Fira Sans",  
					'google'      => true,
					'font-size'   => '18px', 
					'line-height' => '22px',
					'letter-spacing' => '0'
				),
			),
			array(
				'id'          => 'tb_footer_typography',
				'type'        => 'typography', 
				'title'       => esc_html__('Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.footer_v1 , .footer_v1 p , .footer_v1 a , .footer_v1 .widget_nav_menu ul > li a, .footer_v1 span , .footer_v1 select , .footer_v1 select option, .footer_v1 td, .footer_v1 th'),
				'units'       =>'px',
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => 'rgba(255, 255, 255, 0.6)',
					'font-weight' => '400', 
					'font-family' => 'Roboto',  
					'google'      => true,
					'font-size'   => '14px', 
					'line-height' => '23px',
					'letter-spacing' => '0'
				),
			),
		    array(
				'id'       => 'tb_footer_v1_fixed',
				'type'     => 'switch',
				'title'    => esc_html__( 'footer fixed', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable footer fixed.', 'saga' ),
				'default'  => false,
			),
			array(
				'id'       => 'tb_footer_to_top',
				'type'     => 'switch',
				'title'    => esc_html__( 'Back To Top', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable back to top.', 'saga' ),
				'default'  => true,
			),
		)
    ) );
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Footer V2', 'saga' ),
        'id'     => 'footer_v2',
        'subsection' => true,
		'fields' => array(
			array(
				'id' => 'tb_footer_v2_margin',
				'title' => esc_html__('Footer Margin', 'saga'),
				'subtitle' => esc_html__('Please, Enter margin.', 'saga'),
				'type' => 'spacing',
				'mode' => 'margin',
				'units' => array('px'),
				'output' => array('.footer_v2'),
				'default' => array(
					'margin-top'     => '20px', 
					'margin-right'   => '20px', 
					'margin-bottom'  => '20px', 
					'margin-left'    => '20px',
					'units'          => 'px', 
				)
			),
			array(
				'id' => 'tb_footer_v2_padding',
				'title' => esc_html__('Footer Columns Padding', 'saga'),
				'subtitle' => esc_html__('Please, Enter padding.', 'saga'),
				'type' => 'spacing',
				'units' => array('px'),
				'output' => array('.footer_v2 .footer-widget-1 , .footer_v2 .footer-widget-2 , .footer_v2 .footer-widget-3 , .footer_v2 .footer-widget-4, .footer_v2 .footer-widget-5, .footer_v2 .footer-widget-6'),
				'default' => array(
					'padding-top'     => '60px', 
					'padding-right'   => '', 
					'padding-bottom'  => '90px', 
					'padding-left'    => '',
					'units'           => 'px', 
				)
			),
			array(
				'id'       => 'tb_footer_v2_backgroud',
				'type'     => 'background',
				'title'    => esc_html__('Footer Background', 'saga'),
				'subtitle' => esc_html__('background with image, color, etc.', 'saga'),
				'output'    => array('.footer_v2 , .footer_v2 select  , .footer_v2 select option'), 
				'default'  => array(
					'background-color' => '#101828',
				)
			),
			array(
				'id'          => 'tb_footer_v2_title_typography',
				'type'        => 'typography', 
				'title'       => esc_html__('Font Options title', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.footer_v2 .wg-title'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#fff',
					'font-weight' => '600',  
					'font-family' => 'Fira Sans',   
					'google'      => true,
					'font-size'   => '13px', 
					'line-height' => '19px',
					'letter-spacing' => '0'
				),
			),
			array(
				'id'          => 'tb_footer_v2_typography',
				'type'        => 'typography', 
				'title'       => esc_html__('Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.footer_v2 , .footer_v2 p , .footer_v2 a , .footer_v2 h5 , .footer_v2 h6 , .footer_v2 span , .footer_v2 select , .footer_v2 select option , .footer_v2 td, .footer_v2 th'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => 'rgba(255, 255, 255, 0.7)',
					'font-weight' => '400', 
					'font-family' => 'Roboto',  
					'google'      => true,
					'font-size'   => '14px', 
					'line-height' => '23px',
	         	    'letter-spacing' => '0'
				),
			),
			array(
				'id'       => 'tb_footer_v2_fixed',
				'type'     => 'switch',
				'title'    => esc_html__( 'footer fixed', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable footer fixed.', 'saga' ),
				'default'  => false,
			),
           array(
				'id'       => 'tb_footer_v2_to_top',
				'type'     => 'switch',
				'title'    => esc_html__( 'Back To Top', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable back to top.', 'saga' ),
				'default'  => true,
			),
		)
    ) );


	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Footer V3', 'saga' ),
        'id'     => 'footer_v3',
        'subsection' => true,
		'fields' => array(
			array(
				'id' => 'tb_footer_v3_margin',
				'title' => esc_html__('Footer Margin', 'saga'),
				'subtitle' => esc_html__('Please, Enter margin.', 'saga'),
				'type' => 'spacing',
				'mode' => 'margin',
				'units' => array('px'),
				'output' => array('.footer_v3'),
				'default' => array(
					'margin-top'     => '0px', 
					'margin-right'   => '0px', 
					'margin-bottom'  => '0px', 
					'margin-left'    => '0px',
					'units'          => 'px', 
				)
			),
			array(
				'id' => 'tb_footer_v3_padding',
				'title' => esc_html__('Footer Columns Padding', 'saga'),
				'subtitle' => esc_html__('Please, Enter padding.', 'saga'),
				'type' => 'spacing',
				'units' => array('px'),
				'output'         => array('.footer_v3'),
				'default' => array(
					'padding-top'     => '0', 
					'padding-right'   => '0', 
					'padding-bottom'  => '0', 
					'padding-left'    => '0',
					'units'           => 'px', 
				)
			),
			array(
				'id'       => 'tb_footer_v3_backgroud',
				'type'     => 'background',
				'title'    => esc_html__('Footer Background', 'saga'),
				'subtitle' => esc_html__('background with image, color, etc.', 'saga'),
				'output'   => array('.footer_v3 , .footer_v3 select  , .footer_v3 select option'), 
				'default'  => array(
					'background-color' => '#fff',
				)
			),
			array(
				'id'          => 'tb_footer_v3_title_typography',
				'type'        => 'typography', 
				'title'       => esc_html__('Font Options title', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.footer_v3 .wg-title'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828',
					'font-weight' => '600',  
					'font-family' => 'Fira Sans',   
					'google'      => true,
					'font-size'   => '16px', 
					'line-height' => '26px',
					'letter-spacing' => '0'
				),
			),
			array(
				'id'          => 'tb_footer_v3_typography',
				'type'        => 'typography', 
				'title'       => esc_html__('Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.footer_v3 , .footer_v3 p , .footer_v3 .textwidget, .footer_v3 a , .footer_v3 h5 , .footer_v3 h6 , .footer_v3 span , .footer_v3 select , .footer_v3 select option , .footer_v3 td, .footer_v3 th , .footer_v3 a:before'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#6a7c92',
					'font-weight' => '400', 
					'font-family' => 'Roboto',  
					'google'      => true,
					'font-size'   => '15px', 
					'line-height' => '25px',
	         	    'letter-spacing' => '0'
				),
			),
		    array(
				'id'       => 'tb_footer_v3_fixed',
				'type'     => 'switch',
				'title'    => esc_html__( 'footer fixed', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable footer fixed.', 'saga' ),
				'default'  => false,
			),
           array(
				'id'       => 'tb_footer_v3_to_top',
				'type'     => 'switch',
				'title'    => esc_html__( 'Back To Top', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable back to top.', 'saga' ),
				'default'  => true,
			),
		)
    ) );

	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Footer V4', 'saga' ),
        'id'     => 'footer_v4',
        'subsection' => true,
		'fields' => array(
			array(
				'id' => 'tb_footer_v4_margin',
				'title' => esc_html__('Footer Margin', 'saga'),
				'subtitle' => esc_html__('Please, Enter margin.', 'saga'),
				'type' => 'spacing',
				'mode' => 'margin',
				'units' => array('px'),
				'output' => array('.footer_v4'),
				'default' => array(
					'margin-top'     => '0px', 
					'margin-right'   => '0px', 
					'margin-bottom'  => '0px', 
					'margin-left'    => '0px',
					'units'          => 'px', 
				)
			),
			array(
				'id' => 'tb_footer_v4_padding',
				'title' => esc_html__('Footer Columns Padding', 'saga'),
				'subtitle' => esc_html__('Please, Enter padding.', 'saga'),
				'type' => 'spacing',
				'units' => array('px'),
				'output'         => array('.footer_v4'),
				'default' => array(
					'padding-top'     => '0', 
					'padding-right'   => '0', 
					'padding-bottom'  => '0', 
					'padding-left'    => '0',
					'units'           => 'px', 
				)
			),
			array(
				'id'       => 'tb_footer_v4_backgroud',
				'type'     => 'background',
				'title'    => esc_html__('Footer Background', 'saga'),
				'subtitle' => esc_html__('background with image, color, etc.', 'saga'),
				'output'   => array('.footer_v4 , .footer_v4 select  , .footer_v4 select option'), 
				'default'  => array(
					'background-color' => '#fff',
				)
			),
			array(
				'id'          => 'tb_footer_v4_title_typography',
				'type'        => 'typography', 
				'title'       => esc_html__('Font Options title', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.footer_v4 .wg-title'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828',
					'font-weight' => '600',  
					'font-family' => 'Fira Sans',   
					'google'      => true,
					'font-size'   => '13px', 
					'line-height' => '19px',
					'letter-spacing' => '0'
				),
			),
			array(
				'id'          => 'tb_footer_v4_typography',
				'type'        => 'typography', 
				'title'       => esc_html__('Font Options', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      => array('.footer_v4 , .footer_v4 p , .footer_v4 a , .footer_v4 h5 , .footer_v4 h6 , .footer_v4 span , .footer_v4 select , .footer_v4 select option , .footer_v4 td, .footer_v4 th , .footer_v4 a:before'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#6a7c92',
					'font-weight' => '400', 
					'font-family' => 'Roboto',  
					'google'      => true,
					'font-size'   => '14px', 
					'line-height' => '23px',
	         	    'letter-spacing' => '0'
				),
			),
		    array(
				'id'       => 'tb_footer_v4_fixed',
				'type'     => 'switch',
				'title'    => esc_html__( 'footer fixed', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable footer fixed.', 'saga' ),
				'default'  => false,
			),
           array(
				'id'       => 'tb_footer_v4_to_top',
				'type'     => 'switch',
				'title'    => esc_html__( 'Back To Top', 'saga' ),
				'subtitle' => esc_html__( 'Enable/Disable back to top.', 'saga' ),
				'default'  => true,
			),
		)
    ) );
	/*-----------------------------------------------*
    START Title Bar
    /*-----------------------------------------------*/
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Title Bar', 'saga' ),
        'id'     => 'title_bar',
        'icon'   => 'el el-credit-card',
		'fields' => array(
			array( 
				'id'       => 'tb_page_title_layout',
				'type'     => 'image_select',
				'title'    => esc_html__('pagetitle Layout', 'saga'),
				'subtitle' => esc_html__('Select pagetitle layout in your site.', 'saga'),
				'options'  => array(
					'pagetitle-v1'	=> array(
						'alt'   => 'Page title V1',
						'img'   => SAGA_URI_PATH.'/assets/images/pagetitle/pagetitle-v1.png'
					),
					'pagetitle-v2'	=> array(
						'alt'   => 'Page title V2',
						'img'   => SAGA_URI_PATH.'/assets/images/pagetitle/pagetitle-v2.png'
					),
					'pagetitle-v3'	=> array(
						'alt'   => 'Page title V3',
						'img'   => SAGA_URI_PATH.'/assets/images/pagetitle/pagetitle-v3.png'
					),
					'pagetitle-v4'	=> array(
						'alt'   => 'Page title V4',
						'img'   => SAGA_URI_PATH.'/assets/images/pagetitle/pagetitle-v4.png'
					),
		           'pagetitle-v5'	=> array(
						'alt'   => 'Page title V5',
						'img'   => SAGA_URI_PATH.'/assets/images/pagetitle/pagetitle-v5.png'
					),
				),
				'default' => 'pagetitle-v2'
            ),
			array(
				'id'       => 'tb_title_bar_bg',
				'type'     => 'background',
				'title'    => esc_html__('Background', 'saga'),
				'subtitle' => esc_html__('background with image, color, etc.', 'saga'),
				'output'         => array('.page-header .mo-title-bar-wrap'),
				'default'  => array(
					'background-color' => '#060606',
					'background-repeat' => 'no-repeat',
					'background-position' => 'center center',
					'background-attachment' => 'fixed',
					'background-size' => 'cover',
					'background-image' => SAGA_URI_PATH.'/assets/images/bg-titlebar.jpg',
				)
			),
			array( 
				'id'       => 'tb_show_page_title',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show page title', 'saga' ),
				'subtitle' => esc_html__( 'Show or not show page title.', 'saga' ),
				'default'  => true,
			),
			array( 
				'id'       => 'tb_show_page_breadcrumb',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show page breadcrumb', 'saga' ),
				'subtitle' => esc_html__( 'Show or not show page breadcrumb.', 'saga' ),
				'default'  => true,
			),
			array(
                'id' => 'page_title_height',
                'title' => 'Page Title Height',
                'type' => 'dimensions',
                'units' => array('px'),
                'width' => false,
				'subtitle' => esc_html__('in pixels.', 'saga'),
                'output' => array('.pagetitle-v5, .pagetitle-v2 .mo-title-bar-wrap, .pagetitle-v3 .mo-title-bar-wrap, .pagetitle-v4 .mo-title-bar-wrap'),
                'default' => array(
                    'units' => 'px',
                    'height' => ''
                )
            ),
			array(
				'id'          => 'title_bar_heading',
				'type'        => 'typography', 
				'title'       => esc_html__('Heading', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      	=> array('.page-header .mo-title-bar h2'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'        => '#fff', 
					'font-weight'  => '700', 
					'font-family'  => 'Fira Sans',  
					'google'       => true,
					'font-size'    => '48px', 
					'line-height'  => '54px',
					'letter-spacing' => '0'
				),
			),
			array(
				'id'          => 'title_bar_path',
				'type'        => 'typography', 
				'title'       => esc_html__('Path', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      	=> array('.page-header .mo-title-bar .mo-path, .page-header .mo-title-bar .mo-path a ,  .woocommerce .mo-page-title-shop, .woocommerce .mo-page-title-shop a , .pagetitle-v4 .mo-path-inner'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#fff', 
					'font-weight' => '400', 
					'font-family' => 'Roboto', 
					'google'      => true,
					'font-size'   => '12px', 
					'line-height' => '20px',
					'letter-spacing' => '.5px'
				),
			),
		   	array(
				'id'       => 'title_bar_subtext',
				'type'     => 'text',
				'title'    => esc_html__('Sub Text', 'saga'),
				'subtitle' => esc_html__('Please, Enter sub text of title bar.', 'saga'),
				'default'  => ''
			),
			array(
				'id'          => 'title_bar_subtext_format',
				'type'        => 'typography', 
				'title'       => esc_html__('Sub Text Format', 'saga'),
				'google'      => true, 
				'font-backup' => true,
				'letter-spacing' => true,
				'output'      	=> array('.page-header .subtext'),
				'units'       =>'px',
				'subtitle'    => esc_html__('Typography option with each property can be called individually.', 'saga'),
				'default'     => array(
					'color'       => '#101828', 
					'font-weight' => '400', 
					'font-family' => 'Roboto',  
					'google'      => true,
					'font-size'   => '12px', 
					'line-height' => '15px',
					'letter-spacing' => '0.5px'
				),
			),
			array(
				'id'       => 'page_breadcrumb_delimiter',
				'type'     => 'text',
				'title'    => esc_html__('Delimiter', 'saga'),
				'subtitle' => esc_html__('Please, Enter Delimiter of page breadcrumb in title bar.', 'saga'),
				'default'  => '/'
			),
		)
		
    ) );
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Post', 'saga' ),
        'id'     => 'post_titlebar',
		'subsection' => true,
		'fields' => array(
		    array( 
				'id'       => 'tb_archive_title_bar',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Archive Title Bar', 'saga' ),
				'subtitle' => esc_html__( 'show or not post title on your archive blog.', 'saga' ),
				'default'  => false,
			),
			array(
				'id'       => 'tb_archive_title_bar_bg',
				'type'     => 'background',
				'title'    => esc_html__('Archive Titlebar Background', 'saga'),
				'subtitle' => esc_html__('background with image, color, etc.', 'saga'),
				'output'   => array('.archive .mo-title-bar-wrap'), 
				'required' => array( 'tb_archive_title_bar', '=', '1' ),
				'default'  => array(
					'background-color' => '#252b33',
					'background-repeat' => 'no-repeat',
					'background-position' => 'center center',
					'background-size' => 'cover',
					'background-attachment' => 'fixed',
					'background-image' => SAGA_URI_PATH.'/assets/images/bg-titlebar.jpg',
				)
			),
		 )
    ) );
	// -> START Blog Post
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Blog', 'saga' ),
        'id'     => 'blog',
		'icon'   => 'el el-icon-file-edit',
    ) );
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Single Post', 'saga' ),
        'id'     => 'single_post',
		'subsection' => true,
		'fields' => array(
			array( 
				'id'       => 'tb_post_layout',
				'type'     => 'image_select',
				'title'    => esc_html__('Select Layout', 'saga'),
				'subtitle' => esc_html__('Select layout of single blog.', 'saga'),
				'options'  => array(
					'2cl'	=> array(
								'alt'   => '2cl',
								'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/2cl.png'
							),
					'2cr'	=> array(
								'alt'   => '2cr',
								'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/2cr.png'
							),
		           '1col'	=> array(
								'alt'   => '1col',
								'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/1col.png'
							)
				),
				'default' => '1col'
			),
		    array( 
				'id'       => 'tb_post_header_layout',
				'type'     => 'image_select',
				'title'    => esc_html__('Select header Layout', 'saga'),
				'subtitle' => esc_html__('Select header layout of single blog.', 'saga'),
				'options'  => array(
					'basic'	=> array(
						'alt'   => 'basic',
						'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/1col.png'
					),
		           'img_overlay'	=> array(
						'alt'   => 'img_overlay',
						'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/1ct.png'
				   ),
				   'img_overlay_sm'	=> array(
						'alt'   => 'img_overlay_sm',
						'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/1ct_sm.png'
				   ),
				),
				'default' => 'basic'
			),
		    array(
				'id'=>'post-meta-single',
				'type' => 'button_set',
				'title' => esc_html__('Post Meta in post detail page', 'saga'),
				'multi' => true,
				'options'=> array(
					'author'  => esc_html__('Author', 'saga'),    
					'comment' => esc_html__('Comment', 'saga'),
					'date'    => esc_html__('Date', 'saga'),
					'like'    => esc_html__('Like', 'saga'),
					'cat'     => esc_html__('Categories', 'saga'),
					'tag'     => esc_html__('Tags', 'saga'),
					'view'    => esc_html__('View', 'saga'),
				),
				'default' => array('author','date','cat','tag','view'),                            
			 ),
		    array(
				'id'=>'post_share',
				'type' => 'button_set',
				'title' => esc_html__('Post Share Links position', 'saga'),
				'multi' => true,
				'options'=> array(
					'sticky'    => esc_html__('Sticky', 'saga'),    
					'basic'     => esc_html__('Basic', 'saga'),
				), 
		       'default' => array('sticky'), 
			),
			array( 
				'id'       => 'tb_post_show_nav',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Navigation', 'saga' ),
				'subtitle' => esc_html__( 'Show or not post navigation on your single blog.', 'saga' ),
				'default'  => true,
			),
			array(
				'id'       => 'tb_post_show_author',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Author', 'saga' ),
				'subtitle' => esc_html__( 'Show or not post author on your single blog.', 'saga' ),
				'default'  => true,
			),
		    array(
				'id'       => 'tb_related_post',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Related Post', 'saga' ),
				'subtitle' => esc_html__( 'Show or not related post on your single blog.', 'saga' ),
				'default'  => true,
			),
			array(
				'id'       => 'tb_post_show_comment',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Comment', 'saga' ),
				'subtitle' => esc_html__( 'Show or not post comment on your single blog.', 'saga' ),
				'default'  => true,
			),
		)
    ) );
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Archive Post', 'saga' ),
        'id'     => 'archive_post',
		'subsection' => true,
		'fields' => array(
			array( 
				'id'       => 'tb_blog_layout',
				'type'     => 'image_select',
				'title'    => esc_html__('Select Layout', 'saga'),
				'subtitle' => esc_html__('Select layout of blog.', 'saga'),
				'options'  => array(
					'2cl'	=> array(
								'alt'   => '2cl',
								'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/2cl.png'
							),
					'2cr'	=> array(
								'alt'   => '2cr',
								'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/2cr.png'
							),
		            '1col'	=> array(
								'alt'   => '1col',
								'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/1col.png'
							)
				),
				'default' => '2cr'
			),
			array(
				'id'       => 'tb_blog_style',
				'type'     => 'select',
				'title'    => esc_html__( 'blog Style', 'saga' ),
				'subtitle' => esc_html__( 'Select archive style.', 'saga' ),
				'options'  => array(
		              'normal' => esc_html__( 'Default', 'saga' ), 
		              'style1' => esc_html__( 'Style1' , 'saga' ), 
					  'style2' => esc_html__( 'Style2' , 'saga' ),
		              'style3' => esc_html__( 'Style3' , 'saga' ),
					  'style4' => esc_html__( 'Style4' , 'saga' ),
				  ),
				'default'  => 'normal',
			),
		)
    ) );
    // -> START Portfolio
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Portfolio', 'saga' ),
        'id'     => 'portfolio',
        'desc'   => esc_html__( '', 'saga' ),
        'icon'   => 'el el-picture',
		'fields' => array(
		  array( 
				'id'       => 'tb_portfolio_layout',
				'type'     => 'image_select',
				'title'    => esc_html__('Select Layout', 'saga'),
				'subtitle' => esc_html__('Select layout of portfolio.', 'saga'),
				'options'  => array(
					'portfolio-side'	=> array(
						'alt'   => 'portfolio side',
						'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/2cr.png'
					),
		            'portfolio-full'	=> array(
						'alt'   => 'portfolio full width',
						'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/1col.png'
					),
					'portfolio-parallax'	=> array(
						'alt'   => 'portfolio img overlay',
						'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/1ct.png'
					),
					'portfolio-parallax-sm'	=> array(
						'alt'   => 'portfolio samll  img overlay samll',
						'img'   => SAGA_URI_PATH_ADMIN.'/assets/images/1ct_sm.png'
					),
				),
				'default' => 'portfolio-full'
			),
			array(
                'id' => 'portfolio_container_width',
                'title' => 'Portfolio Container Width',
                'subtitle' => esc_html__('in pixels.', 'saga'),
                'type' => 'dimensions',
                'units' => array('px'),
                'height' => false,
                'default' => array(
                    'units' => 'px',
                    'width' => '900'
                )
            ),
			array(
				'id'       => 'tb_portfolio_full_thumbnail',
				'type'     => 'switch',
		        'title'    => esc_html__( 'Show thumbnail image', 'saga' ),
				'subtitle' => esc_html__( 'Show or not thumbnail image on your single portfolio.', 'saga' ),
				'default'  => true,
				'required' => array('tb_portfolio_layout','=', 'portfolio-full')
			),
		    array(
				'id'=>'tb_portfolio_meta_single',
				'type' => 'button_set',
				'title' => esc_html__('Post Meta in portfolio page', 'saga'),
				'multi' => true,
				'options'=> array(
					'author'  => esc_html__('Author', 'saga'),    
					'date'    => esc_html__('Date', 'saga'),
					'like'    => esc_html__('Like', 'saga'),
					'cat'     => esc_html__('Categories', 'saga'),
					'view'    => esc_html__('View', 'saga'),
		            'share'   => esc_html__('Share', 'saga'),
				),
				'default' => array('date','cat','view','share','like'),                            
			 ),
		     array(
				'id'       => 'tb_portfolio_show_nav',
				'type'     => 'switch',
		        'title'    => esc_html__( 'Show Navigation', 'saga' ),
				'subtitle' => esc_html__( 'Show or not post navigation on your single portfolio.', 'saga' ),
				'default'  => true,
			),
		     array(
				'id'       => 'tb_related_portfolio',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Related Post', 'saga' ),
				'subtitle' => esc_html__( 'Show or not related post on your portfolio page.', 'saga' ),
				'default'  => true,
			 ),
			 array(
				'id'       => 'tb_portfolio_slug',
				'type'     => 'text',
				'title'    => esc_html__('Slug link', 'saga'),
				'subtitle' => esc_html__('Change portfolio slug', 'saga'),
				'description' => esc_html__( 'After saving your custom portfolio slug, flush the permalinks from "Wordpress Settings > Permalinks" for the changes to take effect.', 'saga' ),
				'default'  => 'portfolio'
			),
			array(
				'type'  => 'text',
				'id'    => 'tb_portfolio_category_slug',
				'title' => esc_html__( 'Portfolio Category Slug', 'saga' ),
				'description' => esc_html__( 'After saving your custom portfolio slug, flush the permalinks from "Wordpress Settings > Permalinks" for the changes to take effect.', 'saga' ),
				'default'  => 'project-type'
			),
		)
    ) );

	// -> START Page
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Page', 'saga' ),
        'id'     => 'page',
        'icon'   => 'el el-pencil',
		'fields' => array(
		   array(
				'id'             => 'page_padding',
				'type'           => 'spacing',
				'output'         => array('.internal-content'),
				'mode'           => 'padding',
				'units'          => array('em', 'px'),
				'title'    => esc_html__('Padding', 'saga'),
				'subtitle' => esc_html__('Please, Enter padding of pages.', 'saga'),
				'default'            => array(
					'padding-top'     => '60px', 
					'padding-right'   => '0px', 
					'padding-bottom'  => '60px', 
					'padding-left'    => '0px',
					'units'           => 'px', 
				)
			),
	     	array(
				'id'       => 'page_bg',
				'type'     => 'background',
				'title'    => esc_html__('Background', 'saga'),
				'subtitle' => esc_html__('background with image, color, etc.', 'saga'),
				'output'   => array('.internal-content'),
				'default'  => array(
					'background-color' => '#fff',
				)
			),
			array(
				'id'       => 'page_comment',
				'type'     => 'switch',
				'title'    => esc_html__( 'Show Page Comment', 'saga' ),
				'subtitle' => esc_html__( 'Show or not page comment on your page.', 'saga' ),
				'default'  => true,
			)
		)
    ) );
    Redux::setSection( $opt_name, array(
        'title'  => esc_html__( '404 Page', 'saga' ),
		'id'     => 'errorpage',
		'subsection' => true,
		'fields' => array(
		array(
			'id'       => 'error-404-bg',
			'type'     => 'background',
			'title'    => esc_html__('Background', 'saga'),
			'subtitle' => esc_html__('background with image, color, etc.', 'saga'),
			'output'   => array('.page-404'),
			'default'  => array(
				'background-color' => '#fff',
			)
		),
		array(
			'id'       => 'error-404-title',
			'type'     => 'text',
			'title'    => esc_html__( 'Title', 'saga' ),
			'subtitle' => '',
			'default' => '404'
		),
		array(
			'id'       => 'error-404-subtitle',
			'type'     => 'text',
			'title'    => esc_html__( 'Heading', 'saga' ),
			'subtitle' => '',
			'default' => 'Sorry we cant find that page!'
		),
		array(
			'id'       => 'error-404-content',
			'type'     => 'text',
			'title'    => esc_html__( 'Content', 'saga' ),
			'subtitle' => '',
			'default' => 'You are here because you entered the address of a page that no longer exists or has been moved to a different address'
		),
		array(
			'id' => 'error-404-btn',
			'type'	 => 'button_set',
			'title' => esc_html__('Button', 'saga'),
			'subtitle' => esc_html__('Switch on to display the "back to home" button.', 'saga'),
			'options' => array(
				'on'  => esc_html__( 'On', 'saga' ),
				'off' => esc_html__( 'Off', 'saga' )
			),
			'default' => 'on'
		),
		array(
			'id'       => 'error-404-btn-title',
			'type'     => 'text',
			'title'    => esc_html__( 'Button Title', 'saga' ),
			'subtitle' => '',
			'default'  => 'Back to home',
			'required' => array(
				'error-404-btn',
				'equals',
				'on'
			)
		),
	  )
    ) );
   // -> START Social Icon
	Redux::setSection( $opt_name, array(
        'title'  => esc_html__( 'Social', 'saga' ),
        'id'     => 'social',
		'icon'   => 'el el-share',
		'fields' => array(
			array(
				'id' => 'facebook_url',
				'type' => 'text',
				'title' => esc_html__('Facebook URL', 'saga' ),
				'desc' => esc_html__('Your Facebook URL', 'saga' ),
			),
			array(
				'id' => 'twitter_url',
				'type' => 'text',
				'title' => esc_html__('Twitter URL', 'saga' ),
				'desc' => esc_html__('Your Twitter URL', 'saga' ),
			),
			array(
				'id' => 'linkedin_url',
				'type' => 'text',
				'title' => esc_html__('Linkedin URL', 'saga' ),
				'desc' => esc_html__('Your Linkedin URL', 'saga' ),
			),
			array(
				'id' => 'youtube_url',
				'type' => 'text',
				'title' => esc_html__('Youtube URL', 'saga' ),
				'desc' => esc_html__('Your Youtube URL', 'saga' ),
			),
			array(
				'id' => 'instagram_url',
				'type' => 'text',
				'title' => esc_html__('Instagram URL', 'saga' ),
				'desc' => esc_html__('Your Instagram URL', 'saga' ),
			),
			array(
				'id' => 'pinterest_url',
				'type' => 'text',
				'title' => esc_html__('Pinterest URL', 'saga' ),
				'desc' => esc_html__('Your Pinterest URL', 'saga' ),
			),
		   array(
				'id' => 'dribbble_url',
				'type' => 'text',
				'title' => esc_html__('Dribbble URL', 'saga' ),
				'desc' => esc_html__('Your Dribbble URL', 'saga' ),
			),
		   array(
				'id' => 'deviantart_url',
				'type' => 'text',
				'title' => esc_html__('Deviantart URL', 'saga' ),
				'desc' => esc_html__('Your Deviantart URL', 'saga' ),
			),
		   array(
				'id' => 'flickr_url',
				'type' => 'text',
				'title' => esc_html__('Flickr URL', 'saga' ),
				'desc' => esc_html__('Your Flickr URL', 'saga' ),
			),
		   array(
				'id' => 'rss_url',
				'type' => 'text',
				'title' => esc_html__('RSS URL', 'saga' ),
				'desc' => esc_html__('Your RSS URL', 'saga' ),
			),
		 array(
				'id' => 'tumblr_url',
				'type' => 'text',
				'title' => esc_html__('Tumblr URL', 'saga' ),
				'desc' => esc_html__('Your Tumblr URL', 'saga' ),
			),
		   array(
				'id' => 'vimeo_url',
				'type' => 'text',
				'title' => esc_html__('Vimeo URL', 'saga' ),
				'desc' => esc_html__('Your Vimeo URL', 'saga' ),
			),
			 array(
				'id' => 'skype_url',
				'type' => 'text',
				'title' => esc_html__('Skype URL', 'saga' ),
				'desc' => esc_html__('Your Skype URL', 'saga' ),
			),
		   array(
				'id' => 'Soundcloud_url',
				'type' => 'text',
				'title' => esc_html__('Soundcloud URL', 'saga' ),
				'desc' => esc_html__('Your Soundcloud URL', 'saga' ),
			),
		 array(
				'id' => 'behance_url',
				'type' => 'text',
				'title' => esc_html__('Behance URL', 'saga' ),
				'desc' => esc_html__('Your Behance URL', 'saga' ),
			),
		  array(
				'id' => 'tripadvisor_url',
				'type' => 'text',
				'title' => esc_html__('Tripadvisor URL', 'saga' ),
				'desc' => esc_html__('Your Tripadvisor URL', 'saga' ),
			),
		)
    ) );
    
    /**
     * This is a test function that will let you see when the compiler hook occurs.
     * It only runs if a field    set with compiler=>true is changed.
     * */
    if ( ! function_exists( 'compiler_action' ) ) {
        function compiler_action( $options, $css, $changed_values ) {
            echo '<h1>The compiler hook has run!</h1>';
            echo "<pre>";
            print_r( $changed_values ); // Values that have changed since the last save
            echo "</pre>";
            //print_r($options); //Option values
            //print_r($css); // Compiler selector CSS values  compiler => array( CSS SELECTORS )
        }
    }

    /**
     * Custom function for the callback validation referenced above
     * */
    if ( ! function_exists( 'redux_validate_callback_function' ) ) {
        function redux_validate_callback_function( $field, $value, $existing_value ) {
            $error   = false;
            $warning = false;

            //do your validation
            if ( $value == 1 ) {
                $error = true;
                $value = $existing_value;
            } elseif ( $value == 2 ) {
                $warning = true;
                $value   = $existing_value;
            }

            $return['value'] = $value;

            if ( $error == true ) {
                $return['error'] = $field;
                $field['msg']    = 'your custom error message';
            }

            if ( $warning == true ) {
                $return['warning'] = $field;
                $field['msg']      = 'your custom warning message';
            }

            return $return;
        }
    }

    /**
     * Custom function for the callback referenced above
     */
    if ( ! function_exists( 'redux_my_custom_field' ) ) {
        function redux_my_custom_field( $field, $value ) {
            print_r( $field );
            echo '<br/>';
            print_r( $value );
        }
    }

    /**
     * Custom function for filtering the sections array. Good for child themes to override or add to the sections.
     * Simply include this function in the child themes functions.php file.
     * NOTE: the defined constants for URLs, and directories will NOT be available at this point in a child theme,
     * so you must use get_template_directory_uri() if you want to use any of the built in icons
     * */
    if ( ! function_exists( 'dynamic_section' ) ) {
        function dynamic_section( $sections ) {
            //$sections = array();
            $sections[] = array(
                'title'  => esc_html__( 'Section via hook', 'saga' ),
                'desc'   => esc_html__( '<p class="description">This is a section created by adding a filter to the sections array. Can be used by child themes to add/remove sections from the options.</p>', 'saga' ),
                'icon'   => 'el el-paper-clip',
                // Leave this as a blank section, no options just some intro text set above.
                'fields' => array()
            );

            return $sections;
        }
    }

    /**
     * Filter hook for filtering the args. Good for child themes to override or add to the args array. Can also be used in other functions.
     * */
    if ( ! function_exists( 'change_arguments' ) ) {
        function change_arguments( $args ) {
            //$args['dev_mode'] = true;

            return $args;
        }
    }

    /**
     * Filter hook for filtering the default value of any given field. Very useful in development mode.
     * */
    if ( ! function_exists( 'change_defaults' ) ) {
        function change_defaults( $defaults ) {
            $defaults['str_replace'] = 'Testing filter hook!';

            return $defaults;
        }
    }