<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
use Elementor\Element_Base;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
class MOElement_Testimonial extends MOElement_Base{
    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'mo-testimonials';
    }
    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Testimonials Carousel', 'saga');
    }
    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-testimonial-carousel';
    }

    public function get_keywords() {
        return [ 'testimonial', 'content', 'carousel' ];
    }

    public function get_script_depends() {
      return [
          'jquery.owl.carousel',
          'saga.elements',
      ];
    }

    public function get_style_depends() {
      return array('owl-carousel-css');
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_testimonial',
            [
                'label' => __('Testimonials', 'saga'),
            ]
        );
         $this->add_control(
            'style',
            array(
                'label'   => esc_html__( 'Layout', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                  'style-1' => esc_html__('Style I - Carousel', 'saga'),
                  'style-2' => esc_html__('Style II - Grid', 'saga')
                ]
            )
         );
        $this->add_control(
            'style_carousel',
            array(
                'label'   => esc_html__( 'Style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'tpl1',
                'options' => [
                  'tpl1' => esc_html__('Style 1', 'saga'),
                  'tpl2' => esc_html__('Style 2', 'saga'),
                  'tpl3' => esc_html__('Style 3', 'saga'),
                  'tpl4' => esc_html__('Style 4', 'saga'),
                  'tpl5' => esc_html__('Style 5', 'saga')
                ]
            )
         );
         $repeater = new \Elementor\Repeater();
         $repeater->add_control(
             'testimonial_image',
             [
                'label'      => __('Choose Image', 'saga'),
                'default'    => [
                    'url' => SAGA_URI . 'elementor/assets/images/testimonial.png',
                ],
                'type'       => Controls_Manager::MEDIA,
                'show_label' => false, 
             ]
         );
         $repeater->add_control(
            'testimonial_name',
            [
                'label'   => __('Name', 'saga'),
                'default' => 'John Doe',
                'type'    => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'testimonial_job',
            [
                'label'   => __('Job', 'saga'),
                'default' => 'Designer',
                'type'    => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'testimonial_title',
            [
               'label'       => __('Title', 'saga'),
               'type'        => Controls_Manager::TEXT,
               'default'     => 'Wonderful experience!',
            ]
        );
        $repeater->add_control(
            'testimonial_content',
            [
               'label'       => __('Content', 'saga'),
               'type'        => Controls_Manager::TEXTAREA,
               'default'     => 'I was impresed by the moling services, not lorem ipsum is simply free text of used by refreshing. Neque porro este qui dolorem ipsum quia.',
               'label_block' => true,
               'rows'        => '6',
            ]
        );
		$repeater->add_control(
			'rating',
			[
				'label' => __( 'Rating/Stars', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 5,
						'step' => 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 0,
				],
			]
		);
        $this->add_control(
            'testimonials',
            [
                'label'       => __('Testimonials Content Item', 'saga'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '{{{ testimonial_name }}}',
                'default'     => array(
                    array(
                        'testimonial_name'     => esc_html__( 'Mona Kamal', 'saga' ),
                        'testimonial_job'      => esc_html__( 'Founder & CEO', 'saga' ),
                        'testimonial_title'    => esc_html__( 'Wonderful experience!', 'saga' ),
                        'testimonial_content'  => esc_html__( 'There’re too many themes that claim to base on creativity & creators, but this one is the only one that makes me stop exploring more right at first glance.', 'saga' ),
                        'testimonial_image'    => ['url' => SAGA_URI . 'elementor/assets/images/testimonial.png', ]
                    ),
                    array(
                        'testimonial_name'     => esc_html__( 'Mona Kamal', 'saga' ),
                        'testimonial_job'      => esc_html__( 'Founder & CEO', 'saga' ),
                        'testimonial_title'    => esc_html__( 'Wonderful experience!', 'saga' ),
                        'testimonial_content'  => esc_html__( 'There’re too many themes that claim to base on creativity & creators, but this one is the only one that makes me stop exploring more right at first glance.', 'saga' ),
                        'testimonial_image'    => ['url' => SAGA_URI . 'elementor/assets/images/testimonial.png', ]
                    ),
                    array(
                        'testimonial_name'     => esc_html__( 'Mona Kamal', 'saga' ),
                        'testimonial_job'      => esc_html__( 'Founder & CEO', 'saga' ),
                        'testimonial_title'    => esc_html__( 'Wonderful experience!', 'saga' ),
                        'testimonial_content'  => esc_html__( 'There’re too many themes that claim to base on creativity & creators, but this one is the only one that makes me stop exploring more right at first glance.', 'saga' ),
                        'testimonial_image'    => ['url' => SAGA_URI . 'elementor/assets/images/testimonial.png', ]
                    ),
                    array(
                        'testimonial_name'     => esc_html__( 'Mona Kamal', 'saga' ),
                        'testimonial_job'      => esc_html__( 'Founder & CEO', 'saga' ),
                        'testimonial_title'    => esc_html__( 'Wonderful experience!', 'saga' ),
                        'testimonial_content'  => esc_html__( 'There’re too many themes that claim to base on creativity & creators, but this one is the only one that makes me stop exploring more right at first glance.', 'saga' ),
                        'testimonial_image'    => ['url' => SAGA_URI . 'elementor/assets/images/testimonial.png', ]
                    ),
                    array(
                        'testimonial_name'     => esc_html__( 'Mona Kamal', 'saga' ),
                        'testimonial_job'      => esc_html__( 'Founder & CEO', 'saga' ),
                        'testimonial_title'    => esc_html__( 'Wonderful experience!', 'saga' ),
                        'testimonial_content'  => esc_html__( 'There’re too many themes that claim to base on creativity & creators, but this one is the only one that makes me stop exploring more right at first glance.', 'saga' ),
                        'testimonial_image'    => ['url' => SAGA_URI . 'elementor/assets/images/testimonial.png', ]
                    ),
                ),
            ]
        );
        $this->end_controls_section();
        $this->add_control_carousel(false, array('style' => 'style-1'));
        $this->add_control_grid(array('style' => 'style-2'));

        // Color Styling
        $this->start_controls_section(
            'section_style_content',
            [
                'label' => __('Color', 'saga'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
 
        $this->add_control(
            'title_color',
            [
                'label'     => __('Title Color', 'saga'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .mo-testimonial .content h4' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .mo-testimonial.tpl5 .owl-item.active.center .item:after' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label'     => __('Content Color', 'saga'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .mo-testimonial .content p' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_control(
            'name_text_color',
            [
                'label'     => __('Name Color', 'saga'),
                'type'      => Controls_Manager::COLOR,
                'separator' => 'before',
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .mo-testimonial .testimonial-title h5' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'job_text_color',
            [
                'label'     => __('Job Color', 'saga'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .mo-testimonial .testimonial-title h6' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'star_rating_color',
            [
                'label'     => __('Star Rating Color', 'saga'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .mo-star-rating .active' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();


        // Image Styling
        $this->start_controls_section(
            'section_style_image',
            [
                'label'     => __('Image', 'saga'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_size',
            [
                'label'      => __('Image Size', 'saga'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 20,
                        'max' => 200,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .mo-testimonial .testimonial-avatar, {{WRAPPER}} .mo-testimonial .testimonial-avatar img' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name'      => 'image_border',
                'selector'  => '{{WRAPPER}} .mo-testimonial .testimonial-avatar',
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'image_border_radius',
            [
                'label'      => __('Border Radius', 'saga'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .mo-testimonial .testimonial-avatar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
      $settings = $this->get_settings_for_display();
      printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
      if(isset($settings['style']) && $settings['style']){
        include $this->get_template('testimonials/mo-testimonials-' . $settings['style'] . '.php');
     }
      print '</div>';
    }
}