<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
class MOElement_Socials extends MOElement_Base{

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'mo-socials';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Socials', 'saga');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-social-icons';
    }

    public function get_keywords() {
        return [ 'social', 'content', 'link' ];
    }


    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_socials',
            [
                'label' => __('Socials', 'saga'),
            ]
        );


        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
			'social_title',
			[
				'label'       => __('social_title', 'saga'),
                'type'        => Controls_Manager::TEXT,
                'placeholder' => 'Facebook',
			]
		);
		$repeater->add_control(
            'social_icon',
            [
                'label'      => __('Choose Icon', 'saga'),
                'type'       => 'icon',
                'show_label' => false,
            ]
         );
         $repeater->add_control(
            'social_link',
            [
                'label'   => __('Social Link', 'saga'),
                'default' => '#',
                'type'    => Controls_Manager::TEXT,
            ]
         );
         $repeater->add_control(
            'social_color',
            [
                'label'     => __('Social Color', 'saga'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '',
                'selectors' => [
                    '{{WRAPPER}} .social-links {{CURRENT_ITEM}} a' => 'background: {{VALUE}};',
                ],
            ]
         );
        $this->add_control(
            'socials',
            [
                'label'       => __('Social Icon Item', 'saga'),
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'title_field' => '',
                'default'     => array(
                    array(
                        'social_title'      => esc_html__( 'Facebook', 'saga' ),
                        'social_icon'       => esc_html__( 'fab fa-facebook', 'saga' ),
                        'social_link'       => '#',
                    ),
                    array(
                        'social_title'      => esc_html__( 'Twitter', 'saga' ),
                        'social_icon'       => esc_html__( 'fa-brands fa-x-twitter', 'saga' ),
                        'social_link'       => '#',
                    ),
                    array(
                        'social_title'      => esc_html__( 'Instagram', 'saga' ),
                        'social_icon'       => esc_html__( 'fab fa-instagram', 'saga' ),
                        'social_link'       => '#',
                    ),
                    array(
                        'social_title'      => esc_html__( 'pinterest', 'saga' ),
                        'social_icon'       => esc_html__( 'fab fa-pinterest', 'saga' ),
                        'social_link'       => '#',
                    ),
                ),
            ]
        );
        $this->end_controls_section();


        // Style.
        $this->start_controls_section(
            'section_style_content',
            [
                'label' => __('Color', 'saga'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'content_color',
            [
                'label'     => __('Text Color', 'saga'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .social-icons a' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'content_background',
            [
                'label'     => __('Background Color', 'saga'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#e60000',
                'selectors' => [
                    '{{WRAPPER}} .social-icons a' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
        
          // Hover Styling
          $this->start_controls_section(
            'section_hover',
            [
                'label' => __('Hover Color', 'saga'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
          $this->add_control(
            'style',
            array(
                'label'   => esc_html__( 'Style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                  'style1' => esc_html__('Style 1 (Solid)', 'saga'),
                  'style2' => esc_html__('Style 2 (Border Circle)', 'saga'),
                ]
            )
        );
       
        $this->add_control(
            'content_hr_color',
            [
                'label'     => __('Hover Text Color', 'saga'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#fff',
                'selectors' => [
                    '{{WRAPPER}} .social-icons a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'content_hr_background',
            [
                'label'     => __('Hover Background Color', 'saga'),
                'type'      => Controls_Manager::COLOR,
                'default'   => '#181b31',
                'selectors' => [
                    '{{WRAPPER}} .social-icons a::before, .social-icons a:hover' => 'background: {{VALUE}};',
                ],
            ]
        );
        
        $this->end_controls_section();


        // Image Styling
        $this->start_controls_section(
            'section_style_icon',
            [
                'label'     => __('Icon Style', 'saga'),
                'tab'       => Controls_Manager::TAB_STYLE,
            ]
        );
         $this->add_control(
            'align',
            [
                'label' => __( 'Alignment', 'saga' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'saga' ),
						'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'saga' ),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'saga' ),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
					'{{WRAPPER}} .social-links' => 'text-align: {{VALUE}};',
				],
            ]
        ); 

        $this->add_control(
            'icons_width',
            [
                'label'      => __('Icons Width', 'saga'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 30,
                        'max' => 50,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .social-icons a' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icons_space',
            [
                'label'      => __('Icon Space', 'saga'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 0,
                        'max' => 20,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .social-icons a' => 'margin-right: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icons_size',
            [
                'label'      => __('Icon Size', 'saga'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => ['px'],
                'range'      => [
                    'px' => [
                        'min' => 10,
                        'max' => 30,
                    ],
                ],
                'selectors'  => [
                    '{{WRAPPER}} .social-icons a' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_control(
            'icons_border_radius',
            [
                'label'      => __('Border Radius', 'saga'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .social-icons a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        

      
    }
    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
      $settings = $this->get_settings_for_display();
      printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
      if(isset($settings['style']) && $settings['style']){
         include $this->get_template('mo-socials.php');
      }
      print '</div>';
    }
}