<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
/**
 * Elementor heading widget.
 *
 * Elementor widget that displays an eye-catching headlines.
 *
 * @since 1.0.0
 */
class MOElement_Image_Box extends MOElement_Base {

	/**
	 * Get widget name.
	 *
	 * Retrieve heading widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'mo-image-box';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve heading widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Image Box', 'saga' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-featured-image';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'image', 'content' ];
	}

	/**
	 * Register heading widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_title',
			[
				'label' => __( 'Content', 'saga' ),
			]
		);
		$this->add_control(
			'style',
			[
				'label' => __( 'Style', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'style1'  => esc_html__('Style 1', 'saga'),
					'style2'  => esc_html__('Style 2', 'saga'),
					'style3'  => esc_html__('Style 3', 'saga'),
					'style4'  => esc_html__('Style 4', 'saga'),
					'style5'  => esc_html__('Style 5', 'saga'),
					'style6'  => esc_html__('Style 6', 'saga'),
					'style7'  => esc_html__('Style 7', 'saga'),
					'style8'  => esc_html__('Style 8', 'saga'),
					'style9'  => esc_html__('Style 9', 'saga'),
					'style10' => esc_html__('Style 10', 'saga'),
				],
				'default' => 'style1',
			]
		);
		$this->add_control(
			'title_text',
			[
				'label' => __( 'Title', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => __( 'Enter your title', 'saga' ),
				'default' => __( 'Add Your Heading Text Here', 'saga' ),
			]
		);
		$this->add_control(
            'sup_title_text',
            array(
                'label'       => __('Sub Title', 'saga'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
            )
        );
		$this->add_control(
			'description_text',
			[
				'label' => __( 'Description', 'saga' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Your Description', 'saga' ),
			]
		);
		$this->add_control(
            'selected_icon',
            [
                'label' => __( 'Icon', 'saga' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
            ]
        );
		$this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'saga' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
		$this->add_control(
			'link_text',
			[
				'label' => __( 'Text Link', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'Read More', 'saga' ),
				'default' => __( 'Read More', 'saga' ),
			]
		);
	    $this->add_control(
			'link',
			[
				'label' => __( 'Link', 'saga' ),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'https://your-link.com', 'saga' ),
				'label_block' => true
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'section_box_style',
			[
				'label' => __( 'Box', 'saga' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'box_primary_color',
			[
				'label' => __( 'Primary Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .image-box-style1 .perspective_overlay' => ' background:linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, {{VALUE}} 100%);',
					'{{WRAPPER}} .image-box-style2 .sup-title' => 'color:{{VALUE}};',
					'{{WRAPPER}} .image-box-style2  .button.btn-txt-arrow svg.svg-arrow path' => 'stroke:{{VALUE}};',
					'{{WRAPPER}} .image-box-style3 .image-bg:before' => 'background: {{VALUE}};',
					'{{WRAPPER}} .image-box-style3 .title-wrap .icon-wrap i, {{WRAPPER}} .image-box-style3 .title-wrap .sup-title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .image-box-style3 .title-wrap svg, {{WRAPPER}} .title-wrap svg rect, {{WRAPPER}} .image-box-style3 .title-wrap svg path, {{WRAPPER}} .image-box-style3  .title-wrap svg polyline' => 'stroke:{{VALUE}};',
					'{{WRAPPER}} .image-box-style4 .sup-title' => 'color:{{VALUE}};',
					'{{WRAPPER}} .image-box-style4:hover .perspective_overlay' => 'background: linear-gradient(0deg,{{VALUE}} 0%, rgba(172, 29, 225, 0) 45%);',
					'{{WRAPPER}} .image-box-style5 .perspective_overlay' => 'background:linear-gradient(180deg, rgba(255, 255, 255, 0) 0%, {{VALUE}} 100%);',
					'{{WRAPPER}} .image-box-style7 .content-wrap:after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .image-box-style7 .sup-title, {{WRAPPER}} .image-box-style7 .content-wrap .button:hover' => 'color: {{VALUE}};',
					'{{WRAPPER}} .image-box-style8:hover .title-wrap' => 'background: {{VALUE}};',
					'{{WRAPPER}} .image-box-style8 .sup-title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .image-box-style9 .icon-wrap:after' => 'background-color: {{VALUE}};',
					'{{WRAPPER}} .image-box-style9 .sup-title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .image-box-style10 .sup-title' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_responsive_control(
			'box_height',
			[
				'label' => __( 'Height', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 100,
						'max' => 800,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .image-box-style1 > .img-perspective' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .image-box-style2' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .image-box-style3, .image-box-style3 > .thumb-service img' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .image-box-style3 .thumb-service img' => 'min-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .image-box-style4' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .image-box-style5' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .image-box-style6 .thumb-service img' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .image-box-style7' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .image-box-style8 .thumb-service' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .image-box-style9 .thumb-service' => 'height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .image-box-style10' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}
	/**
	 * Render heading widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
      printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
         include $this->get_template('mo-image-box.php');
      print '</div>';
	}
}