<?php
/**
* Icon Params
*/

if( !defined( 'ABSPATH' ) )
	exit; // Exit if accessed directly

function mo_get_icon( $atts = array(), $add_icon = false, $prefix = 'i_' ) {

	$atts = shortcode_atts( array(

		// Icon
		$prefix . 'add_icon'         => false,
		$prefix . 'type'             => 'fontawesome',
		$prefix . 'icon_fontawesome' => false,
		$prefix . 'icon_linea'       => false,
		$prefix . 'icon_animated'         => false,
		$prefix . 'icon_image'       => false,

		//Custom icons
		$prefix . 'icon_mo_custom_icons' => false,

		// Style
		$prefix . 'color'            => false,
		$prefix . 'hcolor'           => false,
		$prefix . 'align'            => false,
		$prefix . 'size'             => false

	), $atts );

	if( $add_icon && 'true' !== $atts[ $prefix . 'add_icon' ] ) {
		return '';
	}

	if( 'image' === $atts[ $prefix . 'type' ] ) {
		$type = $atts[ $prefix . 'type' ];
		$image_url = isset( $atts[ $prefix . 'icon_' . $type ] ) ? wp_get_attachment_url( $atts[ $prefix . 'icon_' . $type ] ) : '';
		
		return array(
			'type' => $type,
			'src' => $image_url
		);
	}
	elseif( 'animated' === $atts[ $prefix . 'type' ] ) {
		$type = $atts[ $prefix . 'type' ];
		$icon = isset( $atts[ $prefix . 'icon_' . $type ] ) ? esc_attr( $atts[ $prefix . 'icon_' . $type ] ) : 'animated-arrows_anticlockwise';
		$svg  = str_replace( 'animated-', '', $icon );		

		$svg_src = LD_ADDONS_URL . 'assets/vendors/animated-icons/svg/' . $svg . '.svg';
		
		return array(
			'type' => $type,
			'src' => $svg_src,
			'class' => $icon,
		);
	}
	else {
		
		$type = $atts[ $prefix . 'type' ];
		$icon_class = isset( $atts[ $prefix . 'icon_' . $type ] ) ? esc_attr( $atts[ $prefix . 'icon_' . $type ] ) : 'fa fa-adjust';
		$icon_color = isset( $atts[ $prefix . 'color' ] ) ? $atts[ $prefix . 'color' ] : '';
		$icon_hcolor = isset( $atts[ $prefix . 'hcolor' ] ) ? $atts[ $prefix . 'hcolor' ] : '';
		$icon_align = isset( $atts[ $prefix . 'align' ] ) ? $atts[ $prefix . 'align' ] : 'left';
		$icon_size  = isset( $atts[ $prefix . 'size' ] ) ? $atts[ $prefix . 'size' ] : 'size';

		vc_icon_element_fonts_enqueue( $type );
	
		return array(
			'type'	=> $type,
			'color'	=> $icon_color,
			'hcolor' => $icon_hcolor,
			'icon'	=> $icon_class,
			'align'	=> $icon_align,
			'size'	=> $icon_size
		);
	}

}

function mo_get_icon_params( $add_icon = false, $group = '', $fonts = 'all', $remove = array(), $prefix = 'i_', $dependency = array() ) {

	$font_hash = array(
		'fontawesome'   => esc_html__( 'Font Awesome', 'saga' ),
		'linea'         => esc_html__( 'mo', 'saga' ),
		'animated'      => esc_html__( 'Animated', 'saga' ),
		'image'    => esc_html__( 'Image icon', 'saga' ),
	);
	
	//Add custom icons fonts
	$font_hash = apply_filters( 'mo_custom_icons_font', $font_hash );

	$settings = array();

	// Add icon field
	if( $add_icon && 'manual' !== $add_icon ) {
		$settings[] = array(
            'type'       => 'checkbox',
            'param_name' => $prefix . 'add_icon',
            'heading'    => esc_html__( 'Add icon?', 'saga' ),
            'description' => esc_html__( 'Will enable icon on element', 'saga' ),
		);
	}

// Iconpicker field
	$add_these = $add_these_select = array();
	$add_these_select[esc_html__( 'Select icon font.', 'saga' )] = '';

	if( 'all' == $fonts ) {
		$fonts = array_keys( $font_hash );
	}

	foreach( $fonts as $font ) {

		$add_these_select[ $font_hash[$font] ] = $font;
		
		if( 'image' === $font ) {
			
			
			$add_these[] = array(
				'type'        => 'attach_image',
				'param_name'  => $prefix . 'icon_' . $font,
				'heading'     => esc_html__( 'Image', 'saga' ),
				'dependency'  => array(
					'element' => $prefix . 'type',
					'value'   => $font
				),
				'group' => $group
			);
		}
		else {			
	
			$add_these[] = array(
				'type'       => 'iconpicker',
				'param_name' => $prefix . 'icon_' . $font,
				'heading'    => esc_html__( 'Icon', 'saga' ),
				'description' => esc_html__( 'Select icon from library.', 'saga' ),
				'settings' => array(
					'emptyIcon'    => false,
					'type'         => $font,
					'iconsPerPage' => 4000
				),
				'dependency' => array(
					'element' => $prefix . 'type',
					'value'   => $font
				),
				'group' => $group
			);	
		}
	}

	// Icon library select field
	$settings[] = array(
		'type'       => 'dropdown',
		'param_name' => $prefix . 'type',
		'heading'    => esc_html__( 'Icon library', 'saga' ),
		'value'      => $add_these_select,
		'description' => esc_html__( 'Select icon library.', 'saga' ),
		'dependency'  => ! $add_icon ? $dependency : array(
			'element' => $prefix . 'add_icon',
            'value'   => 'true'
		),
		'group' => $group
	);

	$settings = array_merge( $settings, $add_these );

	// Icon color picker field
	if( ! in_array( 'color', $remove ) ) {
		$settings[] = array(
			'type'        => 'mo_colorpicker',
			'only_solid'  => true,
			'param_name'  => $prefix . 'color',
			'heading'     => esc_html__( 'Icon color', 'saga' ),
			'description' => esc_html__( 'Select icon color.', 'saga' ),
			'edit_field_class' => 'vc_col-sm-6',
			'dependency'  => ! $add_icon ? $dependency : array(
				'element' => $prefix . 'add_icon',
	            'value'   => 'true'
			),
			'group' => esc_html__( 'Design Options', 'saga' ),
		);
	}
	// Icon color picker field
	if( ! in_array( 'hcolor', $remove ) ) {
		$settings[] = array(
			'type'        => 'mo_colorpicker',
			'only_solid'  => true,
			'param_name'  => $prefix . 'hcolor',
			'heading'     => esc_html__( 'Icon hover color', 'saga' ),
			'description' => esc_html__( 'Pick icon hover color.', 'saga' ),
			'edit_field_class' => 'vc_col-sm-6',
			'dependency'  => ! $add_icon ? $dependency : array(
				'element' => $prefix . 'add_icon',
	            'value'   => 'true'
			),
			'group' => esc_html__( 'Design Options', 'saga' ),
		);
	}

	// Icon alignment field
	if( ! in_array( 'align', $remove ) ) {
		$settings[] = array(
			'type'       => 'dropdown',
			'param_name' => $prefix . 'align',
			'heading'    => esc_html__( 'Icon alignment', 'saga' ),
			'edit_field_class' => 'vc_col-sm-6',
			'value'      => array(
				esc_html__( 'Left', 'saga' )   => 'left',
				esc_html__( 'Right', 'saga' )  => 'right'
			),
			'description' => esc_html__( 'Select icon alignment.', 'saga' ),
			'group' => $group,
			'dependency'  => ! $add_icon ? $dependency : array(
				'element' => $prefix . 'add_icon',
	            'value'   => 'true'
			)
		);
	}
	


	foreach( $settings as &$param ) {
		if( empty( $param['group'] ) ) {
			unset($param['group']);
		}
	}

	return $settings;
}

add_filter( 'vc_iconpicker-type-linea', 'mo_iconpicker_type_linea' );
/**
 * [rs_iconpicker_type_linea description]
 * @method rs_iconpicker_type_linea
 * @param  [type]                   $icons [description]
 * @return [type]                          [description]
 */
function mo_iconpicker_type_linea( $icons ) {

	$linea_icons = array(

		'Weather' => array(
			array('icon-weather_aquarius' => 'weather aquarius' ),
			array('icon-weather_cloud_drop' => 'weather cloud drop' ),
			array('icon-weather_cloud_lightning' => 'weather cloud lightning' ),
			array('icon-weather_cloud_snowflake' => 'weather cloud snowflake' ),
			array('icon-weather_cloud' => 'weather cloud' ),
			array('icon-weather_downpour_fullmoon' => 'weather downpour fullmoon' ),
			array('icon-weather_downpour_halfmoon' => 'weather downpour halfmoon' ),
			array('icon-weather_downpour_sun' => 'weather downpour sun' ),
			array('icon-weather_drop' => 'weather drop' ),
			array('icon-weather_first_quarter' => 'weather first quarter' ),
			array('icon-weather_fog_fullmoon' => 'weather fog fullmoon' ),
			array('icon-weather_fog_halfmoon' => 'weather fog halfmoon' ),
			array('icon-weather_fog_sun' => 'weather fog sun' ),
			array('icon-weather_fog' => 'weather fog' ),
			array('icon-weather_fullmoon' => 'weather fullmoon' ),
			array('icon-weather_hail_fullmoon' => 'weather hail fullmoon' ),
			array('icon-weather_hail_halfmoon' => 'weather hail halfmoon' ),
			array('icon-weather_hail_sun' => 'weather hail sun' ),
			array('icon-weather_hail' => 'weather hail' ),
			array('icon-weather_last_quarter' => 'weather last quarter' ),
			array('icon-weather_lightning' => 'weather lightning' ),
			array('icon-weather_mistyrain_fullmoon' => 'weather mistyrain fullmoon' ),
			array('icon-weather_mistyrain_halfmoon' => 'weather mistyrain halfmoon' ),
			array('icon-weather_mistyrain_sun' => 'weather mistyrain sun' ),
			array('icon-weather_mistyrain' => 'weather mistyrain' ),
			array('icon-weather_moon' => 'weather moon' ),
			array('icon-weather_moondown_full' => 'weather moondown full' ),
			array('icon-weather_moondown_half' => 'weather moondown half' ),
			array('icon-weather_moonset_full' => 'weather moonset full' ),
			array('icon-weather_moonset_half' => 'weather moonset half' ),
			array('icon-weather_move2' => 'weather move2' ),
			array('icon-weather_newmoon' => 'weather newmoon' ),
			array('icon-weather_rain_fullmoon' => 'weather rain fullmoon' ),
			array('icon-weather_rain_halfmoon' => 'weather rain halfmoon' ),
			array('icon-weather_rain_sun' => 'weather rain sun' ),
			array('icon-weather_rain' => 'weather rain' ),
			array('icon-weather_snow_fullmoon' => 'weather snow fullmoon' ),
			array('icon-weather_snow_halfmoon' => 'weather snow halfmoon' ),
			array('icon-weather_snow_sun' => 'weather snow sun' ),
			array('icon-weather_snow' => 'weather snow' ),
			array('icon-weather_snowflake' => 'weather snowflake' ),
			array('icon-weather_star' => 'weather star' ),
			array('icon-weather_storm_fullmoon' => 'weather storm fullmoon' ),
			array('icon-weather_storm_halfmoon' => 'weather storm halfmoon' ),
			array('icon-weather_storm_sun' => 'weather storm sun' ),
			array('icon-weather_storm-11' => 'weather storm' ),
			array('icon-weather_storm-32' => 'weather storm' ),
			array('icon-weather_sun' => 'weather sun' ),
			array('icon-weather_sundown' => 'weather sundown' ),
			array('icon-weather_sunset' => 'weather sunset' ),
			array('icon-weather_taurus' => 'weather taurus' ),
			array('icon-weather_tempest_fullmoon' => 'weather tempest fullmoon' ),
			array('icon-weather_tempest_halfmoon' => 'weather tempest halfmoon' ),
			array('icon-weather_tempest_sun' => 'weather tempest sun' ),
			array('icon-weather_tempest' => 'weather tempest' ),
			array('icon-weather_variable_fullmoon' => 'weather variable fullmoon' ),
			array('icon-weather_variable_halfmoon' => 'weather variable halfmoon' ),
			array('icon-weather_variable_sun' => 'weather variable sun' ),
			array('icon-weather_waning_cresent' => 'weather waning cresent' ),
			array('icon-weather_waning_gibbous' => 'weather waning gibbous' ),
			array('icon-weather_waxing_cresent' => 'weather waxing cresent' ),
			array('icon-weather_waxing_gibbous' => 'weather waxing gibbous' ),
			array('icon-weather_wind_fullmoon' => 'weather wind fullmoon' ),
			array('icon-weather_wind_halfmoon' => 'weather wind halfmoon' ),
			array('icon-weather_wind_sun' => 'weather wind sun' ),
			array('icon-weather_wind' => 'weather wind' ),
			array('icon-weather_windgust' => 'weather windgust' ),
		),

		'Software' => array(
			array( 'icon-software_add_vectorpoint' => 'software add_vectorpoint' ),
			array( 'icon-software_character' => 'software character' ),
			array( 'icon-software_crop' => 'software crop' ),
			array( 'icon-software_eyedropper' => 'software eyedropper' ),
			array( 'icon-software_font_allcaps' => 'software font_allcaps' ),
			array( 'icon-software_font_baseline_shift' => 'software font_baseline_shift' ),
			array( 'icon-software_font_horizontal_scale' => 'software font_horizontal_scale' ),
			array( 'icon-software_font_kerning' => 'software font_kerning' ),
			array( 'icon-software_font_leading' => 'software font_leading' ),
			array( 'icon-software_font_size' => 'software font_size' ),
			array( 'icon-software_font_smallcapital' => 'software font_smallcapital' ),
			array( 'icon-software_font_smallcaps' => 'software font_smallcaps' ),
			array( 'icon-software_font_strikethrough' => 'software font_strikethrough' ),
			array( 'icon-software_font_tracking' => 'software font_tracking' ),
			array( 'icon-software_font_underline' => 'software font_underline' ),
			array( 'icon-software_font_vertical_scale' => 'software font_vertical_scale' ),
			array( 'icon-software_horizontal_align_center' => 'software horizontal_align_center' ),
			array( 'icon-software_horizontal_align_right' => 'software horizontal_align_right' ),
			array( 'icon-software_horizontal_distribute_center' => 'software horizontal_distribute_center' ),
			array( 'icon-software_horizontal_distribute_left' => 'software horizontal_distribute_left' ),
			array( 'icon-software_horizontal_distribute_right' => 'software horizontal_distribute_right' ),
			array( 'icon-software_indent_firstline' => 'software indent_firstline' ),
			array( 'icon-software_indent_left' => 'software indent_left' ),
			array( 'icon-software_indent_right' => 'software indent_right' ),
			array( 'icon-software_lasso' => 'software lasso' ),
			array( 'icon-software_layers1' => 'software layers1' ),
			array( 'icon-software_layers2' => 'software layers2' ),
			array( 'icon-software_layout_2columns' => 'software layout_2columns' ),
			array( 'icon-software_layout_3columns' => 'software layout_3columns' ),
			array( 'icon-software_layout_4boxes' => 'software layout_4boxes' ),
			array( 'icon-software_layout_4columns' => 'software layout_4columns' ),
			array( 'icon-software_layout_4lines' => 'software layout_4lines' ),
			array( 'icon-software_layout_header_2columns' => 'software layout_header_2columns' ),
			array( 'icon-software_layout_header_3columns' => 'software layout_header_3columns' ),
			array( 'icon-software_layout_header_4boxes' => 'software layout_header_4boxes' ),
			array( 'icon-software_layout_header_4columns' => 'software layout_header_4columns' ),
			array( 'icon-software_layout_header_complex' => 'software layout_header_complex' ),
			array( 'icon-software_layout_header_complex2' => 'software layout_header_complex2' ),
			array( 'icon-software_layout_header_complex3' => 'software layout_header_complex3' ),
			array( 'icon-software_layout_header_complex4' => 'software layout_header_complex4' ),
			array( 'icon-software_layout_header_sideleft' => 'software layout_header_sideleft' ),
			array( 'icon-software_layout_header_sideright' => 'software layout_header_sideright' ),
			array( 'icon-software_layout_header' => 'software layout_header' ),
			array( 'icon-software_layout_sidebar_left' => 'software layout_sidebar_left' ),
			array( 'icon-software_layout_sidebar_right' => 'software layout_sidebar_right' ),
			array( 'icon-software_layout-8boxes' => 'software layout' ),
			array( 'icon-software_layout' => 'software layout' ),
			array( 'icon-software_magnete' => 'software magnete' ),
			array( 'icon-software_pages' => 'software pages' ),
			array( 'icon-software_paintbrush' => 'software paintbrush' ),
			array( 'icon-software_paintbucket' => 'software paintbucket' ),
			array( 'icon-software_paintroller' => 'software paintroller' ),
			array( 'icon-software_paragraph_align_left' => 'software paragraph_align_left' ),
			array( 'icon-software_paragraph_align_right' => 'software paragraph_align_right' ),
			array( 'icon-software_paragraph_center' => 'software paragraph_center' ),
			array( 'icon-software_paragraph_justify_all' => 'software paragraph_justify_all' ),
			array( 'icon-software_paragraph_justify_center' => 'software paragraph_justify_center' ),
			array( 'icon-software_paragraph_justify_left' => 'software paragraph_justify_left' ),
			array( 'icon-software_paragraph_justify_right' => 'software paragraph_justify_right' ),
			array( 'icon-software_paragraph_space_after' => 'software paragraph_space_after' ),
			array( 'icon-software_paragraph_space_before' => 'software paragraph_space_before' ),
			array( 'icon-software_paragraph' => 'software paragraph' ),
			array( 'icon-software_pathfinder_exclude' => 'software pathfinder_exclude' ),
			array( 'icon-software_pathfinder_intersect' => 'software pathfinder_intersect' ),
			array( 'icon-software_pathfinder_subtract' => 'software pathfinder_subtract' ),
			array( 'icon-software_pathfinder_unite' => 'software pathfinder_unite' ),
			array( 'icon-software_pen_add' => 'software pen_add' ),
			array( 'icon-software_pen_remove' => 'software pen_remove' ),
			array( 'icon-software_pen' => 'software pen' ),
			array( 'icon-software_pencil' => 'software pencil' ),
			array( 'icon-software_polygonallasso' => 'software polygonallasso' ),
			array( 'icon-software_remove_vectorpoint' => 'software remove_vectorpoint' ),
			array( 'icon-software_scale_expand' => 'software scale_expand' ),
			array( 'icon-software_scale_reduce' => 'software scale_reduce' ),
			array( 'icon-software_slice' => 'software slice' ),
			array( 'icon-software_transform_bezier' => 'software transform_bezier' ),
			array( 'icon-software_vector_box' => 'software vector_box' ),
			array( 'icon-software_vector_composite' => 'software vector_composite' ),
			array( 'icon-software_vector_line' => 'software vector_line' ),
			array( 'icon-software_vertical_align_bottom' => 'software vertical_align_bottom' ),
			array( 'icon-software_vertical_align_center' => 'software vertical_align_center' ),
			array( 'icon-software_vertical_align_top' => 'software vertical_align_top' ),
			array( 'icon-software_vertical_distribute_bottom' => 'software vertical_distribute_bottom' ),
			array( 'icon-software_vertical_distribute_center' => 'software vertical_distribute_center' ),
			array( 'icon-software_vertical_distribute_top' => 'software vertical_distribute_top' ),
			array( 'icon-software-horizontal_align_left' => 'software horizontal_align_left' ),
		),

		'Music' => array(
			array( 'icon-music_beginning_button' => 'Music beginning button' ),
			array( 'icon-music_bell' => 'Music bell' ),
			array( 'icon-music_cd' => 'Music cd' ),
			array( 'icon-music_diapason' => 'Music diapason' ),
			array( 'icon-music_eject_button' => 'Music eject button' ),
			array( 'icon-music_end_button' => 'Music end_button' ),
			array( 'icon-music_fastforward_button' => 'Music fastforward button' ),
			array( 'icon-music_headphones' => 'Music headphones' ),
			array( 'icon-music_ipod' => 'Music ipod' ),
			array( 'icon-music_loudspeaker' => 'Music loudspeaker' ),
			array( 'icon-music_microphone_old' => 'Music microphone old' ),
			array( 'icon-music_microphone' => 'Music microphone' ),
			array( 'icon-music_mixer' => 'Music mixer' ),
			array( 'icon-music_mute' => 'Music mute' ),
			array( 'icon-music_note_multiple' => 'Music note multiple' ),
			array( 'icon-music_note_single' => 'Music note single' ),
			array( 'icon-music_pause_button' => 'Music pause button' ),
			array( 'icon-music_play_button' => 'Music play button' ),
			array( 'icon-music_playlist' => 'Music playlist' ),
			array( 'icon-music_radio_ghettoblaster' => 'Music radio ghettoblaster' ),
			array( 'icon-music_radio_portable' => 'Music radio portable' ),
			array( 'icon-music_record' => 'Music record' ),
			array( 'icon-music_recordplayer' => 'Music recordplayer' ),
			array( 'icon-music_repeat_button' => 'Music repeat button' ),
			array( 'icon-music_rewind_button' => 'Music rewind button' ),
			array( 'icon-music_shuffle_button' => 'Music shuffle button' ),
			array( 'icon-music_stop_button' => 'Music stop button' ),
			array( 'icon-music_tape' => 'Music tape' ),
			array( 'icon-music_volume_down' => 'Music volume down' ),
			array( 'icon-music_volume_up' => 'Music volume up' ),
		),

		'Ecommerce' => array(
			array( 'icon-ecommerce_bag_check' => 'Ecommerce bag check' ),
			array( 'icon-ecommerce_bag_minus' => 'Ecommerce bag minus' ),
			array( 'icon-ecommerce_bag_plus' => 'Ecommerce bag plus' ),
			array( 'icon-ecommerce_bag_refresh' => 'Ecommerce bag refresh' ),
			array( 'icon-ecommerce_bag_remove' => 'Ecommerce bag remove' ),
			array( 'icon-ecommerce_bag_search' => 'Ecommerce bag search' ),
			array( 'icon-ecommerce_bag' => 'Ecommerce bag' ),
			array( 'icon-ecommerce_banknote' => 'Ecommerce banknote' ),
			array( 'icon-ecommerce_banknotes' => 'Ecommerce banknotes' ),
			array( 'icon-ecommerce_basket' => 'Ecommerce basket' ),
			array( 'icon-ecommerce_bath' => 'Ecommerce bath' ),
			array( 'icon-ecommerce_cart_check' => 'Ecommerce cart check' ),
			array( 'icon-ecommerce_cart_content' => 'Ecommerce cart content' ),
			array( 'icon-ecommerce_cart_minus' => 'Ecommerce cart minus' ),
			array( 'icon-ecommerce_cart_plus' => 'Ecommerce cart plus' ),
			array( 'icon-ecommerce_cart_refresh' => 'Ecommerce cart refresh' ),
			array( 'icon-ecommerce_cart_remove' => 'Ecommerce cart remove' ),
			array( 'icon-ecommerce_cart_search' => 'Ecommerce cart search' ),
			array( 'icon-ecommerce_cart' => 'Ecommerce cart' ),
			array( 'icon-ecommerce_creditcard' => 'Ecommerce creditcard' ),
			array( 'icon-ecommerce_diamond' => 'Ecommerce diamond' ),
			array( 'icon-ecommerce_gift' => 'Ecommerce gift' ),
			array( 'icon-ecommerce_graph_decrease' => 'Ecommerce graph decrease' ),
			array( 'icon-ecommerce_graph_increase' => 'Ecommerce graph increase' ),
			array( 'icon-ecommerce_graph1' => 'Ecommerce graph1' ),
			array( 'icon-ecommerce_graph2' => 'Ecommerce graph2' ),
			array( 'icon-ecommerce_graph3' => 'Ecommerce graph3' ),
			array( 'icon-ecommerce_megaphone' => 'Ecommerce megaphone' ),
			array( 'icon-ecommerce_money' => 'Ecommerce money' ),
			array( 'icon-ecommerce_safe' => 'Ecommerce safe' ),
			array( 'icon-ecommerce_sale' => 'Ecommerce sale' ),
			array( 'icon-ecommerce_sales' => 'Ecommerce sales' ),
			array( 'icon-ecommerce_ticket' => 'Ecommerce ticket' ),
			array( 'icon-ecommerce_wallet' => 'Ecommerce wallet' ),
		),

		'Basic Elaboration' => array(
			array( 'icon-basic_elaboration_bookmark_checck' => 'Basic Eaboration bookmark checck' ),
			array( 'icon-basic_elaboration_bookmark_minus' => 'Basic Eaboration bookmark minus' ),
			array( 'icon-basic_elaboration_bookmark_plus' => 'Basic Eaboration bookmark plus' ),
			array( 'icon-basic_elaboration_bookmark_remove' => 'Basic Eaboration bookmark remove' ),
			array( 'icon-basic_elaboration_mail_check' => 'Basic Eaboration mail check' ),
			array( 'icon-basic_elaboration_mail_cloud' => 'Basic Eaboration mail cloud' ),
			array( 'icon-basic_elaboration_mail_document' => 'Basic Eaboration mail document' ),
			array( 'icon-basic_elaboration_mail_download' => 'Basic Eaboration mail download' ),
			array( 'icon-basic_elaboration_mail_flagged' => 'Basic Eaboration mail flagged' ),
			array( 'icon-basic_elaboration_mail_heart' => 'Basic Eaboration mail heart' ),
			array( 'icon-basic_elaboration_mail_next' => 'Basic Eaboration mail next' ),
			array( 'icon-basic_elaboration_mail_noaccess' => 'Basic Eaboration mail noaccess' ),
			array( 'icon-basic_elaboration_mail_note' => 'Basic Eaboration mail note' ),
			array( 'icon-basic_elaboration_mail_pencil' => 'Basic Eaboration mail pencil' ),
			array( 'icon-basic_elaboration_mail_picture' => 'Basic Eaboration mail picture' ),
			array( 'icon-basic_elaboration_mail_previous' => 'Basic Eaboration mail previous' ),
			array( 'icon-basic_elaboration_mail_refresh' => 'Basic Eaboration mail refresh' ),
			array( 'icon-basic_elaboration_mail_remove' => 'Basic Eaboration mail remove' ),
			array( 'icon-basic_elaboration_mail_search' => 'Basic Eaboration mail search' ),
			array( 'icon-basic_elaboration_mail_star' => 'Basic Eaboration mail star' ),
			array( 'icon-basic_elaboration_mail_upload' => 'Basic Eaboration mail upload' ),
			array( 'icon-basic_elaboration_message_check' => 'Basic Eaboration message check' ),
			array( 'icon-basic_elaboration_message_dots' => 'Basic Eaboration message dots' ),
			array( 'icon-basic_elaboration_message_happy' => 'Basic Eaboration message happy' ),
			array( 'icon-basic_elaboration_message_heart' => 'Basic Eaboration message heart' ),
			array( 'icon-basic_elaboration_message_minus' => 'Basic Eaboration message minus' ),
			array( 'icon-basic_elaboration_message_note' => 'Basic Eaboration message note' ),
			array( 'icon-basic_elaboration_message_plus' => 'Basic Eaboration message plus' ),
			array( 'icon-basic_elaboration_message_refresh' => 'Basic Eaboration message refresh' ),
			array( 'icon-basic_elaboration_message_remove' => 'Basic Eaboration message remove' ),
			array( 'icon-basic_elaboration_message_sad' => 'Basic Eaboration message sad' ),
			array( 'icon-basic_elaboration_todolist_2' => 'Basic Eaboration todolist 2' ),
		),

		'Basic' => array(
			array( 'icon-basic_accelerator' => 'Basic accelerator' ),
			array( 'icon-basic_alarm' => 'Basic alarm' ),
			array( 'icon-basic_anchor' => 'Basic anchor' ),
			array( 'icon-basic_anticlockwise' => 'Basic anticlockwise' ),
			array( 'icon-basic_archive_full' => 'Basic archive full' ),
			array( 'icon-basic_archive' => 'Basic archive' ),
			array( 'icon-basic_ban' => 'Basic ban' ),
			array( 'icon-basic_bolt' => 'Basic bolt' ),
			array( 'icon-basic_book_pen' => 'Basic book pen' ),
			array( 'icon-basic_book_pencil' => 'Basic book pencil' ),
			array( 'icon-basic_book' => 'Basic book' ),
			array( 'icon-basic_bookmark' => 'Basic bookmark' ),
			array( 'icon-basic_calculator' => 'Basic calculator' ),
			array( 'icon-basic_calendar' => 'Basic calendar' ),
			array( 'icon-basic_cards_diamonds' => 'Basic cards diamonds' ),
			array( 'icon-basic_cards_hearts' => 'Basic cards hearts' ),
			array( 'icon-basic_case' => 'Basic case' ),
			array( 'icon-basic_chronometer' => 'Basic chronometer' ),
			array( 'icon-basic_clessidre' => 'Basic clessidre' ),
			array( 'icon-basic_clock' => 'Basic clock' ),
			array( 'icon-basic_clockwise' => 'Basic clockwise' ),
			array( 'icon-basic_cloud' => 'Basic cloud' ),
			array( 'icon-basic_clubs' => 'Basic clubs' ),
			array( 'icon-basic_compass' => 'Basic compass' ),
			array( 'icon-basic_cup' => 'Basic cup' ),
			array( 'icon-basic_diamonds' => 'Basic diamonds' ),
			array( 'icon-basic_display' => 'Basic display' ),
			array( 'icon-basic_download' => 'Basic download' ),
			array( 'icon-basic_exclamation' => 'Basic exclamation' ),
			array( 'icon-basic_eye_closed' => 'Basic eye closed' ),
			array( 'icon-basic_eye' => 'Basic eye' ),
			array( 'icon-basic_female' => 'Basic female' ),
			array( 'icon-basic_flag1' => 'Basic flag1' ),
			array( 'icon-basic_flag2' => 'Basic flag2' ),
			array( 'icon-basic_floppydisk' => 'Basic floppydisk' ),
			array( 'icon-basic_folder_multiple' => 'Basic folder multiple' ),
			array( 'icon-basic_folder' => 'Basic folder' ),
			array( 'icon-basic_gear' => 'Basic gear' ),
			array( 'icon-basic_geolocalize-01' => 'Basic geolocalize 01' ),
			array( 'icon-basic_geolocalize-05' => 'Basic geolocalize 05' ),
			array( 'icon-basic_globe' => 'Basic globe' ),
			array( 'icon-basic_gunsight' => 'Basic gunsight' ),
			array( 'icon-basic_hammer' => 'Basic hammer' ),
			array( 'icon-basic_headset' => 'Basic headset' ),
			array( 'icon-basic_heart_broken' => 'Basic heart broken' ),
			array( 'icon-basic_heart' => 'Basic heart' ),
			array( 'icon-basic_helm' => 'Basic helm' ),
			array( 'icon-basic_home' => 'Basic home' ),
			array( 'icon-basic_info' => 'Basic info' ),
			array( 'icon-basic_ipod' => 'Basic ipod' ),
			array( 'icon-basic_joypad' => 'Basic joypad' ),
			array( 'icon-basic_key' => 'Basic key' ),
			array( 'icon-basic_keyboard' => 'Basic keyboard' ),
			array( 'icon-basic_laptop' => 'Basic laptop' ),
			array( 'icon-basic_life_buoy' => 'Basic life buoy' ),
			array( 'icon-basic_lightbulb' => 'Basic lightbulb' ),
			array( 'icon-basic_link' => 'Basic link' ),
			array( 'icon-basic_lock_open' => 'Basic lock open' ),
			array( 'icon-basic_lock' => 'Basic lock' ),
			array( 'icon-basic_magic_mouse' => 'Basic magic mouse' ),
			array( 'icon-basic_magnifier_minus' => 'Basic magnifier minus' ),
			array( 'icon-basic_magnifier_plus' => 'Basic magnifier plus' ),
			array( 'icon-basic_magnifier' => 'Basic magnifier' ),
			array( 'icon-basic_mail_multiple' => 'Basic mail multiple' ),
			array( 'icon-basic_mail_open_text' => 'Basic mail open_text' ),
			array( 'icon-basic_mail_open' => 'Basic mail open' ),
			array( 'icon-basic_mail' => 'Basic mail' ),
			array( 'icon-basic_male' => 'Basic male' ),
			array( 'icon-basic_map' => 'Basic map' ),
			array( 'icon-basic_message_multiple' => 'Basic message multiple' ),
			array( 'icon-basic_message_txt' => 'Basic message txt' ),
			array( 'icon-basic_message' => 'Basic message' ),
			array( 'icon-basic_mixer2' => 'Basic mixer2' ),
			array( 'icon-basic_mouse' => 'Basic mouse' ),
			array( 'icon-basic_notebook_pen' => 'Basic notebook pen' ),
			array( 'icon-basic_notebook_pencil' => 'Basic notebook pencil' ),
			array( 'icon-basic_notebook' => 'Basic notebook' ),
			array( 'icon-basic_paperplane' => 'Basic paperplane' ),
			array( 'icon-basic_pencil_ruler_pen' => 'Basic pencil ruler pen' ),
			array( 'icon-basic_pencil_ruler' => 'Basic pencil ruler' ),
			array( 'icon-basic_photo' => 'Basic photo' ),
			array( 'icon-basic_picture_multiple' => 'Basic picture multiple' ),
			array( 'icon-basic_picture' => 'Basic picture' ),
			array( 'icon-basic_pin1' => 'Basic pin1' ),
			array( 'icon-basic_pin2' => 'Basic pin2' ),
			array( 'icon-basic_postcard_multiple' => 'Basic postcard multiple' ),
			array( 'icon-basic_postcard' => 'Basic postcard' ),
			array( 'icon-basic_printer' => 'Basic printer' ),
			array( 'icon-basic_question' => 'Basic question' ),
			array( 'icon-basic_rss' => 'Basic rss' ),
			array( 'icon-basic_server_cloud' => 'Basic server cloud' ),
			array( 'icon-basic_server_download' => 'Basic server download' ),
			array( 'icon-basic_server_upload' => 'Basic server upload' ),
			array( 'icon-basic_server' => 'Basic server' ),
			array( 'icon-basic_server2' => 'Basic server2' ),
			array( 'icon-basic_settings' => 'Basic settings' ),
			array( 'icon-basic_share' => 'Basic share' ),
			array( 'icon-basic_sheet_multiple' => 'Basic sheet multiple' ),
			array( 'icon-basic_sheet_pen' => 'Basic sheet pen' ),
			array( 'icon-basic_sheet_pencil' => 'Basic sheet pencil' ),
			array( 'icon-basic_sheet_txt' => 'Basic sheet txt' ),
			array( 'icon-basic_sheet' => 'Basic sheet' ),
			array( 'icon-basic_signs' => 'Basic signs' ),
			array( 'icon-basic_smartphone' => 'Basic smartphone' ),
			array( 'icon-basic_spades' => 'Basic spades' ),
			array( 'icon-basic_spread_bookmark' => 'Basic spread bookmark' ),
			array( 'icon-basic_spread_text_bookmark' => 'Basic spread text bookmark' ),
			array( 'icon-basic_spread_text' => 'Basic spread text' ),
			array( 'icon-basic_spread' => 'Basic spread' ),
			array( 'icon-basic_star' => 'Basic star' ),
			array( 'icon-basic_tablet' => 'Basic tablet' ),
			array( 'icon-basic_target' => 'Basic target' ),
			array( 'icon-basic_todo_pen' => 'Basic todo pen' ),
			array( 'icon-basic_todo_pencil' => 'Basic todo pencil' ),
			array( 'icon-basic_todo_txt' => 'Basic todo txt' ),
			array( 'icon-basic_todo' => 'Basic todo' ),
			array( 'icon-basic_todolist_pen' => 'Basic todolist pen' ),
			array( 'icon-basic_todolist_pencil' => 'Basic todolist pencil' ),
			array( 'icon-basic_upload' => 'Basic upload' ),
			array( 'icon-basic_usb' => 'Basic usb' ),
			array( 'icon-basic_video' => 'Basic video' ),
			array( 'icon-basic_watch' => 'Basic watch' ),
			array( 'icon-basic_webpage_img_txt' => 'Basic webpage img txt' ),
			array( 'icon-basic_webpage_multiple' => 'Basic webpage multiple' ),
			array( 'icon-basic_webpage_txt' => 'Basic webpage txt' ),
			array( 'icon-basic_webpage' => 'Basic webpage' ),
			array( 'icon-basic_world' => 'Basic world' ),
		),

		'Arrows' => array(
			array( 'icon-arrows_anticlockwise_dashed' => 'Arrows anticlockwise dashed' ),
			array( 'icon-arrows_anticlockwise' => 'Arrows anticlockwise' ),
			array( 'icon-arrows_check' => 'Arrows check' ),
			array( 'icon-arrows_circle_check' => 'Arrows circle check' ),
			array( 'icon-arrows_circle_left' => 'Arrows circle left' ),
			array( 'icon-arrows_circle_minus' => 'Arrows circle minus' ),
			array( 'icon-arrows_circle_plus' => 'Arrows circle plus' ),
			array( 'icon-arrows_circle_remove' => 'Arrows circle remove' ),
			array( 'icon-arrows_circle_right' => 'Arrows circle right' ),
			array( 'icon-arrows_circle_up' => 'Arrows circle up' ),
			array( 'icon-arrows_clockwise_dashed' => 'Arrows clockwise dashed' ),
			array( 'icon-arrows_clockwise' => 'Arrows clockwise' ),
			array( 'icon-arrows_deny' => 'Arrows deny' ),
			array( 'icon-arrows_down_double-34' => 'Arrows down double 34' ),
			array( 'icon-arrows_down' => 'Arrows down' ),
			array( 'icon-arrows_downleft' => 'Arrows downleft' ),
			array( 'icon-arrows_downright' => 'Arrows downright' ),
			array( 'icon-arrows_exclamation' => 'Arrows exclamation' ),
			array( 'icon-arrows_info' => 'Arrows info' ),
			array( 'icon-arrows_left_double-32' => 'Arrows left double 32' ),
			array( 'icon-arrows_left' => 'Arrows left' ),
			array( 'icon-arrows_minus' => 'Arrows minus' ),
			array( 'icon-arrows_plus' => 'Arrows plus' ),
			array( 'icon-arrows_question' => 'Arrows question' ),
			array( 'icon-arrows_remove' => 'Arrows remove' ),
			array( 'icon-arrows_right_double-31' => 'Arrows right double 31' ),
			array( 'icon-arrows_right' => 'Arrows right' ),
			array( 'icon-arrows_rotate_anti_dashed' => 'Arrows rotate anti dashed' ),
			array( 'icon-arrows_rotate_anti' => 'Arrows rotate anti' ),
			array( 'icon-arrows_rotate_dashed' => 'Arrows rotate dashed' ),
			array( 'icon-arrows_rotate' => 'Arrows rotate' ),
			array( 'icon-arrows_slim_down_dashed' => 'Arrows slim down dashed' ),
			array( 'icon-arrows_slim_down' => 'Arrows slim down' ),
			array( 'icon-arrows_slim_left_dashed' => 'Arrows slim left dashed' ),
			array( 'icon-arrows_slim_left' => 'Arrows slim left' ),
			array( 'icon-arrows_slim_right_dashed' => 'Arrows slim right dashed' ),
			array( 'icon-arrows_slim_right' => 'Arrows slim right' ),
			array( 'icon-arrows_slim_up_dashed' => 'Arrows slim up dashed' ),
			array( 'icon-arrows_slim_up' => 'Arrows slim up' ),
			array( 'icon-arrows_squares' => 'Arrows squares' ),
			array( 'icon-arrows_up_double-33' => 'Arrows up double 33' ),
			array( 'icon-arrows_up' => 'Arrows up' ),
			array( 'icon-arrows_vertical' => 'Arrows vertical' ),
		),

		'Numbers' => array(
			array( 'icon-num-1' => 'Number 1' ),
			array( 'icon-num-2' => 'Number 2' ),
			array( 'icon-num-3' => 'Number 3' ),
			array( 'icon-num-4' => 'Number 4' ),
			array( 'icon-num-5' => 'Number 5' ),
			array( 'icon-num-6' => 'Number 6' ),
			array( 'icon-num-7' => 'Number 7' ),
			array( 'icon-num-8' => 'Number 8' ),
			array( 'icon-num-9' => 'Number 9' ),
			array( 'icon-num-10' => 'Number 10' ),
		),

		'Ionicons iOS' => array(
			array( 'icon-arrow-up-material' => 'Arrow Up' ),
			array( 'icon-arrow-left-material' => 'Arrow Left' ),
			array( 'icon-arrow-down-material' => 'Arrow Down' ),
			array( 'icon-arrow-right-material' => 'Arrow Right' ),
			array( 'icon-ion-ios-add-circle-outline' => 'add-circle-outline' ),
			array( 'icon-ion-ios-add-circle-outline' => 'add-circle-outline' ),
			array( 'icon-ion-ios-add-circle' => 'add-circle' ),
			array( 'icon-ion-ios-add' => 'add' ),
			array( 'icon-ion-ios-airplane' => 'airplane' ),
			array( 'icon-ion-ios-alarm' => 'alarm' ),
			array( 'icon-ion-ios-albums' => 'albums' ),
			array( 'icon-ion-ios-alert' => 'alert' ),
			array( 'icon-ion-ios-american-football' => 'american-football' ),
			array( 'icon-ion-ios-analytics' => 'analytics' ),
			array( 'icon-ion-ios-aperture' => 'aperture' ),
			array( 'icon-ion-ios-apps' => 'apps' ),
			array( 'icon-ion-ios-appstore' => 'appstore' ),
			array( 'icon-ion-ios-archive' => 'archive' ),
			array( 'icon-ion-ios-arrow-back' => 'arrow-back' ),
			array( 'icon-ion-ios-arrow-down' => 'arrow-down' ),
			array( 'icon-ion-ios-arrow-dropdown-circle' => 'arrow-dropdown-circle' ),
			array( 'icon-ion-ios-arrow-dropdown' => 'arrow-dropdown' ),
			array( 'icon-ion-ios-arrow-dropleft-circle' => 'arrow-dropleft-circle' ),
			array( 'icon-ion-ios-arrow-dropleft' => 'arrow-dropleft' ),
			array( 'icon-ion-ios-arrow-dropright-circle' => 'arrow-dropright-circle' ),
			array( 'icon-ion-ios-arrow-dropright' => 'arrow-dropright' ),
			array( 'icon-ion-ios-arrow-dropup-circle' => 'arrow-dropup-circle' ),
			array( 'icon-ion-ios-arrow-dropup' => 'arrow-dropup' ),
			array( 'icon-ion-ios-arrow-forward' => 'arrow-forward' ),
			array( 'icon-ion-ios-arrow-round-back' => 'arrow-round-back' ),
			array( 'icon-ion-ios-arrow-round-down' => 'arrow-round-down' ),
			array( 'icon-ion-ios-arrow-round-forward' => 'arrow-round-forward' ),
			array( 'icon-ion-ios-arrow-round-up' => 'arrow-round-up' ),
			array( 'icon-ion-ios-arrow-up' => 'arrow-up' ),
			array( 'icon-ion-ios-at' => 'at' ),
			array( 'icon-ion-ios-attach' => 'attach' ),
			array( 'icon-ion-ios-backspace' => 'backspace' ),
			array( 'icon-ion-ios-barcode' => 'barcode' ),
			array( 'icon-ion-ios-baseball' => 'baseball' ),
			array( 'icon-ion-ios-basket' => 'basket' ),
			array( 'icon-ion-ios-basketball' => 'basketball' ),
			array( 'icon-ion-ios-battery-charging' => 'battery-charging' ),
			array( 'icon-ion-ios-battery-dead' => 'battery-dead' ),
			array( 'icon-ion-ios-battery-full' => 'battery-full' ),
			array( 'icon-ion-ios-beaker' => 'beaker' ),
			array( 'icon-ion-ios-bed' => 'bed' ),
			array( 'icon-ion-ios-beer' => 'beer' ),
			array( 'icon-ion-ios-bicycle' => 'bicycle' ),
			array( 'icon-ion-ios-bluetooth' => 'bluetooth' ),
			array( 'icon-ion-ios-boat' => 'boat' ),
			array( 'icon-ion-ios-body' => 'body' ),
			array( 'icon-ion-ios-bonfire' => 'bonfire' ),
			array( 'icon-ion-ios-book' => 'book' ),
			array( 'icon-ion-ios-bookmark' => 'bookmark' ),
			array( 'icon-ion-ios-bookmarks' => 'bookmarks' ),
			array( 'icon-ion-ios-bowtie' => 'bowtie' ),
			array( 'icon-ion-ios-briefcase' => 'briefcase' ),
			array( 'icon-ion-ios-browsers' => 'browsers' ),
			array( 'icon-ion-ios-brush' => 'brush' ),
			array( 'icon-ion-ios-bug' => 'bug' ),
			array( 'icon-ion-ios-build' => 'build' ),
			array( 'icon-ion-ios-bulb' => 'bulb' ),
			array( 'icon-ion-ios-bus' => 'bus' ),
			array( 'icon-ion-ios-business' => 'business' ),
			array( 'icon-ion-ios-cafe' => 'cafe' ),
			array( 'icon-ion-ios-calculator' => 'calculator' ),
			array( 'icon-ion-ios-calendar' => 'calendar' ),
			array( 'icon-ion-ios-call' => 'call' ),
			array( 'icon-ion-ios-camera' => 'camera' ),
			array( 'icon-ion-ios-car' => 'car' ),
			array( 'icon-ion-ios-card' => 'card' ),
			array( 'icon-ion-ios-cart' => 'cart' ),
			array( 'icon-ion-ios-cash' => 'cash' ),
			array( 'icon-ion-ios-cellular' => 'cellular' ),
			array( 'icon-ion-ios-chatboxes' => 'chatboxes' ),
			array( 'icon-ion-ios-chatbubbles' => 'chatbubbles' ),
			array( 'icon-ion-ios-checkbox-outline' => 'checkbox-outline' ),
			array( 'icon-ion-ios-checkbox' => 'checkbox' ),
			array( 'icon-ion-ios-checkmark-circle-outline' => 'checkmark-circle-outline' ),
			array( 'icon-ion-ios-checkmark-circle' => 'checkmark-circle' ),
			array( 'icon-ion-ios-checkmark' => 'checkmark' ),
			array( 'icon-ion-ios-clipboard' => 'clipboard' ),
			array( 'icon-ion-ios-clock' => 'clock' ),
			array( 'icon-ion-ios-close-circle-outline' => 'close-circle-outline' ),
			array( 'icon-ion-ios-close-circle' => 'close-circle' ),
			array( 'icon-ion-ios-close' => 'close' ),
			array( 'icon-ion-ios-cloud-circle' => 'cloud-circle' ),
			array( 'icon-ion-ios-cloud-done' => 'cloud-done' ),
			array( 'icon-ion-ios-cloud-download' => 'cloud-download' ),
			array( 'icon-ion-ios-cloud-outline' => 'cloud-outline' ),
			array( 'icon-ion-ios-cloud-upload' => 'cloud-upload' ),
			array( 'icon-ion-ios-cloud' => 'cloud' ),
			array( 'icon-ion-ios-cloudy-night' => 'cloudy-night' ),
			array( 'icon-ion-ios-cloudy' => 'cloudy' ),
			array( 'icon-ion-ios-code-download' => 'code-download' ),
			array( 'icon-ion-ios-code-working' => 'code-working' ),
			array( 'icon-ion-ios-code' => 'code' ),
			array( 'icon-ion-ios-cog' => 'cog' ),
			array( 'icon-ion-ios-color-fill' => 'color-fill' ),
			array( 'icon-ion-ios-color-filter' => 'color-filter' ),
			array( 'icon-ion-ios-color-palette' => 'color-palette' ),
			array( 'icon-ion-ios-color-wand' => 'color-wand' ),
			array( 'icon-ion-ios-compass' => 'compass' ),
			array( 'icon-ion-ios-construct' => 'construct' ),
			array( 'icon-ion-ios-contact' => 'contact' ),
			array( 'icon-ion-ios-contacts' => 'contacts' ),
			array( 'icon-ion-ios-contract' => 'contract' ),
			array( 'icon-ion-ios-contrast' => 'contrast' ),
			array( 'icon-ion-ios-copy' => 'copy' ),
			array( 'icon-ion-ios-create' => 'create' ),
			array( 'icon-ion-ios-crop' => 'crop' ),
			array( 'icon-ion-ios-cube' => 'cube' ),
			array( 'icon-ion-ios-cut' => 'cut' ),
			array( 'icon-ion-ios-desktop' => 'desktop' ),
			array( 'icon-ion-ios-disc' => 'disc' ),
			array( 'icon-ion-ios-document' => 'document' ),
			array( 'icon-ion-ios-done-all' => 'done-all' ),
			array( 'icon-ion-ios-download' => 'download' ),
			array( 'icon-ion-ios-easel' => 'easel' ),
			array( 'icon-ion-ios-egg' => 'egg' ),
			array( 'icon-ion-ios-exit' => 'exit' ),
			array( 'icon-ion-ios-expand' => 'expand' ),
			array( 'icon-ion-ios-eye-off' => 'eye-off' ),
			array( 'icon-ion-ios-eye' => 'eye' ),
			array( 'icon-ion-ios-fastforward' => 'fastforward' ),
			array( 'icon-ion-ios-female' => 'female' ),
			array( 'icon-ion-ios-filing' => 'filing' ),
			array( 'icon-ion-ios-film' => 'film' ),
			array( 'icon-ion-ios-finger-print' => 'finger-print' ),
			array( 'icon-ion-ios-fitness' => 'fitness' ),
			array( 'icon-ion-ios-flag' => 'flag' ),
			array( 'icon-ion-ios-flame' => 'flame' ),
			array( 'icon-ion-ios-flash-off' => 'flash-off' ),
			array( 'icon-ion-ios-flash' => 'flash' ),
			array( 'icon-ion-ios-flashlight' => 'flashlight' ),
			array( 'icon-ion-ios-flask' => 'flask' ),
			array( 'icon-ion-ios-flower' => 'flower' ),
			array( 'icon-ion-ios-folder-open' => 'folder-open' ),
			array( 'icon-ion-ios-folder' => 'folder' ),
			array( 'icon-ion-ios-football' => 'football' ),
			array( 'icon-ion-ios-funnel' => 'funnel' ),
			array( 'icon-ion-ios-gift' => 'gift' ),
			array( 'icon-ion-ios-git-branch' => 'git-branch' ),
			array( 'icon-ion-ios-git-commit' => 'git-commit' ),
			array( 'icon-ion-ios-git-compare' => 'git-compare' ),
			array( 'icon-ion-ios-git-merge' => 'git-merge' ),
			array( 'icon-ion-ios-git-network' => 'git-network' ),
			array( 'icon-ion-ios-git-pull-request' => 'git-pull-request' ),
			array( 'icon-ion-ios-glasses' => 'glasses' ),
			array( 'icon-ion-ios-globe' => 'globe' ),
			array( 'icon-ion-ios-grid' => 'grid' ),
			array( 'icon-ion-ios-hammer' => 'hammer' ),
			array( 'icon-ion-ios-hand' => 'hand' ),
			array( 'icon-ion-ios-happy' => 'happy' ),
			array( 'icon-ion-ios-headset' => 'headset' ),
			array( 'icon-ion-ios-heart-dislike' => 'heart-dislike' ),
			array( 'icon-ion-ios-heart-empty' => 'heart-empty' ),
			array( 'icon-ion-ios-heart-half' => 'heart-half' ),
			array( 'icon-ion-ios-heart' => 'heart' ),
			array( 'icon-ion-ios-help-buoy' => 'help-buoy' ),
			array( 'icon-ion-ios-help-circle-outline' => 'help-circle-outline' ),
			array( 'icon-ion-ios-help-circle' => 'help-circle' ),
			array( 'icon-ion-ios-help' => 'help' ),
			array( 'icon-ion-ios-home' => 'home' ),
			array( 'icon-ion-ios-hourglass' => 'hourglass' ),
			array( 'icon-ion-ios-ice-cream' => 'ice-cream' ),
			array( 'icon-ion-ios-image' => 'image' ),
			array( 'icon-ion-ios-images' => 'images' ),
			array( 'icon-ion-ios-infinite' => 'infinite' ),
			array( 'icon-ion-ios-information-circle-outline' => 'information-circle-outline' ),
			array( 'icon-ion-ios-information-circle' => 'information-circle' ),
			array( 'icon-ion-ios-information' => 'information' ),
			array( 'icon-ion-ios-jet' => 'jet' ),
			array( 'icon-ion-ios-journal' => 'journal' ),
			array( 'icon-ion-ios-key' => 'key' ),
			array( 'icon-ion-ios-keypad' => 'keypad' ),
			array( 'icon-ion-ios-laptop' => 'laptop' ),
			array( 'icon-ion-ios-leaf' => 'leaf' ),
			array( 'icon-ion-ios-link' => 'link' ),
			array( 'icon-ion-ios-list-box' => 'list-box' ),
			array( 'icon-ion-ios-list' => 'list' ),
			array( 'icon-ion-ios-locate' => 'locate' ),
			array( 'icon-ion-ios-lock' => 'lock' ),
			array( 'icon-ion-ios-log-in' => 'log-in' ),
			array( 'icon-ion-ios-log-out' => 'log-out' ),
			array( 'icon-ion-ios-magnet' => 'magnet' ),
			array( 'icon-ion-ios-mail-open' => 'mail-open' ),
			array( 'icon-ion-ios-mail-unread' => 'mail-unread' ),
			array( 'icon-ion-ios-mail' => 'mail' ),
			array( 'icon-ion-ios-male' => 'male' ),
			array( 'icon-ion-ios-man' => 'man' ),
			array( 'icon-ion-ios-map' => 'map' ),
			array( 'icon-ion-ios-medal' => 'medal' ),
			array( 'icon-ion-ios-medical' => 'medical' ),
			array( 'icon-ion-ios-medkit' => 'medkit' ),
			array( 'icon-ion-ios-megaphone' => 'megaphone' ),
			array( 'icon-ion-ios-menu' => 'menu' ),
			array( 'icon-ion-ios-mic-off' => 'mic-off' ),
			array( 'icon-ion-ios-mic' => 'mic' ),
			array( 'icon-ion-ios-microphone' => 'microphone' ),
			array( 'icon-ion-ios-moon' => 'moon' ),
			array( 'icon-ion-ios-more' => 'more' ),
			array( 'icon-ion-ios-move' => 'move' ),
			array( 'icon-ion-ios-musical-note' => 'musical-note' ),
			array( 'icon-ion-ios-musical-notes' => 'musical-notes' ),
			array( 'icon-ion-ios-navigate' => 'navigate' ),
			array( 'icon-ion-ios-notifications-off' => 'notifications-off' ),
			array( 'icon-ion-ios-notifications-outline' => 'notifications-outline' ),
			array( 'icon-ion-ios-notifications' => 'notifications' ),
			array( 'icon-ion-ios-nuclear' => 'nuclear' ),
			array( 'icon-ion-ios-nutrition' => 'nutrition' ),
			array( 'icon-ion-ios-open' => 'open' ),
			array( 'icon-ion-ios-options' => 'options' ),
			array( 'icon-ion-ios-outlet' => 'outlet' ),
			array( 'icon-ion-ios-paper-plane' => 'paper-plane' ),
			array( 'icon-ion-ios-paper' => 'paper' ),
			array( 'icon-ion-ios-partly-sunny' => 'partly-sunny' ),
			array( 'icon-ion-ios-pause' => 'pause' ),
			array( 'icon-ion-ios-paw' => 'paw' ),
			array( 'icon-ion-ios-people' => 'people' ),
			array( 'icon-ion-ios-person-add' => 'person-add' ),
			array( 'icon-ion-ios-person' => 'person' ),
			array( 'icon-ion-ios-phone-landscape' => 'phone-landscape' ),
			array( 'icon-ion-ios-phone-portrait' => 'phone-portrait' ),
			array( 'icon-ion-ios-photos' => 'photos' ),
			array( 'icon-ion-ios-pie' => 'pie' ),
			array( 'icon-ion-ios-pin' => 'pin' ),
			array( 'icon-ion-ios-pint' => 'pint' ),
			array( 'icon-ion-ios-pizza' => 'pizza' ),
			array( 'icon-ion-ios-planet' => 'planet' ),
			array( 'icon-ion-ios-play-circle' => 'play-circle' ),
			array( 'icon-ion-ios-play' => 'play' ),
			array( 'icon-ion-ios-podium' => 'podium' ),
			array( 'icon-ion-ios-power' => 'power' ),
			array( 'icon-ion-ios-pricetag' => 'pricetag' ),
			array( 'icon-ion-ios-pricetags' => 'pricetags' ),
			array( 'icon-ion-ios-print' => 'print' ),
			array( 'icon-ion-ios-pulse' => 'pulse' ),
			array( 'icon-ion-ios-qr-scanner' => 'qr-scanner' ),
			array( 'icon-ion-ios-quote' => 'quote' ),
			array( 'icon-ion-ios-radio-button-off' => 'radio-button-off' ),
			array( 'icon-ion-ios-radio-button-on' => 'radio-button-on' ),
			array( 'icon-ion-ios-radio' => 'radio' ),
			array( 'icon-ion-ios-rainy' => 'rainy' ),
			array( 'icon-ion-ios-recording' => 'recording' ),
			array( 'icon-ion-ios-redo' => 'redo' ),
			array( 'icon-ion-ios-refresh-circle' => 'refresh-circle' ),
			array( 'icon-ion-ios-refresh' => 'refresh' ),
			array( 'icon-ion-ios-remove-circle-outline' => 'remove-circle-outline' ),
			array( 'icon-ion-ios-remove-circle' => 'remove-circle' ),
			array( 'icon-ion-ios-remove' => 'remove' ),
			array( 'icon-ion-ios-reorder' => 'reorder' ),
			array( 'icon-ion-ios-repeat' => 'repeat' ),
			array( 'icon-ion-ios-resize' => 'resize' ),
			array( 'icon-ion-ios-restaurant' => 'restaurant' ),
			array( 'icon-ion-ios-return-left' => 'return-left' ),
			array( 'icon-ion-ios-return-right' => 'return-right' ),
			array( 'icon-ion-ios-reverse-camera' => 'reverse-camera' ),
			array( 'icon-ion-ios-rewind' => 'rewind' ),
			array( 'icon-ion-ios-ribbon' => 'ribbon' ),
			array( 'icon-ion-ios-rocket' => 'rocket' ),
			array( 'icon-ion-ios-rose' => 'rose' ),
			array( 'icon-ion-ios-sad' => 'sad' ),
			array( 'icon-ion-ios-save' => 'save' ),
			array( 'icon-ion-ios-school' => 'school' ),
			array( 'icon-ion-ios-search' => 'search' ),
			array( 'icon-ion-ios-send' => 'send' ),
			array( 'icon-ion-ios-settings' => 'settings' ),
			array( 'icon-ion-ios-share-alt' => 'share-alt' ),
			array( 'icon-ion-ios-share' => 'share' ),
			array( 'icon-ion-ios-shirt' => 'shirt' ),
			array( 'icon-ion-ios-shuffle' => 'shuffle' ),
			array( 'icon-ion-ios-skip-backward' => 'skip-backward' ),
			array( 'icon-ion-ios-skip-forward' => 'skip-forward' ),
			array( 'icon-ion-ios-snow' => 'snow' ),
			array( 'icon-ion-ios-speedometer' => 'speedometer' ),
			array( 'icon-ion-ios-square-outline' => 'square-outline' ),
			array( 'icon-ion-ios-square' => 'square' ),
			array( 'icon-ion-ios-star-half' => 'star-half' ),
			array( 'icon-ion-ios-star-outline' => 'star-outline' ),
			array( 'icon-ion-ios-star' => 'star' ),
			array( 'icon-ion-ios-stats' => 'stats' ),
			array( 'icon-ion-ios-stopwatch' => 'stopwatch' ),
			array( 'icon-ion-ios-subway' => 'subway' ),
			array( 'icon-ion-ios-sunny' => 'sunny' ),
			array( 'icon-ion-ios-swap' => 'swap' ),
			array( 'icon-ion-ios-switch' => 'switch' ),
			array( 'icon-ion-ios-sync' => 'sync' ),
			array( 'icon-ion-ios-tablet-landscape' => 'tablet-landscape' ),
			array( 'icon-ion-ios-tablet-portrait' => 'tablet-portrait' ),
			array( 'icon-ion-ios-tennisball' => 'tennisball' ),
			array( 'icon-ion-ios-text' => 'text' ),
			array( 'icon-ion-ios-thermometer' => 'thermometer' ),
			array( 'icon-ion-ios-thumbs-down' => 'thumbs-down' ),
			array( 'icon-ion-ios-thumbs-up' => 'thumbs-up' ),
			array( 'icon-ion-ios-thunderstorm' => 'thunderstorm' ),
			array( 'icon-ion-ios-time' => 'time' ),
			array( 'icon-ion-ios-timer' => 'timer' ),
			array( 'icon-ion-ios-today' => 'today' ),
			array( 'icon-ion-ios-train' => 'train' ),
			array( 'icon-ion-ios-transgender' => 'transgender' ),
			array( 'icon-ion-ios-trash' => 'trash' ),
			array( 'icon-ion-ios-trending-down' => 'trending-down' ),
			array( 'icon-ion-ios-trending-up' => 'trending-up' ),
			array( 'icon-ion-ios-trophy' => 'trophy' ),
			array( 'icon-ion-ios-tv' => 'tv' ),
			array( 'icon-ion-ios-umbrella' => 'umbrella' ),
			array( 'icon-ion-ios-undo' => 'undo' ),
			array( 'icon-ion-ios-unlock' => 'unlock' ),
			array( 'icon-ion-ios-videocam' => 'videocam' ),
			array( 'icon-ion-ios-volume-high' => 'volume-high' ),
			array( 'icon-ion-ios-volume-low' => 'volume-low' ),
			array( 'icon-ion-ios-volume-mute' => 'volume-mute' ),
			array( 'icon-ion-ios-volume-off' => 'volume-off' ),
			array( 'icon-ion-ios-walk' => 'walk' ),
			array( 'icon-ion-ios-wallet' => 'wallet' ),
			array( 'icon-ion-ios-warning' => 'warning' ),
			array( 'icon-ion-ios-watch' => 'watch' ),
			array( 'icon-ion-ios-water' => 'water' ),
			array( 'icon-ion-ios-wifi' => 'wifi' ),
			array( 'icon-ion-ios-wine' => 'wine' ),
			array( 'icon-ion-ios-woman' => 'woman' ),
			array( 'icon-ion-logo-android' => 'icon-ion-logo-android' ),
			array( 'icon-ion-logo-angular' => 'icon-ion-logo-angular' ),
			array( 'icon-ion-logo-apple' => 'icon-ion-logo-apple' ),
			array( 'icon-ion-logo-bitbucket' => 'icon-ion-logo-bitbucket' ),
			array( 'icon-ion-logo-bitcoin' => 'icon-ion-logo-bitcoin' ),
			array( 'icon-ion-logo-buffer' => 'icon-ion-logo-buffer' ),
			array( 'icon-ion-logo-chrome' => 'icon-ion-logo-chrome' ),
			array( 'icon-ion-logo-closed-captioning' => 'icon-ion-logo-closed-captioning' ),
			array( 'icon-ion-logo-codepen' => 'icon-ion-logo-codepen' ),
			array( 'icon-ion-logo-css3' => 'icon-ion-logo-css3' ),
			array( 'icon-ion-logo-designernews' => 'icon-ion-logo-designernews' ),
			array( 'icon-ion-logo-dribbble' => 'icon-ion-logo-dribbble' ),
			array( 'icon-ion-logo-dropbox' => 'icon-ion-logo-dropbox' ),
			array( 'icon-ion-logo-euro' => 'icon-ion-logo-euro' ),
			array( 'icon-ion-logo-facebook' => 'icon-ion-logo-facebook' ),
			array( 'icon-ion-logo-flickr' => 'icon-ion-logo-flickr' ),
			array( 'icon-ion-logo-foursquare' => 'icon-ion-logo-foursquare' ),
			array( 'icon-ion-logo-freebsd-devil' => 'icon-ion-logo-freebsd-devil' ),
			array( 'icon-ion-logo-game-controller-a' => 'icon-ion-logo-game-controller-a' ),
			array( 'icon-ion-logo-game-controller-b' => 'icon-ion-logo-game-controller-b' ),
			array( 'icon-ion-logo-github' => 'icon-ion-logo-github' ),
			array( 'icon-ion-logo-google' => 'icon-ion-logo-google' ),
			array( 'icon-ion-logo-googleplus' => 'icon-ion-logo-googleplus' ),
			array( 'icon-ion-logo-hackernews' => 'icon-ion-logo-hackernews' ),
			array( 'icon-ion-logo-html5' => 'icon-ion-logo-html5' ),
			array( 'icon-ion-logo-instagram' => 'icon-ion-logo-instagram' ),
			array( 'icon-ion-logo-ionic' => 'icon-ion-logo-ionic' ),
			array( 'icon-ion-logo-ionitron' => 'icon-ion-logo-ionitron' ),
			array( 'icon-ion-logo-javascript' => 'icon-ion-logo-javascript' ),
			array( 'icon-ion-logo-linkedin' => 'icon-ion-logo-linkedin' ),
			array( 'icon-ion-logo-markdown' => 'icon-ion-logo-markdown' ),
			array( 'icon-ion-logo-model-s' => 'icon-ion-logo-model-s' ),
			array( 'icon-ion-logo-no-smoking' => 'icon-ion-logo-no-smoking' ),
			array( 'icon-ion-logo-nodejs' => 'icon-ion-logo-nodejs' ),
			array( 'icon-ion-logo-npm' => 'icon-ion-logo-npm' ),
			array( 'icon-ion-logo-octocat' => 'icon-ion-logo-octocat' ),
			array( 'icon-ion-logo-pinterest' => 'icon-ion-logo-pinterest' ),
			array( 'icon-ion-logo-playstation' => 'icon-ion-logo-playstation' ),
			array( 'icon-ion-logo-polymer' => 'icon-ion-logo-polymer' ),
			array( 'icon-ion-logo-python' => 'icon-ion-logo-python' ),
			array( 'icon-ion-logo-reddit' => 'icon-ion-logo-reddit' ),
			array( 'icon-ion-logo-rss' => 'icon-ion-logo-rss' ),
			array( 'icon-ion-logo-sass' => 'icon-ion-logo-sass' ),
			array( 'icon-ion-logo-skype' => 'icon-ion-logo-skype' ),
			array( 'icon-ion-logo-slack' => 'icon-ion-logo-slack' ),
			array( 'icon-ion-logo-snapchat' => 'icon-ion-logo-snapchat' ),
			array( 'icon-ion-logo-steam' => 'icon-ion-logo-steam' ),
			array( 'icon-ion-logo-tumblr' => 'icon-ion-logo-tumblr' ),
			array( 'icon-ion-logo-tux' => 'icon-ion-logo-tux' ),
			array( 'icon-ion-logo-twitch' => 'icon-ion-logo-twitch' ),
			array( 'icon-ion-logo-twitter' => 'icon-ion-logo-twitter' ),
			array( 'icon-ion-logo-usd' => 'icon-ion-logo-usd' ),
			array( 'icon-ion-logo-vimeo' => 'icon-ion-logo-vimeo' ),
			array( 'icon-ion-logo-vk' => 'icon-ion-logo-vk' ),
			array( 'icon-ion-logo-whatsapp' => 'icon-ion-logo-whatsapp' ),
			array( 'icon-ion-logo-windows' => 'icon-ion-logo-windows' ),
			array( 'icon-ion-logo-wordpress' => 'icon-ion-logo-wordpress' ),
			array( 'icon-ion-logo-xbox' => 'icon-ion-logo-xbox' ),
			array( 'icon-ion-logo-xing' => 'icon-ion-logo-xing' ),
			array( 'icon-ion-logo-yahoo' => 'icon-ion-logo-yahoo' ),
			array( 'icon-ion-logo-yen' => 'icon-ion-logo-yen' ),
			array( 'icon-ion-logo-youtube' => 'icon-ion-logo-youtube' ),
		),

		'Ionicons Material Design' => array(
			array( 'icon-md-add-circle-outline' => 'icon-md-add-circle-outline' ),
			array( 'icon-md-add-circle' => 'icon-md-add-circle' ),
			array( 'icon-md-add' => 'icon-md-add' ),
			array( 'icon-md-airplane' => 'icon-md-airplane' ),
			array( 'icon-md-alarm' => 'icon-md-alarm' ),
			array( 'icon-md-albums' => 'icon-md-albums' ),
			array( 'icon-md-alert' => 'icon-md-alert' ),
			array( 'icon-md-american-football' => 'icon-md-american-football' ),
			array( 'icon-md-analytics' => 'icon-md-analytics' ),
			array( 'icon-md-aperture' => 'icon-md-aperture' ),
			array( 'icon-md-apps' => 'icon-md-apps' ),
			array( 'icon-md-appstore' => 'icon-md-appstore' ),
			array( 'icon-md-archive' => 'icon-md-archive' ),
			array( 'icon-md-arrow-back' => 'icon-md-arrow-back' ),
			array( 'icon-md-arrow-down' => 'icon-md-arrow-down' ),
			array( 'icon-md-arrow-dropdown-circle' => 'icon-md-arrow-dropdown-circle' ),
			array( 'icon-md-arrow-dropdown' => 'icon-md-arrow-dropdown' ),
			array( 'icon-md-arrow-dropleft-circle' => 'icon-md-arrow-dropleft-circle' ),
			array( 'icon-md-arrow-dropleft' => 'icon-md-arrow-dropleft' ),
			array( 'icon-md-arrow-dropright-circle' => 'icon-md-arrow-dropright-circle' ),
			array( 'icon-md-arrow-dropright' => 'icon-md-arrow-dropright' ),
			array( 'icon-md-arrow-dropup-circle' => 'icon-md-arrow-dropup-circle' ),
			array( 'icon-md-arrow-dropup' => 'icon-md-arrow-dropup' ),
			array( 'icon-md-arrow-forward' => 'icon-md-arrow-forward' ),
			array( 'icon-md-arrow-round-back' => 'icon-md-arrow-round-back' ),
			array( 'icon-md-arrow-round-down' => 'icon-md-arrow-round-down' ),
			array( 'icon-md-arrow-round-forward' => 'icon-md-arrow-round-forward' ),
			array( 'icon-md-arrow-round-up' => 'icon-md-arrow-round-up' ),
			array( 'icon-md-arrow-up' => 'icon-md-arrow-up' ),
			array( 'icon-md-at' => 'icon-md-at' ),
			array( 'icon-md-attach' => 'icon-md-attach' ),
			array( 'icon-md-backspace' => 'icon-md-backspace' ),
			array( 'icon-md-barcode' => 'icon-md-barcode' ),
			array( 'icon-md-baseball' => 'icon-md-baseball' ),
			array( 'icon-md-basket' => 'icon-md-basket' ),
			array( 'icon-md-basketball' => 'icon-md-basketball' ),
			array( 'icon-md-battery-charging' => 'icon-md-battery-charging' ),
			array( 'icon-md-battery-dead' => 'icon-md-battery-dead' ),
			array( 'icon-md-battery-full' => 'icon-md-battery-full' ),
			array( 'icon-md-beaker' => 'icon-md-beaker' ),
			array( 'icon-md-bed' => 'icon-md-bed' ),
			array( 'icon-md-beer' => 'icon-md-beer' ),
			array( 'icon-md-bicycle' => 'icon-md-bicycle' ),
			array( 'icon-md-bluetooth' => 'icon-md-bluetooth' ),
			array( 'icon-md-boat' => 'icon-md-boat' ),
			array( 'icon-md-body' => 'icon-md-body' ),
			array( 'icon-md-bonfire' => 'icon-md-bonfire' ),
			array( 'icon-md-book' => 'icon-md-book' ),
			array( 'icon-md-bookmark' => 'icon-md-bookmark' ),
			array( 'icon-md-bookmarks' => 'icon-md-bookmarks' ),
			array( 'icon-md-bowtie' => 'icon-md-bowtie' ),
			array( 'icon-md-briefcase' => 'icon-md-briefcase' ),
			array( 'icon-md-browsers' => 'icon-md-browsers' ),
			array( 'icon-md-brush' => 'icon-md-brush' ),
			array( 'icon-md-bug' => 'icon-md-bug' ),
			array( 'icon-md-build' => 'icon-md-build' ),
			array( 'icon-md-bulb' => 'icon-md-bulb' ),
			array( 'icon-md-bus' => 'icon-md-bus' ),
			array( 'icon-md-business' => 'icon-md-business' ),
			array( 'icon-md-cafe' => 'icon-md-cafe' ),
			array( 'icon-md-calculator' => 'icon-md-calculator' ),
			array( 'icon-md-calendar' => 'icon-md-calendar' ),
			array( 'icon-md-call' => 'icon-md-call' ),
			array( 'icon-md-camera' => 'icon-md-camera' ),
			array( 'icon-md-car' => 'icon-md-car' ),
			array( 'icon-md-card' => 'icon-md-card' ),
			array( 'icon-md-cart' => 'icon-md-cart' ),
			array( 'icon-md-cash' => 'icon-md-cash' ),
			array( 'icon-md-cellular' => 'icon-md-cellular' ),
			array( 'icon-md-chatboxes' => 'icon-md-chatboxes' ),
			array( 'icon-md-chatbubbles' => 'icon-md-chatbubbles' ),
			array( 'icon-md-checkbox-outline' => 'icon-md-checkbox-outline' ),
			array( 'icon-md-checkbox' => 'icon-md-checkbox' ),
			array( 'icon-md-checkmark-circle-outline' => 'icon-md-checkmark-circle-outline' ),
			array( 'icon-md-checkmark-circle' => 'icon-md-checkmark-circle' ),
			array( 'icon-md-checkmark' => 'icon-md-checkmark' ),
			array( 'icon-md-clipboard' => 'icon-md-clipboard' ),
			array( 'icon-md-clock' => 'icon-md-clock' ),
			array( 'icon-md-close-circle-outline' => 'icon-md-close-circle-outline' ),
			array( 'icon-md-close-circle' => 'icon-md-close-circle' ),
			array( 'icon-md-close' => 'icon-md-close' ),
			array( 'icon-md-cloud-circle' => 'icon-md-cloud-circle' ),
			array( 'icon-md-cloud-done' => 'icon-md-cloud-done' ),
			array( 'icon-md-cloud-download' => 'icon-md-cloud-download' ),
			array( 'icon-md-cloud-outline' => 'icon-md-cloud-outline' ),
			array( 'icon-md-cloud-upload' => 'icon-md-cloud-upload' ),
			array( 'icon-md-cloud' => 'icon-md-cloud' ),
			array( 'icon-md-cloudy-night' => 'icon-md-cloudy-night' ),
			array( 'icon-md-cloudy' => 'icon-md-cloudy' ),
			array( 'icon-md-code-download' => 'icon-md-code-download' ),
			array( 'icon-md-code-working' => 'icon-md-code-working' ),
			array( 'icon-md-code' => 'icon-md-code' ),
			array( 'icon-md-cog' => 'icon-md-cog' ),
			array( 'icon-md-color-fill' => 'icon-md-color-fill' ),
			array( 'icon-md-color-filter' => 'icon-md-color-filter' ),
			array( 'icon-md-color-palette' => 'icon-md-color-palette' ),
			array( 'icon-md-color-wand' => 'icon-md-color-wand' ),
			array( 'icon-md-compass' => 'icon-md-compass' ),
			array( 'icon-md-construct' => 'icon-md-construct' ),
			array( 'icon-md-contact' => 'icon-md-contact' ),
			array( 'icon-md-contacts' => 'icon-md-contacts' ),
			array( 'icon-md-contract' => 'icon-md-contract' ),
			array( 'icon-md-contrast' => 'icon-md-contrast' ),
			array( 'icon-md-copy' => 'icon-md-copy' ),
			array( 'icon-md-create' => 'icon-md-create' ),
			array( 'icon-md-crop' => 'icon-md-crop' ),
			array( 'icon-md-cube' => 'icon-md-cube' ),
			array( 'icon-md-cut' => 'icon-md-cut' ),
			array( 'icon-md-desktop' => 'icon-md-desktop' ),
			array( 'icon-md-disc' => 'icon-md-disc' ),
			array( 'icon-md-document' => 'icon-md-document' ),
			array( 'icon-md-done-all' => 'icon-md-done-all' ),
			array( 'icon-md-download' => 'icon-md-download' ),
			array( 'icon-md-easel' => 'icon-md-easel' ),
			array( 'icon-md-egg' => 'icon-md-egg' ),
			array( 'icon-md-exit' => 'icon-md-exit' ),
			array( 'icon-md-expand' => 'icon-md-expand' ),
			array( 'icon-md-eye-off' => 'icon-md-eye-off' ),
			array( 'icon-md-eye' => 'icon-md-eye' ),
			array( 'icon-md-fastforward' => 'icon-md-fastforward' ),
			array( 'icon-md-female' => 'icon-md-female' ),
			array( 'icon-md-filing' => 'icon-md-filing' ),
			array( 'icon-md-film' => 'icon-md-film' ),
			array( 'icon-md-finger-print' => 'icon-md-finger-print' ),
			array( 'icon-md-fitness' => 'icon-md-fitness' ),
			array( 'icon-md-flag' => 'icon-md-flag' ),
			array( 'icon-md-flame' => 'icon-md-flame' ),
			array( 'icon-md-flash-off' => 'icon-md-flash-off' ),
			array( 'icon-md-flash' => 'icon-md-flash' ),
			array( 'icon-md-flashlight' => 'icon-md-flashlight' ),
			array( 'icon-md-flask' => 'icon-md-flask' ),
			array( 'icon-md-flower' => 'icon-md-flower' ),
			array( 'icon-md-folder-open' => 'icon-md-folder-open' ),
			array( 'icon-md-folder' => 'icon-md-folder' ),
			array( 'icon-md-football' => 'icon-md-football' ),
			array( 'icon-md-funnel' => 'icon-md-funnel' ),
			array( 'icon-md-gift' => 'icon-md-gift' ),
			array( 'icon-md-git-branch' => 'icon-md-git-branch' ),
			array( 'icon-md-git-commit' => 'icon-md-git-commit' ),
			array( 'icon-md-git-compare' => 'icon-md-git-compare' ),
			array( 'icon-md-git-merge' => 'icon-md-git-merge' ),
			array( 'icon-md-git-network' => 'icon-md-git-network' ),
			array( 'icon-md-git-pull-request' => 'icon-md-git-pull-request' ),
			array( 'icon-md-glasses' => 'icon-md-glasses' ),
			array( 'icon-md-globe' => 'icon-md-globe' ),
			array( 'icon-md-grid' => 'icon-md-grid' ),
			array( 'icon-md-hammer' => 'icon-md-hammer' ),
			array( 'icon-md-hand' => 'icon-md-hand' ),
			array( 'icon-md-happy' => 'icon-md-happy' ),
			array( 'icon-md-headset' => 'icon-md-headset' ),
			array( 'icon-md-heart-dislike' => 'icon-md-heart-dislike' ),
			array( 'icon-md-heart-empty' => 'icon-md-heart-empty' ),
			array( 'icon-md-heart-half' => 'icon-md-heart-half' ),
			array( 'icon-md-heart' => 'icon-md-heart' ),
			array( 'icon-md-help-buoy' => 'icon-md-help-buoy' ),
			array( 'icon-md-help-circle-outline' => 'icon-md-help-circle-outline' ),
			array( 'icon-md-help-circle' => 'icon-md-help-circle' ),
			array( 'icon-md-help' => 'icon-md-help' ),
			array( 'icon-md-home' => 'icon-md-home' ),
			array( 'icon-md-hourglass' => 'icon-md-hourglass' ),
			array( 'icon-md-ice-cream' => 'icon-md-ice-cream' ),
			array( 'icon-md-image' => 'icon-md-image' ),
			array( 'icon-md-images' => 'icon-md-images' ),
			array( 'icon-md-infinite' => 'icon-md-infinite' ),
			array( 'icon-md-information-circle-outline' => 'icon-md-information-circle-outline' ),
			array( 'icon-md-information-circle' => 'icon-md-information-circle' ),
			array( 'icon-md-information' => 'icon-md-information' ),
			array( 'icon-md-jet' => 'icon-md-jet' ),
			array( 'icon-md-journal' => 'icon-md-journal' ),
			array( 'icon-md-key' => 'icon-md-key' ),
			array( 'icon-md-keypad' => 'icon-md-keypad' ),
			array( 'icon-md-laptop' => 'icon-md-laptop' ),
			array( 'icon-md-leaf' => 'icon-md-leaf' ),
			array( 'icon-md-link' => 'icon-md-link' ),
			array( 'icon-md-list-box' => 'icon-md-list-box' ),
			array( 'icon-md-list' => 'icon-md-list' ),
			array( 'icon-md-locate' => 'icon-md-locate' ),
			array( 'icon-md-lock' => 'icon-md-lock' ),
			array( 'icon-md-log-in' => 'icon-md-log-in' ),
			array( 'icon-md-log-out' => 'icon-md-log-out' ),
			array( 'icon-md-magnet' => 'icon-md-magnet' ),
			array( 'icon-md-mail-open' => 'icon-md-mail-open' ),
			array( 'icon-md-mail-unread' => 'icon-md-mail-unread' ),
			array( 'icon-md-mail' => 'icon-md-mail' ),
			array( 'icon-md-male' => 'icon-md-male' ),
			array( 'icon-md-man' => 'icon-md-man' ),
			array( 'icon-md-map' => 'icon-md-map' ),
			array( 'icon-md-medal' => 'icon-md-medal' ),
			array( 'icon-md-medical' => 'icon-md-medical' ),
			array( 'icon-md-medkit' => 'icon-md-medkit' ),
			array( 'icon-md-megaphone' => 'icon-md-megaphone' ),
			array( 'icon-md-menu' => 'icon-md-menu' ),
			array( 'icon-md-mic-off' => 'icon-md-mic-off' ),
			array( 'icon-md-mic' => 'icon-md-mic' ),
			array( 'icon-md-microphone' => 'icon-md-microphone' ),
			array( 'icon-md-moon' => 'icon-md-moon' ),
			array( 'icon-md-more' => 'icon-md-more' ),
			array( 'icon-md-move' => 'icon-md-move' ),
			array( 'icon-md-musical-note' => 'icon-md-musical-note' ),
			array( 'icon-md-musical-notes' => 'icon-md-musical-notes' ),
			array( 'icon-md-navigate' => 'icon-md-navigate' ),
			array( 'icon-md-notifications-off' => 'icon-md-notifications-off' ),
			array( 'icon-md-notifications-outline' => 'icon-md-notifications-outline' ),
			array( 'icon-md-notifications' => 'icon-md-notifications' ),
			array( 'icon-md-nuclear' => 'icon-md-nuclear' ),
			array( 'icon-md-nutrition' => 'icon-md-nutrition' ),
			array( 'icon-md-open' => 'icon-md-open' ),
			array( 'icon-md-options' => 'icon-md-options' ),
			array( 'icon-md-outlet' => 'icon-md-outlet' ),
			array( 'icon-md-paper-plane' => 'icon-md-paper-plane' ),
			array( 'icon-md-paper' => 'icon-md-paper' ),
			array( 'icon-md-partly-sunny' => 'icon-md-partly-sunny' ),
			array( 'icon-md-pause' => 'icon-md-pause' ),
			array( 'icon-md-paw' => 'icon-md-paw' ),
			array( 'icon-md-people' => 'icon-md-people' ),
			array( 'icon-md-person-add' => 'icon-md-person-add' ),
			array( 'icon-md-person' => 'icon-md-person' ),
			array( 'icon-md-phone-landscape' => 'icon-md-phone-landscape' ),
			array( 'icon-md-phone-portrait' => 'icon-md-phone-portrait' ),
			array( 'icon-md-photos' => 'icon-md-photos' ),
			array( 'icon-md-pie' => 'icon-md-pie' ),
			array( 'icon-md-pin' => 'icon-md-pin' ),
			array( 'icon-md-pint' => 'icon-md-pint' ),
			array( 'icon-md-pizza' => 'icon-md-pizza' ),
			array( 'icon-md-planet' => 'icon-md-planet' ),
			array( 'icon-md-play-circle' => 'icon-md-play-circle' ),
			array( 'icon-md-play' => 'icon-md-play' ),
			array( 'icon-md-podium' => 'icon-md-podium' ),
			array( 'icon-md-power' => 'icon-md-power' ),
			array( 'icon-md-pricetag' => 'icon-md-pricetag' ),
			array( 'icon-md-pricetags' => 'icon-md-pricetags' ),
			array( 'icon-md-print' => 'icon-md-print' ),
			array( 'icon-md-pulse' => 'icon-md-pulse' ),
			array( 'icon-md-qr-scanner' => 'icon-md-qr-scanner' ),
			array( 'icon-md-quote' => 'icon-md-quote' ),
			array( 'icon-md-radio-button-off' => 'icon-md-radio-button-off' ),
			array( 'icon-md-radio-button-on' => 'icon-md-radio-button-on' ),
			array( 'icon-md-radio' => 'icon-md-radio' ),
			array( 'icon-md-rainy' => 'icon-md-rainy' ),
			array( 'icon-md-recording' => 'icon-md-recording' ),
			array( 'icon-md-redo' => 'icon-md-redo' ),
			array( 'icon-md-refresh-circle' => 'icon-md-refresh-circle' ),
			array( 'icon-md-refresh' => 'icon-md-refresh' ),
			array( 'icon-md-remove-circle-outline' => 'icon-md-remove-circle-outline' ),
			array( 'icon-md-remove-circle' => 'icon-md-remove-circle' ),
			array( 'icon-md-remove' => 'icon-md-remove' ),
			array( 'icon-md-reorder' => 'icon-md-reorder' ),
			array( 'icon-md-repeat' => 'icon-md-repeat' ),
			array( 'icon-md-resize' => 'icon-md-resize' ),
			array( 'icon-md-restaurant' => 'icon-md-restaurant' ),
			array( 'icon-md-return-left' => 'icon-md-return-left' ),
			array( 'icon-md-return-right' => 'icon-md-return-right' ),
			array( 'icon-md-reverse-camera' => 'icon-md-reverse-camera' ),
			array( 'icon-md-rewind' => 'icon-md-rewind' ),
			array( 'icon-md-ribbon' => 'icon-md-ribbon' ),
			array( 'icon-md-rocket' => 'icon-md-rocket' ),
			array( 'icon-md-rose' => 'icon-md-rose' ),
			array( 'icon-md-sad' => 'icon-md-sad' ),
			array( 'icon-md-save' => 'icon-md-save' ),
			array( 'icon-md-school' => 'icon-md-school' ),
			array( 'icon-md-search' => 'icon-md-search' ),
			array( 'icon-md-send' => 'icon-md-send' ),
			array( 'icon-md-settings' => 'icon-md-settings' ),
			array( 'icon-md-share-alt' => 'icon-md-share-alt' ),
			array( 'icon-md-share' => 'icon-md-share' ),
			array( 'icon-md-shirt' => 'icon-md-shirt' ),
			array( 'icon-md-shuffle' => 'icon-md-shuffle' ),
			array( 'icon-md-skip-backward' => 'icon-md-skip-backward' ),
			array( 'icon-md-skip-forward' => 'icon-md-skip-forward' ),
			array( 'icon-md-snow' => 'icon-md-snow' ),
			array( 'icon-md-speedometer' => 'icon-md-speedometer' ),
			array( 'icon-md-square-outline' => 'icon-md-square-outline' ),
			array( 'icon-md-square' => 'icon-md-square' ),
			array( 'icon-md-star-half' => 'icon-md-star-half' ),
			array( 'icon-md-star-outline' => 'icon-md-star-outline' ),
			array( 'icon-md-star' => 'icon-md-star' ),
			array( 'icon-md-stats' => 'icon-md-stats' ),
			array( 'icon-md-stopwatch' => 'icon-md-stopwatch' ),
			array( 'icon-md-subway' => 'icon-md-subway' ),
			array( 'icon-md-sunny' => 'icon-md-sunny' ),
			array( 'icon-md-swap' => 'icon-md-swap' ),
			array( 'icon-md-switch' => 'icon-md-switch' ),
			array( 'icon-md-sync' => 'icon-md-sync' ),
			array( 'icon-md-tablet-landscape' => 'icon-md-tablet-landscape' ),
			array( 'icon-md-tablet-portrait' => 'icon-md-tablet-portrait' ),
			array( 'icon-md-tennisball' => 'icon-md-tennisball' ),
			array( 'icon-md-text' => 'icon-md-text' ),
			array( 'icon-md-thermometer' => 'icon-md-thermometer' ),
			array( 'icon-md-thumbs-down' => 'icon-md-thumbs-down' ),
			array( 'icon-md-thumbs-up' => 'icon-md-thumbs-up' ),
			array( 'icon-md-thunderstorm' => 'icon-md-thunderstorm' ),
			array( 'icon-md-time' => 'icon-md-time' ),
			array( 'icon-md-timer' => 'icon-md-timer' ),
			array( 'icon-md-today' => 'icon-md-today' ),
			array( 'icon-md-train' => 'icon-md-train' ),
			array( 'icon-md-transgender' => 'icon-md-transgender' ),
			array( 'icon-md-trash' => 'icon-md-trash' ),
			array( 'icon-md-trending-down' => 'icon-md-trending-down' ),
			array( 'icon-md-trending-up' => 'icon-md-trending-up' ),
			array( 'icon-md-trophy' => 'icon-md-trophy' ),
			array( 'icon-md-tv' => 'icon-md-tv' ),
			array( 'icon-md-umbrella' => 'icon-md-umbrella' ),
			array( 'icon-md-undo' => 'icon-md-undo' ),
			array( 'icon-md-unlock' => 'icon-md-unlock' ),
			array( 'icon-md-videocam' => 'icon-md-videocam' ),
			array( 'icon-md-volume-high' => 'icon-md-volume-high' ),
			array( 'icon-md-volume-low' => 'icon-md-volume-low' ),
			array( 'icon-md-volume-mute' => 'icon-md-volume-mute' ),
			array( 'icon-md-volume-off' => 'icon-md-volume-off' ),
			array( 'icon-md-walk' => 'icon-md-walk' ),
			array( 'icon-md-wallet' => 'icon-md-wallet' ),
			array( 'icon-md-warning' => 'icon-md-warning' ),
			array( 'icon-md-watch' => 'icon-md-watch' ),
			array( 'icon-md-water' => 'icon-md-water' ),
			array( 'icon-md-wifi' => 'icon-md-wifi' ),
			array( 'icon-md-wine' => 'icon-md-wine' ),
			array( 'icon-md-woman' => 'icon-md-woman' ),
		)

	);

	return array_merge( $icons, $linea_icons );
}


add_filter( 'vc_iconpicker-type-animated', 'mo_iconpicker_type_animated' );

function mo_iconpicker_type_animated( $icons ) {

	$animated_icons = array(
		'Arrows' => array(
			array( 'animated-arrows_anticlockwise' => 'Icon arrow anticlockwise' ),
			array( 'animated-arrows_anticlockwise_dashed' => 'Icon arrow anticlockwise dashed' ),
			array( 'animated-arrows_button_down' => 'Icon arrow button down' ),
			array( 'animated-arrows_button_off' => 'Icon arrow button off' ),
			array( 'animated-arrows_button_on' => 'Icon arrow button on' ),
			array( 'animated-arrows_button_up' => 'Icon arrow button up' ),
			array( 'animated-arrows_check' => 'Icon arrow check' ),
			array( 'animated-arrows_circle_check' => 'Icon arrow circle check' ),
			array( 'animated-arrows_circle_down' => 'Icon arrow circle down' ),			
			array( 'animated-arrows_circle_downleft' => 'Icon arrow circle downleft' ),
			array( 'animated-arrows_circle_downright' => 'Icon arrow circle downright' ),
			array( 'animated-arrows_circle_left' => 'Icon arrow circle left' ),
			array( 'animated-arrows_circle_minus' =>  'Icon arrow circle minus' ),
			array( 'animated-arrows_circle_plus' => 'Icon arrow circle plus' ),
			array( 'animated-arrows_circle_remove' => 'Icon arrow circle remove' ),
			array( 'animated-arrows_circle_right' => 'Icon arrow circle right' ),
			array( 'animated-arrows_circle_up' => 'Icon arrow circle up' ),
			array( 'animated-arrows_circle_upleft' => 'Icon arrow circle upleft' ),
			array( 'animated-arrows_circle_upright' => 'Icon arrow circle upright' ),
			array( 'animated-arrows_clockwise' => 'Icon arrow clockwise' ),
			array( 'animated-arrows_clockwise_dashed' => 'Icon arrow clockwise dashed' ),
			array( 'animated-arrows_compress' => 'Icon arrow compress' ),
			array( 'animated-arrows_deny' => 'Icon arrow deny' ),
			array( 'animated-arrows_diagonal2' => 'Icon arrow diagonal2' ),
			array( 'animated-arrows_diagonal' =>  'Icon arrow diagonal' ),
			array( 'animated-arrows_down' => 'Icon arrow down' ),
			array( 'animated-arrows_down_double-34' => 'Icon arrow down double-34' ),
			array( 'animated-arrows_downleft' => 'Icon arrow downleft' ),
			array( 'animated-arrows_downright' => 'Icon arrow downright' ),
			array( 'animated-arrows_drag_down' => 'Icon arrow drag down' ),
			array( 'animated-arrows_drag_down_dashed' => 'Icon arrow drag down dashed' ),
			array( 'animated-arrows_drag_horiz' => 'Icon arrow drag horiz' ),
			array( 'animated-arrows_drag_left' => 'Icon arrow drag left' ),
			array( 'animated-arrows_drag_left_dashed' => 'Icon arrow drag left dashed' ),
			array( 'animated-arrows_drag_right' => 'Icon arrow drag right' ),
			array( 'animated-arrows_drag_right_dashed' => 'Icon arrow drag right dashed' ),
			array( 'animated-arrows_drag_up' => 'Icon arrow drag up' ),
			array( 'animated-arrows_drag_up_dashed' => 'Icon arrow drag up dashed' ),
			array( 'animated-arrows_drag_vert' => 'Icon arrow drag vert' ),
			array( 'animated-arrows_exclamation' => 'Icon arrow exclamation' ),
			array( 'animated-arrows_expand' => 'Icon arrow expand' ),
			array( 'animated-arrows_expand_diagonal1' => 'Icon arrow expand diagonal1' ),
			array( 'animated-arrows_expand_horizontal1' => 'Icon arrow expand horizontal1' ),
			array( 'animated-arrows_expand_vertical1' => 'Icon arrow expand vertical1' ),
			array( 'animated-arrows_fit_horizontal' => 'Icon arrow fit horizontal' ),
			array( 'animated-arrows_fit_vertical' => 'Icon arrow fit vertical' ),
			array( 'animated-arrows_glide' => 'Icon arrow glide' ),
			array( 'animated-arrows_glide_horizontal' => 'Icon arrow glide horizontal' ),
			array( 'animated-arrows_glide_vertical' => 'Icon arrow glide vertical' ),
			array( 'animated-arrows_hamburger-2' => 'Icon arrow hamburger-2' ),
			array( 'animated-arrows_hamburger1' => 'Icon arrow hamburger1' ),
			array( 'animated-arrows_horizontal' => 'Icon arrow horizontal' ),
			array( 'animated-arrows_info' => 'Icon arrow info' ),
			array( 'animated-arrows_keyboard_alt' => 'Icon arrow keyboard alt' ),
			array( 'animated-arrows_keyboard_cmd-29' => 'Icon arrow keyboard cmd-29' ),
			array( 'animated-arrows_keyboard_delete' => 'Icon arrow keyboard delete' ),
			array( 'animated-arrows_keyboard_down-28' => 'Icon arrow keyboard down-28' ), 
			array( 'animated-arrows_keyboard_left' => 'Icon arrow keyboard left' ), 
			array( 'animated-arrows_keyboard_return' => 'Icon arrow keyboard return' ), 
			array( 'animated-arrows_keyboard_right' => 'Icon arrow keyboard right' ), 
			array( 'animated-arrows_keyboard_shift' => 'Icon arrow keyboard shift' ), 
			array( 'animated-arrows_keyboard_tab' => 'Icon arrow keyboard tab' ), 
			array( 'animated-arrows_keyboard_up' => 'Icon arrow keyboard up' ), 
			array( 'animated-arrows_left' => 'Icon arrow left' ), 
			array( 'animated-arrows_left_double-32' => 'Icon arrow left double-32' ), 
			array( 'animated-arrows_minus' => 'Icon arrow minus' ), 
			array( 'animated-arrows_move2' => 'Icon arrow move2' ), 
			array( 'animated-arrows_move' => 'Icon arrow move' ), 
			array( 'animated-arrows_move_bottom' => 'Icon arrow move bottom' ), 
			array( 'animated-arrows_move_left' => 'Icon arrow move left' ), 
			array( 'animated-arrows_move_right' => 'Icon arrow move right' ), 
			array( 'animated-arrows_move_top' => 'Icon arrow move top' ), 
			array( 'animated-arrows_plus' => 'Icon arrow plus' ), 
			array( 'animated-arrows_question' => 'Icon arrow question' ), 
			array( 'animated-arrows_remove' => 'Icon arrow remove' ), 
			array( 'animated-arrows_right' => 'Icon arrow right' ), 
			array( 'animated-arrows_right_double-31' => 'Icon arrow right double-31' ), 
			array( 'animated-arrows_rotate' => 'Icon arrow rotate' ), 
			array( 'animated-arrows_rotate_anti' => 'Icon arrow rotate anti' ), 
			array( 'animated-arrows_rotate_anti_dashed' => 'Icon arrow rotate anti dashed' ), 
			array( 'animated-arrows_rotate_dashed' => 'Icon arrow rotate dashed' ), 
			array( 'animated-arrows_shrink' => 'Icon arrow shrink' ), 
			array( 'animated-arrows_shrink_diagonal1' => 'Icon arrow shrink diagonal1' ), 
			array( 'animated-arrows_shrink_diagonal2' => 'Icon arrow shrink diagonal2' ), 
			array( 'animated-arrows_shrink_horizonal2' => 'Icon arrow shrink horizonal2' ), 
			array( 'animated-arrows_shrink_horizontal1' => 'Icon arrow shrink horizontal1' ), 
			array( 'animated-arrows_shrink_vertical1' => 'Icon arrow shrink vertical1' ), 
			array( 'animated-arrows_shrink_vertical2' => 'Icon arrow shrink vertical2' ), 
			array( 'animated-arrows_sign_down' => 'Icon arrow sign down' ), 
			array( 'animated-arrows_sign_left' => 'Icon arrow sign left' ), 
			array( 'animated-arrows_sign_right' => 'Icon arrow sign right' ), 
			array( 'animated-arrows_sign_up' => 'Icon arrow sign up' ), 
			array( 'animated-arrows_slide_down1' => 'Icon arrow slide down1' ), 
			array( 'animated-arrows_slide_down2' => 'Icon arrow slide down2' ), 
			array( 'animated-arrows_slide_left1' => 'Icon arrow slide left1' ), 
			array( 'animated-arrows_slide_left2' => 'Icon arrow slide left2' ), 
			array( 'animated-arrows_slide_right1' => 'Icon arrow slide right1' ), 
			array( 'animated-arrows_slide_right2' => 'Icon arrow slide right2' ), 
			array( 'animated-arrows_slide_up1' => 'Icon arrow slide up1' ), 
			array( 'animated-arrows_slide_up2' => 'Icon arrow slide up2' ), 
			array( 'animated-arrows_slim_down' => 'Icon arrow slim down' ), 
			array( 'animated-arrows_slim_down_dashed' => 'Icon arrow slim down dashed' ), 
			array( 'animated-arrows_slim_left' => 'Icon arrow slim left' ), 
			array( 'animated-arrows_slim_left_dashed' => 'Icon arrow slim left dashed' ), 
			array( 'animated-arrows_slim_right' => 'Icon arrow slim right' ), 
			array( 'animated-arrows_slim_right_dashed' => 'Icon arrow slim right dashed' ), 
			array( 'animated-arrows_slim_up' => 'Icon arrow slim up' ), 
			array( 'animated-arrows_slim_up_dashed' => 'Icon arrow slim up dashed' ), 
			array( 'animated-arrows_square_check' => 'Icon arrow square check' ), 
			array( 'animated-arrows_square_down' => 'Icon arrow square down' ), 
			array( 'animated-arrows_square_downleft' => 'Icon arrow square downleft' ), 
			array( 'animated-arrows_square_downright' => 'Icon arrow square downright' ), 
			array( 'animated-arrows_square_left' => 'Icon arrow square left' ), 
			array( 'animated-arrows_square_minus' => 'Icon arrow square minus' ), 
			array( 'animated-arrows_square_plus' => 'Icon arrow square plus' ), 
			array( 'animated-arrows_square_remove' => 'Icon arrow square remove' ), 
			array( 'animated-arrows_square_right' => 'Icon arrow square right' ), 
			array( 'animated-arrows_square_up' => 'Icon arrow square up' ), 
			array( 'animated-arrows_square_upleft' => 'Icon arrow square upleft' ), 
			array( 'animated-arrows_square_upright' => 'Icon arrow square upright' ), 
			array( 'animated-arrows_squares' => 'Icon arrow squares' ), 
			array( 'animated-arrows_stretch_diagonal1' => 'Icon arrow stretch diagonal1' ), 
			array( 'animated-arrows_stretch_diagonal2' => 'Icon arrow stretch diagonal2' ), 
			array( 'animated-arrows_stretch_diagonal3' => 'Icon arrow stretch diagonal3' ), 
			array( 'animated-arrows_stretch_diagonal4' => 'Icon arrow stretch diagonal4' ), 
			array( 'animated-arrows_stretch_horizontal1' => 'Icon arrow stretch horizontal1' ), 
			array( 'animated-arrows_stretch_horizontal2' => 'Icon arrow stretch horizontal2' ), 
			array( 'animated-arrows_stretch_vertical1' => 'Icon arrow stretch vertical1' ), 
			array( 'animated-arrows_stretch_vertical2' => 'Icon arrow stretch vertical2' ), 
			array( 'animated-arrows_switch_horizontal' => 'Icon arrow switch horizontal' ), 
			array( 'animated-arrows_switch_vertical' => 'Icon arrow switch vertical' ), 
			array( 'animated-arrows_up' => 'Icon arrow up' ), 
			array( 'animated-arrows_up_double-33' => 'Icon arrow up double-33' ), 
			array( 'animated-arrows_upleft' => 'Icon arrow upleft' ), 
			array( 'animated-arrows_upright' => 'Icon arrow upright' ), 
			array( 'animated-arrows_vertical' => 'Icon arrow vertical'),
		),
		'Basic' => array(
			array( 'animated-basic_accelerator' => 'Icon basic accelerator' ), 
			array( 'animated-basic_alarm' => 'Icon basic alarm' ), 
			array( 'animated-basic_anchor' => 'Icon basic anchor' ), 
			array( 'animated-basic_anticlockwise' => 'Icon basic anticlockwise' ), 
			array( 'animated-basic_archive' => 'Icon basic archive' ), 
			array( 'animated-basic_archive_full' => 'Icon basic archive full' ), 
			array( 'animated-basic_ban' => 'Icon basic ban' ), 
			array( 'animated-basic_battery_charge' => 'Icon basic battery charge' ), 
			array( 'animated-basic_battery_empty' => 'Icon basic battery empty' ), 
			array( 'animated-basic_battery_full' => 'Icon basic battery full' ), 
			array( 'animated-basic_battery_half' => 'Icon basic battery half' ), 
			array( 'animated-basic_bolt' => 'Icon basic bolt' ), 
			array( 'animated-basic_book' => 'Icon basic book' ), 
			array( 'animated-basic_book_pen' => 'Icon basic book pen' ), 
			array( 'animated-basic_book_pencil' => 'Icon basic book pencil' ), 
			array( 'animated-basic_bookmark' => 'Icon basic bookmark' ), 
			array( 'animated-basic_calculator' => 'Icon basic calculator' ), 
			array( 'animated-basic_calendar' => 'Icon basic calendar' ), 
			array( 'animated-basic_cards_diamonds' => 'Icon basic cards diamonds' ), 
			array( 'animated-basic_cards_hearts' => 'Icon basic cards hearts' ), 
			array( 'animated-basic_case' => 'Icon basic case' ), 
			array( 'animated-basic_chronometer' => 'Icon basic chronometer' ), 
			array( 'animated-basic_clessidre' => 'Icon basic clessidre' ), 
			array( 'animated-basic_clock' => 'Icon basic clock' ), 
			array( 'animated-basic_clockwise' => 'Icon basic clockwise' ), 
			array( 'animated-basic_cloud' => 'Icon basic cloud' ), 
			array( 'animated-basic_clubs' => 'Icon basic clubs' ), 
			array( 'animated-basic_compass' => 'Icon basic compass' ), 
			array( 'animated-basic_cup' => 'Icon basic cup' ), 
			array( 'animated-basic_diamonds' => 'Icon basic diamonds' ), 
			array( 'animated-basic_display' => 'Icon basic display' ), 
			array( 'animated-basic_download' => 'Icon basic download' ), 
			array( 'animated-basic_exclamation' => 'Icon basic exclamation' ), 
			array( 'animated-basic_eye' => 'Icon basic eye' ), 
			array( 'animated-basic_eye_closed' => 'Icon basic eye closed' ), 
			array( 'animated-basic_female' => 'Icon basic female' ), 
			array( 'animated-basic_flag1' => 'Icon basic flag1' ), 
			array( 'animated-basic_flag2' => 'Ico basic flag2' ), 
			array( 'animated-basic_floppydisk' => 'Icon basic floppydisk' ), 
			array( 'animated-basic_folder' => 'Icon basic folder' ), 
			array( 'animated-basic_folder_multiple' => 'Icon basic folder multiple' ), 
			array( 'animated-basic_gear' => 'Icon basic gear' ), 
			array( 'animated-basic_geolocalize-01' => 'Icon basic geolocalize-01' ), 
			array( 'animated-basic_geolocalize-05' => 'Icon basic geolocalize-05' ), 
			array( 'animated-basic_globe' => 'Icon basic globe' ), 
			array( 'animated-basic_gunsight' => 'Icon basic gunsight' ), 
			array( 'animated-basic_hammer' => 'Icon basic hammer' ), 
			array( 'animated-basic_headset' => 'Icon basic headset' ), 
			array( 'animated-basic_heart' => 'Icon basic heart' ), 
			array( 'animated-basic_heart_broken' => 'Icon basic heart broken' ), 
			array( 'animated-basic_helm' => 'Icon basic helm' ), 
			array( 'animated-basic_home' => 'Icon basic home' ), 
			array( 'animated-basic_info' => 'Icon basic info' ), 
			array( 'animated-basic_ipod' => 'Basic ipod' ), 
			array( 'animated-basic_joypad' => 'Basic joypad' ), 
			array( 'animated-basic_key' => 'Basic key' ), 
			array( 'animated-basic_keyboard' => 'Basic keyboard' ), 
			array( 'animated-basic_laptop' => 'Basic laptop' ), 
			array( 'animated-basic_life_buoy' => 'Basic life buoy' ), 
			array( 'animated-basic_lightbulb' => 'Basic lightbulb' ), 
			array( 'animated-basic_link' => 'Basic link' ), 
			array( 'animated-basic_lock' => 'Basic lock' ), 
			array( 'animated-basic_lock_open' => 'Basic lock open' ), 
			array( 'animated-basic_magic_mouse' => 'Basic magic mouse' ), 
			array( 'animated-basic_magnifier' => 'Basic magnifier' ), 
			array( 'animated-basic_magnifier_minus' => 'Basic magnifier minus' ), 
			array( 'animated-basic_magnifier_plus' => 'Basic magnifier plus' ), 
			array( 'animated-basic_mail' => 'Basic mail' ), 
			array( 'animated-basic_mail_multiple' => 'Basic mail multiple' ), 
			array( 'animated-basic_mail_open' => 'Basic mail open' ), 
			array( 'animated-basic_mail_open_text' => 'Basic mail open text' ), 
			array( 'animated-basic_male' => 'Basic male' ),
			array( 'animated-basic_map' => 'Basic map' ), 
			array( 'animated-basic_message' => 'Basic message' ), 
			array( 'animated-basic_message_multiple' => 'Basic message multiple' ), 
			array( 'animated-basic_message_txt' => 'Basic message txt' ), 
			array( 'animated-basic_mixer2' => 'Basic mixer2' ), 
			array( 'animated-basic_mouse' => 'Basic mouse' ), 
			array( 'animated-basic_notebook' => 'Basic notebook' ), 
			array( 'animated-basic_notebook_pen' => 'basic notebook pen' ), 
			array( 'animated-basic_notebook_pencil' => 'basic notebook pencil' ), 
			array( 'animated-basic_paperplane' => 'basic paperplane' ), 
			array( 'animated-basic_pencil_ruler' => 'basic pencil ruler' ), 
			array( 'animated-basic_pencil_ruler_pen' => 'basic pencil ruler pen' ), 
			array( 'animated-basic_photo' => 'basic photo' ), 
			array( 'animated-basic_picture' => 'basic picture' ), 
			array( 'animated-basic_picture_multiple' => 'basic picture multiple' ), 
			array( 'animated-basic_pin1' => 'basic pin1' ), 
			array( 'animated-basic_pin2' => 'basic pin2' ), 
			array( 'animated-basic_postcard' => 'basic postcard' ), 
			array( 'animated-basic_postcard_multiple' => 'basic postcard multiple' ), 
			array( 'animated-basic_printer' => 'basic printer' ), 
			array( 'animated-basic_question' => 'basic question' ), 
			array( 'animated-basic_rss' => 'basic rss' ), 
			array( 'animated-basic_server2' => 'basic server2' ), 
			array( 'animated-basic_server' => 'basic server' ), 
			array( 'animated-basic_server_cloud' => 'basic server cloud' ), 
			array( 'animated-basic_server_download' => 'basic server download' ), 
			array( 'animated-basic_server_upload' => 'basic server upload' ), 
			array( 'animated-basic_settings' => 'basic settings' ), 
			array( 'animated-basic_share' => 'basic share' ), 
			array( 'animated-basic_sheet' => 'basic sheet' ), 
			array( 'animated-basic_sheet_multiple' => 'basic sheet multiple' ), 
			array( 'animated-basic_sheet_pen' => 'basic sheet pen' ), 
			array( 'animated-basic_sheet_pencil' => 'basic sheet pencil' ), 
			array( 'animated-basic_sheet_txt' => 'basic sheet txt' ), 
			array( 'animated-basic_signs' => 'basic signs' ), 
			array( 'animated-basic_smartphone' => 'basic smartphone' ), 
			array( 'animated-basic_spades' => 'basic spades' ), 
			array( 'animated-basic_spread' => 'basic spread' ), 
			array( 'animated-basic_spread_bookmark' => 'basic spread bookmark' ), 
			array( 'animated-basic_spread_text' => 'basic spread text' ), 
			array( 'animated-basic_spread_text_bookmark' => 'basic spread text bookmark' ), 
			array( 'animated-basic_star' => 'basic star' ), 
			array( 'animated-basic_tablet' => 'basic tablet' ), 
			array( 'animated-basic_target' => 'basic target' ), 
			array( 'animated-basic_todo' => 'basic todo' ), 
			array( 'animated-basic_todo_pen' => 'basic todo pen' ), 
			array( 'animated-basic_todo_pencil' => 'basic todo pencil' ), 
			array( 'animated-basic_todo_txt' => 'basic todo txt' ), 
			array( 'animated-basic_todolist_pen' => 'basic todolist pen' ), 
			array( 'animated-basic_todolist_pencil' => 'basic todolist pencil' ), 
			array( 'animated-basic_trashcan' => 'basic trashcan' ), 
			array( 'animated-basic_trashcan_full' => 'basic trashcan full' ), 
			array( 'animated-basic_trashcan_refresh' => 'basic trashcan refresh' ), 
			array( 'animated-basic_trashcan_remove' => 'basic trashcan remove' ), 
			array( 'animated-basic_upload' => 'basic upload' ), 
			array( 'animated-basic_usb' => 'basic usb' ), 
			array( 'animated-basic_video' => 'basic video' ), 
			array( 'animated-basic_watch' => 'basic watch' ), 
			array( 'animated-basic_webpage' => 'basic webpage' ), 
			array( 'animated-basic_webpage_img_txt' => 'basic webpage img txt' ), 
			array( 'animated-basic_webpage_multiple' => 'basic webpage multiple' ), 
			array( 'animated-basic_webpage_txt' => 'basic webpage txt' ), 
			array( 'animated-basic_world' => 'basic world' ),
		),
		'Basic Elaboration' => array(
			array( 'animated-basic_elaboration_bookmark_checck' => 'basic elaboration bookmark checck' ),
			array( 'animated-basic_elaboration_bookmark_minus' => 'basic elaboration bookmark minus' ), 
			array( 'animated-basic_elaboration_bookmark_plus' => 'basic elaboration bookmark plus' ), 
			array( 'animated-basic_elaboration_bookmark_remove' => 'basic elaboration bookmark remove' ), 
			array( 'animated-basic_elaboration_briefcase_check' => 'basic elaboration briefcase check' ), 
			array( 'animated-basic_elaboration_briefcase_download' => 'basic elaboration briefcase download' ), 
			array( 'animated-basic_elaboration_briefcase_flagged' => 'basic elaboration briefcase flagged' ), 
			array( 'animated-basic_elaboration_briefcase_minus' => 'basic elaboration briefcase minus' ), 
			array( 'animated-basic_elaboration_briefcase_plus' => 'basic elaboration briefcase plus' ), 
			array( 'animated-basic_elaboration_briefcase_refresh' => 'basic elaboration briefcase refresh' ),
			array( 'animated-basic_elaboration_briefcase_remove' => 'basic elaboration briefcase remove' ), 
			array( 'animated-basic_elaboration_briefcase_search' => 'basic elaboration briefcase search' ), 
			array( 'animated-basic_elaboration_briefcase_star' => 'basic elaboration briefcase star' ), 
			array( 'animated-basic_elaboration_briefcase_upload' => 'basic elaboration briefcase upload' ), 
			array( 'animated-basic_elaboration_browser_check' => 'basic elaboration browser check' ), 
			array( 'animated-basic_elaboration_browser_download' => 'basic elaboration browser download' ), 
			array( 'animated-basic_elaboration_browser_minus' => 'basic elaboration browser minus' ), 
			array( 'animated-basic_elaboration_browser_plus' => 'basic elaboration browser plus' ), 
			array( 'animated-basic_elaboration_browser_refresh' => 'basic elaboration browser refresh' ), 
			array( 'animated-basic_elaboration_browser_remove' => 'basic elaboration browser remove' ), 
			array( 'animated-basic_elaboration_browser_search' => 'basic elaboration browser search' ), 
			array( 'animated-basic_elaboration_browser_star' => 'basic elaboration browser star' ), 
			array( 'animated-basic_elaboration_browser_upload' => 'basic elaboration browser upload' ), 
			array( 'animated-basic_elaboration_calendar_check' => 'basic elaboration calendar check' ), 
			array( 'animated-basic_elaboration_calendar_cloud' => 'basic elaboration calendar cloud' ), 
			array( 'animated-basic_elaboration_calendar_download' => 'basic elaboration calendar download' ), 
			array( 'animated-basic_elaboration_calendar_empty' => 'basic elaboration calendar empty' ), 
			array( 'animated-basic_elaboration_calendar_flagged' => 'basic elaboration calendar flagged' ), 
			array( 'animated-basic_elaboration_calendar_heart' => 'basic elaboration calendar heart' ), 
			array( 'animated-basic_elaboration_calendar_minus' => 'basic elaboration calendar minus' ), 
			array( 'animated-basic_elaboration_calendar_next' => 'basic elaboration calendar next' ), 
			array( 'animated-basic_elaboration_calendar_noaccess' => 'basic elaboration calendar noaccess' ), 
			array( 'animated-basic_elaboration_calendar_pencil' => 'basic elaboration calendar pencil' ), 
			array( 'animated-basic_elaboration_calendar_plus' => 'basic elaboration calendar plus' ), 
			array( 'animated-basic_elaboration_calendar_previous' => 'basic elaboration calendar previous' ), 
			array( 'animated-basic_elaboration_calendar_refresh' => 'basic elaboration calendar refresh' ), 
			array( 'animated-basic_elaboration_calendar_remove' => 'basic elaboration calendar remove' ), 
			array( 'animated-basic_elaboration_calendar_search' => 'basic elaboration calendar search' ), 
			array( 'animated-basic_elaboration_calendar_star' => 'basic elaboration calendar star' ), 
			array( 'animated-basic_elaboration_calendar_upload' => 'basic elaboration calendar upload' ), 
			array( 'animated-basic_elaboration_cloud_check' => 'basic elaboration cloud check' ), 
			array( 'animated-basic_elaboration_cloud_download' => 'basic elaboration cloud download' ), 
			array( 'animated-basic_elaboration_cloud_minus' => 'basic elaboration cloud minus' ), 
			array( 'animated-basic_elaboration_cloud_noaccess' => 'basic elaboration cloud noaccess' ), 
			array( 'animated-basic_elaboration_cloud_plus' => 'basic elaboration cloud plus' ), 
			array( 'animated-basic_elaboration_cloud_refresh' => 'basic elaboration cloud refresh' ), 
			array( 'animated-basic_elaboration_cloud_remove' => 'basic elaboration cloud remove' ), 
			array( 'animated-basic_elaboration_cloud_search' => 'basic elaboration cloud search' ), 
			array( 'animated-basic_elaboration_cloud_upload' => 'basic elaboration cloud upload' ), 
			array( 'animated-basic_elaboration_document_check' => 'basic elaboration document check' ), 
			array( 'animated-basic_elaboration_document_cloud' => 'basic elaboration document cloud' ), 
			array( 'animated-basic_elaboration_document_download' => 'basic elaboration document download' ), 
			array( 'animated-basic_elaboration_document_flagged' => 'basic elaboration document flagged' ), 
			array( 'animated-basic_elaboration_document_graph' => 'basic elaboration document graph' ), 
			array( 'animated-basic_elaboration_document_heart' => 'basic elaboration document heart' ), 
			array( 'animated-basic_elaboration_document_minus' => 'basic elaboration document minus' ), 
			array( 'animated-basic_elaboration_document_next' => 'basic elaboration document next' ), 
			array( 'animated-basic_elaboration_document_noaccess' => 'basic elaboration document noaccess' ), 
			array( 'animated-basic_elaboration_document_note' => 'basic elaboration document note' ), 
			array( 'animated-basic_elaboration_document_pencil' => 'basic elaboration document pencil' ), 
			array( 'animated-basic_elaboration_document_picture' => 'basic elaboration document picture' ), 
			array( 'animated-basic_elaboration_document_plus' => 'basic elaboration document plus' ), 
			array( 'animated-basic_elaboration_document_previous' => 'basic elaboration document previous' ), 
			array( 'animated-basic_elaboration_document_refresh' => 'basic elaboration document refresh' ), 
			array( 'animated-basic_elaboration_document_remove' => 'basic elaboration document remove' ), 
			array( 'animated-basic_elaboration_document_search' => 'basic elaboration document search' ), 
			array( 'animated-basic_elaboration_document_star' => 'basic elaboration document star' ), 
			array( 'animated-basic_elaboration_document_upload' => 'basic elaboration document upload' ), 
			array( 'animated-basic_elaboration_folder_check' => 'basic elaboration folder check' ), 
			array( 'animated-basic_elaboration_folder_cloud' => 'basic elaboration folder cloud' ), 
			array( 'animated-basic_elaboration_folder_document' => 'basic elaboration folder document' ), 
			array( 'animated-basic_elaboration_folder_download' => 'basic elaboration folder download' ), 
			array( 'animated-basic_elaboration_folder_flagged' => 'basic elaboration folder flagged' ), 
			array( 'animated-basic_elaboration_folder_graph' => 'basic elaboration folder graph' ), 
			array( 'animated-basic_elaboration_folder_heart' => 'basic elaboration folder heart' ), 
			array( 'animated-basic_elaboration_folder_minus' => 'basic elaboration folder minus' ), 
			array( 'animated-basic_elaboration_folder_next' => 'basic elaboration folder next' ), 
			array( 'animated-basic_elaboration_folder_noaccess' => 'basic elaboration folder noaccess' ), 
			array( 'animated-basic_elaboration_folder_note' => 'basic elaboration folder note' ), 
			array( 'animated-basic_elaboration_folder_pencil' => 'basic elaboration folder pencil' ), 
			array( 'animated-basic_elaboration_folder_picture' => 'basic elaboration folder picture' ), 
			array( 'animated-basic_elaboration_folder_plus' => 'basic elaboration folder plus' ), 
			array( 'animated-basic_elaboration_folder_previous' => 'basic elaboration folder previous' ), 
			array( 'animated-basic_elaboration_folder_refresh' => 'basic elaboration folder refresh' ), 
			array( 'animated-basic_elaboration_folder_remove' => 'basic elaboration folder remove' ), 
			array( 'animated-basic_elaboration_folder_search' => 'basic elaboration folder search' ), 
			array( 'animated-basic_elaboration_folder_star' => 'basic elaboration folder star' ), 
			array( 'animated-basic_elaboration_folder_upload' => 'basic elaboration folder upload' ), 
			array( 'animated-basic_elaboration_mail_check' => 'basic elaboration mail check' ), 
			array( 'animated-basic_elaboration_mail_cloud' => 'basic elaboration mail cloud' ), 
			array( 'animated-basic_elaboration_mail_document' => 'basic elaboration mail document' ), 
			array( 'animated-basic_elaboration_mail_download' => 'basic elaboration mail download' ), 
			array( 'animated-basic_elaboration_mail_flagged' => 'basic elaboration mail flagged' ), 
			array( 'animated-basic_elaboration_mail_heart' => 'basic elaboration mail heart' ), 
			array( 'animated-basic_elaboration_mail_next' => 'basic elaboration mail next' ), 
			array( 'animated-basic_elaboration_mail_noaccess' => 'basic elaboration mail noaccess' ), 
			array( 'animated-basic_elaboration_mail_note' => 'basic elaboration mail note' ), 
			array( 'animated-basic_elaboration_mail_pencil' => 'basic elaboration mail pencil' ), 
			array( 'animated-basic_elaboration_mail_picture' => 'basic elaboration mail picture' ), 
			array( 'animated-basic_elaboration_mail_previous' => 'basic elaboration mail previous' ), 
			array( 'animated-basic_elaboration_mail_refresh' => 'basic elaboration mail refresh' ), 
			array( 'animated-basic_elaboration_mail_remove' => 'basic elaboration mail remove' ), 
			array( 'animated-basic_elaboration_mail_search' => 'basic elaboration mail search' ), 
			array( 'animated-basic_elaboration_mail_star' => 'basic elaboration mail star' ), 
			array( 'animated-basic_elaboration_mail_upload' => 'basic elaboration mail upload' ), 
			array( 'animated-basic_elaboration_message_check' => 'basic elaboration message check' ), 
			array( 'animated-basic_elaboration_message_dots' => 'basic elaboration message dots' ), 
			array( 'animated-basic_elaboration_message_happy' => 'basic elaboration message happy' ), 
			array( 'animated-basic_elaboration_message_heart' => 'basic elaboration message heart' ), 
			array( 'animated-basic_elaboration_message_minus' => 'basic elaboration message minus' ), 
			array( 'animated-basic_elaboration_message_note' => 'basic elaboration message note' ), 
			array( 'animated-basic_elaboration_message_plus' => 'basic elaboration message plus' ), 
			array( 'animated-basic_elaboration_message_refresh' => 'basic elaboration message refresh' ), 
			array( 'animated-basic_elaboration_message_remove' => 'basic elaboration message remove' ), 
			array( 'animated-basic_elaboration_message_sad' => 'basic elaboration message sad' ), 
			array( 'animated-basic_elaboration_smartphone_cloud' => 'basic elaboration smartphone cloud' ), 
			array( 'animated-basic_elaboration_smartphone_heart' => 'basic elaboration smartphone heart' ), 
			array( 'animated-basic_elaboration_smartphone_noaccess' => 'basic elaboration smartphone noaccess' ), 
			array( 'animated-basic_elaboration_smartphone_note' => 'basic elaboration smartphone note' ), 
			array( 'animated-basic_elaboration_smartphone_pencil' => 'basic elaboration smartphone pencil' ), 
			array( 'animated-basic_elaboration_smartphone_picture' => 'basic elaboration smartphone picture' ), 
			array( 'animated-basic_elaboration_smartphone_refresh' => 'basic elaboration smartphone refresh' ), 
			array( 'animated-basic_elaboration_smartphone_search' => 'basic elaboration smartphone search' ), 
			array( 'animated-basic_elaboration_tablet_cloud' => 'basic elaboration tablet cloud' ), 
			array( 'animated-basic_elaboration_tablet_heart' => 'basic elaboration tablet heart' ), 
			array( 'animated-basic_elaboration_tablet_noaccess' => 'basic elaboration tablet noaccess' ), 
			array( 'animated-basic_elaboration_tablet_note' => 'basic elaboration tablet note' ), 
			array( 'animated-basic_elaboration_tablet_pencil' => 'basic elaboration tablet pencil' ), 
			array( 'animated-basic_elaboration_tablet_picture' => 'basic elaboration tablet picture' ), 
			array( 'animated-basic_elaboration_tablet_refresh' => 'basic elaboration tablet refresh' ), 
			array( 'animated-basic_elaboration_tablet_search' => 'basic elaboration tablet search' ), 
			array( 'animated-basic_elaboration_todolist_2' => 'basic elaboration todolist_2' ), 
			array( 'animated-basic_elaboration_todolist_check' => 'basic elaboration todolist check' ), 
			array( 'animated-basic_elaboration_todolist_cloud' => 'basic elaboration todolist cloud' ), 
			array( 'animated-basic_elaboration_todolist_download' => 'basic elaboration todolist download' ), 
			array( 'animated-basic_elaboration_todolist_flagged' => 'basic elaboration todolist flagged' ), 
			array( 'animated-basic_elaboration_todolist_minus' => 'basic elaboration todolist minus' ), 
			array( 'animated-basic_elaboration_todolist_noaccess' => 'basic elaboration todolist noaccess' ), 
			array( 'animated-basic_elaboration_todolist_pencil' => 'basic elaboration todolist pencil' ), 
			array( 'animated-basic_elaboration_todolist_plus' => 'basic elaboration todolist plus' ), 
			array( 'animated-basic_elaboration_todolist_refresh' => 'basic elaboration todolist refresh' ), 
			array( 'animated-basic_elaboration_todolist_remove' => 'basic elaboration todolist remove' ), 
			array( 'animated-basic_elaboration_todolist_search' => 'basic elaboration todolist search' ), 
			array( 'animated-basic_elaboration_todolist_star' => 'basic elaboration todolist star' ), 
			array( 'animated-basic_elaboration_todolist_upload' => 'basic elaboration todolist upload' ),
		),
		'Ecommerce' => array(
			array( 'animated-ecommerce_bag' => 'ecommerce bag' ), 
			array( 'animated-ecommerce_bag_check' => 'ecommerce bag check' ), 
			array( 'animated-ecommerce_bag_cloud' => 'ecommerce bag cloud' ), 
			array( 'animated-ecommerce_bag_download' => 'ecommerce bag download' ), 
			array( 'animated-ecommerce_bag_minus' => 'ecommerce bag minus' ), 
			array( 'animated-ecommerce_bag_plus' => 'ecommerce bag plus' ), 
			array( 'animated-ecommerce_bag_refresh' => 'ecommerce bag refresh' ), 
			array( 'animated-ecommerce_bag_remove' => 'ecommerce bag remove' ), 
			array( 'animated-ecommerce_bag_search' => 'ecommerce bag search' ), 
			array( 'animated-ecommerce_bag_upload' => 'ecommerce bag upload' ), 
			array( 'animated-ecommerce_banknote' => 'ecommerce banknote' ), 
			array( 'animated-ecommerce_banknotes' => 'ecommerce banknotes' ), 
			array( 'animated-ecommerce_basket' => 'ecommerce basket' ), 
			array( 'animated-ecommerce_basket_check' => 'ecommerce basket check' ), 
			array( 'animated-ecommerce_basket_cloud' => 'ecommerce basket cloud' ), 
			array( 'animated-ecommerce_basket_download' => 'ecommerce basket download' ), 
			array( 'animated-ecommerce_basket_minus' => 'ecommerce basket minus' ), 
			array( 'animated-ecommerce_basket_plus' => 'ecommerce basket plus' ), 
			array( 'animated-ecommerce_basket_refresh' => 'ecommerce basket refresh' ), 
			array( 'animated-ecommerce_basket_remove' => 'ecommerce basket remove' ), 
			array( 'animated-ecommerce_basket_search' => 'ecommerce basket search' ), 
			array( 'animated-ecommerce_basket_upload' => 'ecommerce basket upload' ), 
			array( 'animated-ecommerce_bath' => 'ecommerce bath' ), 
			array( 'animated-ecommerce_cart' => 'ecommerce cart' ), 
			array( 'animated-ecommerce_cart_check' => 'ecommerce cart check' ), 
			array( 'animated-ecommerce_cart_cloud' => 'ecommerce cart cloud' ), 
			array( 'animated-ecommerce_cart_content' => 'ecommerce cart content' ), 
			array( 'animated-ecommerce_cart_download' => 'ecommerce cart download' ), 
			array( 'animated-ecommerce_cart_minus' => 'ecommerce cart minus' ), 
			array( 'animated-ecommerce_cart_plus' => 'ecommerce cart plus' ), 
			array( 'animated-ecommerce_cart_refresh' => 'ecommerce cart refresh' ), 
			array( 'animated-ecommerce_cart_remove' => 'ecommerce cart remove' ), 
			array( 'animated-ecommerce_cart_search' => 'ecommerce cart search' ), 
			array( 'animated-ecommerce_cart_upload' => 'ecommerce cart upload' ), 
			array( 'animated-ecommerce_creditcard' => 'ecommerce creditcard' ), 
			array( 'animated-ecommerce_diamond' => 'ecommerce diamond' ),
			array( 'animated-ecommerce_gift' => 'ecommerce gift' ), 
			array( 'animated-ecommerce_graph1' => 'ecommerce graph1' ), 
			array( 'animated-ecommerce_graph2' => 'ecommerce graph2' ), 
			array( 'animated-ecommerce_graph3' => 'ecommerce graph3' ), 
			array( 'animated-ecommerce_graph_decrease' => 'ecommerce graph decrease' ), 
			array( 'animated-ecommerce_graph_increase' => 'ecommerce graph increase' ),
			array( 'animated-ecommerce_megaphone' => 'ecommerce megaphone' ), 
			array( 'animated-ecommerce_money' => 'ecommerce money' ), 
			array( 'animated-ecommerce_naira' => 'ecommerce naira' ), 
			array( 'animated-ecommerce_pesos' => 'ecommerce pesos' ), 
			array( 'animated-ecommerce_pound' => 'ecommerce pound' ), 
			array( 'animated-ecommerce_receipt' => 'ecommerce receipt' ), 
			array( 'animated-ecommerce_receipt_bath' => 'ecommerce receipt bath' ), 
			array( 'animated-ecommerce_receipt_cent' => 'ecommerce receipt cent' ), 
			array( 'animated-ecommerce_receipt_dollar' => 'ecommerce receipt dollar' ), 
			array( 'animated-ecommerce_receipt_euro' => 'ecommerce receipt euro' ), 
			array( 'animated-ecommerce_receipt_franc' => 'ecommerce receipt franc' ), 
			array( 'animated-ecommerce_receipt_guarani' => 'ecommerce receipt guarani' ), 
			array( 'animated-ecommerce_receipt_kips' => 'ecommerce receipt kips' ), 
			array( 'animated-ecommerce_receipt_lira' => 'ecommerce receipt lira' ), 
			array( 'animated-ecommerce_receipt_tugrik' => 'ecommerce receipt tugrik' ), 
			array( 'animated-ecommerce_receipt_won' => 'ecommerce receipt won' ), 
			array( 'animated-ecommerce_receipt_yen2' => 'ecommerce receipt yen2' ), 
			array( 'animated-ecommerce_receipt_yen' => 'ecommerce receipt yen' ), 
			array( 'animated-ecommerce_recept_colon' => 'ecommerce recept colon' ), 
			array( 'animated-ecommerce_rublo' => 'ecommerce rublo' ), 
			array( 'animated-ecommerce_rupee' => 'ecommerce rupee' ), 
			array( 'animated-ecommerce_safe' => 'ecommerce safe' ), 
			array( 'animated-ecommerce_sale' => 'ecommerce sale' ), 
			array( 'animated-ecommerce_sales' => 'ecommerce sales' ), 
			array( 'animated-ecommerce_ticket' => 'ecommerce ticket' ), 
			array( 'animated-ecommerce_wallet' => 'ecommerce wallet' ),
		),
		'Music' => array(
			array( 'animated-music_beginning_button' => 'music beginning button' ), 
			array( 'animated-music_bell' => 'music bell' ), 
			array( 'animated-music_cd' => 'music cd' ), 
			array( 'animated-music_diapason' => 'music diapason' ), 
			array( 'animated-music_eject_button' => 'music eject button' ), 
			array( 'animated-music_end_button' => 'music end button' ), 
			array( 'animated-music_fastforward_button' => 'music fastforward button' ), 
			array( 'animated-music_headphones' => 'music headphones' ), 
			array( 'animated-music_ipod' => 'music ipod' ), 
			array( 'animated-music_loudspeaker' => 'music loudspeaker' ), 
			array( 'animated-music_microphone' => 'music microphone' ), 
			array( 'animated-music_microphone_old' => 'music microphone old' ), 
			array( 'animated-music_mixer' => 'music mixer' ), 
			array( 'animated-music_mute' => 'music mute' ), 
			array( 'animated-music_note_multiple' => 'music note multiple' ), 
			array( 'animated-music_note_single' => 'music note single' ), 
			array( 'animated-music_pause_button' => 'music pause button' ), 
			array( 'animated-music_play_button' => 'music play button' ), 
			array( 'animated-music_playlist' => 'music playlist' ), 
			array( 'animated-music_radio_ghettoblaster' => 'music radio ghettoblaster' ), 
			array( 'animated-music_radio_portable' => 'music radio portable' ), 
			array( 'animated-music_record' => 'music record' ), 
			array( 'animated-music_recordplayer' => 'music recordplayer' ), 
			array( 'animated-music_repeat_button' => 'music repeat button' ), 
			array( 'animated-music_rewind_button' => 'music rewind button' ), 
			array( 'animated-music_shuffle_button' => 'music shuffle button' ), 
			array( 'animated-music_stop_button' => 'music stop button' ), 
			array( 'animated-music_tape' => 'music tape' ), 
			array( 'animated-music_volume_down' => 'music volume down' ), 
			array( 'animated-music_volume_up' => 'music volume up' ), 
		),
		'Software' => array(
			array( 'animated-software-horizontal_align_left' => 'software horizontal align left' ), 
			array( 'animated-software_add_vectorpoint' => 'software add vectorpoint' ), 
			array( 'animated-software_box_oval' => 'software box oval' ), 
			array( 'animated-software_box_polygon' => 'software box polygon' ), 
			array( 'animated-software_box_rectangle' => 'software box rectangle' ), 
			array( 'animated-software_box_roundedrectangle' => 'software box roundedrectangle' ), 
			array( 'animated-software_character' => 'software character' ), 
			array( 'animated-software_crop' => 'software crop' ), 
			array( 'animated-software_eyedropper' => 'software eyedropper' ), 
			array( 'animated-software_font_allcaps' => 'software font allcaps' ), 
			array( 'animated-software_font_baseline_shift' => 'software font baseline shift' ), 
			array( 'animated-software_font_horizontal_scale' => 'software font horizontal scale' ), 
			array( 'animated-software_font_kerning' => 'software font kerning' ), 
			array( 'animated-software_font_leading' => 'software font leading' ), 
			array( 'animated-software_font_size' => 'software font size' ), 
			array( 'animated-software_font_smallcapital' => 'software font smallcapital' ), 
			array( 'animated-software_font_smallcaps' => 'software font smallcaps' ), 
			array( 'animated-software_font_strikethrough' => 'software font strikethrough' ), 
			array( 'animated-software_font_tracking' => 'software font tracking' ), 
			array( 'animated-software_font_underline' => 'software font underline' ), 
			array( 'animated-software_font_vertical_scale' => 'software font vertical scale' ), 
			array( 'animated-software_horizontal_align_center' => 'software horizontal align center' ), 
			array( 'animated-software_horizontal_align_right' => 'software horizontal align right' ), 
			array( 'animated-software_horizontal_distribute_center' => 'software horizontal distribute center' ), 
			array( 'animated-software_horizontal_distribute_left' => 'software horizontal distribute left' ), 
			array( 'animated-software_horizontal_distribute_right' => 'software horizontal distribute right' ), 
			array( 'animated-software_indent_firstline' => 'software indent firstline' ), 
			array( 'animated-software_indent_left' => 'software indent left' ), 
			array( 'animated-software_indent_right' => 'software indent right' ), 
			array( 'animated-software_lasso' => 'software lasso' ), 
			array( 'animated-software_layers1' => 'software layers1' ), 
			array( 'animated-software_layers2' => 'software layers2' ), 
			array( 'animated-software_layout-8boxes' => 'software layout 8boxes' ), 
			array( 'animated-software_layout' => 'software layout' ), 
			array( 'animated-software_layout_2columns' => 'software layout 2columns' ), 
			array( 'animated-software_layout_3columns' => 'software layout 3columns' ), 
			array( 'animated-software_layout_4boxes' => 'software layout 4boxes' ), 
			array( 'animated-software_layout_4columns' => 'software layout 4columns' ), 
			array( 'animated-software_layout_4lines' => 'software layout 4lines' ), 
			array( 'animated-software_layout_header' => 'software layout header' ), 
			array( 'animated-software_layout_header_2columns' => 'software layout header 2columns' ), 
			array( 'animated-software_layout_header_3columns' => 'software layout header 3columns' ), 
			array( 'animated-software_layout_header_4boxes' => 'software layout header 4boxes' ), 
			array( 'animated-software_layout_header_4columns' => 'software layout header 4columns' ), 
			array( 'animated-software_layout_header_complex2' => 'software layout header complex2' ), 
			array( 'animated-software_layout_header_complex3' => 'software layout header complex3' ), 
			array( 'animated-software_layout_header_complex4' => 'software layout header complex4' ), 
			array( 'animated-software_layout_header_complex' => 'software layout header complex' ), 
			array( 'animated-software_layout_header_sideleft' => 'software layout header sideleft' ), 
			array( 'animated-software_layout_header_sideright' => 'software layout header sideright' ), 
			array( 'animated-software_layout_sidebar_left' => 'software layout sidebar left' ), 
			array( 'animated-software_layout_sidebar_right' => 'software layout sidebar right' ), 
			array( 'animated-software_magnete' => 'software magnete' ), 
			array( 'animated-software_pages' => 'software pages' ), 
			array( 'animated-software_paintbrush' => 'software paintbrush' ), 
			array( 'animated-software_paintbucket' => 'software paintbucket' ), 
			array( 'animated-software_paintroller' => 'software paintroller' ), 
			array( 'animated-software_paragraph' => 'software paragraph' ), 
			array( 'animated-software_paragraph_align_left' => 'software paragraph align left' ), 
			array( 'animated-software_paragraph_align_right' => 'software paragraph align right' ), 
			array( 'animated-software_paragraph_center' => 'software paragraph center' ), 
			array( 'animated-software_paragraph_justify_all' => 'software paragraph justify all' ), 
			array( 'animated-software_paragraph_justify_center' => 'software paragraph justify center' ), 
			array( 'animated-software_paragraph_justify_left' => 'software paragraph justify left' ), 
			array( 'animated-software_paragraph_justify_right' => 'software paragraph justify right' ), 
			array( 'animated-software_paragraph_space_after' => 'software paragraph space after' ), 
			array( 'animated-software_paragraph_space_before' => 'software paragraph space before' ), 
			array( 'animated-software_pathfinder_exclude' => 'software pathfinder exclude' ), 
			array( 'animated-software_pathfinder_intersect' => 'software pathfinder intersect' ), 
			array( 'animated-software_pathfinder_subtract' => 'software pathfinder subtract' ), 
			array( 'animated-software_pathfinder_unite' => 'software pathfinder unite' ), 
			array( 'animated-software_pen' => 'software pen' ), 
			array( 'animated-software_pen_add' => 'software pen add' ), 
			array( 'animated-software_pen_remove' => 'software pen remove' ), 
			array( 'animated-software_pencil' => 'software pencil' ), 
			array( 'animated-software_polygonallasso' => 'software polygonallasso' ), 
			array( 'animated-software_reflect_horizontal' => 'software reflect horizontal' ), 
			array( 'animated-software_reflect_vertical' => 'software reflect vertical' ), 
			array( 'animated-software_remove_vectorpoint' => 'software remove vectorpoint' ), 
			array( 'animated-software_scale_expand' => 'software scale expand' ), 
			array( 'animated-software_scale_reduce' => 'software scale reduce' ), 
			array( 'animated-software_selection_oval' => 'software selection oval' ), 
			array( 'animated-software_selection_polygon' => 'software selection polygon' ), 
			array( 'animated-software_selection_rectangle' => 'software selection rectangle' ), 
			array( 'animated-software_selection_roundedrectangle' => 'software selection roundedrectangle' ), 
			array( 'animated-software_shape_oval' => 'software shape oval' ), 
			array( 'animated-software_shape_polygon' => 'software shape polygon' ), 
			array( 'animated-software_shape_rectangle' => 'software shape rectangle' ), 
			array( 'animated-software_shape_roundedrectangle' => 'software shape roundedrectangle' ), 
			array( 'animated-software_slice' => 'software slice' ), 
			array( 'animated-software_transform_bezier' => 'software transform bezier' ), 
			array( 'animated-software_vector_box' => 'software vector box' ), 
			array( 'animated-software_vector_composite' => 'software vector composite' ), 
			array( 'animated-software_vector_line' => 'software vector line' ), 
			array( 'animated-software_vertical_align_bottom' => 'software vertical align bottom' ), 
			array( 'animated-software_vertical_align_center' => 'software vertical align center' ), 
			array( 'animated-software_vertical_align_top' => 'software vertical align top' ), 
			array( 'animated-software_vertical_distribute_bottom' => 'software vertical distribute bottom' ), 
			array( 'animated-software_vertical_distribute_center' => 'software vertical distribute center' ), 
			array( 'animated-software_vertical_distribute_top' => 'software vertical distribute top' ),
		),
		'Weather' => array(
			array( 'animated-weather_aquarius' => 'weather aquarius' ), 
			array( 'animated-weather_aries' => 'weather aries' ), 
			array( 'animated-weather_cancer' => 'weather cancer' ), 
			array( 'animated-weather_capricorn' => 'weather capricorn' ), 
			array( 'animated-weather_cloud' => 'weather cloud' ), 
			array( 'animated-weather_cloud_drop' => 'weather cloud drop' ), 
			array( 'animated-weather_cloud_lightning' => 'weather cloud lightning' ), 
			array( 'animated-weather_cloud_snowflake' => 'weather cloud snowflake' ), 
			array( 'animated-weather_downpour_fullmoon' => 'weather downpour fullmoon' ), 
			array( 'animated-weather_downpour_halfmoon' => 'weather downpour halfmoon' ), 
			array( 'animated-weather_downpour_sun' => 'weather downpour sun' ), 
			array( 'animated-weather_drop' => 'weather drop' ), 
			array( 'animated-weather_first_quarter' => 'weather first quarter' ), 
			array( 'animated-weather_fog' => 'weather fog' ), 
			array( 'animated-weather_fog_fullmoon' => 'weather fog fullmoon' ), 
			array( 'animated-weather_fog_halfmoon' => 'weather fog halfmoon' ), 
			array( 'animated-weather_fog_sun' => 'weather fog sun' ), 
			array( 'animated-weather_fullmoon' => 'weather fullmoon' ), 
			array( 'animated-weather_gemini' => 'weather gemini' ), 
			array( 'animated-weather_hail' => 'weather hail' ), 
			array( 'animated-weather_hail_fullmoon' => 'weather hail fullmoon' ), 
			array( 'animated-weather_hail_halfmoon' => 'weather hail halfmoon' ), 
			array( 'animated-weather_hail_sun' => 'weather hail sun' ), 
			array( 'animated-weather_last_quarter' => 'weather last quarter' ), 
			array( 'animated-weather_leo' => 'weather leo' ), 
			array( 'animated-weather_libra' => 'weather libra' ), 
			array( 'animated-weather_lightning' => 'weather lightning' ), 
			array( 'animated-weather_mistyrain' => 'weather mistyrain' ), 
			array( 'animated-weather_mistyrain_fullmoon' => 'weather mistyrain fullmoon' ), 
			array( 'animated-weather_mistyrain_halfmoon' => 'weather mistyrain halfmoon' ), 
			array( 'animated-weather_mistyrain_sun' => 'weather mistyrain sun' ), 
			array( 'animated-weather_moon' => 'weather moon' ), 
			array( 'animated-weather_moondown_full' => 'weather moondown full' ), 
			array( 'animated-weather_moondown_half' => 'weather moondown half' ), 
			array( 'animated-weather_moonset_full' => 'weather moonset full' ), 
			array( 'animated-weather_moonset_half' => 'weather moonset half' ), 
			array( 'animated-weather_move2' => 'weather move2' ), 
			array( 'animated-weather_newmoon' => 'weather newmoon' ), 
			array( 'animated-weather_pisces' => 'weather pisces' ), 
			array( 'animated-weather_rain' => 'weather rain' ), 
			array( 'animated-weather_rain_fullmoon' => 'weather rain fullmoon' ), 
			array( 'animated-weather_rain_halfmoon' => 'weather rain halfmoon' ), 
			array( 'animated-weather_rain_sun' => 'weather rain sun' ), 
			array( 'animated-weather_sagittarius' => 'weather sagittarius' ), 
			array( 'animated-weather_scorpio' => 'weather scorpio' ), 
			array( 'animated-weather_snow' => 'weather snow' ), 
			array( 'animated-weather_snow_fullmoon' => 'weather snow fullmoon' ), 
			array( 'animated-weather_snow_halfmoon' => 'weather snow halfmoon' ), 
			array( 'animated-weather_snow_sun' => 'weather snow sun' ), 
			array( 'animated-weather_snowflake' => 'weather snowflake' ), 
			array( 'animated-weather_star' => 'weather star' ), 
			array( 'animated-weather_storm-11' => 'weather storm-11' ), 
			array( 'animated-weather_storm-32' => 'weather storm-32' ), 
			array( 'animated-weather_storm_fullmoon' => 'weather storm fullmoon' ), 
			array( 'animated-weather_storm_halfmoon' => 'weather storm halfmoon' ), 
			array( 'animated-weather_storm_sun' => 'weather storm sun' ), 
			array( 'animated-weather_sun' => 'weather sun' ), 
			array( 'animated-weather_sundown' => 'weather sundown' ), 
			array( 'animated-weather_sunset' => 'weather sunset' ), 
			array( 'animated-weather_taurus' => 'weather taurus' ), 
			array( 'animated-weather_tempest' => 'weather tempest' ), 
			array( 'animated-weather_tempest_fullmoon' => 'weather tempest fullmoon' ), 
			array( 'animated-weather_tempest_halfmoon' => 'weather tempest halfmoon' ), 
			array( 'animated-weather_tempest_sun' => 'weather tempest sun' ), 
			array( 'animated-weather_variable_fullmoon' => 'weather variable fullmoon' ), 
			array( 'animated-weather_variable_halfmoon' => 'weather variable halfmoon' ), 
			array( 'animated-weather_variable_sun' => 'weather variable sun' ), 
			array( 'animated-weather_virgo' => 'weather virgo' ), 
			array( 'animated-weather_waning_cresent' => 'weather waning cresent' ), 
			array( 'animated-weather_waning_gibbous' => 'weather waning gibbous' ), 
			array( 'animated-weather_waxing_cresent' => 'weather waxing cresent' ), 
			array( 'animated-weather_waxing_gibbous' => 'weather waxing gibbous' ), 
			array( 'animated-weather_wind' => 'weather wind' ), 
			array( 'animated-weather_wind_E' => 'weather wind_E' ), 
			array( 'animated-weather_wind_N' => 'weather wind_N' ), 
			array( 'animated-weather_wind_NE' => 'weather wind_NE' ), 
			array( 'animated-weather_wind_NW' => 'weather wind_NW' ), 
			array( 'animated-weather_wind_S' => 'weather wind_S' ), 
			array( 'animated-weather_wind_SE' => 'weather wind_SE' ), 
			array( 'animated-weather_wind_SW' => 'weather wind_SW' ), 
			array( 'animated-weather_wind_W' => 'weather wind_W' ), 
			array( 'animated-weather_wind_fullmoon' => 'weather wind fullmoon' ), 
			array( 'animated-weather_wind_halfmoon' => 'weather wind halfmoon' ), 
			array( 'animated-weather_wind_sun' => 'weather wind sun' ), 
			array( 'animated-weather_windgust' => 'weather windgust' ),
		)
	);

	
	return array_merge( $icons, $animated_icons );	
}
