<?php
  use Elementor\Group_Control_Image_Size;
  use Elementor\Icons_Manager;
  $this->add_render_attribute('block', 'class', ['image-flip-box' ]);

  $settings = $this->get_settings_for_display();
  if ( empty( $settings['title_text'] ) ) {
    return;
  }
  $title_text = $settings['title_text'];
  $sub_text = $settings['sub_text'];
  $back_sup_title_box = $settings['back_sub_text'];
  $back_description_text = $settings['back_description_text'];
   
  $this->add_render_attribute( 'title_text', 'class', 'title' );
  $this->add_render_attribute( 'back_description_text', 'class', 'desc' );


  $this->add_inline_editing_attributes( 'title_text', 'none' );
  $this->add_inline_editing_attributes( 'back_description_text' );

  $this->add_render_attribute('href', 'href', esc_url($settings['link']['url']));
if($settings['link']['is_external']) {
	$this->add_render_attribute('href', 'target', '_blank');
}
if(!empty($settings['link']['nofollow'])) {
	$this->add_render_attribute('href', 'rel', 'nofollow');
}?>





  <div class="image-flip-box" data-flip-direction="<?php echo esc_attr($settings['style']);?>" data-horizontal-align="center" data-vertical-align="center">


     <?php if (!empty($settings['image']['url'])) : 
        $image_url = $settings['image']['url']; 
        $image_scr = 'style="background-image:url('.esc_url($image_url).')"';
      endif; ?>
     <div class="image-flip-box__front-side bg_overlay_dark" data-is-bg-overlay="true" data-opacity-bg-overlay="0.5" <?php $this->mo_render_link_html($image_scr);  ?> >   
		  <div class="image-flip-box__content">
             <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
             <?php if( $settings['sub_text']) echo '<span class="sup_title">'.$settings['sub_text'].'</span>';  ?>
             <?php if( $settings['title_text']) echo '<h6>'.$settings['title_text'].'</h6>';  ?>
       </div>
    </div>
    

    <?php if (!empty($settings['back_image']['url'])) : 
        $back_image_url = $settings['back_image']['url']; 
        $back_image_scr = 'style="background-image:url('.esc_url($back_image_url).')"';
      endif; ?>
    <div class="image-flip-box__back-side bg_overlay_dark" data-is-bg-overlay="true" data-opacity-bg-overlay="0.5" <?php $this->mo_render_link_html($back_image_scr);  ?> >   
       <div class="image-flip-box__content">
          <?php if($back_sup_title_box) echo '<span class="sup_title">'.esc_html($back_sup_title_box).'</span>'; ?>
          <?php if( $settings['back_title_text']) echo '<h6>'.$settings['back_title_text'].'</h6>';  ?>
          <div <?php echo $this->get_render_attribute_string( 'back_description_text' ); ?>>
            <div class="content"><?php echo wp_kses($back_description_text, true); ?></div>
          </div>
          <?php if(!empty($settings['link']['url'])){ ?>
            <a class="button btn-txt text_center btn-txt-arrow light hr_primary" <?php $this->print_render_attribute_string('href') ?>>
              <span class="mo_module_button__container">
                <span class="mo_module_button__cover front"><span class="mo_btn_text front"> <?php echo esc_html($settings['link_text']);?></span></span>
                <svg class="svg-arrow" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 11.9 11.9" xml:space="preserve"><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path></svg>			
              </span>
            </a>
          <?php } ?>
        </div>
    </div>
</div>