<?php
if(!defined('ABSPATH')) {
	exit;
}
use Elementor\Utils;
$settings = array(
	'button_title'          => esc_html__('Button title', 'saga'),
	'link'                  => array(
		'url'         => '#',
		'is_external' => false,
		'nofollow'    => false,
	),
	'button_style_elementor'=> 'solid',
	'button_size_elementor' => 'medium',
	'button_alignment'      => 'center',
	'btn_border_rounded'    => false,
	'btn_icon'              => 'none',
	'icon_position'         => 'left',
	'button_icon'           => '',
	'image_size'            => array(
		'size' => 32,
		'unit' => 'px',
	),
	'image'                 => array(
		'url' => Utils::get_placeholder_image_src(),
	),
	'button_hover'            => 'none',
	'button_background'       => 'bg_dark',
	'button_background_hover' => 'bg_dark',
);
$settings = wp_parse_args($this->get_settings(), $settings);
$this->add_render_attribute('wrapper', 'class', 'text-'.$settings['button_alignment']);
$data_settings = array();
// but_style
$this->add_render_attribute('but_style', 'class', array(
	'button',
	'btn-'.$settings['button_style_elementor'],
	$settings['button_size_elementor'],
	'button_'.$settings['btn_icon'],
	'btn_icon_position_'.$settings['icon_position'],
	'text_'.$settings['button_alignment'],
	$settings['button_hover'],
	'btn-txt-'.$settings['button_plain_style'],
	'bg_'.$settings['button_background'],
	'bg_hr_'.$settings['button_background_hover'],

	$settings['button_title_color'],
	'hr_'.$settings['button_title_color_hover'],

	'outline_'.$settings['button_border'],
	'outline_hr_'.$settings['button_border_hover'],

	$settings['btn_border_rounded'] ? 'rounded' : '',
));
// border_style
$this->add_render_attribute('border_style', 'style', array(
	'border-width:'.$settings['btn_border_width'].';', 
	$settings['btn_border_rounded'] ? 'border-radius:'.$settings['btn_border_radius'] : '',
));
// Icon
$icon = '';
$text = '';
switch($settings['btn_icon']) {
	case 'default':
		$icon = '<span class="btn_icon_container"><span class="mo_btn_icon mo_icon_default"></span></span>';
		break;
	case 'icon':
		$icon = '<span style="font-size:'.esc_attr((int)$settings['icon_height']['size']).'px;" class="btn_icon_container"><span class="mo_btn_icon '.esc_attr($settings['button_icon']).'"></span></span>';
		break;
	case 'image':
		if(isset($settings['image']['id']) && (bool) $settings['image']['id']) {
			$image = wp_get_attachment_image_src($settings['image']['id'],'full');
			if($image) {
				$image_obj = wp_prepare_attachment_for_js($settings['image']['id']);
				if (strpos($image[0],'.svg') !== false) {
					$icon = '<span class="btn_icon_container"><span class="icon_svg_btn">'.file_get_contents($image[0]).'</span></span>';
				} else {
					$icon = '<span class="btn_icon_container"><img src="'.esc_url($settings['image']['url']) .'" alt="'.$image_obj['alt'].'" style="width:'.esc_attr((int)$settings['image_size']['size']).'px;" /></span>';
				}
			}
		}
		break;
	default:
		break;
}
$svg_underlined = '<svg width="16" height="16" viewBox="0 0 25 24" fill="none" xmlns="http://www.w3.org/2000/svg"><path d="M16.2802 11.28C16.4209 11.4205 16.5 11.6112 16.5002 11.81V12.19C16.4979 12.3884 16.419 12.5783 16.2802 12.72L11.1402 17.85C11.0463 17.9447 10.9185 17.9979 10.7852 17.9979C10.6518 17.9979 10.524 17.9447 10.4302 17.85L9.72017 17.14C9.6261 17.0478 9.57309 16.9217 9.57309 16.79C9.57309 16.6583 9.6261 16.5322 9.72017 16.44L14.1702 12L9.72017 7.56C9.62551 7.46612 9.57227 7.33832 9.57227 7.205C9.57227 7.07169 9.62551 6.94389 9.72017 6.85L10.4302 6.15C10.524 6.05535 10.6518 6.00211 10.7852 6.00211C10.9185 6.00211 11.0463 6.05535 11.1402 6.15L16.2802 11.28Z" fill="currentcolor"></path></svg>';
$svg_arrow = '<svg class="svg-arrow" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 11.9 11.9" xml:space="preserve"><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path></svg>';
$svg_arrow2 = '<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="30px" height="18px" viewBox="0 0 30 18" enable-background="new 0 0 30 18" xml:space="preserve"><path class="handle" d="M20.305,16.212c-0.407,0.409-0.407,1.071,0,1.479s1.068,0.408,1.476,0l7.914-7.952c0.408-0.409,0.408-1.071,0-1.481l-7.914-7.952c-0.407-0.409-1.068-0.409-1.476,0s-0.407,1.071,0,1.48l7.185,7.221L20.305,16.212z"></path><path class="bar" fill-rule="evenodd" clip-rule="evenodd" d="M1,8h28.001c0.551,0,1,0.448,1,1c0,0.553-0.449,1-1,1H1c-0.553,0-1-0.447-1-1C0,8.448,0.447,8,1,8z"></path></svg>';

if(!empty($settings['button_title'])) {
	$text = '<span class="mo_btn_text front">'.esc_html($settings['button_title']).'</span>';
}
if(!empty($settings['button_title']) && $settings['button_plain_style'] == 'underlined') {
	$text = '<span class="mo_btn_text front">'.esc_html($settings['button_title']).' '.$svg_underlined.'</span>';
}

$text2 = '<span class="mo_btn_text back">'.esc_html($settings['button_title']).'</span>';
$svg_text2 = '<span class="mo_btn_text back">'.esc_html($settings['button_title']).'  '.$svg_underlined.'</span>';

if( $settings['button_hover'] == 'roll') {
    $text = $text.$text2;
}
if( $settings['button_plain_style'] == 'underlined') {
    $text = $text.$svg_text2;
}



if( $settings['btn_parallax'] == 'yes' ) {
	$this->add_render_attribute('btn_parallax', 'data-mo', 'parallax');
}
if($settings['icon_position'] == 'left') {
	$text = $icon.$text;
} else {
	$text = $text.$icon;
}
if(empty($settings['link']['url'])) {
	$settings['link']['url'] = '#';
}
$this->add_render_attribute('href', 'href', esc_url($settings['link']['url']));
if($settings['link']['is_external']) {
	$this->add_render_attribute('href', 'target', '_blank');
}
if(!empty($settings['link']['nofollow'])) {
	$this->add_render_attribute('href', 'rel', 'nofollow');
}
?>
<div <?php $this->print_render_attribute_string('wrapper') ?>>
	<a <?php $this->print_render_attribute_string('but_style')?>  <?php $this->print_render_attribute_string('href') ?>  <?php $this->print_render_attribute_string('btn_parallax') ?> <?php $this->print_render_attribute_string('border_style') ?>>
		<span class="mo_module_button__container">
			<span class="mo_module_button__cover front"><?=$text?></span>
			<?php if($settings['button_plain_style'] == 'arrow') {  echo $svg_arrow; } ?>
			<?php if($settings['button_plain_style'] == 'arrow2') { ?><span class="arrows"><span class="arrow"><?php echo $svg_arrow2;?> <?php echo $svg_arrow2;?></span></span><?php } ?>
		</span>
	</a>
</div>