<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

/**
 * Elementor heading widget.
 *
 * Elementor widget that displays an eye-catching headlines.
 *
 * @since 1.0.0
 */
class MOElement_Process_Box extends MOElement_Base {
	
	/**
	 * Get widget name.
	 *
	 * Retrieve heading widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'mo-process_box';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve heading widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Process Box', 'saga' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve heading widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-archive-title';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'process box', 'block', 'action' ];
	}

	/**
	 * Register heading widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {
		$this->start_controls_section(
			'section_content',
			[
				'label' => __( 'Content', 'saga' ),
			]
		);
		$this->add_control(
			'style',
			[
				'label' => __( 'Style', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'options' => [
				'style1' => esc_html__('style1', 'saga'),            
                'style2' => esc_html__('style2', 'saga'),   
                'style3' => esc_html__('style3', 'saga'),   
                'style4' => esc_html__('style4', 'saga'),
				],
				'default' => 'style1',
			]
		);
		$this->add_control(
			'sub_title',
			[
				'label' => __( 'Step Title', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'Enter your Sub Title', 'saga' ),
				'default' => __( '1', 'saga' ),
				'label_block' => true,
			]
		);
		$this->add_control(
            'selected_icon',
            [
                'label' => __( 'Icon', 'saga' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
            ]
        );
		$this->add_control(
			'title_text',
			[
				'label' => __( 'Title', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your title', 'saga' ),
				'default' => __( 'Add Your Heading Text Here', 'saga' ),
				'label_block' => true
			]
		);
		$this->add_control(
			'description_text',
			[
				'label' => __( 'Description', 'saga' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Your Description', 'saga' ),
			]
		);
		$this->add_control(
			'button_url',
			[
				'label' => __( 'Button URL', 'saga' ),
				'type' => Controls_Manager::URL,
				'default' => [
					'url' => '#'
				]
			]
		);
  		$this->end_controls_section();

		$this->start_controls_section(
			'section_title_style',
			[
				'label' => __( 'Color', 'saga' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'color',
			[
				'label' => __( 'Process Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
				'{{WRAPPER}} .process-box-style1 .number-step:before, {{WRAPPER}} .process-box-style1:hover .number-step:after' => 'background: {{VALUE}};',
				'{{WRAPPER}} .process-box-style1 .process-wrap:after' => 'background: -webkit-linear-gradient(0,{{VALUE}} 0%,#e6eaef 77%);',
				'{{WRAPPER}} .process-box-style2 .number-icon-wrap .icon-wrap:before' => 'background: {{VALUE}}',
				'{{WRAPPER}} .process-box-style2 .number-icon-wrap .icon-wrap i' => 'color: {{VALUE}}',
				'{{WRAPPER}} .process-box-style3:before' => 'background: {{VALUE}}',
				'{{WRAPPER}} .process-box-style3 .icon-wrap i, {{WRAPPER}} .process-box-style3 .process-box-style3 h3' => 'color: {{VALUE}}',
				'{{WRAPPER}} .process-box-style4 .button.btn-txt-arrow svg.svg-arrow path' => 'stroke: {{VALUE}}',
				'{{WRAPPER}} .process-box-style4:hover .number-step h3' => 'color: {{VALUE}}',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render heading widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
         include $this->get_template('mo-process-box.php');
      print '</div>';
	}

	public function add_wpml_support() {
		add_filter( 'wpml_elementor_widgets_to_translate', [ $this, 'wpml_widgets_to_translate_filter' ] );
	}

	public function wpml_widgets_to_translate_filter( $widgets ) {
		$widgets[ $this->get_name() ] = [
			'conditions' => [ 'widgetType' => $this->get_name() ],
			'fields'     => [
				[
					'field'       => 'sub_title',
					'type'        => __( 'Sub Title', 'saga' ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'title_text',
					'type'        => __( 'Title', 'saga' ),
					'editor_type' => 'LINE'
				],
				[
					'field'       => 'description_text',
					'type'        => __( 'Description', 'saga' ),
					'editor_type' => 'LINE'
				],
			],
		];
		return $widgets;
	}
}
