<?php
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;

class MOElement_Button extends MOElement_Base{

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'mo-button';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Button', 'saga');
    }
    public function get_icon(){
        return 'eicon-button';
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {

      
        $this->start_controls_section(
            'basic',
            array(
                'label' => esc_html__('General', 'saga')
            )
        );
        
        $this->add_control(
            'button_title',
            array(
                'label'   => esc_html__('Button title', 'saga'),
                'type'    => Controls_Manager::TEXT,
                'default' => esc_html__('Button title', 'saga')
            )
        );
        
        $this->add_control(
            'link',
            array(
                'label'       => esc_html__('Button link', 'saga'),
                'type'        => Controls_Manager::URL,
                'description' => esc_html__('Add link to button.', 'saga'),
                'default'     => array(
                    'url'         => '#',
                    'is_external' => false,
                    'nofollow'    => false,
                ),
            )
        );
        $this->end_controls_section();
        


        //  style Section
        $this->start_controls_section(
        'icon_style',
        array(
            'label' => __( 'Button Style', 'saga' ),
            'tab'   => Controls_Manager::TAB_STYLE,
        )
        );
        $this->add_control(
            'button_style_elementor',
            array(
                'label'   => esc_html__('Button style', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'solid'   => esc_html__('Solid', 'saga'),
                    'border'  => esc_html__('Border', 'saga'),
                    'txt'     => esc_html__('Plain', 'saga'),
                ),
                'default' => 'solid',
            )
        );
        $this->add_control(
            'button_plain_style',
            array(
                'label'   => esc_html__('Plain Style', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'arrow'     => esc_html__('Effect 1', 'saga'),
                    'arrow2'    => esc_html__('Effect 2', 'saga'),
                    'arrow3'    => esc_html__('Effect 3', 'saga'),
                    'underlined'=> esc_html__('Effect 4', 'saga'),
                ),
                'condition'   => array(
                    'button_style_elementor' => 'txt',
                ),
            )
        );
        $this->add_control(
            'button_hover',
            array(
                'label'   => esc_html__('Hover Effect', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'linear'     => esc_html__('Effect 1 (Color)', 'saga'),
                    'roll'       => esc_html__('Effect 2 (roll)', 'saga'),
                    'scaleup'    => esc_html__('Effect 3 (scaleup)', 'saga'),
                    'hover-grow' => esc_html__('Effect 4 (grow)', 'saga'),
                    'slide'      => esc_html__('Effect 5 (slide)', 'saga'),
                    'effect-icon'=> esc_html__('Effect 6 (only with icon)', 'saga'),
                ),
                'default' => 'linear',
                'condition'   => array(
                    'button_style_elementor!' => 'txt',
                ),
            )
        );
        $this->add_control(
            'button_size_elementor',
            array(
                'label'   => esc_html__('Button size', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'small'  => esc_html__('Small', 'saga'),
                    'medium' => esc_html__('Medium', 'saga'),
                    'large'  => esc_html__('Large', 'saga'),
                ),
                'default' => 'medium',
                'condition'   => array(
                    'button_style_elementor!' => 'txt',
                ),
            )
        );
        $this->add_control(
            'button_alignment',
            [
                'label' => __( 'Alignment', 'saga' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __( 'Left', 'saga' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => __( 'Center', 'saga' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => __( 'Right', 'saga' ),
                        'icon' => 'fa fa-align-right',
                    ],
                ],
                'default' => 'center',
            ]
        );
        $this->add_control(
            'btn_border_width',
            array(
                'label'       => esc_html__('Button Border Width', 'saga'),
                'type'        => Controls_Manager::SELECT,
                'options'     => array(
                    '0'    => esc_html__('None', 'saga'),
                    '1px'  => esc_html__('1px', 'saga'),
                    '2px'  => esc_html__('2px', 'saga'),
                    '3px'  => esc_html__('3px', 'saga'),
                    '4px'  => esc_html__('4px', 'saga'),
                    '5px'  => esc_html__('5px', 'saga'),
                    '6px'  => esc_html__('6px', 'saga'),
                    '7px'  => esc_html__('7px', 'saga'),
                    '8px'  => esc_html__('8px', 'saga'),
                    '9px'  => esc_html__('9px', 'saga'),
                    '10px' => esc_html__('10px', 'saga'),
                ),
                'description' => esc_html__('Select button border width.', 'saga'),
                'default'     => '0px',
                'selectors'   => array(
                    '{{WRAPPER}}.widget-mo-core-button .mo_module_button_elementor a'                                                                     => 'border-width: {{VALUE}} !important;',
                    '{{WRAPPER}}.widget-mo-core-button .mo_module_button_elementor a.hover_type2 .mo_module_button__container .mo_module_button__cover' => 'border-width: {{VALUE}} !important;',
                ),
                'condition'   => array(
                    'button_style_elementor' => 'border',
                ),
            )
        );

        $this->add_control(
            'btn_parallax',
            array(
                'label'     => esc_html__('Parallax', 'saga'),
                'type'      => Controls_Manager::SWITCHER,
            )
        );
        
        $this->add_control(
            'btn_border_rounded',
            array(
                'label'     => esc_html__('Border Rounded', 'saga'),
                'type'      => Controls_Manager::SWITCHER,
                'condition' => array(
                    'button_style_elementor!' => 'txt',
                ),
            )
        );
        $this->add_control(
            'btn_border_radius',
            array(
                'label'       => esc_html__('Button Border Radius', 'saga'),
                'type'        => Controls_Manager::SELECT,
                'options'     => array(
                    'unset' => esc_html__('None', 'saga'),
                    '1px'   => esc_html__('1px', 'saga'),
                    '2px'   => esc_html__('2px', 'saga'),
                    '3px'   => esc_html__('3px', 'saga'),
                    '4px'   => esc_html__('4px', 'saga'),
                    '5px'   => esc_html__('5px', 'saga'),
                    '10px'  => esc_html__('10px', 'saga'),
                    '15px'  => esc_html__('15px', 'saga'),
                    '20px'  => esc_html__('20px', 'saga'),
                    '25px'  => esc_html__('25px', 'saga'),
                    '30px'  => esc_html__('30px', 'saga'),
                    '35px'  => esc_html__('35px', 'saga'),
                    '40px'  => esc_html__('40px', 'saga'),
                    '45px'  => esc_html__('45px', 'saga'),
                    '50px'  => esc_html__('50px', 'saga'),
                ),
                'default'     => 'unset',
                'selectors'   => array(
                    '{{WRAPPER}}.widget-mo-core-button .mo_module_button_elementor.rounded a'                                     => 'border-radius: {{VALUE}};',
                    '{{WRAPPER}}.widget-mo-core-button .mo_module_button_elementor .hover_type4 .mo_module_button__cover:before' => 'border-radius: {{VALUE}};',
                    '{{WRAPPER}}.widget-mo-core-button .mo_module_button_elementor .hover_type4 .mo_module_button__cover:after'  => 'border-radius: {{VALUE}};',
                ),
                'condition'   => array(
                    'button_style_elementor!'   => 'txt',
                    'btn_border_rounded!' => '',
                ),
            )
        );
        $this->end_controls_section();
        // End Icon style


         // Default style Section
        $this->start_controls_section(
            'style',
            array(
                'label' => esc_html__('Color', 'saga'),
                'tab'   => Controls_Manager::TAB_STYLE,
            )
        );
        
        $this->add_control(
            'button_style_header',
            array(
                'label' => esc_html__('Button', 'saga'),
                'type'  => Controls_Manager::HEADING,
            )
        );
        $this->start_controls_tabs('style_tabs');
        $this->start_controls_tab('default_tab',
            array(
                'label' => esc_html__('Default', 'saga'),
            )
        );
        $this->add_control(
            'button_background',
            array(
                'label'   => esc_html__('Background Color', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'dark'        => esc_html__('Dark', 'saga'),
                    'primary'     => esc_html__('Primary', 'saga'),
                    'light'       => esc_html__('Light', 'saga'),
                    'grey'        => esc_html__('Grey', 'saga'),
                    'transparent' => esc_html__('Transparent', 'saga'),
                    'custom'      => esc_html__('Custom', 'saga'),
                ),
                'default' => 'dark',
                'condition' => array(
                    'button_style_elementor!' => 'txt',
                ),
            )
        );
        $this->add_control(
			'button_custom_background',
			[
				'label' => __( 'Custom Background Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .button.bg_custom' => 'background: {{VALUE}};',
				],
                'condition' => array(
                    'button_background' => 'custom',
                ),
			]
		);
        $this->add_responsive_control(
            'button_title_color',
            array(
                'label'   => esc_html__('Title color', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'dark'      => esc_html__('Dark', 'saga'),
                    'primary'   => esc_html__('Primary', 'saga'),
                    'light'     => esc_html__('Light', 'saga'),
                    'grey'      => esc_html__('Grey', 'saga'),
                ),
                'default'     => 'light',
            )
        );
        $this->add_control(
            'button_border',
            array(
                'label'   => esc_html__('Border Color', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'dark'        => esc_html__('Dark', 'saga'),
                    'primary'     => esc_html__('Primary', 'saga'),
                    'light'       => esc_html__('Light', 'saga'),
                    'grey'        => esc_html__('Grey', 'saga'),
                ),
                'default' => 'dark',
                'condition'   => array(
                    'button_style_elementor' => 'border',
                ),
            )
        );

        $this->end_controls_tab();

         // Hover style Section
        $this->start_controls_tab('hover_tab',
            array(
                'label' => esc_html__('Hover', 'saga'),
            )
        );
        $this->add_control(
            'button_background_hover',
            array(
                'label'   => esc_html__('Background Color', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'dark'        => esc_html__('Dark', 'saga'),
                    'primary'     => esc_html__('Primary', 'saga'),
                    'light'       => esc_html__('Light', 'saga'),
                    'grey'        => esc_html__('Grey', 'saga'),
                    'custom'      => esc_html__('Custom', 'saga'),
                    'transparent' => esc_html__('Transparent', 'saga'),
                    'custom'      => esc_html__('Custom', 'saga'),
                ),
                'default' => 'dark',
                'condition' => array(
                    'button_style_elementor!' => 'txt',
                ),
            )
        );
        $this->add_control(
			'button_custom_background_hover',
			[
				'label' => __( 'Custom Background Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .button.bg_custom:hover' => 'background: {{VALUE}};',
				],
                'condition' => array(
                    'button_background_hover' => 'custom',
                ),
			]
		);
        $this->add_responsive_control(
            'button_title_color_hover',
            array(
                'label'       => esc_html__('Title color', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'dark'      => esc_html__('Dark', 'saga'),
                    'primary'   => esc_html__('Primary', 'saga'),
                    'light'     => esc_html__('Light', 'saga'),
                    'grey'      => esc_html__('Grey', 'saga'),
                ),
                'default'     => 'light',
            )
        );
        $this->add_responsive_control(
            'button_border_hover',
            array(
                'label'       => esc_html__('Border color', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'dark'      => esc_html__('Dark', 'saga'),
                    'primary'   => esc_html__('Primary', 'saga'),
                    'light'     => esc_html__('Light', 'saga'),
                    'grey'      => esc_html__('Grey', 'saga'),
                ),
                'default'     => 'primary',
                'condition'   => array(
                    'button_style_elementor' => 'border',
                ),
            )
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();




         // Icon Section
         $this->start_controls_section(
			'icon_section',
			array(
				'label' => __( 'Button Icon', 'saga' ),
                'tab'   => Controls_Manager::TAB_STYLE,
			)
		);

        $this->add_control(
            'btn_icon',
            array(
                'label'   => esc_html__('Button Icon', 'saga'),
                'type'    => Controls_Manager::SELECT,
                'options' => array(
                    'none'    => esc_html__('None', 'saga'),
                    'default' => esc_html__('Default', 'saga'),
                    'icon'    => esc_html__('Icon', 'saga'),
                    'image'   => esc_html__('Image', 'saga'),
                ),
                'default' => 'none',
            )
        );
        
        $this->add_control(
            'icon_position',
            array(
                'label'     => esc_html__('Icon position', 'saga'),
                'type'      => Controls_Manager::SELECT,
                'options'   => array(
                    'left'  => esc_html__('Left', 'saga'),
                    'right' => esc_html__('Right', 'saga'),
                ),
                'default'   => 'left',
                'condition' => array(
                    'btn_icon!' => 'none',
                ),
            )
        );
        
        $this->add_control(
            'button_icon',
            array(
                'label'     => esc_html__('Icon:', 'saga'),
                'type'      => Controls_Manager::ICON,
                'condition' => array(
                    'btn_icon' => 'icon',
                ),
            )
        );
        
        $this->add_control(
            'image_size',
            array(
                'label'      => esc_html__('Image Width', 'saga'),
                'type'       => Controls_Manager::SLIDER,
                'default'    => array(
                    'size' => 32,
                    'unit' => 'px',
                ),
                'range'      => array(
                    'px' => array(
                        'min'  => 8,
                        'max'  => 64,
                        'step' => 1,
                    ),
                ),
                'size_units' => array( 'px' ),
                'condition'  => array(
                    'btn_icon' => 'image'
                ),
                'selectors'  => array(
                    '{{WRAPPER}}.widget-mo-core-button .mo_module_button_elementor.button_icon_image .elementor_btn_icon_container img' => 'width: {{SIZE}}{{UNIT}}; height: auto;',
                    '{{WRAPPER}}.widget-mo-core-button .icon_svg_btn'                                                                    => 'width: {{SIZE}}{{UNIT}};',
                ),
            )
        );
        
        $this->add_responsive_control(
            'icon_height',
            array(
                'label'      => esc_html__('Icon Size', 'saga'),
                'type'       => Controls_Manager::SLIDER,
                'default'    => array(
                    'size' => 1,
                    'unit' => 'em',
                ),
                'range'      => array(
                    'px'  => array(
                        'min'  => 8,
                        'max'  => 30,
                        'step' => 1,
                    ),
                ),
                'size_units' => array( 'px' ),
                'condition'  => array(
                    'btn_icon' => 'icon',
                ),
                'selectors'  => array(
                    '{{WRAPPER}}.widget-mo-core-button .mo_module_button_elementor.button_icon_icon:not(.hover_type2) .elementor_mo_btn_icon'                                                                                                 => 'font-size: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}}.widget-mo-core-button .widget-mo-addon-advanced-button .mo_module_button_elementor.button_icon_icon a.hover_type2 .mo_module_button__cover .elementor_btn_icon_container .elementor_mo_btn_icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ),
            )
        );

        $this->add_control(
            'image',
            array(
                'label'     => esc_html__('Button Image', 'saga'),
                'type'      => Controls_Manager::MEDIA,
                'default'   => array(
                    'url' => Utils::get_placeholder_image_src(),
                ),
                'condition' => array(
                    'btn_icon' => 'image'
                ),
            )
        );
        $this->end_controls_section();
        // End Icon Section


    }
    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
      $settings = $this->get_settings_for_display();
      printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
      include $this->get_template('mo-button.php');
      print '</div>';
    }
}