<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
/**
 * Elementor icon box widget.
 *
 * Elementor widget that displays an icon, a headline and a text.
 *
 * @since 1.0.0
 */
class MOElement_Accordion extends MOElement_Base {  

	/**
	 * Get widget name.
	 *
	 * Retrieve icon box widget name.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'mo-accordion';
	}

	/**
	 * Get widget title.
	 *
	 * Retrieve icon box widget title.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Accordion', 'saga' );
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve icon box widget icon.
	 *
	 * @since 1.0.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-accordion';
	}

	/**
	 * Get widget keywords.
	 *
	 * Retrieve the list of keywords the widget belongs to.
	 *
	 * @since 2.1.0
	 * @access public
	 *
	 * @return array Widget keywords.
	 */
	public function get_keywords() {
		return [ 'accordion', 'box' ];
	}

	public function get_script_depends() {
		return [
		   'accordionjs',
		];
	 }
	/**
	 * Register icon box widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function register_controls() {

		//Content Service box
		$this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Accordions', 'saga' ),
			]
		);
		$this->add_control(
            'style',
            array(
                'label'   => esc_html__( 'Style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style1',
                'options' => [
                  'style1' => esc_html__('Style 1', 'saga'),
                  'style2' => esc_html__('Style 2', 'saga'),
                  'style3' => esc_html__('Style 3', 'saga'),
                  'style4' => esc_html__('Style 4', 'saga')
                ]
            )
        );
		$repeater = new \Elementor\Repeater();
		$repeater->add_control(
			'acc_title',
			[
				'label' => __( 'Title & Content', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Accordion Title', 'saga' ),
				'placeholder' => __( 'Accordion Title', 'saga' ),
				'label_block' => true,
			]
		);
		$repeater->add_control(
			'acc_content',
			[
				'label' => __( 'Content', 'saga' ),
				'default' => __( 'Accordion Content', 'saga' ),
				'placeholder' => __( 'Accordion Content', 'saga' ),
				'type' => Controls_Manager::TEXTAREA,
				'show_label' => false,
			]
		);
		$this->add_control(
			'mo_accs',
			[
				'label' => __( 'Accordion Items', 'saga' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'acc_title' => __( 'Accordion #1', 'saga' ),
						'acc_content' => __( 'Find the right font in the huge Google Font Library, then adjust size, color, line height, font weight, letter spacin The theme will only load the font and weights variant you choosed. Find the right font in the huge Google Font Library, then adjust size, color, line height, font weight', 'saga' ),
					],
					[
						'acc_title' => __( 'Accordion #2', 'saga' ),
						'acc_content' => __( 'Find the right font in the huge Google Font Library, then adjust size, color, line height, font weight, letter spacin The theme will only load the font and weights variant you choosed. Find the right font in the huge Google Font Library, then adjust size, color, line height, font weight', 'saga' ),
					],
				],
				'title_field' => '{{{ acc_title }}}',
			]
		);
		$this->end_controls_section();

		//Style
		$this->start_controls_section(
			'style_section',
			[
				'label' => __( 'Accordions', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'accs_space',
			[
				'label' => __( 'Spacing', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .accordionjs li' => 'margin-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'accs_border',
				'selector' => '{{WRAPPER}} .accordionjs li',
			]
		);
		$this->add_control(
			'accs_radius',
			[
				'label' => __( 'Border Radius', 'saga' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .accordionjs li' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

		//Title
		$this->start_controls_section(
			'style_title',
			[
				'label' => __( 'Title', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'title_color',
			[
				'label' => __( 'Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .acc_section:not(.acc_active) .acc_head h6' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'title_color_active',
			[
				'label' => __( 'Color Active', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .acc_section.acc_active .acc_head h6' => 'color: {{VALUE}};',
				]
			]
		);
		$this->end_controls_section();

		//Title
		$this->start_controls_section(
			'style_content',
			[
				'label' => __( 'Content', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'content_color',
			[
				'label' => __( 'Font Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .acc_content' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_responsive_control(
			'content_padding',
			[
				'label' => __( 'Padding', 'saga' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', 'em', '%' ],
				'selectors' => [
					'{{WRAPPER}} .acc_content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
	}

	/**
	 * Render icon box widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
         include $this->get_template('mo-accordion.php');
      print '</div>';
	}
}