<?php
add_action( 'widgets_init', 'Widget_Logo_widget' );
function Widget_Logo_widget() {
	register_widget( 'Widget_Logo' );
}
class Widget_Logo extends WP_Widget {
	 function __construct() {
		parent::__construct(
			'logo-widget', // Base ID
			esc_html__( 'Saga - Logo', 'saga'), // Name
			array('description' => esc_html__('Display Post on your site.', 'saga'),) // Args
        );
		function widget_logo_scripts() {
			wp_enqueue_media();
			wp_enqueue_script('widget_logo_scripts', SAGA_JS . 'widgets.js');
		}
		add_action('admin_enqueue_scripts','widget_logo_scripts');
	}
	function widget( $args, $instance ) {
		extract( $args );
		$Logo_img        = esc_attr($instance['Logo_img']);
		$logo_image_id   = esc_attr($instance['logo_image_id']);
		$Logo_img_w      = esc_attr($instance['Logo_img_w']);
		$logo_image_w_id = esc_attr($instance['logo_image_w_id']);
		$Logo_content    = $instance['Logo_content'];
		$logo_size       = $instance['logo_size'];
		echo $before_widget;
		if (isset($instance['logo_size'])) { $logo_size = $instance['logo_size']; } else { $logo_size = "sm-logo"; }
		$printOutlogo = $printOutlogo_w ='';
		if(!empty($Logo_img)) { $printOutlogo = '<a href="'. esc_url(home_url('/')).'"><img class="logo_dark '.($logo_size).'" src="'.$Logo_img.'" alt="logo"></a>'; }
		if(!empty($Logo_img_w)) { $printOutlogo_w = '<a href="'. esc_url(home_url('/')).'"><img class="Logo_white '.($logo_size).'" src="'.$Logo_img_w.'" alt="logo"></a>';}
		$printOut = '
		  <div class="widget-content">
			<div class="widget-logo">
			   '.$printOutlogo.' 
			   '.$printOutlogo_w.'
				<div class="widget-logo-detail"><p>'.($Logo_content).'</p></div>
			</div>
		 </div>';
		echo $printOut;
		echo $after_widget;
	}
	function update( $new_instance, $old_instance ) {
		$instance                    = $old_instance;
		$instance['Logo_content']    = $new_instance['Logo_content'];
		$instance['logo_size']       = $new_instance['logo_size'];
		$instance['Logo_img']        = $new_instance['Logo_img'];
		$instance['Logo_img_w']      = $new_instance['Logo_img_w'];
		$instance['logo_image_id']   = $new_instance['logo_image_id'];
		$instance['logo_image_w_id'] = $new_instance['logo_image_w_id'];
		return $instance;
	}
	function form( $instance ) {
		$defaults = array( 'Logo_title' => 'Logo Widget' );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>
		<p>
			<label for="<?php echo $this->get_field_id( 'Logo_img' ); ?>"><?php esc_html_e('Dark Logo URL :', 'saga');?></label>
			<input id="<?php echo $this->get_field_id( 'Logo_img' ); ?>" name="<?php echo $this->get_field_name( 'Logo_img' ); ?>" value="<?php echo (isset($instance['Logo_img'])?$instance['Logo_img']:"");?>" class="widefat custom_media_url_post" type="text">
			<input type="button" value="<?php esc_html_e('Upload Dark Logo', 'saga') ?>" class="button custom_media_upload_post" id="custom_image_uploader_logo"/>
			<input id="<?php echo $this->get_field_id( 'logo_image_id' ); ?>" name="<?php echo $this->get_field_name( 'logo_image_id' ); ?>" value="<?php echo (isset($instance['logo_image_id'])?$instance['logo_image_id']:"");?>" class="widefat logo_image_id" type="hidden">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'Logo_img_w' ); ?>"><?php esc_html_e('White Logo URL :', 'saga');?></label>
			<input id="<?php echo $this->get_field_id( 'Logo_img_w' ); ?>" name="<?php echo $this->get_field_name( 'Logo_img_w' ); ?>" value="<?php echo (isset($instance['Logo_img_w'])?$instance['Logo_img_w']:"");?>" class="widefat custom_media_url_logo" type="text">
			<input type="button" value="<?php esc_html_e('Upload White Logo', 'saga') ?>" class="button custom_media_upload_loga" id="custom_image_w_uploader_logo"/>
			<input id="<?php echo $this->get_field_id( 'logo_image_w_id' ); ?>" name="<?php echo $this->get_field_name( 'logo_image_w_id' ); ?>" value="<?php echo (isset($instance['logo_image_w_id'])?$instance['logo_image_w_id']:"");?>" class="widefat logo_image_id" type="hidden">
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'Logo_content' ); ?>"><?php esc_html_e('Post content:', 'saga');?></label>
			<textarea id="<?php echo $this->get_field_id( 'Logo_content' ); ?>" name="<?php echo $this->get_field_name( 'Logo_content' ); ?>" class="widefat"><?php echo (isset($instance['Logo_content'])?esc_attr($instance['Logo_content']):""); ?></textarea>
		</p>
		<p>
			<label for="<?php echo esc_attr($this->get_field_id('logo_size')); ?>"><?php esc_html_e('Logo size', 'saga'); ?></label>
			<select class="widefat" id="<?php echo esc_attr($this->get_field_id('logo_size')); ?>" name="<?php echo esc_attr($this->get_field_name('logo_size')); ?>">
				<option <?php if ($logo_size == 'sm-logo'){ echo 'selected="selected"'; } ?> value="sm-logo"><?php esc_html_e('Small', 'saga'); ?></option>
				<option <?php if ($logo_size == 'md-logo'){ echo 'selected="selected"'; } ?> value="md-logo"><?php esc_html_e('Middle', 'saga'); ?></option>
				<option <?php if ($logo_size == 'lg-logo'){ echo 'selected="selected"'; } ?> value="lg-logo"><?php esc_html_e('Large', 'saga'); ?></option>
			</select>
		</p>
	<?php
	}
}