<?php
   if (!defined('ABSPATH')) {
      exit; // Exit if accessed directly.
   }
   use Elementor\Group_Control_Image_Size;
?>
   
<?php if( $settings['style'] == 'style-1' ){ 
   $this->add_render_attribute('wrapper', 'class', ['mo-testimonial-carousel mo-testimonial' , $settings['style'] , $settings['style_carousel']]);
   $this->add_render_attribute('carousel', 'class', ['init-carousel-owl owl-carousel']);
?>
  
<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
  <div <?php echo $this->get_render_attribute_string('carousel') ?> <?php echo $this->get_carousel_settings() ?>>
      <?php foreach ($settings['testimonials'] as $testimonial): ?>
      <?php $avatar = (isset($testimonial['testimonial_image']['url']) && $testimonial['testimonial_image']['url']) ? $testimonial['testimonial_image']['url'] : ''; ?>
      <div class="item testimonial-item">

         <?php $has_avatar = ! empty( $testimonial['testimonial_image']['url']); ?>
         <?php if ( $has_avatar ){ ?>
            <div class="top testimonial-avatar"><figure><img src="<?php echo esc_url($avatar) ?>" alt="<?php echo $testimonial['testimonial_name']; ?>"/></figure></div>
         <?php } ?>

         <div class="testimonial-details">
               <div class="testimonial-meta testimonial-content clearfix">
                  <svg xmlns="http://www.w3.org/2000/svg" class="quote" width="31" height="23" viewBox="0 0 31 23"><path fill="none" stroke="currentColor" d="m.988 20.124-.148.303.226.251.844.938.232.258.323-.128c2.229-.879 4.953-1.59 8.18-2.128l.367-.061.047-.37a42.957 42.957 0 0 1 1.112-5.746v-.001A46.697 46.697 0 0 1 13.964 8c.43-1.068 1.174-2.69 2.236-4.875l.174-.358-.31-.25-1.125-.906-.251-.203-.288.145-3.969 2-.118.06-.073.11C8.71 6.028 7.13 8.633 5.5 11.538a171.37 171.37 0 0 0-4.513 8.587Zm13.437.003-.143.296.215.248.813.938.23.266.33-.128c2.25-.88 4.976-1.591 8.182-2.129l.363-.06.05-.366c.267-1.98.649-3.897 1.143-5.75v-.002a46.71 46.71 0 0 1 1.794-5.442l.002-.006c.408-1.06 1.15-2.679 2.232-4.864l.178-.36-.313-.251-1.125-.906-.25-.202-.287.144-4 2-.12.06-.075.113c-1.507 2.302-3.085 4.905-4.735 7.808l-.001.003a154.8 154.8 0 0 0-4.484 8.59Z"></path></svg>
                  <div class="content">
                     <?php mo_get_rating( 'rate-5', $testimonial['rating'] ) ?>
                     <?php if($testimonial['testimonial_title']) echo'<h4>'.$testimonial['testimonial_title'].'</h4>'; 
                     if($testimonial['testimonial_content']) echo'<p>'.$testimonial['testimonial_content'].'</p>'; ?>
                  </div><!-- content  --> 
               </div><!-- testimonial-meta  --> 
               <div class="testimonial-title">
                  <?php if ( $has_avatar ){ ?>
                     <div class="sec testimonial-avatar"><figure><img src="<?php echo esc_url($avatar) ?>" alt="<?php echo $testimonial['testimonial_name']; ?>"/></figure></div>
                  <?php } ?>
                  <?php if($testimonial['testimonial_name']) echo '<h5 data-title="'.esc_html($testimonial['testimonial_name']).'"><span>'.esc_html($testimonial['testimonial_name']).'</span></h5>'; ?>
                  <?php if($testimonial['testimonial_job']) echo '<h6>'.$testimonial['testimonial_job'].'</h6>'; ?>
               </div><!-- testimonial-title --> 
         </div><!-- testimonial-details  --> 
       </div><!-- testimonial-item  --> 
      <?php endforeach; ?>
   </div>
</div>
   <?php
}