<?php
  use Elementor\Group_Control_Image_Size;

  $settings = $this->get_settings_for_display();
  $title_text = $settings['title_text'];
  $this->add_render_attribute( 'block', 'class', [ 'mo-circle', 'text-' . $settings['align'] ] );
  $this->add_render_attribute('link', 'class', 'mo-text-circle');

  $html_tags = 'span';
  if ( ! empty( $settings['link']['url'] ) ) {
    $html_tags = 'a';
    $this->add_render_attribute( 'link', 'href', $settings['link']['url'] );
    if ( $settings['link']['is_external'] ) {
      $this->add_render_attribute( 'link', 'target', '_blank' );
    }
    if ( $settings['link']['nofollow'] ) {
      $this->add_render_attribute( 'link', 'rel', 'nofollow' );
    }
  }
  if($title_text){
    $this->add_render_attribute('link', 'title', $title_text);
    $this->add_render_attribute('link', 'rel', $title_text);
  }
?>
      
  <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
    <?php if (!empty($settings['title_text'])) : ?>
      <<?php echo $html_tags ?> <?php echo $this->get_render_attribute_string( 'link' ) ?>>
        <div class="mo-circle-box">
          <div class="mo-circle-icon"><i class="fas fa-arrow-right"></i></div>
          <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" version="1.1" viewBox="0 0 200 200">
            <defs> <path d="M0, 100a100, 100 0 1, 0 200, 0a100, 100 0 1, 0 -200, 0" id="txt-path"></path></defs>
            <text><textPath startOffset="0" xlink:href="#txt-path"><?php echo esc_attr($settings['title_text']) ?></textPath></text>
          </svg>
        </div>
      </<?php echo $html_tags ?>>

    <?php endif; ?>
  </div>
