<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;

/**
 * Class MOElement_Posts_Grid
 */
class MOElement_Portfolio extends MOElement_Base{

    public function get_name() {
        return 'mo-portfolio';
    }
    public function get_title() {
        return __('Portfolio', 'saga');
    }
    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-gallery-grid';
    }

    public function get_keywords() {
        return [ 'portfolio', 'content', 'carousel', 'grid' ];
    }

    public function get_script_depends() {
      return [
          'jquery.isotope',
          'saga.elements',
      ];
    }
    protected function register_controls() {
        $this->start_controls_section(
            'section_query',
            [
                'label' => __('Query & Layout', 'saga'),
                'tab'   => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
			'project_cat',
			[
				'label' => __( 'Select Categories', 'saga' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $this->select_param_cate_project(),
				'multiple' => true,
				'label_block' => true,
				'placeholder' => __( 'All Categories', 'saga' ),
			]
		);
		$this->add_control(
			'filter',
			[
				'label' => __( 'Show Filter', 'saga' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'saga' ),
				'label_off' => __( 'Hide', 'saga' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);
		$this->add_control(
			'all_text',
			[
				'label' => __( 'All Text', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'All',
				'condition' => [
					'filter' => 'yes',
				],
			]
		);
		$this->add_control(
			'column',
			[
				'label' => __( 'Columns', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => '3',
				'options' => [
					'2'  	=> __( '2 Column', 'saga' ),
					'3' 	=> __( '3 Column', 'saga' ),
					'4' 	=> __( '4 Column', 'saga' ),
					'5' 	=> __( '5 Column', 'saga' ),
				],
			]
		);		
		$this->add_responsive_control(
			'w_gaps',
			[
				'label' => __( 'Gap Width', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .project-item' => 'padding: calc({{SIZE}}{{UNIT}}/2);',
					'{{WRAPPER}} .projects-grid' => 'margin: calc(-{{SIZE}}{{UNIT}}/2);',
				],
			]
		);
		$this->add_control(
			'project_num',
			[
				'label' => __( 'Show Number Projects', 'saga' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '9',
			]
		);		
		$this->add_control(
			'layout',
			[
				'label' => __( 'Layout Style', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'style-1',
				'options' => [
					'style-1'  	=> __( 'Grid', 'saga' ),
					'style-2' 	=> __( 'Masonry', 'saga' ),
				],
			]
		);
		$this->add_control(
			'style',
			[
				'label' => __( 'Hover Style', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'effect1',
				'options' => [
					'effect1'  	=> __( 'Effect 1', 'saga' ),
					'effect2'  	=> __( 'Effect 2', 'saga' ),
					'effect3'  	=> __( 'Effect 3', 'saga' ),
					'effect4'  	=> __( 'Effect 4', 'saga' ),
				],
			]
		);

		$this->add_responsive_control(
			'image_height',
			[
				'label' => __( 'Height', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 200,
						'max' => 700,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .portfolio-effect1 .img-inner, {{WRAPPER}} .portfolio-effect2 .img-inner, {{WRAPPER}} .portfolio-effect3 .wrapper, {{WRAPPER}} .portfolio-effect4 .img-inner' => 'height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'layout' => 'style-1',
				]
			]
		);
		$this->end_controls_section();

		//Style
		$this->start_controls_section(
			'filter_style_section',
			[
				'label' => __( 'Filter', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
				'condition' => [
					'filter' => 'yes',
				]
			]
		);
		$this->add_responsive_control(
			'filter_align',
			[
				'label' => __( 'Alignment', 'saga' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => __( 'Left', 'saga' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'saga' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'saga' ),
						'icon' => 'fa fa-align-right',
					]
				],
				'selectors' => [
					'{{WRAPPER}} .project_filters' => 'text-align: {{VALUE}};',
				],
				'default' => '',
			]
		);
		$this->add_responsive_control(
			'filter_spacing',
			[
				'label' => __( 'Spacing', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 200,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .project_filters a' => 'margin-left: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'filter_color',
			[
				'label' => __( 'Text Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project_filters li a' => 'color: {{VALUE}};',
					'{{WRAPPER}} .project_filters li a:after' => 'background-color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'filter_hcolor',
			[
				'label' => __( 'Text Hover Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .project_filters li a:hover, {{WRAPPER}} .project_filters li a.selected, {{WRAPPER}} .project_filters:hover a:before, {{WRAPPER}} .project_filters a:hover, {{WRAPPER}} .project_filters li a:hover' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_group_control(
            \Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'filter_typography',
				'selector' => '{{WRAPPER}} .project_filters li a',
			]
		);
		$this->end_controls_section();

		$this->start_controls_section(
			'overlay_style_section',
			[
				'label' => __( 'Content', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'overlay_align',
			[
				'label' => __( 'Alignment', 'saga' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => __( 'Left', 'saga' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'saga' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'saga' ),
						'icon' => 'fa fa-align-right',
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .portfolio-effect1 .caption-inner, {{WRAPPER}} .portfolio-effect2 .content-block, {{WRAPPER}} .portfolio-effect3 .details, {{WRAPPER}} .portfolio-effect4 .perspective-caption' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'overlay_bg_color',
			[
				'label' => __( 'Overlay Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-effect1 .img-inner .img-portfolio:before, {{WRAPPER}} .portfolio-effect2 .img-inner:before, {{WRAPPER}} .portfolio-effect3 .details, {{WRAPPER}} .portfolio-effect4 .img-inner .img-perspective:before' => 'background: {{VALUE}};',
				],
			]
		);
		//Title
		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'saga' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'title_spacing',
			[
				'label' => __( 'Spacing', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .portfolio-effect1 .caption-inner, {{WRAPPER}} .portfolio-effect2 .content-block h4, {{WRAPPER}} .portfolio-effect2 .content-block .portfolio-cates, {{WRAPPER}} .portfolio-effect3 .details, {{WRAPPER}} .portfolio-effect4 .perspective-caption' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'portfolio_title_color',
			[
				'label' => __( 'Title Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-title' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'cat_color',
			[
				'label' => __( 'Category Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-cates, {{WRAPPER}} .portfolio-cates a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();		
    }

    protected function content_template() {}

	protected function select_param_cate_project() {
	  	$category = get_terms( 'project-type' );
	  	$cat = array();
	  	foreach( $category as $item ) {
	     	if( $item ) {
	        	$cat[$item->slug] = $item->name;
	     	}
	  	}
	  	return $cat;
	}
    protected function render() {
        $settings = $this->get_settings_for_display();
        printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
        if( !empty($settings['layout']) ){
            include $this->get_template('mo-portfolio.php');
        }
        print '</div>'; 

    }
}