<?php 
$id = get_the_ID();
$terms = wp_get_object_terms($id, 'category');
?>
<div id="post-<?php the_ID(); ?>" <?php post_class(); ?>>      
   <div class="post post-list">
       <div class="date-wrapper">
			<div class="date">
				<span class="post-date"><?php echo get_the_date('d' ); ?></span>
				<span class="post-month"><?php echo get_the_date('M' ); ?></span>
			</div>
		</div><!--date-wrapper-->   
		<div class="caption">
			<h3 class="post-title"><a href="<?php echo get_the_permalink(); ?>"><?php the_title(); ?></a></h3>
			<ul class="meta-post">
			<?php if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) { ?> <li class="date"><?php echo esc_html($terms[0]->name); ?></li> <?php } ?>
				<li><div class="author"><?php echo get_the_author();?></div></li>
			</ul>
		</div><!--caption-->  
		<div class="post-thumbnail">
		   <a class="link-image-content" href="<?php the_permalink(); ?>"><?php if ( has_post_thumbnail()) { the_post_thumbnail('thumbnail'); }?></a>
		</div><!--post-thumbnail-->  
		<div class="post-btn">
			<a class="button btn-txt text_center btn-txt-arrow larg" href="<?php the_permalink() ?>"> <span class="mo_module_button__container"><span class="mo_module_button__cover front"></span><svg class="svg-arrow" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 11.9 11.9" xml:space="preserve"><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path></svg></span></a>
		</div><!--post-btn-->  
	</div><!--post post-list-->   
</div>