<?php	
use Elementor\Plugin;
if (!defined('ABSPATH')) {
    exit;
}

class Theplus_Elementor_Plugin_Options
{
    
    /**
     * Option key, and option page slug
     * @var string
     */
    private $key = 'theplus_options';
    
    /**
     * Array of metaboxes
     * @var array
     */
    protected $option_metabox = array();

	/**
     * Array of fields
     * @var array
     */
    protected $fields = array();
    
    /**
     * Options Page title
     * @var string
     */
    protected $title = '';
    
    /**
     * Options Page hook
     * @var string
     */
    protected $options_page = '';
    protected $options_pages = array();
    /**
     * Constructor
     * @since 0.1.0
     */
    public function __construct()
    {
        // Set our title
		if(current_user_can("manage_options")){
			add_action( 'admin_post_theplus_api_key_deactive', array( $this,'theplus_key_api_form_de_action') );
			add_action( 'admin_post_theplus_api_key_active', array( $this,'theplus_key_api_form_ac_action') );
		}		
		
		//Plus Designs
		remove_action( 'theplus_free_pro_import_data', 'theplus_free_import_data_content' );
		add_action( 'theplus_free_pro_import_data', array( $this,'theplus_pro_import_data_content'));
		
		//Extar Options		
		add_filter( 'theplus_pro_api_con_field', array( $this,'theplus_pro_api_connection_field'), 11 ,1);
		
		//Activate
		remove_action( 'theplus_free_pro_purchase_code', 'theplus_free_purchase_code_content' );
		add_action( 'theplus_free_pro_purchase_code', array( $this,'theplus_pro_purchase_code_field'));
		//add_filter( 'theplus_pro_purchase_code_fields', array( $this,'theplus_pro_purchase_code_field'), 11 ,1);
		
		//White Label
		remove_action( 'theplus_free_pro_white_label', 'theplus_free_white_label_content' );
		add_filter( 'theplus_pro_white_lab_fields', array( $this,'theplus_pro_white_lab_field'), 11 ,1);
		
        $this->title = esc_html__('ThePlus Settings', 'theplus');
		add_action( 'admin_head', [ $this, 'plus_icon_logo' ] );
        
        // Set our CMB fields
        $this->fields = array();
    }
    
	/*Panel Function Overwrite Start*/
	public function theplus_pro_import_data_content() {
		$verify_api=theplus_check_api_status();
		wp_enqueue_script( 'jquery-masonry');
		$ajax = Plugin::$instance->common->get_component( 'ajax' );
		$cls_close='';
		$purchase_option=get_option( 'theplus_purchase_code' );
		$plus_key = isset($purchase_option['tp_api_key']) ? sanitize_text_field($purchase_option['tp_api_key']) : '';
		if($verify_api==1 && !empty($plus_key)){
			$cls_close = ' tp-close-up-box';
		}?>
				<div class="theplus_about-tab changelog <?php echo $cls_close; ?>">
					<div style="background:red;color:#ffffffcf;padding:15px;width:max-content;margin:0 auto;margin-bottom:20px;font-size:16px;font-weight:600;border-radius:5px">This functionality is deprecated, You can use <a style="color:#fff" href="https://theplusaddons.com/plus-extras/cross-domain-copy-paste-and-live-copy-elementor/" target="_blank">Live Copy Paste Feature</a>
					</div>
					<div class="feature-section">
						<?php if(!empty($verify_api) && $verify_api==1){ ?>
						<div id="pt-plus-import-form">
							<div class="plus-template-main-category">
								<div class="theplus-import-cat-nd-btn">
									<div class="theplus-import-template-library">
										<img src="<?php echo THEPLUS_ASSETS_URL; ?>/images/template-import.png"><?php echo esc_html__("Import","theplus"); ?>
									</div>
									<ul class="plus-main-category-list">
										<li class="active-open"><div class="plus-templates-tab" data-listing="special-blocks"><?php echo esc_html__("Special Blocks","theplus"); ?></div></li>
										<li><div class="plus-templates-tab" data-listing="plus-templates"><?php echo esc_html__("Plus Templates","theplus"); ?></div></li>
										<li><div class="plus-templates-tab" data-listing="plus-widgets"><?php echo esc_html__("Plus Widgets","theplus"); ?></div></li>
										<li><div class="plus-templates-tab" data-listing="plus-listing"><?php echo esc_html__("Plus Listing","theplus"); ?></div></li>							
									</ul>
								</div>
								
								<div class="plus-import-listing-widgets">
									<div id="listing-special-blocks" class="widgets-listing-content active">
										<img src="<?php echo THEPLUS_ASSETS_URL; ?>/images/ajax-loader.gif" class="templates-loading" />
									</div>
									<div id="listing-plus-templates" class="widgets-listing-content">
										<img src="<?php echo THEPLUS_ASSETS_URL; ?>/images/ajax-loader.gif" class="templates-loading" />
									</div>
									<div id="listing-plus-widgets" class="widgets-listing-content">
										<img src="<?php echo THEPLUS_ASSETS_URL; ?>/images/ajax-loader.gif" class="templates-loading" />
									</div>
									<div id="listing-plus-listing" class="widgets-listing-content">
										<img src="<?php echo THEPLUS_ASSETS_URL; ?>/images/ajax-loader.gif" class="templates-loading" />
									</div>									
								</div>
							</div>
							
							<div id="elementor-import-template-area" class="theplus-import-template-library-form hidden">
								<form id="elementor-import-template-form" method="post" action="<?php echo admin_url( 'admin-ajax.php' ); ?>" enctype="multipart/form-data">
									<input type="hidden" name="action" value="elementor_library_direct_actions">
									<input type="hidden" name="library_action" value="direct_import_template">
									<input type="hidden" name="_nonce" value="<?php echo $ajax->create_nonce(); ?>">
									<div class="tp-im-svg"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" width="200" height="150" viewBox="0 0 180.905 133.992">
										  <defs>
											<linearGradient id="linear-gradient" x1="0.5" y1="1" x2="0.5" gradientUnits="objectBoundingBox">
											  <stop offset="0" stop-color="gray" stop-opacity="0.251"/>
											  <stop offset="0.54" stop-color="gray" stop-opacity="0.122"/>
											  <stop offset="1" stop-color="gray" stop-opacity="0.102"/>
											</linearGradient>
											<linearGradient id="linear-gradient-2" x1="0.5" y1="1" x2="0.5" y2="0" xlink:href="#linear-gradient"/>
											<linearGradient id="linear-gradient-3" x1="-0.211" y1="3.614" x2="-0.211" y2="0.343" xlink:href="#linear-gradient"/>
											<linearGradient id="linear-gradient-4" x1="-0.036" y1="4.542" x2="-0.036" y2="1.284" xlink:href="#linear-gradient"/>
											<linearGradient id="linear-gradient-5" x1="-0.017" y1="4.446" x2="-0.017" y2="1.187" xlink:href="#linear-gradient"/>
											<linearGradient id="linear-gradient-6" x1="-1.04" y1="1.715" x2="-1.04" y2="0.715" xlink:href="#linear-gradient"/>
											<linearGradient id="linear-gradient-7" x1="0.551" y1="0.784" x2="0.551" y2="0.225" xlink:href="#linear-gradient"/>
											<linearGradient id="linear-gradient-8" x1="0.5" y1="1" x2="0.5" y2="0" xlink:href="#linear-gradient"/>
										  </defs>
										  <g id="undraw_upload_87y9" transform="translate(0 -0.002)">
											<path id="Path_7403" data-name="Path 7403" d="M187.973,64.669c-5.935-2.413-12.207-4.433-18.611-4.176a27.671,27.671,0,0,0-22.877,14.347c-3.756,7.043-4.219,15.3-5.836,23.117-1.993,9.632-5.809,18.785-9.887,27.736-2.191,4.8-4.5,9.72-4.861,14.991-.5,7.316,3,14.609,8.484,19.481s12.774,7.435,20.083,8c3.891.3,7.957.022,11.414-1.788,3.657-1.916,6.322-5.38,9.993-7.267,3.4-1.756,7.382-2,11.2-1.768a50.162,50.162,0,0,1,14.625,3.107c5.338,2.006,10.3,4.909,15.629,6.941s11.278,3.168,16.723,1.471c5.11-1.6,9.156-5.461,12.8-9.381a164.177,164.177,0,0,0,16.319-20.646c3.288-4.924,6.347-10.12,7.8-15.861a31.69,31.69,0,0,0-9.531-30.85c-7.026-6.208-16.461-8.9-25.7-10.539-8.42-1.491-18.155-1.584-25.906-5.471C202.449,72.4,195.723,67.821,187.973,64.669Z" transform="translate(-111.113 -55.673)" fill="#6c63ff" opacity="0.1"/>
											<path id="Path_7404" data-name="Path 7404" d="M756.934,135.256c-2.28.091-2.4,5.978-2.253,6.235a15.779,15.779,0,0,1-.517,2.914,30.2,30.2,0,0,0-.915,4.778,1.4,1.4,0,0,1-.557,1.239,9.619,9.619,0,0,0-2.619,2.039l-.085.091a7.367,7.367,0,0,0-1.153.891c-.172.252-.639.051-.639.051a12.449,12.449,0,0,0-1.5-.077c-.118.035-.3-.182-.409-.319-.049-.065-.081-.115-.081-.115l-.04-1.188a.974.974,0,0,0-.16-.1c.027-.134.061-.273.1-.415a3.557,3.557,0,0,0,1.452-1.3c.038-.061.073-.123.107-.185a.479.479,0,0,0,.3.085.6.6,0,0,0,.141-.013,1.135,1.135,0,0,0,.409-.206,2.188,2.188,0,0,0,.76-.891,1.446,1.446,0,0,0,.072-.212c-.024.04-.049.08-.075.118a1.228,1.228,0,0,0-.085-1.036,3.406,3.406,0,0,1-.4-.588c-.134-.385.12-.782.276-1.159a1.95,1.95,0,0,0,.142-1.092,1.4,1.4,0,0,0-.591-.921c-.627-.407-1.479-.184-2.205-.38a5.979,5.979,0,0,1-.758-.3,5.749,5.749,0,0,0-1.161-.361,1.135,1.135,0,0,0-1.118.222,2.288,2.288,0,0,0-.182.308,1.142,1.142,0,0,1-.714.513,2.68,2.68,0,0,1-.439.046.424.424,0,0,0,0-.182c-.185-.607.345-1.057,1.035-1.329a17.239,17.239,0,0,0,3.618-2.828,18.152,18.152,0,0,1,2.44-2.028,6.7,6.7,0,0,0,4.241-4.2c1.047-3.293-5.011,2.3-5.621,2.467a6.215,6.215,0,0,0-1.483.8l-3.885,2.247a14.066,14.066,0,0,0-2.095,1.447,7.034,7.034,0,0,0-1.536,2.194s-.372.607-.915,1.485a4.043,4.043,0,0,1-1.185,1.26l.018-.032a9.44,9.44,0,0,0-1.5,2.478c-.118.738-.663,3.744-.663,3.744a15.023,15.023,0,0,1-.808,2.826,8.1,8.1,0,0,1-.425,1.538,7.453,7.453,0,0,0-.69,2.3,4.981,4.981,0,0,0-.5,1.833l-1.1,2.635a6.067,6.067,0,0,0-.557,2.065c.019.369.035.8.046,1.15v.16h0v.16c-.059.1-.211.351-.369.656a3.418,3.418,0,0,0-.454,1.34,7.5,7.5,0,0,1-.249,2.6l-.081-.032a1.117,1.117,0,0,0-.16.53l.019.01c0,.046-.014.094-.019.145a7.514,7.514,0,0,1-.123,1.649,57.588,57.588,0,0,0-.107,5.991,19.03,19.03,0,0,0,.345,5.862l-.053,1.78a16.609,16.609,0,0,0,.053,1.916,18.653,18.653,0,0,1,.107,1.937l.4,2.841s-.532,4.39-.08,5.474a5.962,5.962,0,0,1,.479,1.886,2.934,2.934,0,0,0,.731.283v.16l-.1,2.67v.147s-.013.07-.022.187h0v.065a.072.072,0,0,0,0,.019v.056a.363.363,0,0,0,0,.043.287.287,0,0,1,0,.038v.241h0v.233a.453.453,0,0,0,.013.08.072.072,0,0,0,0,.019.41.41,0,0,0,.017.088h0a.336.336,0,0,0,.021.086.025.025,0,0,1,0,.01h0a.158.158,0,0,0,.013.045.084.084,0,0,0,0,.021.26.26,0,0,0,.016.054v.013c.016.045.032.089.051.134a.063.063,0,0,0,0,.014.139.139,0,0,0,.022.049l.01.022.021.043.013.024.022.04.014.024c0,.013.014.026.022.038s.011.016.016.026l.024.037.018.024.026.037.019.024.029.035.019.022.033.038.018.019.054.053a.082.082,0,0,0,.018.016.429.429,0,0,0,.04.037l.026.021.035.029.03.022.035.026.034.022.035.022.037.021.037.022.038.019.04.019.04.019.04.018.043.018.043.016.045.016.048.014.075.022.062.016.05.01.051.011h.054l.053.008h.674l.086-.008h.053l.145-.016s1.809.27,1.868-.446a.576.576,0,0,1,.008-.115v-.091a.236.236,0,0,1,0-.034c0-.035,0-.073,0-.112v-.8c-.011-.354-.029-.683-.04-.867a1.167,1.167,0,0,0-.01-.16s-.616-.929-.516-1.277a9.194,9.194,0,0,0,.078-1.53s-.24-.567-.4-1.068c-.013-.038-.024-.077-.035-.113a5.933,5.933,0,0,0,.377-.479,6.068,6.068,0,0,0-.45-3.641.227.227,0,0,1-.1-.187.084.084,0,0,1,0-.019l.308-3.77-.187-2.194a6.04,6.04,0,0,1,.16-2.144l.583-5.68.827-3.3s.265-.129.479.492.741,3.433.741,3.433l1.277,4.648a9.22,9.22,0,0,0,.4,1.886,3.6,3.6,0,0,1,.187,1.265,3.267,3.267,0,0,1,.345,1.188,5.139,5.139,0,0,0,.131,1.678,22.739,22.739,0,0,1,.187,2.715,5.484,5.484,0,0,0,.053,2.35,8.277,8.277,0,0,1,.133,2.686,1.816,1.816,0,0,0,.109.15c-.013.035-.027.07-.04.1-.083.216-.148.367-.148.367a9.417,9.417,0,0,0,.08,1.53c.1.348-.517,1.277-.517,1.277s0,.057-.01.16c-.011.184-.029.511-.04.867v.91a.21.21,0,0,0,0,.03v.093a.583.583,0,0,0,.008.115c.061.715,1.87.445,1.87.445l.145.018h.808l.054-.01.053-.008.051-.011.051-.01.062-.016.075-.022.046-.014.045-.016a.347.347,0,0,0,.043-.016l.043-.018.042-.018.04-.018.04-.021.037-.019.038-.021.035-.022.037-.022.032-.022.035-.026a.211.211,0,0,0,.03-.022.282.282,0,0,0,.035-.027l.027-.022.04-.035.018-.018.054-.053.016-.019.035-.037.018-.024a.306.306,0,0,0,.03-.035l.018-.024.027-.037.016-.024.026-.037a.231.231,0,0,1,.016-.026c0-.013.014-.026.022-.038l.014-.024c0-.014.014-.027.021-.04a.177.177,0,0,0,.013-.024c0-.014.014-.029.021-.043l.011-.022c0-.016.014-.032.022-.049v-.014c.018-.045.035-.089.049-.134v-.013a.172.172,0,0,1,.018-.053.114.114,0,0,1,0-.022.061.061,0,0,1,.013-.045v-.008a.021.021,0,0,0,0-.01.392.392,0,0,1,.022-.085h0a.555.555,0,0,1,.018-.086v-.021a.618.618,0,0,1,.013-.078.061.061,0,0,0,0-.027v-.208h0v-.279a.423.423,0,0,1,0-.043v-.056a.084.084,0,0,1,0-.019v-.064h0c-.01-.117-.021-.187-.021-.187v-.145l-.1-2.584v-.16c.149-.083.3-.177.458-.287a4.624,4.624,0,0,1,.4-2.065c.425-.592-.212-2.144-.212-2.144l-.265-5.552.105-2.555a2.539,2.539,0,0,1-.319-1.239,4.508,4.508,0,0,0-.425-1.6s-.265-.878.054-1.137-.345-5.908-.345-5.908a53.287,53.287,0,0,0-.144-6.579v-.04l.085-.038c-.026-.2-.053-.38-.083-.551l-.089.027a4.492,4.492,0,0,0-.16-.639l-.425-1.95s-.01-.1-.021-.251c-.014-.176-.03-.414-.034-.623a1.057,1.057,0,0,1,.029-.262L741.92,168a.581.581,0,0,1,.022-.136l-.093-.078s-.013-.088-.022-.222a2.5,2.5,0,0,1,.115-1.107,17.507,17.507,0,0,1,2.4-2.041l1.223-2.448s1.22-1.718,2.148-2.053a34.79,34.79,0,0,0,3.818-2.258,9.533,9.533,0,0,0,1.088-1.277l.033-.051h.019V156.3l2.715-4.067a4.112,4.112,0,0,0,1.126-2.75l.283-4.276-.093-2.529.131-1.437S759.213,135.166,756.934,135.256Zm-15.549,11.066a3.422,3.422,0,0,0-.45,1.7v.155a3.41,3.41,0,0,0,.362,1.529,1.252,1.252,0,0,0-.263.468,2.539,2.539,0,0,1-.549-1.03,1.072,1.072,0,0,0-.425-.7,2.924,2.924,0,0,1,.026-.917l.014-.013s.011-.019.033-.051h0c.113-.171.495-.747.889-1.4a1.257,1.257,0,0,0,.2.067l.243.061Z" transform="translate(-617.824 -116.049)" fill="url(#linear-gradient)"/>
											<path id="Path_7405" data-name="Path 7405" d="M855.277,216.409c.024-.054.043-.112.062-.169a3.542,3.542,0,0,0-.16.391C855.214,216.556,855.247,216.483,855.277,216.409Z" transform="translate(-723.981 -186.568)" fill="url(#linear-gradient-2)"/>
											<path id="Path_7406" data-name="Path 7406" d="M803.053,238.534s-.5,2.382-1.421,2.691,1.118,3.034,1.118,3.034l4.227-.232.077-.883a4.364,4.364,0,0,1,.538-3.919C808.928,237.075,803.053,238.534,803.053,238.534Z" transform="translate(-678.783 -204.896)" fill="#f6bac2"/>
											<path id="Path_7407" data-name="Path 7407" d="M747.881,557.943c-.057.711-1.806.442-1.806.442-2.9.4-2.421-2.44-2.421-2.44V555.8l.1-2.651.029-.739s3.194-1.459,3.112-1.153a1.817,1.817,0,0,0,.129.69c.16.5.388,1.059.388,1.059a9.545,9.545,0,0,1-.077,1.517c-.1.345.5,1.268.5,1.268s0,.057.01.16A18.632,18.632,0,0,1,747.881,557.943Z" transform="translate(-630.24 -468.055)" fill="#b77983"/>
											<path id="Path_7408" data-name="Path 7408" d="M795.71,560.4s-1.748.27-1.806-.442a18.176,18.176,0,0,1,.03-2,1.421,1.421,0,0,1,.008-.16s.6-.923.5-1.268a9.563,9.563,0,0,1-.077-1.518s.062-.149.144-.363a4.418,4.418,0,0,0,.375-1.384c-.077-.308,3.112,1.151,3.112,1.151l.032.827.1,2.563v.145S798.611,560.8,795.71,560.4Z" transform="translate(-672.478 -469.742)" fill="#b77983"/>
											<path id="Path_7409" data-name="Path 7409" d="M791.059,136.93a6.546,6.546,0,0,1-4.1,4.163A18.1,18.1,0,0,0,784.6,143.1a16.939,16.939,0,0,1-3.5,2.806c-.667.27-1.177.717-1,1.317.16.557-1.587,3.285-1.851,3.69h0l-.032.051-.551.576-1.87.947L774.283,152l-.193-1.83.808-1.437h0a3.965,3.965,0,0,0,1.145-1.25c.525-.872.885-1.472.885-1.472a7.025,7.025,0,0,1,1.485-2.178,13.439,13.439,0,0,1,2.023-1.437l3.754-2.235a6.052,6.052,0,0,1,1.437-.8C786.219,139.193,792.071,133.665,791.059,136.93Z" transform="translate(-655.84 -119.057)" fill="#f6bac2"/>
											<path id="Path_7410" data-name="Path 7410" d="M775.807,218.866l2.5-.5a.16.16,0,0,0-.045.1h0l-.032.051-.551.576-1.87.947-1.523-.487-.193-1.83.808-1.437h0a2.864,2.864,0,0,0-.019,2.73Z" transform="translate(-655.84 -186.61)" opacity="0.05"/>
											<path id="Path_7411" data-name="Path 7411" d="M858.124,264.736a.469.469,0,0,0-.018.051.7.7,0,0,1-.093.16l-1.008.492-1.538.16-.8-1.934.532-2.119.294-.4.081-.089c.03.383.185,2.382.176,2.983-.013.666.479.719.479.719Z" transform="translate(-723.553 -224.231)" opacity="0.05"/>
											<path id="Path_7412" data-name="Path 7412" d="M762.964,227.043a.471.471,0,0,0-.018.051,9.345,9.345,0,0,1-1.049,1.268,32.785,32.785,0,0,1-3.689,2.235c-.9.327-2.076,2.036-2.076,2.036l-1.178,2.432a16.658,16.658,0,0,0-2.317,2.025,2.524,2.524,0,0,0-.11,1.1,1.139,1.139,0,0,0,.019.22l-.623.65-.5.517-.7.728-1.139-.16-3.548-.564-.68-.383-3.776-2.127s0-.133-.01-.335c0-.089,0-.192-.01-.3-.011-.345-.027-.774-.045-1.14a6.156,6.156,0,0,1,.538-2.049l1.062-2.614a5.067,5.067,0,0,1,.487-1.819,7.6,7.6,0,0,1,.666-2.279,8.12,8.12,0,0,0,.41-1.525,15.073,15.073,0,0,0,.781-2.8s.525-2.972.639-3.714a9.184,9.184,0,0,1,1.447-2.457,2.91,2.91,0,0,0-.115,2.919l.923-.16,2.5-.487c-.115.077-.038.921-.038.921a1.065,1.065,0,0,1,.409.691,2.653,2.653,0,0,0,.564,1.062l.013.014a1.25,1.25,0,0,1,.6-.859l.576.77.193.921s-.053.129-.385.385.141.921.141.921a4.693,4.693,0,0,1,.206,1.268h0a1.867,1.867,0,0,1,1.087-.37,3.294,3.294,0,0,0,.653-.936.386.386,0,0,1,.551-.255,3.54,3.54,0,0,1,.628-.436c.308-.16.666.16.666.16l.038,1.18s.03.048.08.113c.1.141.281.356.394.319a11.693,11.693,0,0,1,1.447.077s.449.192.615-.051a7.577,7.577,0,0,1,1.118-.883s.184,2.378.184,3.042.479.719.479.719Z" transform="translate(-628.469 -186.392)" fill="#d39999"/>
											<path id="Path_7413" data-name="Path 7413" d="M875.823,284.626h-.034C875.851,284.467,875.823,284.626,875.823,284.626Z" transform="translate(-741.301 -243.975)" fill="none"/>
											<circle id="Ellipse_65" data-name="Ellipse 65" cx="0.23" cy="0.23" r="0.23" transform="translate(123.785 38.864)" fill="#4b4442"/>
											<circle id="Ellipse_66" data-name="Ellipse 66" cx="0.23" cy="0.23" r="0.23" transform="translate(122.106 42.208)" fill="#4b4442"/>
											<circle id="Ellipse_67" data-name="Ellipse 67" cx="0.23" cy="0.23" r="0.23" transform="translate(118.803 49.367)" fill="#4b4442"/>
											<circle id="Ellipse_68" data-name="Ellipse 68" cx="0.23" cy="0.23" r="0.23" transform="translate(120.364 45.755)" fill="#4b4442"/>
											<path id="Path_7414" data-name="Path 7414" d="M747.79,551.947a3.084,3.084,0,0,1-3.27,1.2l.029-.739s3.194-1.459,3.112-1.153A1.7,1.7,0,0,0,747.79,551.947Z" transform="translate(-630.992 -468.055)" opacity="0.05"/>
											<path id="Path_7415" data-name="Path 7415" d="M801.323,555.284a2.484,2.484,0,0,1-3.513-.594,4.417,4.417,0,0,0,.375-1.384c-.077-.308,3.112,1.151,3.112,1.151Z" transform="translate(-675.772 -469.775)" opacity="0.05"/>
											<path id="Path_7416" data-name="Path 7416" d="M746.833,378.195a4.73,4.73,0,0,0-.385,2.049c-2.638,1.9-4.021-.41-4.021-.41a8.481,8.481,0,0,0-.128-2.663,5.559,5.559,0,0,1-.051-2.331,22.485,22.485,0,0,0-.18-2.689,5.145,5.145,0,0,1-.128-1.665,3.285,3.285,0,0,0-.332-1.177,3.619,3.619,0,0,0-.18-1.255,9.239,9.239,0,0,1-.383-1.871l-1.228-4.61s-.513-2.791-.717-3.406-.461-.487-.461-.487l-.738,3.3-.564,5.635a6.183,6.183,0,0,0-.16,2.127l.179,2.176-.3,3.74a.084.084,0,0,0,0,.019.228.228,0,0,0,.093.185,6.154,6.154,0,0,1,.43,3.612c-1.947,2.818-4.3,1.357-4.3,1.357a5.975,5.975,0,0,0-.46-1.868c-.436-1.076.077-5.429.077-5.429l-.385-2.818a18.869,18.869,0,0,0-.1-1.916,16.859,16.859,0,0,1-.051-1.9l.051-1.768a19.391,19.391,0,0,1-.334-5.814,58.415,58.415,0,0,1,.1-5.943,7.556,7.556,0,0,0,.118-1.637,1.142,1.142,0,0,1,.15-.525l.026-.026a6.408,6.408,0,0,0,.307-2.691,3.455,3.455,0,0,1,.439-1.329c.16-.31.3-.565.359-.658l.022-.037a33.92,33.92,0,0,1,5.327,2.2,7.268,7.268,0,0,0,2.2.682,4.9,4.9,0,0,0,1.148.018,4.008,4.008,0,0,0,1.651-.536,2.9,2.9,0,0,0,.714-.573,4.774,4.774,0,0,0,0,1.032c.01.148.021.249.021.249l.426,1.9a4.97,4.97,0,0,1,.16.688c.03.169.056.353.08.548a53.1,53.1,0,0,1,.139,6.526s.639,5.61.334,5.865-.053,1.127-.053,1.127a4.546,4.546,0,0,1,.41,1.587,2.554,2.554,0,0,0,.308,1.23l-.1,2.536.268,5.5S747.244,377.606,746.833,378.195Z" transform="translate(-620.463 -295.171)" fill="#8499f0"/>
											<path id="Path_7417" data-name="Path 7417" d="M806.13,488.37s1.94-1.118,2.363-.615S806.13,488.37,806.13,488.37Z" transform="translate(-682.764 -414.619)" opacity="0.05"/>
											<path id="Path_7418" data-name="Path 7418" d="M813.09,496.14s-.319.16.385.364S813.09,496.14,813.09,496.14Z" transform="translate(-688.552 -421.774)" opacity="0.05"/>
											<path id="Path_7419" data-name="Path 7419" d="M739.99,476.761a2.977,2.977,0,0,0,3.131.211A23.347,23.347,0,0,0,739.99,476.761Z" transform="translate(-627.184 -405.469)" opacity="0.05"/>
											<path id="Path_7420" data-name="Path 7420" d="M750.537,490.24a2.059,2.059,0,0,1-1.4,1.038C748.193,491.412,750.537,490.24,750.537,490.24Z" transform="translate(-634.682 -416.816)" opacity="0.05"/>
											<path id="Path_7421" data-name="Path 7421" d="M797.71,502.52s2.21,3.513,1.787,4.342S797.71,502.52,797.71,502.52Z" transform="translate(-675.688 -427.135)" opacity="0.05"/>
											<path id="Path_7422" data-name="Path 7422" d="M773.16,369.09l-.23,6.877s1.364-.057,1.6-2.323.4-4.112.4-4.112Z" transform="translate(-654.865 -315.011)" opacity="0.05"/>
											<path id="Path_7423" data-name="Path 7423" d="M772.68,368.13l-.23,6.877s1.364-.057,1.6-2.325.407-4.11.407-4.11Z" transform="translate(-654.462 -314.205)" fill="#8499f0"/>
											<path id="Path_7424" data-name="Path 7424" d="M737.948,368.942s-1.076,2.885-3.538,1.488a1.135,1.135,0,0,1,.15-.525,1.943,1.943,0,0,0,2.874-1.175Z" transform="translate(-622.496 -314.709)" opacity="0.05"/>
											<path id="Path_7425" data-name="Path 7425" d="M737.469,367.021s-1.076,2.885-3.538,1.488a1.142,1.142,0,0,1,.15-.525,1.942,1.942,0,0,0,2.874-1.174Z" transform="translate(-622.093 -313.095)" opacity="0.05"/>
											<path id="Path_7426" data-name="Path 7426" d="M737.469,367.981s-1.076,2.885-3.538,1.488a1.142,1.142,0,0,1,.15-.525,1.942,1.942,0,0,0,2.874-1.174Z" transform="translate(-622.093 -313.902)" fill="#8499f0"/>
											<path id="Path_7427" data-name="Path 7427" d="M795.637,376.137c-2.7,1.287-3.7-1.747-3.7-1.747l.639.019c.112,1.94,2.25,1.418,2.983,1.18C795.587,375.765,795.613,375.942,795.637,376.137Z" transform="translate(-670.84 -319.465)" opacity="0.05"/>
											<path id="Path_7428" data-name="Path 7428" d="M796.6,374.688c-2.7,1.285-3.7-1.748-3.7-1.748l.639.019c.112,1.94,2.25,1.42,2.983,1.182C796.547,374.31,796.573,374.494,796.6,374.688Z" transform="translate(-671.646 -318.247)" opacity="0.05"/>
											<path id="Path_7429" data-name="Path 7429" d="M796.116,375.168c-2.7,1.285-3.7-1.748-3.7-1.748l.639.019c.112,1.942,2.25,1.42,2.983,1.182C796.067,374.79,796.093,374.974,796.116,375.168Z" transform="translate(-671.243 -318.65)" fill="#8499f0"/>
											<path id="Path_7430" data-name="Path 7430" d="M737.469,367.981s-1.076,2.885-3.538,1.488a1.142,1.142,0,0,1,.15-.525,1.942,1.942,0,0,0,2.874-1.174Z" transform="translate(-622.093 -313.902)" fill="#fff" opacity="0.1"/>
											<path id="Path_7431" data-name="Path 7431" d="M796.116,375.168c-2.7,1.285-3.7-1.748-3.7-1.748l.639.019c.112,1.942,2.25,1.42,2.983,1.182C796.067,374.79,796.093,374.974,796.116,375.168Z" transform="translate(-671.243 -318.65)" fill="#fff" opacity="0.1"/>
											<path id="Path_7432" data-name="Path 7432" d="M747.9,581.265a4.531,4.531,0,0,1-.019.532c-.057.711-1.806.442-1.806.442-1.6.222-2.172-.544-2.362-1.277a2.922,2.922,0,0,1-.088-.728,3.015,3.015,0,0,1,.029-.437v-.145a1.068,1.068,0,0,1,.993.2,1.687,1.687,0,0,0,1.653.134,2.219,2.219,0,0,1,.958.287c.15.129.4-.182.586-.479.011.192.029.538.04.909C747.9,580.894,747.9,581.086,747.9,581.265Z" transform="translate(-630.243 -491.912)" opacity="0.05"/>
											<path id="Path_7433" data-name="Path 7433" d="M745.1,584.564s-.479.469-1.383-.255a2.922,2.922,0,0,1-.088-.728A8.353,8.353,0,0,0,745.1,584.564Z" transform="translate(-630.244 -495.252)" opacity="0.05"/>
											<path id="Path_7434" data-name="Path 7434" d="M767.669,587.042a.361.361,0,0,1-.519-.083,3.414,3.414,0,0,0,.511-.479C767.666,586.672,767.669,586.863,767.669,587.042Z" transform="translate(-650.008 -497.689)" opacity="0.05"/>
											<path id="Path_7435" data-name="Path 7435" d="M793.868,583.331a4.941,4.941,0,0,0,.017.532c.057.712,1.806.442,1.806.442,1.6.224,2.172-.543,2.362-1.277a3.063,3.063,0,0,0,.059-1.166v-.145a1.081,1.081,0,0,0-.995.2,1.684,1.684,0,0,1-1.651.134,2.227,2.227,0,0,0-.958.289c-.15.129-.4-.182-.584-.479-.011.192-.03.538-.042.909C793.87,582.958,793.866,583.15,793.868,583.331Z" transform="translate(-672.459 -493.648)" opacity="0.05"/>
											<path id="Path_7436" data-name="Path 7436" d="M811.43,586.612s.479.469,1.381-.256a2.907,2.907,0,0,0,.089-.727A8.533,8.533,0,0,1,811.43,586.612Z" transform="translate(-687.218 -496.975)" opacity="0.05"/>
											<path id="Path_7437" data-name="Path 7437" d="M793.868,589.1a.359.359,0,0,0,.517-.083,3.378,3.378,0,0,1-.511-.479C793.869,588.73,793.866,588.922,793.868,589.1Z" transform="translate(-672.459 -499.42)" opacity="0.05"/>
											<path id="Path_7438" data-name="Path 7438" d="M771.57,285s-2.459,6.788-1.512,7.377S771.57,285,771.57,285Z" transform="translate(-652.27 -244.349)" opacity="0.05"/>
											<path id="Path_7439" data-name="Path 7439" d="M790.34,271.88s-.463,2.255-.232,2.459S790.34,271.88,790.34,271.88Z" transform="translate(-669.246 -233.324)" opacity="0.05"/>
											<path id="Path_7440" data-name="Path 7440" d="M808.116,304.77s-3.023,2.817-2.818,3.048S808.116,304.77,808.116,304.77Z" transform="translate(-682.056 -260.962)" opacity="0.05"/>
											<path id="Path_7441" data-name="Path 7441" d="M817.2,258.091c-1.145.35-3.821,1.167-3.851,1.161l.148-.61a1.867,1.867,0,0,1,1.087-.37,3.292,3.292,0,0,0,.653-.936.386.386,0,0,1,.551-.255,3.635,3.635,0,0,1,.628-.436c.308-.16.666.16.666.16l.038,1.178S817.152,258.026,817.2,258.091Z" transform="translate(-688.831 -220.484)" opacity="0.05"/>
											<path id="Path_7442" data-name="Path 7442" d="M817.2,257.151c-1.145.35-3.821,1.167-3.851,1.159l.148-.608a1.867,1.867,0,0,1,1.087-.37,3.292,3.292,0,0,0,.653-.936.386.386,0,0,1,.551-.255,3.543,3.543,0,0,1,.628-.436c.308-.16.666.16.666.16l.038,1.18S817.152,257.083,817.2,257.151Z" transform="translate(-688.831 -219.694)" fill="#d39999"/>
											<path id="Path_7443" data-name="Path 7443" d="M806.5,245.21a4.677,4.677,0,0,1,.2,1.268l-.445.354-.846-2.44-.038-1.268-.016-.072.013.014a1.244,1.244,0,0,1,.6-.857l.576.768.193.921s-.053.129-.385.385S806.5,245.21,806.5,245.21Z" transform="translate(-682.117 -208.391)" opacity="0.05"/>
											<path id="Path_7444" data-name="Path 7444" d="M806.992,244.717a4.693,4.693,0,0,1,.206,1.268l-.445.359-.846-2.44-.038-1.268-.018-.072.013.014a1.25,1.25,0,0,1,.6-.859l.577.77.193.921s-.053.129-.385.385S806.992,244.717,806.992,244.717Z" transform="translate(-682.529 -207.98)" fill="#d39999"/>
											<path id="Path_7445" data-name="Path 7445" d="M811.974,216.148a3.428,3.428,0,1,1-1-2.454A3.457,3.457,0,0,1,811.974,216.148Z" transform="translate(-681.865 -183.584)" opacity="0.05"/>
											<path id="Path_7446" data-name="Path 7446" d="M811.957,215.187a3.438,3.438,0,1,1-1.007-2.45A3.459,3.459,0,0,1,811.957,215.187Z" transform="translate(-681.848 -182.778)" fill="#f6bac2"/>
											<path id="Path_7447" data-name="Path 7447" d="M814.26,215.164a3.438,3.438,0,0,1-.5,1.8c-.051-.091-.081-.2-.133-.289-.072-.129-.238-.238-.361-.16a.369.369,0,0,0-.113.16c-.1.212-.279.425-.514.42a.509.509,0,0,1-.437-.374,1.533,1.533,0,0,1-.026-.61,1.391,1.391,0,0,0-.267-1.174,1.747,1.747,0,0,0-.667-.3.875.875,0,0,1-.575-.425c-.064-.16-.048-.329-.105-.479a.838.838,0,0,0-.621-.457,1.629,1.629,0,0,1-1.087.372,4.075,4.075,0,0,1-1.07-.169,3.459,3.459,0,0,1,6.48,1.681Z" transform="translate(-684.15 -182.755)" opacity="0.05"/>
											<path id="Path_7448" data-name="Path 7448" d="M807.613,204.552c.057.16.042.332.105.479a.872.872,0,0,0,.575.425,1.757,1.757,0,0,1,.667.3,1.4,1.4,0,0,1,.267,1.175,1.534,1.534,0,0,0,.026.61.513.513,0,0,0,.438.374.635.635,0,0,0,.514-.42.372.372,0,0,1,.113-.16c.123-.081.289.027.361.16a1.58,1.58,0,0,0,.206.388.46.46,0,0,0,.42.1,1.059,1.059,0,0,0,.394-.2,2.162,2.162,0,0,0,.734-.883,1.268,1.268,0,0,0-.046-1.118,3.359,3.359,0,0,1-.385-.584c-.131-.382.115-.774.267-1.148a1.993,1.993,0,0,0,.136-1.084,1.392,1.392,0,0,0-.57-.915c-.607-.4-1.428-.182-2.13-.377a5.4,5.4,0,0,1-.733-.3,5.43,5.43,0,0,0-1.118-.358,1.088,1.088,0,0,0-1.084.219,2.412,2.412,0,0,0-.176.307,1.1,1.1,0,0,1-.69.508c-.206.049-.422.037-.639.067a.7.7,0,0,0-.532.3,1.058,1.058,0,0,0-.035.639.648.648,0,0,1-.16.6c-.081.062-.193.093-.243.18a.254.254,0,0,0,.075.3.72.72,0,0,0,.3.134,4.668,4.668,0,0,0,1.225.209,1.616,1.616,0,0,0,1.14-.42c-.027.027-.2.016-.235.014A.933.933,0,0,1,807.613,204.552Z" transform="translate(-681.205 -173.725)" fill="#7e646b"/>
											<g id="Group_35" data-name="Group 35" transform="translate(123.116 28.564)" opacity="0.05">
											  <path id="Path_7449" data-name="Path 7449" d="M812.139,221.713a1.088,1.088,0,0,1-.394.206.463.463,0,0,1-.418-.1,1.561,1.561,0,0,1-.208-.388c-.072-.129-.238-.238-.361-.16a.391.391,0,0,0-.113.16.625.625,0,0,1-.514.42.506.506,0,0,1-.436-.374,1.535,1.535,0,0,1-.027-.61,1.391,1.391,0,0,0-.265-1.174,1.756,1.756,0,0,0-.669-.3.879.879,0,0,1-.575-.425c-.064-.16-.048-.329-.105-.479a.835.835,0,0,0-.621-.457,1.658,1.658,0,0,1-1.087.374,4.735,4.735,0,0,1-1.225-.211.739.739,0,0,1-.3-.133.337.337,0,0,1-.049-.057.447.447,0,0,0-.179.139.254.254,0,0,0,.075.3.72.72,0,0,0,.3.134,4.668,4.668,0,0,0,1.225.209,1.643,1.643,0,0,0,1.086-.372.836.836,0,0,1,.623.455c.057.16.042.332.105.479a.875.875,0,0,0,.575.425,1.756,1.756,0,0,1,.667.3,1.4,1.4,0,0,1,.267,1.175,1.535,1.535,0,0,0,.026.61.513.513,0,0,0,.438.374.636.636,0,0,0,.514-.42.372.372,0,0,1,.113-.16c.123-.081.289.027.361.16a1.533,1.533,0,0,0,.208.388.457.457,0,0,0,.418.1,1.059,1.059,0,0,0,.394-.2,2.162,2.162,0,0,0,.734-.883,1.411,1.411,0,0,0,.069-.211A2.277,2.277,0,0,1,812.139,221.713Z" transform="translate(-804.565 -216.619)"/>
											  <path id="Path_7450" data-name="Path 7450" d="M854,219.538c.034-.073.065-.147.1-.219a1.47,1.47,0,0,0,.059-.169A3.731,3.731,0,0,0,854,219.538Z" transform="translate(-846.106 -217.577)"/>
											  <path id="Path_7451" data-name="Path 7451" d="M807.032,210.256a.655.655,0,0,0,.145-.588,2.61,2.61,0,0,1-.03-.369.542.542,0,0,0-.088.112,1.058,1.058,0,0,0-.035.639A1.242,1.242,0,0,1,807.032,210.256Z" transform="translate(-806.605 -209.3)"/>
											</g>
											<path id="Path_7452" data-name="Path 7452" d="M751.013,347.891c-.3.021-.714.043-1.215.061-.348.011-.738.019-1.154.019-.364,0-.749,0-1.148-.018a24.614,24.614,0,0,1-3.764-.388,8.238,8.238,0,0,1-4.152-1.8c.16-.31.305-.567.359-.658,0-.089,0-.193-.01-.3,1.685.8,6.936,3.016,10.962,1.756a1.138,1.138,0,0,0,.019.22l.091.077A4.844,4.844,0,0,0,751.013,347.891Z" transform="translate(-626.84 -294.6)" opacity="0.05"/>
											<path id="Path_7453" data-name="Path 7453" d="M751.013,346.923c-.3.021-.714.043-1.215.059-.348.013-.738.019-1.154.019-.364,0-.749,0-1.148-.018a24.607,24.607,0,0,1-3.764-.386,8.238,8.238,0,0,1-4.152-1.8c.16-.31.305-.565.359-.658,0-.089,0-.192-.01-.3,1.685.8,6.936,3.018,10.962,1.764a1.139,1.139,0,0,0,.019.22l.091.077A4.784,4.784,0,0,0,751.013,346.923Z" transform="translate(-626.84 -293.785)" fill="#4b4442"/>
											<path id="Path_7454" data-name="Path 7454" d="M309.4,427.305a2.2,2.2,0,0,1-.49-1.672l7.048-57.671.584-4.79a2.211,2.211,0,0,1,2.178-1.942l20.645-.137a2.208,2.208,0,0,0,2.194-2.269l-.008-.219a2.21,2.21,0,0,1,2.208-2.285h21.694a2.208,2.208,0,0,1,2.208,2.2,2.351,2.351,0,0,1-.019.3,2.208,2.208,0,0,0,2.133,2.5l20.835.532a2.207,2.207,0,0,1,2.121,2.58l-10.416,60.838-.2,1.15a2.161,2.161,0,0,1-.319.824Z" transform="translate(-264.928 -304.28)" fill="#b7b6cc"/>
											<g id="Group_36" data-name="Group 36" transform="translate(83.316 39.354)" opacity="0.5">
											  <rect id="Rectangle_1158" data-name="Rectangle 1158" width="41.968" height="12.832" transform="matrix(0.568, -0.823, 0.823, 0.568, 0, 34.529)" fill="url(#linear-gradient-3)"/>
											</g>
											<rect id="Rectangle_1159" data-name="Rectangle 1159" width="12.199" height="41.406" transform="matrix(0.823, 0.568, -0.568, 0.823, 107.35, 39.822)" fill="#f9fafb"/>
											<rect id="Rectangle_1160" data-name="Rectangle 1160" width="8.613" height="8.613" transform="matrix(0.821, 0.571, -0.571, 0.821, 108.073, 41.435)" fill="#f7b643"/>
											<rect id="Rectangle_1161" data-name="Rectangle 1161" width="8.624" height="8.624" transform="matrix(0.823, 0.568, -0.568, 0.823, 102.533, 49.958)" fill="#f7b643" opacity="0.5"/>
											<rect id="Rectangle_1162" data-name="Rectangle 1162" width="8.624" height="8.624" transform="matrix(0.823, 0.568, -0.568, 0.823, 96.613, 58.524)" fill="#f7b643" opacity="0.3"/>
											<g id="Group_37" data-name="Group 37" transform="translate(81.115 37.299)" opacity="0.5">
											  <rect id="Rectangle_1163" data-name="Rectangle 1163" width="41.812" height="12.832" transform="matrix(0.28, -0.96, 0.96, 0.28, 0, 40.133)" fill="url(#linear-gradient-4)"/>
											</g>
											<rect id="Rectangle_1164" data-name="Rectangle 1164" width="12.199" height="41.25" transform="matrix(0.96, 0.28, -0.28, 0.96, 93.169, 37.688)" fill="#f9fafb"/>
											<rect id="Rectangle_1165" data-name="Rectangle 1165" width="8.624" height="8.624" transform="matrix(0.96, 0.28, -0.28, 0.96, 94.706, 38.831)" fill="#f97878"/>
											<rect id="Rectangle_1166" data-name="Rectangle 1166" width="8.624" height="8.624" transform="matrix(0.96, 0.28, -0.28, 0.96, 91.785, 48.824)" fill="#f97878" opacity="0.5"/>
											<rect id="Rectangle_1167" data-name="Rectangle 1167" width="8.624" height="8.624" transform="matrix(0.96, 0.28, -0.28, 0.96, 88.865, 58.817)" fill="#f97878" opacity="0.3"/>
											<g id="Group_38" data-name="Group 38" transform="translate(81.137 37.996)" opacity="0.5">
											  <rect id="Rectangle_1168" data-name="Rectangle 1168" width="41.812" height="12.832" transform="matrix(0.08, -0.997, 0.997, 0.08, 0, 41.677)" fill="url(#linear-gradient-5)"/>
											</g>
											<rect id="Rectangle_1169" data-name="Rectangle 1169" width="12.199" height="41.25" transform="matrix(0.997, 0.08, -0.08, 0.997, 84.874, 38.312)" fill="#f9fafb"/>
											<rect id="Rectangle_1170" data-name="Rectangle 1170" width="8.624" height="8.624" transform="matrix(0.997, 0.08, -0.08, 0.997, 86.605, 39.121)" fill="#73b53b"/>
											<rect id="Rectangle_1171" data-name="Rectangle 1171" width="8.624" height="8.624" transform="matrix(0.997, 0.08, -0.08, 0.997, 85.769, 49.497)" fill="#73b53b" opacity="0.5"/>
											<rect id="Rectangle_1172" data-name="Rectangle 1172" width="8.624" height="8.624" transform="matrix(0.997, 0.08, -0.08, 0.997, 84.935, 59.876)" fill="#73b53b" opacity="0.3"/>
											<g id="Group_39" data-name="Group 39" transform="translate(78.97 39.119)" opacity="0.5">
											  <rect id="Rectangle_1173" data-name="Rectangle 1173" width="12.832" height="41.812" transform="translate(0 0.584) rotate(-2.61)" fill="url(#linear-gradient-6)"/>
											</g>
											<rect id="Rectangle_1174" data-name="Rectangle 1174" width="12.199" height="41.25" transform="translate(79.404 39.965) rotate(-2.61)" fill="#fff"/>
											<rect id="Rectangle_1175" data-name="Rectangle 1175" width="8.624" height="8.624" transform="translate(81.22 40.548) rotate(-2.61)" fill="#6c63ff"/>
											<rect id="Rectangle_1176" data-name="Rectangle 1176" width="8.635" height="8.635" transform="translate(82.032 50.619) rotate(-2.862)" fill="#6c63ff" opacity="0.5"/>
											<rect id="Rectangle_1177" data-name="Rectangle 1177" width="8.624" height="8.624" transform="translate(82.168 61.35) rotate(-2.61)" fill="#6c63ff" opacity="0.3"/>
											<path id="Path_7455" data-name="Path 7455" d="M266.788,376.489l-10.839,4.193-15.842,6.124c-.6-1.118-1.48-2.628-2.571-4.431-3.752-6.218-9.961-15.89-15.489-24.389C215.82,348.4,210.46,340.32,210.46,340.32l3.88-1.118,31.7-9.2Z" transform="translate(-182.21 -282.163)" fill="#e6ecf8"/>
											<path id="Path_7456" data-name="Path 7456" d="M287.216,376.489l-10.839,4.193a81.468,81.468,0,0,1-18.417,1.693c-3.752-6.218-9.961-15.89-15.489-24.389l-7.7-18.789,31.695-9.2Z" transform="translate(-202.638 -282.163)" opacity="0.1"/>
											<path id="Path_7457" data-name="Path 7457" d="M287.339,349.527s-16.838,9.961-41.978,7.708L225.32,308.373l9.6-1.651,33.2-5.7,18.842,47.557Z" transform="translate(-194.697 -257.811)" fill="#6c63ff"/>
											<path id="Path_7458" data-name="Path 7458" d="M337.509,348.617a79.6,79.6,0,0,1-13.167-.375,42.313,42.313,0,0,1-14.325-4.017,43.41,43.41,0,0,1-9.364-6.29c-6.983-6.28-11.3-15.264-15.184-31.172l33.2-5.7Z" transform="translate(-245.242 -257.844)" opacity="0.1"/>
											<path id="Path_7459" data-name="Path 7459" d="M338.005,271a91.925,91.925,0,0,1-25.046.934,42.313,42.313,0,0,1-14.325-4.017,43.45,43.45,0,0,1-9.364-6.29c-8.642-7.775-13.205-19.69-17.911-43.752,0,0,20.634,4.98,41.037-5.929C312.391,211.958,319.268,254.876,338.005,271Z" transform="translate(-233.385 -182.963)" fill="#f9fafb"/>
											<path id="Path_7460" data-name="Path 7460" d="M407.218,509.077a42.313,42.313,0,0,1-14.325-4.018,43.449,43.449,0,0,1-9.364-6.29c7.358-.6,8.415-4.619,8.415-4.619C397.4,502.806,407.218,509.077,407.218,509.077Z" transform="translate(-327.644 -420.102)" opacity="0.1"/>
											<path id="Path_7461" data-name="Path 7461" d="M338.2,280.375s16.779-.949,21.464-4.565l.711,2.283s-11.087,4.891-22.175,4.95Z" transform="translate(-289.552 -236.626)" fill="#6c63ff" opacity="0.3"/>
											<path id="Path_7462" data-name="Path 7462" d="M338.2,339.118s16.246-.889,28.52-6.818l.415.948s-9.74,5.686-28.935,7.174Z" transform="translate(-289.552 -284.096)" fill="#6c63ff" opacity="0.3"/>
											<path id="Path_7463" data-name="Path 7463" d="M346.39,366.628s16.246-.889,28.519-6.818l.415.948s-9.74,5.685-28.934,7.174Z" transform="translate(-296.434 -307.213)" fill="#6c63ff" opacity="0.3"/>
											<path id="Path_7464" data-name="Path 7464" d="M354.57,394.178s16.246-.889,28.52-6.818l.414.948s-9.74,5.686-28.934,7.174Z" transform="translate(-303.308 -330.364)" fill="#6c63ff" opacity="0.3"/>
											<path id="Path_7465" data-name="Path 7465" d="M362.76,421.728s16.246-.889,28.519-6.818l.415.948s-9.74,5.686-28.934,7.174Z" transform="translate(-310.191 -353.515)" fill="#6c63ff" opacity="0.3"/>
											<path id="Path_7466" data-name="Path 7466" d="M370.94,449.288s16.246-.889,28.52-6.818l.414.948s-9.74,5.685-28.934,7.174Z" transform="translate(-317.064 -376.674)" fill="#6c63ff" opacity="0.3"/>
											<path id="Path_7467" data-name="Path 7467" d="M1054.623,827.194s-6.751-.407-5.956,4.324a1.15,1.15,0,0,0,.6,1.215s.011-.351.691-.232a3.1,3.1,0,0,0,.734.035,1.517,1.517,0,0,0,.9-.37h0s1.9-.784,2.636-3.885c0,0,.546-.677.524-.851l-1.138.479a2.04,2.04,0,0,1,.083,1.5s-.037-1.474-.255-1.437c-.045,0-.592.284-.592.284a3.359,3.359,0,0,1,.16,2.472s.192-1.764-.374-2.368l-.8.468a3.544,3.544,0,0,1,.252,2.686,5.04,5.04,0,0,0-.422-2.572l-.727.567a3.464,3.464,0,0,1,.287,2.459s-.059-2.156-.446-2.319a4.133,4.133,0,0,0-.731.8s.5,1.057.19,1.616c0,0-.192-1.437-.348-1.437a4.741,4.741,0,0,0-.7,1.6,3.453,3.453,0,0,1,.546-1.694,1.917,1.917,0,0,0-.971.5s.1-.674,1.127-.731a4.486,4.486,0,0,1,.663-.766,4.17,4.17,0,0,0-1.641.19,1.834,1.834,0,0,1,1.83-.346l.717-.584a5.9,5.9,0,0,0-1.916.019,2.338,2.338,0,0,1,2.109-.16l.781-.466a7.109,7.109,0,0,0-1.83-.16,2.8,2.8,0,0,1,2.06.032l.557-.251s-.84-.16-1.086-.192-.26-.093-.26-.093a2.9,2.9,0,0,1,1.579.176A7.089,7.089,0,0,0,1054.623,827.194Z" transform="translate(-886.518 -699.958)" fill="#6c63ff"/>
											<ellipse id="Ellipse_69" data-name="Ellipse 69" cx="4.778" cy="0.808" rx="4.778" ry="0.808" transform="translate(158.678 132.379)" fill="#6c63ff" opacity="0.1"/>
											<ellipse id="Ellipse_70" data-name="Ellipse 70" cx="16.287" cy="1.475" rx="16.287" ry="1.475" transform="translate(113.651 128.695)" fill="#6c63ff" opacity="0.1"/>
											<path id="Path_7468" data-name="Path 7468" d="M1088.157,729.4s-3.805-.23-3.353,2.438a.65.65,0,0,0,.337.685s.008-.2.391-.131a1.774,1.774,0,0,0,.414.019.852.852,0,0,0,.5-.208h0a3.023,3.023,0,0,0,1.487-2.191s.308-.382.3-.479l-.639.273a1.157,1.157,0,0,1,.046.849s-.021-.832-.144-.813c-.026,0-.334.16-.334.16a1.894,1.894,0,0,1,.093,1.394s.109-.995-.211-1.336l-.452.265a2,2,0,0,1,.142,1.514,2.835,2.835,0,0,0-.238-1.45l-.409.319a1.951,1.951,0,0,1,.16,1.386s-.033-1.215-.251-1.306a2.558,2.558,0,0,0-.414.445s.284.6.109.912c0,0-.109-.81-.2-.813a2.669,2.669,0,0,0-.394.9,1.956,1.956,0,0,1,.308-.958,1.071,1.071,0,0,0-.548.284s.056-.38.639-.412a2.549,2.549,0,0,1,.374-.433,2.352,2.352,0,0,0-.926.107,1.04,1.04,0,0,1,1.031-.195l.406-.331a3.337,3.337,0,0,0-1.081.011,1.3,1.3,0,0,1,1.19-.086l.441-.263a3.978,3.978,0,0,0-1.033-.088,1.578,1.578,0,0,1,1.161.018l.319-.141s-.479-.094-.613-.109-.147-.053-.147-.053a1.647,1.647,0,0,1,.891.1A3.853,3.853,0,0,0,1088.157,729.4Z" transform="translate(-916.908 -617.787)" fill="#6c63ff"/>
											<ellipse id="Ellipse_71" data-name="Ellipse 71" cx="2.694" cy="0.455" rx="2.694" ry="0.455" transform="translate(165.936 114.517)" fill="#6c63ff" opacity="0.1"/>
											<path id="Path_7469" data-name="Path 7469" d="M943.758,743.9s-4.6-.278-4.053,2.943a.784.784,0,0,0,.407.827s0-.24.479-.16a2.1,2.1,0,0,0,.5.024,1.031,1.031,0,0,0,.61-.252h0a3.646,3.646,0,0,0,1.795-2.644s.372-.46.356-.58l-.784.332a1.386,1.386,0,0,1,.056,1.024s-.026-1-.174-.98c-.03,0-.4.195-.4.195a2.3,2.3,0,0,1,.112,1.683s.131-1.2-.254-1.613l-.546.319a2.415,2.415,0,0,1,.171,1.828,3.461,3.461,0,0,0-.286-1.756l-.5.386a2.351,2.351,0,0,1,.195,1.673s-.038-1.467-.3-1.578a3,3,0,0,0-.5.538s.342.72.129,1.1c0,0-.131-.977-.238-.982a3.341,3.341,0,0,0-.479,1.091,2.359,2.359,0,0,1,.372-1.153,1.293,1.293,0,0,0-.659.343s.067-.458.766-.5a2.947,2.947,0,0,1,.452-.521,2.829,2.829,0,0,0-1.118.128,1.253,1.253,0,0,1,1.244-.235l.489-.4a4.062,4.062,0,0,0-1.3.013,1.587,1.587,0,0,1,1.437-.1l.532-.319a4.834,4.834,0,0,0-1.247-.107,1.909,1.909,0,0,1,1.4.022l.38-.171s-.572-.112-.739-.129-.176-.064-.176-.064a1.973,1.973,0,0,1,1.075.118A4.917,4.917,0,0,0,943.758,743.9Z" transform="translate(-794.973 -629.966)" fill="#6c63ff"/>
											<ellipse id="Ellipse_72" data-name="Ellipse 72" cx="3.253" cy="0.549" rx="3.253" ry="0.549" transform="translate(142.368 117.434)" fill="#6c63ff" opacity="0.1"/>
											<ellipse id="Ellipse_73" data-name="Ellipse 73" cx="4.778" cy="0.808" rx="4.778" ry="0.808" transform="translate(3.949 129.971)" fill="#6c63ff" opacity="0.1"/>
											<path id="Path_7470" data-name="Path 7470" d="M68.1,818.19s2.724-.083,3.546-.667,4.192-1.277,4.4-.346,4.1,4.666,1.019,4.691-7.149-.479-7.97-.979S68.1,818.19,68.1,818.19Z" transform="translate(-62.582 -691.165)" fill="#a8a8a8"/>
											<path id="Path_7471" data-name="Path 7471" d="M77.1,829.253c-3.077.026-7.149-.479-7.97-.979-.623-.38-.872-1.745-.958-2.374H68.08s.172,2.2.992,2.7,4.9,1.006,7.973.99c.888-.008,1.194-.319,1.178-.8C78.1,829.071,77.76,829.248,77.1,829.253Z" transform="translate(-62.565 -698.879)" opacity="0.2"/>
											<rect id="Rectangle_1178" data-name="Rectangle 1178" width="27.252" height="48.769" transform="matrix(0.309, -0.951, 0.951, 0.309, 126.099, 25.919)" fill="url(#linear-gradient-7)"/>
											<rect id="Rectangle_1179" data-name="Rectangle 1179" width="26.877" height="48.095" transform="matrix(0.309, -0.951, 0.951, 0.309, 126.478, 25.846)" fill="#f6f7f9"/>
											<g id="Group_40" data-name="Group 40" transform="translate(134.702 9.424)" opacity="0.2">
											  <circle id="Ellipse_74" data-name="Ellipse 74" cx="5.008" cy="5.008" r="5.008" fill="#6c63ff"/>
											</g>
											<g id="Group_41" data-name="Group 41" transform="translate(151.69 12.227)" opacity="0.2">
											  <rect id="Rectangle_1180" data-name="Rectangle 1180" width="1.372" height="21.817" transform="matrix(0.309, -0.951, 0.951, 0.309, 0, 1.304)" fill="#6c63ff"/>
											</g>
											<g id="Group_42" data-name="Group 42" transform="translate(150.608 15.552)" opacity="0.2">
											  <rect id="Rectangle_1181" data-name="Rectangle 1181" width="1.372" height="11.114" transform="matrix(0.309, -0.951, 0.951, 0.309, 0, 1.304)" fill="#6c63ff"/>
											</g>
											<g id="Group_43" data-name="Group 43" transform="translate(149.525 18.88)" opacity="0.2">
											  <rect id="Rectangle_1182" data-name="Rectangle 1182" width="1.372" height="17.975" transform="matrix(0.309, -0.951, 0.951, 0.309, 0, 1.304)" fill="#6c63ff"/>
											</g>
											<g id="Group_44" data-name="Group 44" transform="translate(148.444 22.207)" opacity="0.2">
											  <rect id="Rectangle_1183" data-name="Rectangle 1183" width="1.372" height="21.817" transform="matrix(0.309, -0.951, 0.951, 0.309, 0, 1.304)" fill="#6c63ff"/>
											</g>
											<g id="Group_45" data-name="Group 45" transform="translate(161.493 31.889)" opacity="0.5">
											  <rect id="Rectangle_1184" data-name="Rectangle 1184" width="2.652" height="6.037" transform="matrix(0.309, -0.951, 0.951, 0.309, 0, 2.522)" fill="#6c63ff"/>
											</g>
											<path id="Path_7472" data-name="Path 7472" d="M794.237,441.105a1.443,1.443,0,0,0-.016-.16.812.812,0,0,0-.027-.16c-.021-.109-.043-.216-.069-.319-.013-.049-.026-.1-.04-.148a4.049,4.049,0,0,0-.8-1.544c-.021-.026-.043-.049-.064-.073s-.086-.093-.129-.136-.083-.081-.125-.118-.08-.07-.118-.1c-.077-.062-.148-.115-.211-.16a1.31,1.31,0,0,0-.129-.083.709.709,0,0,0-.3-.1l-.663-.065h0l-.905-.089-3.237-1.257-.128.045a7.333,7.333,0,0,1-.24-.8.715.715,0,0,0,.255-.187.584.584,0,0,0,.176-.225c.081-.188-.075-.589-.043-.819a3.866,3.866,0,0,1,.4-1.059,4.911,4.911,0,0,0,.535-2.282,2.574,2.574,0,0,0-1.063-2.025c-.343-.228-.747-.35-1.1-.557-.278-.16-.522-.374-.787-.556a4.525,4.525,0,0,0-4.458-.319,21.763,21.763,0,0,0-1.879,1.223,3.172,3.172,0,0,1-2.124.584.514.514,0,0,0-.022.093l-.062-.008c-.128.348.185.693.479.931a3.234,3.234,0,0,0,1.883.918,1.978,1.978,0,0,1,.819.061.75.75,0,0,1,.16.1,3.558,3.558,0,0,0,1.118,3.546l-1.653-.594s-.069.035-.176.1l-2.293-1.527s-4.6-1.667-5.875.929,5.536,1.257,5.536,1.257l1.458.8a1.327,1.327,0,0,0,.16.875l3.974,2.456a20.993,20.993,0,0,1-2.357.639c-.34,0-1.277.335-1.873,1.675s-2.726,7.875-4.6,8.964-6.812,8.378-6.812,8.378l.022.057c-.088.024-.174.048-.259.077a5.234,5.234,0,0,0-2.566,1.935.821.821,0,0,0,.575,1.295,3.585,3.585,0,0,0,3.527-1.33c.034-.043.064-.086.093-.129a.681.681,0,0,0,.479.022l2.384-1.927s-1.865,1.836-.771,3.513l-.083.117a26.654,26.654,0,0,0-3.992,8.69s-1.022.754-1.107,3.77A57.724,57.724,0,0,1,764,483.173s-.68,5.782-.255,7.54c0,0,.049.07.141.177-.032.038-.067.08-.105.121a2.068,2.068,0,0,1-1.824.8c-1.191-.252-1.191,1.843.511,2.01a45.371,45.371,0,0,1,4.65.932.979.979,0,0,0,1.214-1.044,8.846,8.846,0,0,0-.511-2.306c-.018-.04-.035-.08-.053-.117.049-.048.1-.1.15-.147,0,0,0-3.687.6-4.691,0,0,1.618-7.625,1.531-9.552-.065-1.507,4.2-7.379,6.053-9.859l-.016-.094c.479-.639.776-1.022.776-1.022l1.435,9.134a13.064,13.064,0,0,0,1.533,3.1s3.661,6.954,4.088,9.132a6.869,6.869,0,0,0,1.29,3.005l-.11.105a1.864,1.864,0,0,1-1.606.576c-1.191-.252-1.191,1.843.511,2.01a45.747,45.747,0,0,1,4.648.934.98.98,0,0,0,1.215-1.046,7.553,7.553,0,0,0-.655-2.6,1.816,1.816,0,0,0-.1-.16.9.9,0,0,0,.339-.238s-2.215-5.279-2.215-6.707c0,0-.936-5.445-4.086-7.455a75.289,75.289,0,0,1,1.194-10.6c.022-.093.045-.185.067-.275a25.264,25.264,0,0,0,2.485-.517l.085-2.513.426,2.01,4.768-2.932s-.042-.529-.121-1.338c-.042-.406-.091-.881-.15-1.4-.048-.412-.1-.849-.16-1.3-.016-.112-.03-.225-.046-.337-.062-.452-.131-.909-.2-1.356q-.043-.252-.086-.5c-.04-.219-.08-.433-.121-.639-.021-.1-.043-.208-.064-.308s-.045-.2-.067-.3-.045-.192-.067-.286c-.013-.046-.024-.093-.035-.137-.024-.091-.048-.18-.072-.267a4.791,4.791,0,0,1-.172-1.1v-.442a3.169,3.169,0,0,1,.043-.441c.01-.072.022-.145.037-.217a4.883,4.883,0,0,1,.241-.856c.053-.139.113-.276.179-.412.16-.319.319-.659.489-1.022.086-.18.172-.366.259-.554s.174-.38.262-.575a25.215,25.215,0,0,0,1.865-5.258c.022-.142.04-.276.048-.4A2.561,2.561,0,0,0,794.237,441.105Z" transform="translate(-644.942 -363.985)" fill="url(#linear-gradient-8)"/>
											<path id="Path_7473" data-name="Path 7473" d="M833.853,469.248l-2.809-1.9s-4.46-1.653-5.7.909,5.368,1.239,5.368,1.239l2.809,1.568Z" transform="translate(-698.781 -397.14)" fill="#ae6e79"/>
											<rect id="Rectangle_1185" data-name="Rectangle 1185" width="26.865" height="41.822" transform="matrix(0.541, -0.841, 0.841, 0.541, 104.599, 87.861)" fill="#f9fafb"/>
											<rect id="Rectangle_1186" data-name="Rectangle 1186" width="7.601" height="1.788" transform="matrix(0.536, -0.844, 0.844, 0.536, 109.813, 86.284)" fill="#b7b6cc"/>
											<rect id="Rectangle_1187" data-name="Rectangle 1187" width="16.693" height="1.64" transform="matrix(0.536, -0.844, 0.844, 0.536, 114.638, 87.584)" fill="#b7b6cc"/>
											<rect id="Rectangle_1188" data-name="Rectangle 1188" width="16.693" height="1.64" transform="matrix(0.536, -0.844, 0.844, 0.536, 117.595, 89.461)" fill="#b7b6cc"/>
											<rect id="Rectangle_1189" data-name="Rectangle 1189" width="16.693" height="1.64" transform="matrix(0.536, -0.844, 0.844, 0.536, 120.551, 91.341)" fill="#b7b6cc"/>
											<rect id="Rectangle_1190" data-name="Rectangle 1190" width="16.669" height="1.638" transform="matrix(0.541, -0.841, 0.841, 0.541, 123.609, 94.065)" fill="#b7b6cc"/>
											<rect id="Rectangle_1191" data-name="Rectangle 1191" width="16.693" height="1.64" transform="matrix(0.536, -0.844, 0.844, 0.536, 126.463, 95.097)" fill="#fff"/>
											<rect id="Rectangle_1192" data-name="Rectangle 1192" width="16.693" height="1.64" transform="matrix(0.536, -0.844, 0.844, 0.536, 129.42, 96.974)" fill="#fff"/>
											<rect id="Rectangle_1193" data-name="Rectangle 1193" width="4.323" height="4.323" transform="matrix(0.536, -0.844, 0.844, 0.536, 141.834, 88.97)" fill="#b7b6cc"/>
											<path id="Path_7474" data-name="Path 7474" d="M900.847,821.93a43.827,43.827,0,0,0-4.509-.92c-1.653-.16-1.653-2.236-.495-1.983a1.789,1.789,0,0,0,1.557-.567,3.639,3.639,0,0,0,.319-.35.958.958,0,0,1,.535-.327,4.478,4.478,0,0,1,2.7.088,1.167,1.167,0,0,1,.428.469,7.667,7.667,0,0,1,.639,2.555.958.958,0,0,1-1.174,1.035Z" transform="translate(-757.467 -691.917)" fill="#bebed0"/>
											<path id="Path_7475" data-name="Path 7475" d="M769.984,827.136a43.719,43.719,0,0,0-4.508-.92c-1.653-.16-1.653-2.236-.5-1.982a1.981,1.981,0,0,0,1.768-.781c.045-.048.085-.094.118-.137A.958.958,0,0,1,767.4,823a4.459,4.459,0,0,1,2.7.088,1.462,1.462,0,0,1,.567.755,8.94,8.94,0,0,1,.495,2.272.958.958,0,0,1-1.178,1.024Z" transform="translate(-647.501 -696.297)" fill="#bebed0"/>
											<path id="Path_7476" data-name="Path 7476" d="M784.25,823.834c-1.972,2.033-3.663-.038-3.92-.38.045-.048.085-.094.118-.137a.958.958,0,0,1,.533-.319,4.459,4.459,0,0,1,2.7.088A1.379,1.379,0,0,1,784.25,823.834Z" transform="translate(-661.083 -696.297)" opacity="0.1"/>
											<path id="Path_7477" data-name="Path 7477" d="M913.87,818.341c-.854.583-3.73.439-3.73.439a2.694,2.694,0,0,1-.26-.319,3.639,3.639,0,0,0,.319-.35.958.958,0,0,1,.535-.327,4.478,4.478,0,0,1,2.7.088A1.167,1.167,0,0,1,913.87,818.341Z" transform="translate(-769.947 -691.916)" opacity="0.1"/>
											<path id="Path_7478" data-name="Path 7478" d="M804.274,673.759c-.58.744-3.882.578-3.882.578a6.33,6.33,0,0,1-1.405-3.138c-.414-2.146-3.965-9-3.965-9a12.986,12.986,0,0,1-1.487-3.056l-1.4-9s-6.772,8.92-6.689,10.82-1.488,9.421-1.488,9.421c-.578.992-.578,4.631-.578,4.631-2.146,2.235-3.963-.414-3.963-.414-.414-1.734.248-7.433.248-7.433a57.781,57.781,0,0,0,1.073-7.764c.081-2.973,1.075-3.716,1.075-3.716a26.485,26.485,0,0,1,3.879-8.568c.5-.714.829-1.1.829-1.1l13.379,1.57a8.426,8.426,0,0,0-.575,1.772,75.452,75.452,0,0,0-1.159,10.451c3.056,1.982,3.965,7.345,3.965,7.345C802.127,668.555,804.274,673.759,804.274,673.759Z" transform="translate(-660.199 -547.721)" fill="#5c5c8e"/>
											<g id="Group_46" data-name="Group 46" transform="translate(120.977 98.295)" opacity="0.05">
											  <path id="Path_7479" data-name="Path 7479" d="M801.389,672.91l-.172-1.1s-6.772,8.92-6.689,10.82-1.487,9.421-1.487,9.421c-.58.992-.58,4.631-.58,4.631a2.823,2.823,0,0,1-1.292.829,2.271,2.271,0,0,0,2.283-.829s0-3.634.578-4.631c0,0,1.57-7.516,1.487-9.421C795.454,681.143,799.588,675.353,801.389,672.91Z" transform="translate(-791.17 -667.689)"/>
											  <path id="Path_7480" data-name="Path 7480" d="M840.268,667.135s-.909-5.368-3.963-7.345a75.611,75.611,0,0,1,1.158-10.451,8.424,8.424,0,0,1,.576-1.772L824.659,646s-.032.035-.089.105l12.477,1.464a8.432,8.432,0,0,0-.575,1.772,75.445,75.445,0,0,0-1.159,10.451c3.056,1.982,3.965,7.345,3.965,7.345,0,1.4,2.148,6.607,2.148,6.607-.342.438-1.629.56-2.63.588.8.021,3.141.029,3.62-.588C842.416,673.743,840.268,668.539,840.268,667.135Z" transform="translate(-819.237 -646)"/>
											</g>
											<path id="Path_7481" data-name="Path 7481" d="M785.3,631.273a3.016,3.016,0,0,1-.391.683,3.453,3.453,0,0,1-3.42,1.311.813.813,0,0,1-.559-1.277,5.088,5.088,0,0,1,2.489-1.916,4.544,4.544,0,0,1,1.055-.214Z" transform="translate(-661.459 -534.142)" fill="#ae6e79"/>
											<path id="Path_7482" data-name="Path 7482" d="M876.48,481.3l-6.623-2.422s-1.9.992-1.156,2.4l6.449,4.048Z" transform="translate(-735.198 -407.27)" fill="#42383c"/>
											<path id="Path_7483" data-name="Path 7483" d="M876.632,481.472l-6.625-2.422s-1.9.99-1.156,2.4l6.441,4.046Z" transform="translate(-735.324 -407.413)" opacity="0.1"/>
											<path id="Path_7484" data-name="Path 7484" d="M901.078,468.192s-.083,3.882,1.653,5.2-5.039,2.065-5.039,2.065,1.075-3.965,0-6.029S901.078,468.192,901.078,468.192Z" transform="translate(-759.564 -398.152)" fill="#ae6e79"/>
											<path id="Path_7485" data-name="Path 7485" d="M833.628,647.52a8.423,8.423,0,0,0-.575,1.772,21.856,21.856,0,0,1-13.549-2.1c-.03-.048-.059-.1-.085-.144.5-.714.829-1.1.829-1.1Z" transform="translate(-693.932 -547.663)" opacity="0.1"/>
											<path id="Path_7486" data-name="Path 7486" d="M799.191,631.315a3.018,3.018,0,0,1-.391.683c-.765-.128-1.376-1.6-1.49-1.875a4.542,4.542,0,0,1,1.055-.214Z" transform="translate(-675.352 -534.184)" opacity="0.1"/>
											<path id="Path_7487" data-name="Path 7487" d="M818.737,490.78l-2.973,1.073-1.239,1.653s-2.555.826-2.89.826-1.239.331-1.817,1.651-2.643,7.767-4.46,8.838-6.607,8.259-6.607,8.259.826,2.236,1.817,1.9l2.312-1.9s-1.817,1.817-.744,3.47a22.234,22.234,0,0,0,16.107,1.568l.081-2.477.414,1.982,4.631-2.89a58.629,58.629,0,0,0-1.159-8.045,4.905,4.905,0,0,1,.319-3.419c1.2-2.5,3.05-6.673,2.825-8.195a3.8,3.8,0,0,0-1.667-2.807.691.691,0,0,0-.291-.1l-1.512-.15Z" transform="translate(-676.562 -417.27)" fill="#42383c"/>
											<path id="Path_7488" data-name="Path 7488" d="M837.775,542.76s-1.653,7.681-3.47,8.92-6.689,5.2-6.855,5.865" transform="translate(-700.679 -460.95)" opacity="0.05"/>
											<path id="Path_7489" data-name="Path 7489" d="M833.123,541.21s-1.651,7.681-3.468,8.92-6.691,5.2-6.855,5.863" transform="translate(-696.772 -459.647)" fill="#42383c"/>
											<path id="Path_7490" data-name="Path 7490" d="M897.28,499.762s5.7-1.9,7.345-1.405" transform="translate(-759.359 -423.568)" opacity="0.1"/>
											<g id="Group_47" data-name="Group 47" transform="translate(141.895 73.51)" opacity="0.05">
											  <path id="Path_7491" data-name="Path 7491" d="M927.2,510.253c1.2-2.5,3.05-6.673,2.825-8.195a3.8,3.8,0,0,0-1.667-2.807.69.69,0,0,0-.291-.1l-.639-.064a.639.639,0,0,1,.192.078,3.81,3.81,0,0,1,1.665,2.809c.225,1.52-1.625,5.7-2.823,8.195a4.9,4.9,0,0,0-.319,3.417,58.5,58.5,0,0,1,1.161,8.045l-3.982,2.489.1.479,4.631-2.89a58.626,58.626,0,0,0-1.159-8.045A4.906,4.906,0,0,1,927.2,510.253Z" transform="translate(-923.136 -497.763)"/>
											  <path id="Path_7492" data-name="Path 7492" d="M891.3,461.506l.715.072-3.111-1.228-.279.1Z" transform="translate(-888.63 -460.35)"/>
											</g>
											<path id="Path_7493" data-name="Path 7493" d="M887.45,585.3s2.555-1.4,3.387-1.073,3.882-.083,3.882-.083" transform="translate(-751.099 -495.722)" opacity="0.05"/>
											<path id="Path_7494" data-name="Path 7494" d="M900.821,470.965c-.094-.829.289-.7.289-.7s-4.46-.826-3.387,1.239a4.73,4.73,0,0,1,.453,1.816h.043C899.459,473.318,900.182,471.932,900.821,470.965Z" transform="translate(-759.591 -399.892)" opacity="0.05"/>
											<circle id="Ellipse_75" data-name="Ellipse 75" cx="3.551" cy="3.551" r="3.551" transform="translate(135.072 65.994)" fill="#ae6e79"/>
											<path id="Path_7495" data-name="Path 7495" d="M870.3,440.456a4.952,4.952,0,0,0,.519-2.25,2.551,2.551,0,0,0-1.032-2c-.332-.224-.725-.343-1.071-.548-.27-.16-.508-.369-.765-.548a4.329,4.329,0,0,0-4.324-.319A19.866,19.866,0,0,0,861.809,436a3.053,3.053,0,0,1-2.06.576c-.125.343.18.682.46.918a3.109,3.109,0,0,0,1.827.9,1.912,1.912,0,0,1,.8.061,1.145,1.145,0,0,1,.406.377,7.436,7.436,0,0,1,.843,1.429,1.185,1.185,0,0,0,.377.556c.319.2.733.034,1.118.019a2.3,2.3,0,0,1,1.552.742,4.739,4.739,0,0,0,1.4,1.059c.41.16,1.231.15,1.437-.34.078-.185-.073-.581-.042-.808a3.91,3.91,0,0,1,.38-1.038Z" transform="translate(-727.797 -369.86)" opacity="0.1"/>
											<path id="Path_7496" data-name="Path 7496" d="M870.772,439.926a4.929,4.929,0,0,0,.519-2.248,2.554,2.554,0,0,0-1.03-2c-.334-.225-.727-.345-1.071-.549-.27-.16-.508-.367-.765-.548a4.329,4.329,0,0,0-4.324-.319,19.854,19.854,0,0,0-1.822,1.206,3.044,3.044,0,0,1-2.06.576c-.125.345.179.683.46.918a3.12,3.12,0,0,0,1.827.905,1.886,1.886,0,0,1,.8.061,1.118,1.118,0,0,1,.406.377,7.346,7.346,0,0,1,.841,1.428,1.188,1.188,0,0,0,.378.556c.319.2.733.034,1.118.019a2.3,2.3,0,0,1,1.551.744,4.7,4.7,0,0,0,1.4,1.057c.41.16,1.231.15,1.437-.34.08-.185-.072-.581-.04-.808A3.905,3.905,0,0,1,870.772,439.926Z" transform="translate(-728.191 -369.415)" fill="#42383c"/>
											<path id="Path_7497" data-name="Path 7497" d="M381.8,485.444a1.646,1.646,0,0,1-1.057.374l-71.34-.3a2.2,2.2,0,0,1-.49-1.672l7.048-57.671,4.42-.048a1.67,1.67,0,0,1,1.629,1.233l.826,3.047a1.67,1.67,0,0,0,1.651,1.233l17.64-.423a1.67,1.67,0,0,0,1.63-1.67v-2.018a1.67,1.67,0,0,1,1.651-1.67l24.444-.263a1.67,1.67,0,0,1,1.656,1.356l10.81,56.526.07.364A1.661,1.661,0,0,1,381.8,485.444Z" transform="translate(-264.928 -362.489)" opacity="0.1"/>
											<path id="Path_7498" data-name="Path 7498" d="M292.58,430.6l-24.444.263a1.67,1.67,0,0,0-1.653,1.669v2.02a1.67,1.67,0,0,1-1.629,1.669l-17.638.423a1.669,1.669,0,0,1-1.653-1.233l-.829-3.045a1.669,1.669,0,0,0-1.63-1.233l-23.561.254a1.669,1.669,0,0,0-1.629,1.948l9.479,55.785a1.67,1.67,0,0,0,1.64,1.391l74.433.319a1.67,1.67,0,0,0,1.646-1.983l-10.877-56.892A1.669,1.669,0,0,0,292.58,430.6Z" transform="translate(-188.455 -366.699)" fill="#e6e8ee"/>
											<path id="Path_7499" data-name="Path 7499" d="M862.12,160.07l-.128,1.421.093,2.513-.27,4.239a4.141,4.141,0,0,1-1.087,2.727l-2.678,4.112-.016.008-1.008.492-1.538.16-.8-1.934.529-2.124.294-.4.081-.089a9.243,9.243,0,0,1,2.531-2.025,1.385,1.385,0,0,0,.538-1.23,30.613,30.613,0,0,1,.881-4.739,15.906,15.906,0,0,0,.5-2.895c-.139-.257-.026-6.1,2.178-6.186S862.12,160.07,862.12,160.07Z" transform="translate(-723.57 -134.371)" fill="#f6bac2"/>
											<ellipse id="Ellipse_76" data-name="Ellipse 76" cx="2.588" cy="0.356" rx="2.588" ry="0.356" transform="translate(21.592 111.561)" fill="#6c63ff" opacity="0.1"/>
											<ellipse id="Ellipse_77" data-name="Ellipse 77" cx="2.588" cy="0.356" rx="2.588" ry="0.356" transform="translate(11.677 112.566)" fill="#6c63ff" opacity="0.1"/>
											<ellipse id="Ellipse_78" data-name="Ellipse 78" cx="2.588" cy="0.356" rx="2.588" ry="0.356" transform="translate(0 111.205)" fill="#6c63ff" opacity="0.1"/>
											<ellipse id="Ellipse_79" data-name="Ellipse 79" cx="1.839" cy="0.252" rx="1.839" ry="0.252" transform="translate(16.394 115.533)" fill="#6c63ff" opacity="0.1"/>
											<ellipse id="Ellipse_80" data-name="Ellipse 80" cx="1.839" cy="0.252" rx="1.839" ry="0.252" transform="translate(6.105 115.28)" fill="#6c63ff" opacity="0.1"/>
											<path id="Path_7500" data-name="Path 7500" d="M64.529,633.685s3.63-11.9-.568-16.666a7.9,7.9,0,0,0-8.3-2.7,2.953,2.953,0,0,0-1.9,1.582c-.559,1.2-.458,3.159,3.483,5.44,6.6,3.82,7.007,9.059,7.007,9.059Z" transform="translate(-50.319 -520.841)" fill="#6c63ff"/>
											<path id="Path_7501" data-name="Path 7501" d="M70.54,626.41s10.7,3.353,8.3,17.676" transform="translate(-64.632 -531.243)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<path id="Path_7502" data-name="Path 7502" d="M103.909,633.92a2.365,2.365,0,0,0-1,2.486" transform="translate(-91.751 -537.554)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<path id="Path_7503" data-name="Path 7503" d="M77.26,636.5a1.858,1.858,0,0,1,2-.41" transform="translate(-70.279 -539.247)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<path id="Path_7504" data-name="Path 7504" d="M103.75,666.733s1.582-.8,1.991.2" transform="translate(-92.539 -564.874)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<path id="Path_7505" data-name="Path 7505" d="M121.9,678.76s-1.188-.094-1.209.479" transform="translate(-106.774 -575.228)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<path id="Path_7506" data-name="Path 7506" d="M89.692,693.148s-4.252-8.648-5.419-8.463c-.554.091-.81.639-.926,1.185a3.479,3.479,0,0,0,.232,2.1A9.318,9.318,0,0,0,89.692,693.148Z" transform="translate(-75.335 -580.21)" fill="#6c63ff"/>
											<path id="Path_7507" data-name="Path 7507" d="M89.71,695s4.461,6.47,5.324,6.754" transform="translate(-80.741 -588.88)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<line id="Line_59" data-name="Line 59" x2="1.041" transform="translate(8.559 107.13)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<line id="Line_60" data-name="Line 60" x2="1.634" y2="0.07" transform="translate(9.806 109.497)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<line id="Line_61" data-name="Line 61" x1="0.177" y2="0.851" transform="translate(10.623 107.603)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<line id="Line_62" data-name="Line 62" x1="0.032" y2="0.773" transform="translate(12.504 110.191)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<path id="Path_7508" data-name="Path 7508" d="M122.66,693.148s4.251-8.648,5.418-8.463c.556.091.811.639.926,1.185a3.479,3.479,0,0,1-.232,2.1A9.323,9.323,0,0,1,122.66,693.148Z" transform="translate(-108.429 -580.21)" fill="#6c63ff"/>
											<path id="Path_7509" data-name="Path 7509" d="M128.375,695s-4.471,6.47-5.325,6.754" transform="translate(-108.757 -588.88)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<line id="Line_63" data-name="Line 63" x1="1.041" transform="translate(18.987 107.13)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<line id="Line_64" data-name="Line 64" x1="1.634" y2="0.07" transform="translate(17.148 109.497)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<line id="Line_65" data-name="Line 65" x2="0.177" y2="0.851" transform="translate(17.787 107.603)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<line id="Line_66" data-name="Line 66" x2="0.032" y2="0.773" transform="translate(16.051 110.191)" fill="none" stroke="#565987" stroke-miterlimit="10" stroke-width="1"/>
											<path id="Path_7510" data-name="Path 7510" d="M75.611,744.167a.734.734,0,0,1-.241-.366.319.319,0,0,1,.169-.372.469.469,0,0,1,.447.16.571.571,0,0,0,.433.2.661.661,0,0,1-.2-.62.252.252,0,0,1,.056-.126c.086-.093.243-.053.347.021a1.311,1.311,0,0,1,.422,1.078,2.06,2.06,0,0,0,0-.444.455.455,0,0,1,.179-.388.5.5,0,0,1,.254-.061.527.527,0,0,1,.414.118.41.41,0,0,1-.016.506,1.629,1.629,0,0,1-.428.342.959.959,0,0,0-.3.292.215.215,0,0,0-.022.051h-.929A2.575,2.575,0,0,1,75.611,744.167Z" transform="translate(-68.681 -629.21)" fill="#6c63ff"/>
											<path id="Path_7511" data-name="Path 7511" d="M177.06,722.4a.723.723,0,0,1-.241-.364.319.319,0,0,1,.168-.372.469.469,0,0,1,.447.16.589.589,0,0,0,.436.209.661.661,0,0,1-.206-.618.254.254,0,0,1,.057-.126c.086-.093.243-.053.346.019a1.292,1.292,0,0,1,.422,1.079,2.074,2.074,0,0,0,0-.445.457.457,0,0,1,.16-.393.509.509,0,0,1,.254-.059.533.533,0,0,1,.414.117.41.41,0,0,1-.018.508,1.6,1.6,0,0,1-.426.342.949.949,0,0,0-.3.291.261.261,0,0,0-.022.053h-.909A2.557,2.557,0,0,1,177.06,722.4Z" transform="translate(-153.931 -610.924)" fill="#6c63ff"/>
											<path id="Path_7512" data-name="Path 7512" d="M143.243,744.209a.749.749,0,0,1-.243-.366.319.319,0,0,1,.169-.372.469.469,0,0,1,.447.16.594.594,0,0,0,.436.211.666.666,0,0,1-.206-.62.254.254,0,0,1,.057-.126c.086-.093.243-.053.346.021a1.292,1.292,0,0,1,.422,1.078,2.062,2.062,0,0,0,0-.444.457.457,0,0,1,.168-.393.493.493,0,0,1,.254-.061.528.528,0,0,1,.414.118.409.409,0,0,1-.018.506,1.622,1.622,0,0,1-.426.342.958.958,0,0,0-.3.292.214.214,0,0,0-.022.051h-.926A2.606,2.606,0,0,1,143.243,744.209Z" transform="translate(-125.512 -629.251)" fill="#6c63ff"/>
											<path id="Path_7513" data-name="Path 7513" d="M44.588,706.25s-.347.453.16,1.139.925,1.263.755,1.689c0,0-.765-1.277-1.388-1.289S43.9,707.008,44.588,706.25Z" transform="translate(-42.169 -598.334)" fill="#6c63ff"/>
											<path id="Path_7514" data-name="Path 7514" d="M44.594,706.25a.573.573,0,0,0-.07.142c-.607.714-.931,1.38-.346,1.4.543.016,1.2.987,1.351,1.233a.58.58,0,0,1-.018.056s-.765-1.277-1.388-1.289S43.909,707.008,44.594,706.25Z" transform="translate(-42.175 -598.334)" opacity="0.1"/>
											<path id="Path_7515" data-name="Path 7515" d="M44.66,709.332c0,.16.018.289.04.289s.04-.129.04-.289-.022-.085-.045-.085S44.66,709.172,44.66,709.332Z" transform="translate(-42.884 -600.838)" fill="#ffd037"/>
											<path id="Path_7516" data-name="Path 7516" d="M42.819,710.494c.141.077.262.121.273.1s-.094-.1-.235-.172-.085-.021-.1,0S42.678,710.417,42.819,710.494Z" transform="translate(-41.265 -601.809)" fill="#ffd037"/>
											<path id="Path_7517" data-name="Path 7517" d="M55.143,706.25s.348.453-.16,1.139-.925,1.263-.755,1.689c0,0,.765-1.277,1.388-1.289S55.828,707.008,55.143,706.25Z" transform="translate(-50.893 -598.334)" fill="#6c63ff"/>
											<path id="Path_7518" data-name="Path 7518" d="M55.244,706.25a.607.607,0,0,1,.072.142c.607.714.931,1.38.347,1.4-.543.016-1.2.987-1.352,1.233a.326.326,0,0,0,.019.056s.765-1.277,1.388-1.289S55.929,707.008,55.244,706.25Z" transform="translate(-50.993 -598.334)" opacity="0.1"/>
											<path id="Path_7519" data-name="Path 7519" d="M63.78,709.332c0,.16-.018.289-.04.289s-.04-.129-.04-.289.022-.085.045-.085S63.78,709.172,63.78,709.332Z" transform="translate(-58.884 -600.838)" fill="#ffd037"/>
											<path id="Path_7520" data-name="Path 7520" d="M64.15,710.494c-.141.077-.263.121-.273.1s.094-.1.235-.172.085-.021.094,0S64.289,710.417,64.15,710.494Z" transform="translate(-59.032 -601.809)" fill="#ffd037"/>
											<path id="Path_7521" data-name="Path 7521" d="M44.522,720.833a3.562,3.562,0,0,1-1.261-.238c-.292-.208-1.491-.457-1.565-.123s-1.456,1.661-.362,1.669a9.324,9.324,0,0,0,2.836-.348C44.461,721.615,44.522,720.833,44.522,720.833Z" transform="translate(-39.736 -610.148)" fill="#a8a8a8"/>
											<path id="Path_7522" data-name="Path 7522" d="M41.318,724.773a9.212,9.212,0,0,0,2.836-.348c.222-.134.31-.62.34-.845h.032s-.061.782-.353.958a9.319,9.319,0,0,1-2.836.348c-.319,0-.425-.115-.418-.281C40.962,724.709,41.091,724.765,41.318,724.773Z" transform="translate(-39.74 -612.897)" opacity="0.2"/>
											<circle id="Ellipse_81" data-name="Ellipse 81" cx="3.454" cy="3.454" r="3.454" transform="translate(1.966 16.781)" fill="#6c63ff" opacity="0.1"/>
											<circle id="Ellipse_82" data-name="Ellipse 82" cx="3.454" cy="3.454" r="3.454" transform="translate(168.046 44.381)" fill="#6c63ff" opacity="0.1"/>
											<circle id="Ellipse_83" data-name="Ellipse 83" cx="3.454" cy="3.454" r="3.454" transform="translate(105.96 5.813)" fill="#6c63ff" opacity="0.1"/>
											<circle id="Ellipse_84" data-name="Ellipse 84" cx="5.788" cy="5.788" r="5.788" transform="translate(6.539 33.501)" fill="#6c63ff" opacity="0.1"/>
											<path id="Path_7523" data-name="Path 7523" d="M462.3,606.5l-.2-.2a.219.219,0,0,1,0-.319l1.793-1.795a.219.219,0,0,1,.319,0L466,605.979a.222.222,0,0,1,0,.319l-.2.2a.222.222,0,0,1-.319,0l-1.06-1.118v2.652a.22.22,0,0,1-.22.222h-.3a.222.222,0,0,1-.222-.222v-2.649l-1.06,1.118a.222.222,0,0,1-.319,0Z" transform="translate(-393.606 -512.509)" fill="#f6f7f9"/>
											<path id="Path_7524" data-name="Path 7524" d="M453,591.819a3.639,3.639,0,1,1-3.639,3.639A3.639,3.639,0,0,1,453,591.819m0-.479a4.118,4.118,0,1,0,4.118,4.118A4.118,4.118,0,0,0,453,591.34Z" transform="translate(-382.559 -501.773)" fill="#f6f7f9"/>
										  </g>
										</svg>
										</div>
									<h3><?php echo esc_html__("Import Designs (.Json)","theplus"); ?></h3>
									<fieldset id="elementor-import-template-form-inputs">
										<input type="file" name="file" accept=".json,application/json,.zip,application/octet-stream,application/zip,application/x-zip,application/x-zip-compressed" required>
										<input type="submit" class="button" value="<?php echo esc_attr__( 'Import Now', 'theplus' ); ?>">
									</fieldset>
								</form>
							</div>
									
						</div>
						<?php }else{ ?>
							<div class="pt-plus-page-form text-center">
								<div class="plus-notice-varified">
									<img src="<?php echo THEPLUS_ASSETS_URL; ?>/images/verify-plugin-note.png" />
									<div class="plus-notice-block-content">
										<div class="plus-notice-importance-title"><?php echo esc_html__('Important Notice','theplus'); ?></div>
										<div class="plus-notice-importance-desc-title"><?php echo '<a href="admin.php?page=theplus_purchase_code">'.esc_html__("Verify","theplus").'</a>'; ?><?php echo esc_html__(' your plugin and get access of all functionalities. Go to Verify section of settings to proceed further.','theplus'); ?></div>
									</div>
								</div>
							</div>
						<?php } ?>
					</div>
				</div> <?php
	}

	
	public function theplus_pro_purchase_code_field() { 
		$verify_api=theplus_check_api_status(); 

		$purchase_option=get_option( 'theplus_purchase_code' );
		$plus_key = isset($purchase_option['tp_api_key']) ? sanitize_text_field($purchase_option['tp_api_key']) : '';
		$cls_close='';
		if($verify_api==1 && !empty($plus_key)){		
			$cls_close = ' tp-close-up-box';
		} ?>
		<div class="tp_active_mainwrapp">
						<div class="theplus_about-tab changelog <?php echo $cls_close; ?>">
						<?php if(THEPLUS_TYPE=='code'){ ?>
							<div class="feature-section">
								<h4 style="padding-left:15px;"><?php echo esc_html__('Verify your plugin in 4 easy steps : Read below or ','theplus');?><?php echo '<a href="https://youtu.be/X-9CxBP6nJY" target="_blank" rel="noopener noreferrer">Watch Our Video Tutorial</a>' ?></h4>					
								<p style="padding-left:15px;"><?php echo esc_html__('1. Visit this ','theplus'); ?><?php echo '<i><a href="https://store.posimyth.com/theplus-verify" target="_blank" rel="noopener noreferrer">Verification URL</a></i>, Where you need to enter your "Envato Purchase Code" and press "Submit" button.</br>  <b> Note</b> : How to get purchase code : visit this <a href="https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-" target="_blank" rel="noopener noreferrer">URL</a> or check <a href="https://www.youtube.com/watch?v=UsoNThFMHv8" target="_blank" rel="noopener noreferrer"> Video</a>'; ?></p>
								<p style="padding-left:15px;"><?php echo esc_html__('2. Add Your Website URL in the form with your email address.','theplus'); ?> </br><?php echo '<b>Important</b> : Website URL must be Home URL. You can get that by going Settings -> General -> WordPress Address (URL) and copy URL from there.'; ?></p>
								<p style="padding-left:15px;"><?php echo esc_html__('3. You will get "The Plus Unique Key" after submitting your details. Now Copy that key.','theplus'); ?></p>
								<p style="padding-left:15px;"><?php echo esc_html__('4.Enter Your "The Plus Unique key" at Verification Area and Press "Save" Button. Your Plugin is now verified to use all functionalities.','theplus'); ?></p>
								
							</div>							
						<?php } 
						if(THEPLUS_TYPE=='store'){ ?>
							<div class="feature-section">
								<h4 style="padding-left:15px;"><?php echo esc_html__('Verify your plugin in 4 easy steps :','theplus');?></h4>					
								<p style="padding-left:15px;"><?php echo esc_html__('1. Visit your ','theplus'); ?><?php echo '<i><a href="https://store.posimyth.com/checkout/purchase-history/" target="_blank" rel="noopener noreferrer">Purchase History</a></i>'; ?></p>
								<p style="padding-left:15px;"><?php echo esc_html__('2. In the Page of "Purchase History" Go to View Licenses -> Manage Sites.','theplus'); ?></p>
								<p style="padding-left:15px;"><?php echo esc_html__('3. Add Your Home URL in the form and press "Add Site". Important : Website URL must be Home URL. You can get that by going Settings -> General -> WordPress Address (URL) and copy URL from there.','theplus'); ?></p>
								<p style="padding-left:15px;"><?php echo esc_html__('4. Now Your License Key will be activated for your Entered Website URL. Use that License key to activate your plugin.','theplus'); ?></p>
								
							</div>
						<?php } ?>
					</div> <?php
				
					$purchase_option=get_option( 'theplus_purchase_code' );
					$plus_key =$plus_last_key_char='';
					if(isset($purchase_option['tp_api_key']) && !empty($purchase_option['tp_api_key'])){
						$plus_key = sanitize_text_field($purchase_option['tp_api_key']);
						$plus_last_key_char = substr($plus_key, -4);
					}
					?>
					<div id="theplus_purchase_code" class="group theplus_form_content">
					<form class="cmb-form" action="<?php echo esc_url( admin_url('admin-post.php') ); ?>" method="post" id="theplus_purchase_code" enctype="multipart/form-data" encoding="multipart/form-data">
						<?php wp_nonce_field( 'nonce_theplus_purchase_action', 'nonce_theplus_purchase_field' ); ?>
						<div class="cmb2-wrap form-table">
							<div id="cmb2-metabox-theplus_purchase_code" class="cmb2-metabox cmb-field-list">
								<div class="cmb-row cmb-type-text cmb2-id-tp-api-key table-layout" data-fieldtype="text">
									<div class="cmb-th">
										<label for="tp_api_key"><?php echo esc_html__("Licence Activation",'theplus'); ?></label>
									</div>
									<div class="cmb-td">
										<?php if($verify_api==1 && !empty($plus_key)){ ?>
											<input type="text" class="regular-text plus-deactivate-key" name="tp_api_key_de" id="tp_api_key" value="**** **** **** **** <?php echo $plus_last_key_char; ?>" placeholder="<?php echo esc_html__("Enter your Key","theplus"); ?>" readonly disabled>
											<input type="hidden" name="action" value="theplus_api_key_deactive">
										<?php }else{ ?>
											<input type="text" class="regular-text" name="tp_api_key" id="tp_api_key" value="<?php echo $plus_key; ?>" placeholder="<?php echo esc_html__("Enter your Key","theplus"); ?>">
											<input type="hidden" name="action" value="theplus_api_key_active">
										<?php } ?>
									</div>
								</div>
							</div>
						</div>
						<?php if($verify_api==1 && !empty($plus_key)){ ?>
							<input type="submit" name="submit-key" value="<?php echo esc_html__("Deactivate","theplus"); ?>" class="button-primary deactivate-plus">
						<?php }else{ ?>
							<input type="submit" name="submit-key" value="<?php echo esc_html__("Activate","theplus"); ?>" class="button-primary">
						<?php } ?>
					</form>
					</div>
					<?php echo theplus_message_display(); ?>
				
				
					</div>
					<div class="tp_active_right_sidebar">
						<div class="tp_active_right_sidebar_wrapper">
							<ul class="tp_active_right_sidebar_list">
								<li>
									<a href="https://store.posimyth.com/checkout/purchase-history/" target="_blank" rel="noopener noreferrer">
									<div class="sidebar_icon"><svg xmlns="http://www.w3.org/2000/svg" width="35.617" height="38.591" viewBox="0 0 35.617 38.591">
									  <g transform="translate(-1.848 -0.75)">
										<path  data-name="Path 7533" d="M12.341,26.544c-.028,0-.06,0-.088-.005a.679.679,0,0,1-.5-.344L6.079,16a.677.677,0,1,1,1.183-.658l5.225,9.4,5.219-5.4a.678.678,0,0,1,.975.941l-5.85,6.06A.691.691,0,0,1,12.341,26.544Z" transform="translate(1.468 5.042)" fill="#8072fc"/>
										<path data-name="Path 7534" d="M21.031,26.544a.681.681,0,0,1-.486-.206l-5.851-6.06a.678.678,0,0,1,.975-.941l5.217,5.4,5.225-9.4A.677.677,0,1,1,27.293,16L21.622,26.2a.684.684,0,0,1-.5.341C21.089,26.541,21.06,26.544,21.031,26.544Z" transform="translate(4.482 5.043)" fill="#8072fc"/>
										<g  data-name="Group 50" transform="translate(1.848 0.75)">
										  <path  data-name="Path 7535" d="M17.668,25.528c-5.626,0-10.194-8.826-10.194-14.585a10.193,10.193,0,1,1,20.386,0C27.86,16.7,23.3,25.528,17.668,25.528Zm0-23.426a8.848,8.848,0,0,0-8.839,8.839c0,4.984,4.133,13.231,8.839,13.231s8.838-8.246,8.838-13.231A8.848,8.848,0,0,0,17.668,2.1Z" transform="translate(0.144 -0.75)" fill="#8072fc"/>
										  <path  data-name="Path 7536" d="M24.463,35.109c-.754,0-1.526-.005-2.322-.011-1.618-.011-3.341-.011-4.961,0-6.341.042-11.355.076-13.825-2.383a5.467,5.467,0,0,1-1.506-4.046c0-4.437,3.617-11.8,9.46-15.965l.785,1.1C6.773,17.591,3.2,24.547,3.2,28.667a4.126,4.126,0,0,0,1.1,3.086c2.072,2.06,7.078,2.028,12.864,1.989,1.622-.011,3.35-.011,4.976,0,5.786.039,10.785.072,12.858-1.989a4.12,4.12,0,0,0,1.1-3.086c0-4.118-3.573-11.074-8.888-14.861l.785-1.1c5.842,4.161,9.457,11.526,9.457,15.965a5.479,5.479,0,0,1-1.507,4.049C33.8,34.862,29.7,35.109,24.463,35.109Z" transform="translate(-1.848 3.483)" fill="#8072fc"/>
										</g>
									  </g>
									</svg></div>
									<div class="sidebar_title"><?php echo esc_html__('Manage Account','theplus'); ?></div>
									</a>	
								</li>
								<li>
									<a href="https://store.posimyth.com/helpdesk" target="_blank" rel="noopener noreferrer">
									<div class="sidebar_icon"><svg xmlns="http://www.w3.org/2000/svg" width="38.842" height="39.5" viewBox="0 0 38.842 39.5"><g >
									<line  data-name="Line 81" stroke="#449fdb" stroke-width="1"/>
								  </g>
								  <path  data-name="Path 7557" d="M45.65,15.8H44.333V11.5c0-4.807-5.348-10.18-12.508-10.18S19.317,6.691,19.317,11.5v4.3H18V11.5C18,6.059,23.679,0,31.825,0S45.65,6.059,45.65,11.5Z" transform="translate(-12.075)" fill="#8072fc"/>
								  <path data-name="Path 7558" d="M103.925,58.483H98.658A.659.659,0,0,1,98,57.825V44.658A.659.659,0,0,1,98.658,44h5.267a.659.659,0,0,1,.658.658V57.825A.659.659,0,0,1,103.925,58.483Zm-4.608-1.317h3.95V45.317h-3.95Z" transform="translate(-65.742 -29.517)" fill="#8072fc"/>
								  <path  data-name="Path 7559" d="M7.925,58.483H2.658A.659.659,0,0,1,2,57.825V44.658A.659.659,0,0,1,2.658,44H7.925a.659.659,0,0,1,.658.658V57.825A.659.659,0,0,1,7.925,58.483ZM3.317,57.167h3.95V45.317H3.317Z" transform="translate(-1.342 -29.517)" fill="#8072fc"/>
								  <path  data-name="Path 7560" d="M37.192,39.5C30.7,39.5,26,30.636,26,24.659V21.744A11.3,11.3,0,0,1,37.192,10.372,11.145,11.145,0,0,1,48.383,21.71v3.326c0,6.549-4.991,14.46-11.192,14.46Zm0-27.807a9.86,9.86,0,0,0-9.875,10.055v2.915c0,5.318,4.241,13.52,9.875,13.52,5.318,0,9.875-7.225,9.875-13.143V21.71a9.844,9.844,0,0,0-9.875-10.021Z" transform="translate(-17.442 -6.958)" fill="#8072fc"/>
								  <path  data-name="Path 7561" d="M62.558,109.269H56.377A2.646,2.646,0,0,1,54,106.714v-.154A2.645,2.645,0,0,1,56.377,104h6.182a.659.659,0,0,1,.658.658v3.95A.659.659,0,0,1,62.558,109.269Zm-6.182-3.95a1.381,1.381,0,0,0-1.06,1.239v.154a1.381,1.381,0,0,0,1.06,1.239H61.9v-2.633H56.377Z" transform="translate(-36.225 -69.769)" fill="#8072fc"/>
								  <path data-name="Path 7562" d="M83.049,93.192H80.658a.658.658,0,1,1,0-1.317h2.391c1.778,0,2.876-2.083,2.876-4.012v-5.2a.658.658,0,1,1,1.317,0v5.2C87.242,90.424,85.639,93.192,83.049,93.192Z" transform="translate(-53.667 -55.008)" fill="#8072fc"/>
								</svg></div>
									<div class="sidebar_title"><?php echo esc_html__('Support Center','theplus'); ?></div>
									</a>	
								</li>
								<li>
									<a href="http://docs.posimyth.com/tpae/" target="_blank" rel="noopener noreferrer">
									<div class="sidebar_icon"><svg  xmlns="http://www.w3.org/2000/svg" width="39.98" height="39.5" viewBox="0 0 39.98 39.5">
									  <g >
										<line data-name="Line 84" stroke="#449fdb" stroke-width="1"/>
									  </g>
									  <path  data-name="Path 7568" d="M3.65,108.471C1.842,108.471,0,106.26,0,104.1a.666.666,0,0,1,1.333,0c0,1.509,1.349,3.04,2.317,3.04a2.756,2.756,0,0,0,2.665-2.769.666.666,0,0,1,1.333,0,2.611,2.611,0,0,0,2.665,2.613,2.682,2.682,0,0,0,2.665-2.693.666.666,0,0,1,1.333,0,2.665,2.665,0,0,0,5.33-.019.666.666,0,0,1,1.333,0,2.665,2.665,0,0,0,5.33-.007.666.666,0,0,1,1.333,0,2.665,2.665,0,0,0,5.33,0,.666.666,0,1,1,1.333,0c0,1.327.694,2.665,2.249,2.665s2.1-1.527,2.1-2.832a.666.666,0,0,1,1.333,0c0,2.452-1.411,4.164-3.43,4.164a3.379,3.379,0,0,1-2.992-1.678,4,4,0,0,1-6.586-.111,4,4,0,0,1-6.662.007,3.995,3.995,0,0,1-6.658.023A4,4,0,0,1,7,106.57a4.023,4.023,0,0,1-3.352,1.9Z" transform="translate(0 -68.971)" fill="#8072fc"/>
									  <path data-name="Path 7569" d="M.666,46.086A.667.667,0,0,1,0,45.42V16.1a.666.666,0,0,1,1.333,0V45.42A.667.667,0,0,1,.666,46.086Z" transform="translate(0 -10.293)" fill="#8072fc"/>
									  <path  data-name="Path 7570" d="M116.666,46.086A.667.667,0,0,1,116,45.42V16.1a.666.666,0,0,1,1.333,0V45.42A.667.667,0,0,1,116.666,46.086Z" transform="translate(-77.354 -10.293)" fill="#8072fc"/>
									  <path  data-name="Path 7571" d="M43.984,2.769H14.666a.666.666,0,1,1,0-1.333H43.984a.666.666,0,0,1,0,1.333Z" transform="translate(-9.336 -0.958)" fill="#8072fc"/>
									  <path  data-name="Path 7572" d="M.666,7.433A.667.667,0,0,1,0,6.766a5.684,5.684,0,0,1,5.316-5.33.666.666,0,1,1,0,1.333,4.385,4.385,0,0,0-3.983,4,.667.667,0,0,1-.666.666Z" transform="translate(0 -0.958)" fill="#8072fc"/>
									  <path  data-name="Path 7573" d="M107.33,7.433a.667.667,0,0,1-.666-.666,4.394,4.394,0,0,0-4-4,.666.666,0,0,1,0-1.333A5.692,5.692,0,0,1,108,6.766.667.667,0,0,1,107.33,7.433Z" transform="translate(-68.018 -0.958)" fill="#8072fc"/>
									  <path  data-name="Path 7574" d="M45.986,18.766H20.666A.667.667,0,0,1,20,18.1v-4a.667.667,0,0,1,.666-.666h25.32a.667.667,0,0,1,.666.666v4A.667.667,0,0,1,45.986,18.766ZM21.333,17.434H45.32V14.769H21.333Z" transform="translate(-13.337 -8.96)" fill="#8072fc"/>
									  <path  data-name="Path 7575" d="M46.653,46.769H22.666a.666.666,0,1,1,0-1.333H46.653a.666.666,0,0,1,0,1.333Z" transform="translate(-14.671 -30.299)" fill="#8072fc"/>
									  <path  data-name="Path 7576" d="M46.653,62.769H22.666a.666.666,0,1,1,0-1.333H46.653a.666.666,0,0,1,0,1.333Z" transform="translate(-14.671 -40.968)" fill="#8072fc"/>
									  <path  data-name="Path 7577" d="M46.653,78.769H22.666a.666.666,0,1,1,0-1.333H46.653a.666.666,0,1,1,0,1.333Z" transform="translate(-14.671 -51.638)" fill="#8072fc"/>
									</svg></div>
									<div class="sidebar_title"><?php echo esc_html__('Documentation','theplus'); ?></div>
									</a>	
								</li>
								<li>
									<a href="https://www.youtube.com/playlist?list=PLFRO-irWzXaLK9H5opSt88xueTnRhqvO5" target="_blank" rel="noopener noreferrer">
									<div class="sidebar_icon"><svg xmlns="http://www.w3.org/2000/svg" width="39.5" height="39.5" viewBox="0 0 39.5 39.5">
									  <g >
										<line  data-name="Line 82" stroke="#449fdb" stroke-width="1"/>
									  </g>
									  <path  data-name="Path 7563" d="M38.842,39.5H.658A.659.659,0,0,1,0,38.842V.658A.659.659,0,0,1,.658,0H38.842A.659.659,0,0,1,39.5.658V38.842A.66.66,0,0,1,38.842,39.5ZM1.317,38.183H38.183V1.317H1.317Z" fill="#8072fc"/>
									  <path  data-name="Path 7564" d="M43.625,97.317H14.658a.658.658,0,1,1,0-1.317H43.625a.658.658,0,1,1,0,1.317Z" transform="translate(-9.392 -64.4)" fill="#8072fc"/>
									  <path  data-name="Path 7565" d="M40.658,35.928A.655.655,0,0,1,40,35.269v-15.2a.658.658,0,0,1,.988-.57l13.167,7.6a.658.658,0,0,1,0,1.14l-13.167,7.6A.652.652,0,0,1,40.658,35.928Zm.658-14.72V34.13l11.192-6.464-11.192-6.46Z" transform="translate(-26.833 -13.02)" fill="#8072fc"/>
									  <path  data-name="Path 7566" d="M27.083,94.754a3.127,3.127,0,1,1,3.127-3.127A3.129,3.129,0,0,1,27.083,94.754Zm0-4.937a1.81,1.81,0,1,0,1.81,1.81A1.813,1.813,0,0,0,27.083,89.817Z" transform="translate(-16.07 -59.369)" fill="#8072fc"/>
									</svg></div>
									<div class="sidebar_title"><?php echo esc_html__('Video Tutorials','theplus'); ?></div>
									</a>	
								</li>
								<li>
									<a href="https://www.facebook.com/groups/theplus4elementor/" target="_blank" rel="noopener noreferrer">
									<div class="sidebar_icon"><svg  xmlns="http://www.w3.org/2000/svg" width="42.5" height="42.5" viewBox="0 0 42.5 42.5">
									  <g >
										<line  data-name="Line 83" stroke="#449fdb" stroke-width="1"/>
									  </g>
									  <path data-name="Path 7567" d="M38.411,42.5h-9.37a.71.71,0,0,1-.708-.708V26.208a.71.71,0,0,1,.708-.708h5.307l1.329-4.25H29.042a.71.71,0,0,1-.708-.708v-6.11c0-1.941,2.112-3.1,5.651-3.1h1.432V7.082h-3.2c-3.7,0-6.714,2.7-6.714,6.021V20.54a.71.71,0,0,1-.708.708H18.417V25.5h6.375a.71.71,0,0,1,.708.708V41.79a.71.71,0,0,1-.708.708H4.766A5.077,5.077,0,0,1,0,37.894V4.25C0,1.818,2.516,0,4.766,0H38.411A4.128,4.128,0,0,1,42.5,4.25V37.9C42.5,40.117,40.857,42.5,38.411,42.5ZM29.75,41.083h8.661c1.577,0,2.672-1.68,2.672-3.187V4.25a2.7,2.7,0,0,0-2.672-2.833H4.766c-1.517,0-3.349,1.264-3.349,2.833V37.9a3.649,3.649,0,0,0,3.349,3.188H24.083V26.917H17.708A.71.71,0,0,1,17,26.208V20.542a.709.709,0,0,1,.708-.708h6.375V13.1c0-4.1,3.646-7.437,8.13-7.437h3.911a.71.71,0,0,1,.708.708v5.667a.71.71,0,0,1-.708.708H33.984c-1.955,0-4.234.441-4.234,1.683v5.4h6.891a.706.706,0,0,1,.674.919l-1.771,5.667a.711.711,0,0,1-.677.5H29.75Z" transform="translate(0)" fill="#8072fc"/>
									</svg></div>
									<div class="sidebar_title"><?php echo esc_html__('Community','theplus'); ?></div>
									</a>	
								</li>
								<li>
									<a href="https://theplusaddons.com/changelog/" target="_blank" rel="noopener noreferrer">
									<div class="sidebar_icon"><svg xmlns="http://www.w3.org/2000/svg" width="35.55" height="39.5" viewBox="0 0 35.55 39.5">
								  <g  transform="translate(-6)">
									<path  data-name="Path 7588" d="M34.308,52.917H6.658A.659.659,0,0,1,6,52.258v-31.6A.659.659,0,0,1,6.658,20h27.65a.659.659,0,0,1,.658.658v31.6A.66.66,0,0,1,34.308,52.917ZM7.317,51.6H33.65V21.317H7.317Z" transform="translate(0 -13.417)" fill="#8072fc"/>
									<path  data-name="Path 7589" d="M103.975,48.258a.654.654,0,0,1-.635-.488l-1.317-4.937a.615.615,0,0,1-.024-.17v-26a.659.659,0,0,1,.658-.658h2.633a.659.659,0,0,1,.658.658v26a.615.615,0,0,1-.024.17L104.61,47.77A.654.654,0,0,1,103.975,48.258Zm-.658-5.68.658,2.469.658-2.469V17.317h-1.317Z" transform="translate(-64.4 -10.733)" fill="#8072fc"/>
									<path  data-name="Path 7590" d="M105.975,33.317h-1.317a.658.658,0,1,1,0-1.317h1.317a.658.658,0,0,1,0,1.317Z" transform="translate(-65.742 -21.467)" fill="#8072fc"/>
									<path  data-name="Path 7591" d="M105.975,93.317h-1.317a.658.658,0,1,1,0-1.317h1.317a.658.658,0,0,1,0,1.317Z" transform="translate(-65.742 -61.717)" fill="#8072fc"/>
									<path  data-name="Path 7592" d="M41.142,7.242a.659.659,0,0,1-.658-.658V5.267H38.328a.659.659,0,0,1-.658-.658c0-2.061-.985-3.292-2.633-3.292H33.39c-1.648,0-2.633,1.231-2.633,3.292a.659.659,0,0,1-.658.658H27.317V6.583a.658.658,0,0,1-1.317,0V4.608a.659.659,0,0,1,.658-.658h2.814C29.726,1.228,31.567,0,33.393,0h1.646c1.825,0,3.663,1.228,3.92,3.95h2.186a.659.659,0,0,1,.658.658V6.583a.663.663,0,0,1-.661.658Z" transform="translate(-13.417)" fill="#8072fc"/>
									<path  data-name="Path 7593" d="M38.408,57.017H18.658A.659.659,0,0,1,18,56.358v-23.7A.659.659,0,0,1,18.658,32h19.75a.659.659,0,0,1,.658.658v23.7A.66.66,0,0,1,38.408,57.017ZM19.317,55.7H37.75V33.317H19.317Z" transform="translate(-8.05 -21.467)" fill="#8072fc"/>
									<path  data-name="Path 7594" d="M43.192,49.317H32.658a.658.658,0,0,1,0-1.317H43.192a.658.658,0,1,1,0,1.317Z" transform="translate(-17.442 -32.2)" fill="#8072fc"/>
									<path  data-name="Path 7595" d="M43.192,65.317H32.658a.658.658,0,0,1,0-1.317H43.192a.658.658,0,1,1,0,1.317Z" transform="translate(-17.442 -42.933)" fill="#8072fc"/>
									<path data-name="Path 7596" d="M43.192,81.317H32.658a.658.658,0,1,1,0-1.317H43.192a.658.658,0,1,1,0,1.317Z" transform="translate(-17.442 -53.667)" fill="#8072fc"/>
								  </g>
								</svg></div>
									<div class="sidebar_title"><?php echo esc_html__('Changelog','theplus'); ?></div>
									</a>	
								</li>
								<li>
									<a href="https://theplusaddons.com/#tpf-footer" target="_blank" rel="noopener noreferrer">
									<div class="sidebar_icon"><svg xmlns="http://www.w3.org/2000/svg" width="52.5" height="38.5" viewBox="0 0 52.5 38.5">
									  <g transform="translate(0 -16)">
										<path  data-name="Path 7578" d="M47.25,54.5h-42A5.256,5.256,0,0,1,0,49.25v-28A5.256,5.256,0,0,1,5.25,16h42a5.256,5.256,0,0,1,5.25,5.25v28A5.256,5.256,0,0,1,47.25,54.5Zm-42-36.75a3.5,3.5,0,0,0-3.5,3.5v28a3.5,3.5,0,0,0,3.5,3.5h42a3.5,3.5,0,0,0,3.5-3.5v-28a3.5,3.5,0,0,0-3.5-3.5Z" fill="#8072fc"/>
										<path  data-name="Path 7579" d="M35.9,49.907a7.666,7.666,0,0,1-5.679-2.539L16.646,32.519a.876.876,0,0,1,1.293-1.181L31.516,46.185a6,6,0,0,0,8.78,0L53.847,31.355a.876.876,0,0,1,1.293,1.183L41.585,47.368A7.676,7.676,0,0,1,35.9,49.907Z" transform="translate(-9.235 -8.467)" fill="#8072fc"/>
										<path  data-name="Path 7580" d="M17.291,73.813a.876.876,0,0,1-.59-1.521l11.938-10.9a.875.875,0,1,1,1.181,1.292l-11.938,10.9a.878.878,0,0,1-.591.229Z" transform="translate(-9.234 -25.403)" fill="#8072fc"/>
										<path  data-name="Path 7581" d="M87.028,73.812a.867.867,0,0,1-.59-.229l-11.945-10.9a.875.875,0,0,1,1.179-1.292l11.946,10.9a.876.876,0,0,1-.59,1.521Z" transform="translate(-41.742 -25.402)" fill="#8072fc"/>
									  </g>
									</svg></div>
									<div class="sidebar_title"><?php echo esc_html__('Subscribe Us','theplus'); ?></div>
									</a>	
								</li>
								<li>
									<a href="https://roadmap.theplusaddons.com/boards/feature-request" target="_blank" rel="noopener noreferrer">
									<div class="sidebar_icon"><svg xmlns="http://www.w3.org/2000/svg" width="47.903" height="39.5" viewBox="0 0 47.903 39.5">
									  <g  transform="translate(-3.004 -13)">
										<path  data-name="Path 7582" d="M10.148,52.5a.841.841,0,0,1-.6-1.435,28.2,28.2,0,0,0,4.8-7.357C7.329,40.7,3,35.347,3,29.6,3,20.446,13.748,13,26.954,13s23.952,7.446,23.952,16.6S40.161,46.2,26.954,46.2c-.808,0-1.654-.035-2.632-.114A18.689,18.689,0,0,1,10.148,52.5ZM26.956,14.681c-12.28,0-22.271,6.691-22.271,14.918,0,5.258,4.244,10.191,11.075,12.872a.841.841,0,0,1,.472,1.094,31.431,31.431,0,0,1-4.16,7.152,17.3,17.3,0,0,0,11.277-6.065.839.839,0,0,1,.7-.277c1.109.1,2.03.141,2.9.141,12.28,0,22.271-6.69,22.271-14.918s-9.989-14.918-22.27-14.918Z" transform="translate(0)" fill="#8072fc"/>
										<path  data-name="Path 7585" d="M38.372,17.213H14.84a.84.84,0,0,1,0-1.681H38.372a.84.84,0,0,1,0,1.681Z" transform="translate(0.348 10.074)" fill="#8072fc"/>
										<path  data-name="Path 7586" d="M38.372,25.213H14.84a.84.84,0,1,1,0-1.681H38.372a.84.84,0,0,1,0,1.681Z" transform="translate(0.348 5.436)" fill="#8072fc"/>
										<path  data-name="Path 7587" d="M26.606,33.213H14.84a.84.84,0,1,1,0-1.681H26.606a.84.84,0,1,1,0,1.681Z" transform="translate(0.348 0.798)" fill="#8072fc"/>
									  </g>
									</svg></div>
									<div class="sidebar_title"><?php echo esc_html__('Feedback','theplus'); ?></div>
									</a>	
								</li>
							</ul>				
						</div>
					</div>	<?php
	}
	
	public function theplus_pro_api_connection_field($args) {		
		return array_merge(
			$args,			
			array(
				array(
					'name' => esc_html__('Site Key reCAPTCHA v3', 'theplus'),
					'desc' => sprintf(__('Note: <a href="https://www.google.com/recaptcha/intro/v3.html" target="_blank" rel="noopener noreferrer">reCAPTCHA v3</a> is a free service by Google that protects your website from spam and abuse.', 'theplus')),
					'default' => '',
					'id' => 'theplus_site_key_recaptcha',
					'type' => 'text',					
				),
				array(
					'name' => esc_html__('Secret Key reCAPTCHA v3', 'theplus'),
					'desc' => sprintf(__('Note: <a href="https://www.google.com/recaptcha/intro/v3.html" target="_blank" rel="noopener noreferrer">reCAPTCHA v3</a> is a free service by Google that protects your website from spam and abuse.', 'theplus')),
					'default' => '',
					'id' => 'theplus_secret_key_recaptcha',
					'type' => 'text',					
				),
				array(
					'name' => esc_html__('Facebook App Id', 'theplus'),
					'desc' => sprintf(__('Note: Generate Facebook App Id using <a href="https://developers.facebook.com/apps" target="_blank" rel="noopener noreferrer">link</a>. This id will be used for your "Login with Facebook" feature in Login/Signup Widget.', 'theplus')),
					'default' => '',
					'id' => 'theplus_facebook_app_id',
					'type' => 'text',
				),
				array(
					'name' => esc_html__('Facebook App Secret', 'theplus'),
					'desc' => sprintf(__('Note: Generate Facebook App Secret using <a href="https://developers.facebook.com/apps" target="_blank" rel="noopener noreferrer">link</a>. This id will be used for your "Login with Facebook" feature in Login/Signup Widget.', 'theplus')),
					'default' => '',
					'id' => 'theplus_facebook_app_secret',
					'type' => 'text',
				),
				array(
					'name' => esc_html__('Google Client Id', 'theplus'),
					'desc' => sprintf(__('Note: Generate Google Client Id using <a href="https://console.developers.google.com/" target="_blank" rel="noopener noreferrer">link</a>. This id will be used for your "Login with Google" feature in Login/Signup Widget.', 'theplus')),
					'default' => '',
					'id' => 'theplus_google_client_id',
					'type' => 'text',
				),
				array(
					'name' => esc_html__('GA4 Measurement ID', 'theplus'),
					'desc' => sprintf(__('<a href="https://theplusaddons.com/docs/track-google-analytics-events-with-elementor?utm_source=wpbackend&utm_medium=elementoreditor&utm_campaign=widget" target="_blank" rel="noopener noreferrer">GA4 Measurement ID</a>. Note : If you have already added your GA4 Code then skip this, or else you can add the measurement ID here to start tracking your traffic.', 'theplus')),
					'default' => '',
					'id' => 'theplus_google_analytics_id',
					'type' => 'text',
					'attributes'  => array(
						'placeholder' => esc_html__('e.g UA-000000-2', 'theplus'),
					),
				),
				array(
					'name' => esc_html__('Facebook Pixel Id', 'theplus'),
					'desc' => sprintf(__('<a href="https://theplusaddons.com/docs/track-facebook-pixel-events-with-elementor?utm_source=wpbackend&utm_medium=elementoreditor&utm_campaign=widget" target="_blank" rel="noopener noreferrer">Generate Facebook Pixel Id</a>. Note : Keep this field empty, If you have already added Tracking Script on Website.', 'theplus')),
					'default' => '',
					'id' => 'theplus_facebook_pixel_id',
					'type' => 'text',
					'attributes'  => array(
						'placeholder' => esc_html__('e.g 38736373773', 'theplus'),
					),
				),
				array(
						'name' => esc_html__('Iconsmind Font Functionality', 'theplus'),
						'desc' => esc_html__('NOTE : If you disable this, It will stop loading frontend and in the backend throughout the website.', 'theplus'),
						'id' => 'load_icons_mind',
						'type' => 'select',
						'show_option_none' => false,
						'default' => 'disable',
						'options' => array(
							'enable' => esc_html__('Enable', 'theplus'),
							'disable' => esc_html__('Disable', 'theplus'),
						),
				),
				array(
	                'name' => esc_html__('Iconsmind in Specific Page/Post', 'theplus'),
	                'desc' => esc_html__('NOTE : You can add Page/Post id with separated by comma to load this fonts on those specific posts or pages.', 'theplus'),
	                'default' => '',
	                'id' => 'load_icons_mind_ids',
	                'type' => 'text',
					'attributes' => array(
						'data-conditional-id'    => 'load_icons_mind',
						'data-conditional-value' => 'disable',
					),
	            ),
				array(
						'name' => esc_html__('Google Map API Key', 'theplus'),
						'desc' => esc_html__('NOTE : Turn Off this key If you theme already have google key option. So, It will not generate error in console for multiple google map keys.', 'theplus'),
						'id' => 'gmap_api_switch',
						'type' => 'select',
						'show_option_none' => false,
						'default' => 'enable',
						'options' => array(
							'none' => esc_html__('None', 'theplus'),
							'enable' => esc_html__('Show', 'theplus'),
							'disable' => esc_html__('Hide', 'theplus'),
						),
				),
				array(
					'name' => esc_html__('Google Map API Key', 'theplus'),
					'desc' => sprintf(__('This field is required if you want to use Advance Google Map element. You can obtain your own Google Maps Key here: (<a href="https://developers.google.com/maps/documentation/javascript/get-api-key">Click Here</a>)', 'theplus')),
					'default' => '',
					'id' => 'theplus_google_map_api',
					'type' => 'text',
					'attributes' => array(
						'data-conditional-id'    => 'gmap_api_switch',
						'data-conditional-value' => 'enable',
					),
				),
				array(
					'name' => esc_html__('Mailchimp API Key', 'theplus'),
					'desc' => esc_html__('Go to your Mailchimp > Account > Extras > API Keys then create a key and paste here', 'theplus'),
					'default' => '',
					'id' => 'theplus_mailchimp_api',
					'type' => 'text',
				),
				array(
					'name' => esc_html__('Mailchimp List ID', 'theplus'),
					'desc' => esc_html__('Go to your Mailchimp > List > Settings > List name and default > Copy the list ID and paste here.', 'theplus'),
					'default' => '',
					'id' => 'theplus_mailchimp_id',
					'type' => 'text',
				),
				array(
						'name' => esc_html__('Pre Loader', 'theplus'),
						'desc' => esc_html__('NOTE : If you disable this, It will stop loading frontend and in the backend throughout the website.', 'theplus'),
						'id' => 'load_pre_loader_func',
						'type' => 'select',
						'show_option_none' => false,
						'default' => 'disable',
						'options' => array(
							'enable' => esc_html__('Enable', 'theplus'),
							'disable' => esc_html__('Disable', 'theplus'),
						),
				),
				array(
					'name' => esc_html__('Load Lottie JS in Pre Loader', 'theplus'),
					'desc' => esc_html__('NOTE : If you enable this, It will load Lottie JS.', 'theplus'),
					'id'   => 'load_pre_loader_lottie_js',
					'type' => 'checkbox',
				),
				array(
					'name' => esc_html__('Pre Loader in Specific Page/Post', 'theplus'),
					'desc' => esc_html__('NOTE : You can add Page/Post id with separated by comma to load this on those specific posts or pages.', 'theplus'),
					'default' => '',
					'id' => 'load_pre_loader_func_ids',
					'type' => 'text',
					'attributes' => array(
						'data-conditional-id'    => 'load_pre_loader_func',
						'data-conditional-value' => 'disable',
					),
				),
				array(
					'name' => esc_html__('Thumbnail (Dynamic Categories)', 'theplus'),
					'desc' => esc_html__('If you enable this option, Thumbnail image option will be available under each custom post type, Which you can use for Dynamic Categories widget.', 'theplus'),
					'id'   => 'dynamic_category_thumb_check',
					'type' => 'checkbox',
				),
				array(
					'name' => esc_html__('WooCommerce Swatches', 'theplus'),
					'desc' => esc_html__('If you enable this option, Swatches option will be available under Product -> Attributes', 'theplus'),
					'id'   => 'theplus_woo_swatches_switch',
					'type' => 'checkbox',
				),
				array(
					'name' => esc_html__('WooCommerce Product Video URL', 'theplus'),
					'desc' => esc_html__('If you enable this option, Video URL option will be available under each product, Which you can use for Woo Single Image widget for Product Gallery.', 'theplus'),
					'id'   => 'theplus_custom_field_video_switch',
					'type' => 'checkbox',
				),
				array(
                    'name' => esc_html__('WooCommerce Recently Viewed', 'theplus'),
                    'desc' => esc_html__('If you enable this option, It will stored single product in list.', 'theplus'),
                    'id'   => 'theplus_woo_recently_viewed_switch',
                    'type' => 'checkbox',
                ),
				array(
					'name' => esc_html__('WooCommerce Countdown', 'theplus'),
					'desc' => sprintf(__('If you enable this option, It will Enable Field in WooCommerce Product Page. <a href="https://theplusaddons.com/docs/sales-countdown-timer-to-a-woocommerce-product-page-in-elementor/?utm_source=wpbackend&utm_medium=elementoreditor&utm_campaign=widget" target="_blank" rel="noopener noreferrer">How it works</a>.', 'theplus')),
					'id'   => 'theplus_woo_countdown_switch',
					'type' => 'checkbox',
				),
				array(
					'name' => __( 'Woocomerce Thank You Page:', 'theplus' ),
					'desc' => __( 'Select WooCommerce Thank You Page using above option. Make sure to add Thank You page widget on selected page to make it work properly.', 'theplus' ),
					'id' => 'theplus_woo_thank_you_page_select',					
					'type' => 'select',					
					'options' => cmb2_get_term_options(),    
				),
				array(
					'name' => esc_html__('Lottiefiles Backend JS', 'theplus'),
					'desc' => esc_html__('You can enable/disable backend JS of lottiefiles using above option. This is master option, So You have to enable this to make it work in elementor backend. You should keep it disable if your backend have any performance issue, Size of this JS is 246KB.', 'theplus'),
					'id'   => 'bodymovin_load_js_check',
					'type' => 'checkbox',
				),
				array(
						'name' => esc_html__('On Scroll View Animation Offset', 'theplus'),
						'desc' => esc_html__('Enter the value which will be used for offset of on scroll view animation. If you select 90, Then It will start taking effect from bottom\'s 10%. Default : 85 E.g. 90,85..etc.', 'theplus'),
						'id' => 'scroll_animation_offset',
						'type' => 'text',
						'attributes' => array(
							'type' => 'number',
							'pattern' => '\d*',
							'min'  => '30',
							'max'  => '120',							
						),
						'sanitization_cb' => 'absint',
						'escape_cb'       => 'absint',
				),
			));
	}
	
	
	public function theplus_pro_white_lab_field($args) {
		return array_merge(
			$args,			
				array(			
					array(
						'name' => esc_html__('Plugin Name (Pro Version)', 'theplus'),
						'desc' => '',
						'default' => '',
						'id' => 'tp_plugin_name',
						'type' => 'text',
						'attributes'  => array(
							'placeholder' => esc_html__('Enter Plugin Name', 'theplus'),
						),
					),
					array(
						'name' => esc_html__('Plugin Description (Pro Version)', 'theplus'),
						'desc' => '',
						'default' => '',
						'id' => 'tp_plugin_desc',
						'type' => 'textarea_small',
						'attributes'  => array(
							'placeholder' => esc_html__('Enter Plugin Description', 'theplus'),
						),
					),
					array(
						'name' => esc_html__('Developer / Agency (Pro Version)', 'theplus'),
						'desc' => '',
						'default' => '',
						'id' => 'tp_author_name',
						'type' => 'text',
						'attributes'  => array(
							'placeholder' => esc_html__('Enter Developer Name', 'theplus'),
						),
					),
					array(
						'name' => esc_html__('Website URL (Pro Version)', 'theplus'),
						'desc' => '',
						'default' => '',
						'id' => 'tp_author_uri',
						'type' => 'text_url',
						'attributes'  => array(
							'placeholder' => esc_html__('Enter Website URL', 'theplus'),
						),
					),
					array(
						'name'    => esc_html__('Plus Icon/Logo','theplus'),
						'desc'    => '',
						'id'      => 'tp_plus_logo',
						'type'    => 'file',
						'options' => array(
							'url' => false,
						),
						'query_args' => array(						
							 'type' => array(
								'image/gif',
								'image/jpeg',
								'image/png',
							 ),
						),
						'preview_size' => 'large',
					),
					array(
						'name' => esc_html__('Plugin Name (Free Version)', 'theplus'),
						'desc' => '',
						'default' => '',
						'id' => 'l_tp_plugin_name',
						'type' => 'text',
						'attributes'  => array(
							'placeholder' => esc_html__('Enter Plugin Name', 'theplus'),
						),
					),
					array(
						'name' => 'Plugin Description (Free Version)',
						'desc' => '',
						'default' => '',
						'id' => 'l_tp_plugin_desc',
						'type' => 'textarea_small',
						'attributes'  => array(
							'placeholder' => esc_html__('Enter Plugin Description', 'theplus'),
						),
					),
					array(
						'name' => esc_html__('Developer / Agency (Free Version)', 'theplus'),
						'desc' => '',
						'default' => '',
						'id' => 'l_tp_author_name',
						'type' => 'text',
						'attributes'  => array(
							'placeholder' => esc_html__('Enter Developer Name', 'theplus'),
						),
					),
					array(
						'name' => esc_html__('Website URL (Free Version)', 'theplus'),
						'desc' => '',
						'default' => '',
						'id' => 'l_tp_author_uri',
						'type' => 'text_url',
						'attributes'  => array(
							'placeholder' => esc_html__('Enter Website URL', 'theplus'),
						),
					),
					array(
						'name' => '',
						'desc' => esc_html__('Enable Force Disable Options : If you enable this option, It will be completely hidden. If you want it back, You have to deactivate and activate plugin to make it work again. ','theplus'),
						'id'   => 'tp_hidden_label',
						'type' => 'checkbox',
					),
					array(
					'id'   => 'tp_white_label_hidden',
					'type' => 'hidden',
					'default' => 'hidden',
					),
			));
	}
	/*Panel Function Overwrite end*/
	
	public function theplus_key_api_form_ac_action() {
		$action_page = 'theplus_purchase_code';
		
		if(isset($_POST["submit-key"]) && !empty($_POST["submit-key"]) && $_POST["submit-key"]=='Activate'){
			
			if ( ! isset( $_POST['nonce_theplus_purchase_field'] ) || ! wp_verify_nonce( $_POST['nonce_theplus_purchase_field'], 'nonce_theplus_purchase_action' ) ) {
			   wp_safe_redirect(admin_url('admin.php?page='.$action_page));
			} else {
				if (FALSE === get_option($action_page)){
					$default_value = array('tp_api_key' => '');
					if(isset($_POST['tp_api_key']) && !empty($_POST['tp_api_key'])){
						$default_value = array('tp_api_key' => $_POST['tp_api_key']);
					}
					add_option($action_page,$default_value);
					theplus_get_api_check();
					wp_safe_redirect(admin_url('admin.php?page='.$action_page));
				}else{
					if(isset($_POST['tp_api_key']) && !empty($_POST['tp_api_key'])){
						$update_value = array('tp_api_key' => $_POST['tp_api_key']);
						//$update_value = serialize($update_value);
						update_option( $action_page, $update_value );
						theplus_get_api_check();
						wp_safe_redirect(admin_url('admin.php?page='.$action_page));
					}else{
						wp_safe_redirect(admin_url('admin.php?page='.$action_page));
					}
				}
			}
		}else{
			wp_safe_redirect(admin_url('admin.php?page='.$action_page));
		}
		
	}
	
	public function theplus_key_api_form_de_action() {
		$action_page = 'theplus_purchase_code';
		if(isset($_POST["submit-key"]) && !empty($_POST["submit-key"]) && $_POST["submit-key"]=='Deactivate'){
			
			if ( ! isset( $_POST['nonce_theplus_purchase_field'] ) || ! wp_verify_nonce( $_POST['nonce_theplus_purchase_field'], 'nonce_theplus_purchase_action' ) ) {
			   wp_safe_redirect(admin_url('admin.php?page='.$action_page));
			} else {
				if ( FALSE === get_option($action_page) ){
					$default_value = array('tp_api_key' => '');
					//$default_value = serialize($default_value);
					add_option($action_page,$default_value);
					wp_safe_redirect(admin_url('admin.php?page=theplus_purchase_code'));
				}else{
					$update_value = array('tp_api_key' => '');
					//$update_value = serialize($update_value);
					update_option( $action_page, $update_value );
					wp_safe_redirect(admin_url('admin.php?page=theplus_purchase_code'));
				}
			}
		}else{
			wp_safe_redirect(admin_url('admin.php?page=theplus_purchase_code'));
		}
	}
       
   
	public function plus_icon_logo(){
		$plus_logo = theplus_white_label_option('tp_plus_logo');
		if(!empty($plus_logo)){
			?>
		<style>.wp-menu-image.dashicons-before.dashicons-plus-settings{background: url(<?php echo esc_url($plus_logo); ?>);background-size: 22px;background-repeat: no-repeat;background-position: center;}.theplus-current-version.wp-badge{background: url(<?php echo esc_url($plus_logo); ?>) center 25px no-repeat;background-size: 35px;background-position: center 30px;}</style>
	<?php }
	}
    
}

function cmb2_get_term_options() {
	$output = [];
	if (  isset( $_GET['page'] ) && $_GET['page'] == 'theplus_api_connection_data' ) {
		$args = [];
		$args['post_type'] = ['page'];
		$args['posts_per_page'] = -1;

		$query = get_posts($args);

		// Initate an empty array
		if ( $query ) {
			$output['']='Select Template';
			foreach ( $query as $post ){        
				$output[ $post->ID ] = $post->post_title;
			}
		}
	}	

    return $output;
}

// Get it started
$Theplus_Elementor_Plugin_Options = new Theplus_Elementor_Plugin_Options();