<?php
   if (!defined('ABSPATH')) {
      exit; // Exit if accessed directly.
   }
   use Elementor\Group_Control_Image_Size;
   $style = $settings['style'];
   $this->add_render_attribute('wrapper', 'class', ['mo-teams-carousel mo-team' , $style ]);
   $this->add_render_attribute('carousel', 'class', ['init-carousel-owl owl-carousel']);
?>

<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
   <div <?php echo $this->get_render_attribute_string('carousel') ?> <?php echo $this->get_carousel_settings() ?>>
      <?php  foreach ($settings['teams'] as $team): ?>
         <div class="item team-item">
            <div class="team-item-inner">
               <figure class="team-member"> 
                  <?php if (!empty($team['team_image']['url'])) : 
                     $image_url = $team['team_image']['url']; 
                     echo '<div class="team-img"><img src="' . esc_url($image_url) .'" alt="'. esc_attr($team['team_name']) . '"/><div class="overlay"></div></div>';
                  endif; ?>

                  <div class="team-title">
                     <h5 class=" data-title" data-title="<?php echo $team['team_name'] ?>"><span><?php echo $team['team_name'] ?></span></h5>	
                     <?php if($team['team_position']){ ?> <h6><?php echo $team['team_position'] ?></h6><?php } ?>
                  </div>
               </figure>
            </div>
         </div>
      <?php endforeach; ?>
   </div>
</div>