<?php
   $title_text = $settings['title_text'];
   $sub_title = $settings['sub_title'];
   $description_text = $settings['description_text'];
  
   $this->add_render_attribute( 'block', 'class', [ 'mo-title-box', 'title-box-'. $settings['style'], 'text-' . $settings['align']]  );

   $this->add_render_attribute( 'title_text', 'class', 'title' );
   $this->add_render_attribute( 'description_text', 'class', 'title-desc' );
   $this->add_render_attribute( 'sub_title', 'class', [ 'sub-title' ] );

   $this->add_inline_editing_attributes( 'title_text', 'none' );
   $this->add_inline_editing_attributes( 'sub_title', 'none' );
   $this->add_inline_editing_attributes( 'description_text' );
   ?>
   <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
      <div class="content-inner">
         <?php if($sub_title){ ?>
            <h5 <?php echo $this->get_render_attribute_string( 'sub_title' ); ?> data-title="<?php echo esc_html($sub_title); ?>"><span><?php echo esc_html($sub_title); ?></span></h5>
         <?php } ?>  
         <?php if($title_text){ ?>
            <h3 <?php echo $this->get_render_attribute_string( 'title_text' ); ?>><?php echo $settings['title_text'] ?></h3>
         <?php } ?>
         <?php if( $description_text && !empty(trim($description_text)) ){ ?>
            <div <?php echo $this->get_render_attribute_string( 'description_text' ); ?>><?php echo wp_kses($description_text, true); ?></div>
         <?php } ?>
      </div>
   </div>
   <div class="clearfix"></div>