<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

require 'includes/overrides.php';
require 'includes/icons.php';
require 'includes/animations.php';

if(!class_exists('Saga_Elementor_Addons')){
  class Saga_Elementor_Addons {

    public function __construct() {
      add_action('elementor/init', array($this, 'add_category'));
      add_action('elementor/widgets/widgets_registered', array($this, 'include_elements'));
      add_action('elementor/frontend/after_register_scripts', [ $this, 'enqueue_frontend_scripts' ] );
      add_action('elementor/frontend/after_enqueue_styles', [ $this, 'enqueue_frontend_styles' ] );
      add_action('elementor/editor/after_enqueue_scripts', [ $this, 'editor_enqueue_styles' ] );
      add_action('elementor/preview/enqueue_styles', function() {
        wp_enqueue_style('owl-carousel-css');
      } );
    }

    public function include_elements($widgets_manager) {
    
      require 'elements/mo-base.php';
     
      require 'elements/mo-heading-block.php';
      $widgets_manager->register_widget_type(new MOElement_Heading_Block());

      require 'elements/mo-heading-fancy.php';
      $widgets_manager->register_widget_type(new MOElement_Heading_Fancy());
     
      require 'elements/mo-button.php';
      $widgets_manager->register_widget_type(new MOElement_Button());

      require 'elements/mo-icon-box.php';
      $widgets_manager->register_widget_type(new MOElement_Icon_Box());

      require 'elements/mo-image-box.php';
      $widgets_manager->register_widget_type(new MOElement_Image_Box());

      require 'elements/mo-image-hover.php';
      $widgets_manager->register_widget_type(new MOElement_Image_Box_Hover());

      require 'elements/mo-image.php';
      $widgets_manager->register_widget_type(new MOElement_Image());

      require 'elements/mo-process-box.php';
      $widgets_manager->register_widget_type(new MOElement_Process_Box());

      require 'elements/mo-circle.php';
      $widgets_manager->register_widget_type(new MOElement_Circle());

      require 'elements/mo-marquee-carousel.php';
      $widgets_manager->register_widget_type(new MOElement_Marquee_Carousel());

      require 'elements/mo-list-number.php';
      $widgets_manager->register_widget_type(new MOElement_List_Number());

      require 'elements/mo-counter.php';
      $widgets_manager->register_widget_type(new MOElement_Counter());

      require 'elements/mo-pricing-block.php';
      $widgets_manager->register_widget_type(new MOElement_Pricing_Block());

      require 'elements/mo-socials.php';
      $widgets_manager->register_widget_type(new MOElement_Socials());

      require 'elements/mo-socials-share.php';
      $widgets_manager->register_widget_type(new MOElement_Socials_Share());

      require 'elements/mo-teams.php';
      $widgets_manager->register_widget_type(new MOElement_Teams());

      require 'elements/mo-teams-carousel.php';
      $widgets_manager->register_widget_type(new MOElement_Teams_Carousel());

      require 'elements/mo-brand.php';
      $widgets_manager->register_widget_type(new MOElement_Brand());

      require 'elements/mo-testimonial.php';
      $widgets_manager->register_widget_type(new MOElement_Testimonial());

      require 'elements/mo-video-box.php';
      $widgets_manager->register_widget_type(new MOElement_Video_Box());

      require 'elements/mo-countdown.php';
      $widgets_manager->register_widget_type(new MOElement_Countdown());

      require 'elements/mo-navigation-menu.php';
      $widgets_manager->register_widget_type(new MOElement_Navigation_Menu());

      require 'elements/mo-search-box.php';
      $widgets_manager->register_widget_type(new MOElement_Search_Box());
     
      require 'elements/mo-map.php';
      $widgets_manager->register_widget_type(new MOElement_Map());

      require 'elements/mo-progress-bars.php';
      $widgets_manager->register_widget_type(new MOElement_Progress());

      require 'elements/mo-accordion.php';
      $widgets_manager->register_widget_type(new MOElement_Accordion());

      require 'elements/mo-tabs.php';
      $widgets_manager->register_widget_type(new MOElement_Tabs());
    
      if(class_exists('RevSlider')){
        require 'elements/mo-rev-slider.php';
        $widgets_manager->register_widget_type(new MOElement_Rev_Slider());
      }
      
      require 'elements/mo-portfolio.php';
      $widgets_manager->register_widget_type(new MOElement_Portfolio());
      
      require 'elements/mo-portfolio-carousel.php';
      $widgets_manager->register_widget_type(new MOElement_Portfolio_Carousel());

      require 'elements/mo-posts.php';
      $widgets_manager->register_widget_type(new MOElement_Posts());

      if ( class_exists( 'WooCommerce' ) ) {
        require 'elements/mo-products.php';
        $widgets_manager->register_widget_type(new MOElement_Products());
      }
    }

    public function add_category() {
      Elementor\Plugin::instance()->elements_manager->add_category(
      'saga_elements',
      array(
        'title' => __('Saga Elements', 'saga'),
        'icon'  => 'fa fa-plug',
      ),
      9);
    }

    
    public function enqueue_frontend_scripts() {
      wp_register_script('jquery.waypoint', SAGA_URI . 'elementor/assets/libs/waypoint.js' , array(), '1.0.0', true);
      wp_register_script('jquery.owl.carousel', SAGA_URI . 'elementor/assets/libs/owl-carousel/owl.carousel.min.js' , array(), '1.0.0', true);
      wp_register_script('jquery.appear', SAGA_URI . 'elementor/assets/libs/jquery.appear.js' , array(), '1.0.0', true);
      wp_register_script('jquery.count_to', SAGA_URI . 'elementor/assets/libs/count-to.js' , array(), '1.0.0', true);
      wp_register_script('jquery.isotope', SAGA_URI . 'elementor/assets/libs/isotope.js' , array(), '1.0.0', true);
      wp_register_script('countdown', SAGA_URI . 'elementor/assets/libs/countdown.js' , array(), '1.0.0', true);
      wp_register_script('easypiechart', SAGA_URI . 'elementor/assets/libs/easypiechart.js' , array(), '1.0.0', true);
      wp_register_script('accordionjs', SAGA_URI . 'elementor/assets/libs/accordionjs.js' , array(), '1.0.0', true);
     //animated
      wp_enqueue_script( 'fastdom', SAGA_URI.'elementor/assets/libs/fastdom.min.js', 'jquery', '1.0', TRUE ); 
      wp_enqueue_script( 'gsap', SAGA_URI.'elementor/assets/libs/gsap.min.js', 'jquery', '1.0', TRUE );  
      wp_enqueue_script( 'parallax', SAGA_URI.'elementor/assets/libs/parallax.js', 'jquery', '1.0', TRUE ); 
      wp_register_script('split', SAGA_URI.'elementor/assets/libs/split.text.js', 'jquery', '1.0', TRUE );  

      wp_register_script('saga.elements', SAGA_URI . 'elementor/assets/main.js' ,  array('imagesloaded', 'jquery-masonry'), '1.0.0', true);

      wp_register_script('map-ui', SAGA_URI . '/elementor/assets/libs/jquery.ui.map.min.js');
     $google_api_key = apply_filters('saga-elements/map-api', '');
     wp_register_script(
       'google-maps-api',
        add_query_arg( array( 'key' => $google_api_key ), 'https://maps.googleapis.com/maps/api/js' ), false, false, true
    );

    // wp_register_script('gmap3', SAGA_URI . '/elementor/assets/libs/gmap3.min.js'); 
    }

    public function enqueue_frontend_styles() {
   //  wp_register_style('owl-carousel-css', SAGA_URI . 'elementor/assets/libs/owl-carousel/assets/owl.carousel.css', false, '1.0.0');
    //  wp_register_style('slick', SAGA_URI . 'elementor/assets/libs/slick/slick.css', false, '1.0.0');
     // wp_enqueue_style('mo-element-base', SAGA_ELEMENTOR_URI . 'assets/css/base.css');
    }

    public function editor_enqueue_styles(){
      wp_enqueue_style('mo-element-base', SAGA_ELEMENTOR_URI . 'assets/css/base.css');
    }
  }     
}

$addons = new Saga_Elementor_Addons();