<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;
class MOElement_Socials_Share extends MOElement_Base{

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'mo-socials-share';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Socials Share', 'saga');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-share';
    }

    public function get_keywords() {
        return [ 'social', 'share', 'content', 'link' ];
    }


    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
			'content_section',
			[
				'label' => __( 'Content', 'saga' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);
        $this->add_control(
			'social_share',
			[
				'label' => __( 'Social Share Buttons', 'saga' ),
				'type' => Controls_Manager::SELECT2,
				'multiple' => true,
				'options' => [
					'facebook'  => __( 'Facebook', 'saga' ),					
					'twitter' => __( 'Twitter', 'saga' ),
					'google'  => __( 'Google Plus', 'saga' ),					
					'pinterest' => __( 'Pinterest', 'saga' ),
					'linkedin'  => __( 'Linkedin', 'saga' ),					
					'buffer' => __( 'Buffer', 'saga' ),
					'digg'  => __( 'Digg', 'saga' ),					
					'reddit' => __( 'Reddit', 'saga' ),
					'tumbleupon'  => __( 'Tumbleupon', 'saga' ),					
					'tumblr' => __( 'Tumblr', 'saga' ),
					'vk' => __( 'Vk', 'saga' ),
					'email' => __( 'Email', 'saga' ),
					'print' => __( 'Print', 'saga' ),
				],
				'default' => [ 'facebook', 'twitter', 'pinterest', 'linkedin' ],
			]
		);

		$this->add_control(
			'social_shape',
			[
				'label' => __( 'Shape', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'solid',
				'options' => [
					'rounded'  => __( 'Rounded', 'saga' ),
					'square' => __( 'Square', 'saga' ),
					'circle' => __( 'Circle', 'saga' ),
				],
			]
		);

		$this->add_responsive_control(
			'text_align',
			[
				'label' => __( 'Alignment', 'saga' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => __( 'Left', 'saga' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'saga' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'saga' ),
						'icon' => 'fa fa-align-right',
					],
				],
				'selectors' => [
					'{{WRAPPER}} .social-share' => 'text-align: {{VALUE}};',
				],
				'default' => 'left',
				'toggle' => true,
			]
		);

		$this->end_controls_section();

		//Style
		$this->start_controls_section(
			'icon_section',
			[
				'label' => __( 'Icon', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'select_color',
			[
				'label' => __( 'Color', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'default_color',
				'options' => [
					'default_color'  => __( 'Official Color', 'saga' ),
					'custom_color' => __( 'Custom', 'saga' ),
				],
			]
		);
		$this->add_control(
			'social_bgcolor',
			[
				'label' => __( 'Primary Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .social-share a' => 'background-color: {{VALUE}};'
				],
				'condition' => [
					'select_color' => 'custom_color',
				]
			]
		);
		$this->add_responsive_control(
			'social_size',
			[
				'label' => __( 'Size', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 6,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .social-share a' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'social_padding',
			[
				'label' => __( 'Padding', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					]
				],
				'selectors' => [
					'{{WRAPPER}} .social-share a' => 'padding: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_responsive_control(
			'social_space',
			[
				'label' => __( 'Spacing', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .social-share a:not(:last-child)' => 'margin-right: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'hr',
			[
				'type' => Controls_Manager::DIVIDER,
			]
		);
		$this->add_control(
			'social_border_radius',
			[
				'label' => __( 'Border Radius', 'saga' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}} .social-share a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}
    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
      $settings = $this->get_settings_for_display();
      printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
         include $this->get_template('mo-socials-share.php');
      print '</div>';
    }
}