<?php
if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;


class MOElement_Portfolio_Carousel extends MOElement_Base{

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'mo-portfolio-carousel';
    }
    public function get_title() {
        return __('Portfolio Carousel', 'saga');
    }
    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-gallery-grid';
    }

    public function get_keywords() {
        return [ 'portfolio', 'content', 'carousel' ];
    }

    public function get_script_depends() {
      return [
          'jquery.owl.carousel',
          'saga.elements',
      ];
    }

    public function get_style_depends() {
      return array('owl-carousel-css');
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'section_portfolio',
            [
                'label' => __('Portfolio', 'saga'),
            ]
        );
        $this->add_control(
			'project_cat',
			[
				'label' => __( 'Select Categories', 'saga' ),
				'type' => Controls_Manager::SELECT2,
				'options' => $this->select_param_cate_project(),
				'multiple' => true,
				'label_block' => true,
				'placeholder' => __( 'All Categories', 'saga' ),
			]
		);
        $this->add_control(
			'project_num',
			[
				'label' => __( 'Show Number Projects', 'saga' ),
				'type' => Controls_Manager::NUMBER,
				'default' => '9',
			]
		);
        $this->add_control(
			'style',
			[
				'label' => __( 'Hover Style', 'saga' ),
				'type' => Controls_Manager::SELECT,
				'default' => 'effect1',
				'options' => [
					'effect1'  	=> __( 'Effect 1', 'saga' ),
					'effect2'  	=> __( 'Effect 2', 'saga' ),
					'effect3'  	=> __( 'Effect 3', 'saga' ),
					'effect4'  	=> __( 'Effect 4', 'saga' ),
				],
			]
		);
        $this->add_responsive_control(
			'image_height',
			[
				'label' => __( 'Height', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 200,
						'max' => 700,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .mo-portfolio-carousel .img-inner, {{WRAPPER}} .mo-portfolio-carousel .wrapper, {{WRAPPER}} .mo-portfolio-carousel .img-inner img, {{WRAPPER}} .mo-portfolio-carousel .wrapper img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();	
        
        $this->start_controls_section(
			'overlay_style_section',
			[
				'label' => __( 'Content', 'saga' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_responsive_control(
			'overlay_align',
			[
				'label' => __( 'Alignment', 'saga' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left'    => [
						'title' => __( 'Left', 'saga' ),
						'icon' => 'fa fa-align-left',
					],
					'center' => [
						'title' => __( 'Center', 'saga' ),
						'icon' => 'fa fa-align-center',
					],
					'right' => [
						'title' => __( 'Right', 'saga' ),
						'icon' => 'fa fa-align-right',
					],
				],				
				'selectors' => [
					'{{WRAPPER}} .portfolio-effect1 .caption-inner, {{WRAPPER}} .portfolio-effect2 .content-block, {{WRAPPER}} .portfolio-effect3 .details, {{WRAPPER}} .portfolio-effect4 .perspective-caption' => 'text-align: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'overlay_bg_color',
			[
				'label' => __( 'Overlay Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-effect1 .img-inner .img-portfolio:before, {{WRAPPER}} .portfolio-effect2 .img-inner:before, {{WRAPPER}} .portfolio-effect3 .details, {{WRAPPER}} .portfolio-effect4 .img-inner .img-perspective:before' => 'background: {{VALUE}};',
				],
			]
		);
		//Title
		$this->add_control(
			'heading_title',
			[
				'label' => __( 'Title', 'saga' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);
		$this->add_responsive_control(
			'title_spacing',
			[
				'label' => __( 'Spacing', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .portfolio-effect1 .caption-inner, {{WRAPPER}} .portfolio-effect2 .content-block h4, {{WRAPPER}} .portfolio-effect2 .content-block .portfolio-cates, {{WRAPPER}} .portfolio-effect3 .details, {{WRAPPER}} .portfolio-effect4 .perspective-caption' => 'padding-top: {{SIZE}}{{UNIT}}; padding-bottom: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'portfolio_title_color',
			[
				'label' => __( 'Title Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-title' => 'color: {{VALUE}};',
				]
			]
		);
		$this->add_control(
			'cat_color',
			[
				'label' => __( 'Category Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default' => '',
				'selectors' => [
					'{{WRAPPER}} .portfolio-cates, {{WRAPPER}} .portfolio-cates a' => 'color: {{VALUE}};',
				],
			]
		);
		$this->end_controls_section();
        $this->add_control_carousel(false);
    }

    protected function select_param_cate_project() {
        $category = get_terms( 'project-type' );
        $cat = array();
        foreach( $category as $item ) {
           if( $item ) {
              $cat[$item->slug] = $item->name;
           }
        }
        return $cat;
  }
    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
      $settings = $this->get_settings_for_display();
      printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
        include $this->get_template('mo-portfolio-carousel.php');
      print '</div>';
    }
}