<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;

class MOElement_Image_Box_Hover extends MOElement_Base{

    /**
     * Get widget name.
     *
     * Retrieve testimonial widget name.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name() {
        return 'mo-image-box-hover';
    }

    /**
     * Get widget title.
     *
     * Retrieve testimonial widget title.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title() {
        return __('Image Box Hover', 'saga');
    }

    /**
     * Get widget icon.
     *
     * Retrieve testimonial widget icon.
     *
     * @since  1.0.0
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon() {
        return 'eicon-posts-carousel';
    }

    public function get_keywords() {
        return [ 'hover', 'content', 'box' ];
    }

    public function get_script_depends() {
      return [
          'jquery.owl.carousel',
          'saga.elements',
      ];
    }

    public function get_style_depends() {
      return array('owl-carousel-css');
    }

    /**
     * Register testimonial widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function register_controls() {
        $this->start_controls_section(
            'front_content',
            [
                'label' => __('Front Content', 'saga'),
            ]
        );
        $this->add_control(
			'image',
			[
				'label' => __( 'Choose Image', 'saga' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
            'selected_icon',
            [
                'label' => __( 'Icon', 'saga' ),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-chevron-right',
                    'library' => 'fa-solid',
                ],
            ]
        );
        $this->add_control(
			'title_text',
			[
				'label' => __( 'Title', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your title', 'saga' ),
				'default' => __( 'Add Your Heading Text Here', 'saga' ),
			]
		);
		$this->add_control(
			'sub_text',
			[
				'label' => __( 'Sub Title', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Your Subtitle', 'saga' ),
			]
		);
        $this->end_controls_section();



        // Back section
        $this->start_controls_section(
            'back_content',
            [
                'label' => __('Back Content', 'saga'),
            ]
        );
        $this->add_control(
			'back_image',
			[
				'label' => __( 'Choose Image', 'saga' ),
				'type' => Controls_Manager::MEDIA,
				'label_block' => true,
				'default' => [
					'url' => Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);
        $this->add_control(
			'back_title_text',
			[
				'label' => __( 'Title', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter your title', 'saga' ),
				'default' => __( 'Add Your Heading Text Here', 'saga' ),
			]
		);
		$this->add_control(
			'back_sub_text',
			[
				'label' => __( 'Sub Title', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'placeholder' => __( 'Enter Your Subtitle', 'saga' ),
			]
		);
        $this->add_control(
			'back_description_text',
			[
				'label' => __( 'Description', 'saga' ),
				'type' => Controls_Manager::TEXTAREA,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'Enter Your Description', 'saga' ),
			]
		);
        $this->add_control(
			'link_text',
			[
				'label' => __( 'Text Link', 'saga' ),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'Read More', 'saga' ),
				'default' => __( 'Read More', 'saga' ),
			]
		);
	    $this->add_control(
			'link',
			[
				'label' => __( 'Link', 'saga' ),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => __( 'https://your-link.com', 'saga' ),
				'label_block' => true
			]
		);
        $this->end_controls_section();
        



        // Style section
		$this->start_controls_section(
			'section_box_style',
			[
				'label' => __( 'Box', 'saga' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
        $this->add_control(
            'style',
            array(
                'label'   => esc_html__( 'Style', 'saga' ),
                'type'    => Controls_Manager::SELECT,
                'default' => 'style-1',
                'options' => [
                  'horizontal_to_right' => esc_html__('horizontal to right', 'saga'),
                  'horizontal_to_left'  => esc_html__('horizontal to left', 'saga'),
                  'vertical_to_bottom'  => esc_html__('vertical to bottom', 'saga'),
                  'vertical_to_top'     => esc_html__('vertical to top', 'saga'),
                ],
				'default' => 'horizontal_to_right',
            )
         );

         $this->add_control(
			'box_front_color',
			[
				'label' => __( 'Front Overlay Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .image-flip-box__front-side:before' => 'background: {{VALUE}};',
				],
			]
		);
        $this->add_control(
			'box_back_color',
			[
				'label' => __( 'Back Overlay Color', 'saga' ),
				'type' => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .image-flip-box__back-side:before' => 'background: {{VALUE}};',
				],
			]
		);
        $this->add_responsive_control(
			'box_height',
			[
				'label' => __( 'Height', 'saga' ),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 100,
						'max' => 800,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .image-flip-box__front-side, .image-flip-box__back-side' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();

    }

    /**
     * Render testimonial widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since  1.0.0
     * @access protected
     */
    protected function render() {
      $settings = $this->get_settings_for_display();
      printf( '<div class="mo-element-%s mo-element">', $this->get_name() );
         include $this->get_template('mo-image-hover.php');
      print '</div>';
    }
}