<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
global $woocommerce_loop;

$classes = '';
if ( ! empty( $settings['infinite_scroll'] ) && $settings['infinite_scroll'] !== 'none' ) {
	$classes = 'infinite_scroll-'.$settings['infinite_scroll'];
	wp_enqueue_script( 'mo-infinite-scroll');
	wp_enqueue_script( 'mo-appear');
}

// Woo Category render
$mo_tax_query = array();
if ( ! empty( $settings['woo_category'] ) ) {
	$categories = $settings['woo_category'];
	if (is_string($settings['woo_category'])){
		$categories    = explode( ',', $settings['woo_category'] );
	}
	$mo_tax_query = array(
		array(
			'taxonomy' => 'product_cat',
			'terms'    => $categories,
			'field'    => 'slug',
			'operator' => 'IN'
		)
	);
}

$product_visibility_terms  = wc_get_product_visibility_term_ids();
$product_visibility_not_in = $product_visibility_terms['exclude-from-catalog'];
if ( 'yes' === get_option( 'woocommerce_hide_out_of_stock_items' ) ) {
	$mo_tax_query[] = array(
		'taxonomy' => 'product_visibility',
		'field'    => 'name',
		'terms'    => array( 'outofstock', 'exclude-from-catalog' ),
		'operator' => 'NOT IN',
	);
} else {
	$mo_tax_query[] = array(
		'taxonomy' => 'product_visibility',
		'field'    => 'term_taxonomy_id',
		'terms'    => $product_visibility_not_in,
		'operator' => 'NOT IN',
	);
}
$mo_tax_query['relation'] = 'AND';

// Select filter sortby
$orderby = $settings['orderby'];
$order   = $settings['order'];
if ( isset( $_GET['orderby'] ) ) {
	$orderby_value = explode( '-', $_GET['orderby'] );
	$orderby       = esc_attr( $orderby_value[0] );
	$order         = ! empty( $orderby_value[1] ) ? $orderby_value[1] : $order;
	if ( $_GET['orderby'] == 'price' ) {
		$order = 'ASC';
	}
}

$ordering_args = WC()->query->get_catalog_ordering_args( $orderby, $order );
$meta_query    = WC()->query->get_meta_query();

// Pagination setup
$paged = ( get_query_var( 'paged' ) ) ? get_query_var( 'paged' ) : 1;

// Select how many products to show
$per_page = $settings['rows_per_page'];
if ( isset( $_GET['show'] ) ) {
	if ( $_GET['show'] === 'all' ) {
		$per_page = apply_filters( 'mo_products_per_page', '-1' );
	} else {
		$per_page = $_GET['show'];
	}
}

$args = array(
	'post_type'           => 'product',
	'post_status'         => 'publish',
	'ignore_sticky_posts' => 1,
	'orderby'             => $ordering_args['orderby'],
	'order'               => $ordering_args['order'],
	'meta_key'            => $ordering_args['meta_key'],
	'posts_per_page'      => $per_page,
	'paged'               => $paged,
	'meta_query'          => $meta_query,
	'tax_query'           => $mo_tax_query
);

global $products;
$products = new \WP_Query( apply_filters( 'woocommerce_shortcode_products_query', $args, $settings ) );

if ( !$products->have_posts() && $products->get( 'paged' ) > 1 ) {
	$products->set( 'paged', 1 );
	set_query_var('paged', 1);
	$products->get_posts();
}

$gap = ! empty( $settings['grid_gap'] ) && is_array( $settings['grid_gap'] ) ? 'width:' . $settings['grid_gap']['size'] . $settings['grid_gap']['unit'] : '';
ob_start();

if ( $products->have_posts() ) {
	$view_all = isset($_COOKIE['mo-show_all']) ? $_COOKIE['mo-show_all'] : NULL;
	if ( (bool) $settings['dropdown_prod_orderby'] ) : ?>
         <div class="mo-products-header"><?php
			if ( (bool) $settings['dropdown_prod_orderby'] ) {
				get_template_part( 'woocommerce/mo-templates/loop/orderby' ); // Orderby
			}
			?></div> <!-- mo-products-header -->
	<?php endif; ?>

	<?php do_action( 'mo_woocommerce_before_shop_loop' ); ?>

         
   <div class="woocommerce mo-products-grid  <?php echo $settings['woo-style'] ?>">
    <div class="products">
		<?php while ( $products->have_posts() ) {
			$products->the_post();
         echo get_template_part( 'woocommerce/mo-templates/style', $settings['woo-style']);
		} ?>
    </div>
   </div>
	<?php do_action( 'mo_woocommerce_after_shop_loop' );
if ( (bool) $settings['dropdown_prod_orderby'] || (bool) $settings['pagination'] ) {
	if ( (bool) $settings['pagination'] ) : ?>
        <div class="<?php echo $settings['pagination_postion'] ?>">
		    <?php get_template_part( 'woocommerce/mo-templates/default-pagination' ); ?>
        </div>
	<?php
	endif; 
  }
}
wp_reset_postdata();
echo '<div class="woocommerce mo-shop-list '.esc_attr($classes).'">' . ob_get_clean() . '</div>';