<?php
   use Elementor\Icons_Manager;
   if ( empty( $settings['title_text'] ) ) {
      return;
   }
   $title_text = $settings['title_text'];
   $best_label = $settings['best_label'];
  
   $this->add_render_attribute('best_label', 'style', array(
      $settings['best_label'] ? 'pricing-best' : '',
   ));
 
   $this->add_render_attribute( 'block', 'class', [ 'pricing-item', $settings['style'], $settings['best_label'] ? 'pricing-best' : '' ] );

   $this->add_render_attribute( 'title_text', 'class', 'title' );

   $this->add_inline_editing_attributes( 'title_text', 'none' );
   
   $image_url = $settings['image']['url']; 

   if(empty($settings['button_url']['url'])) {
      $settings['button_url']['url'] = '#';
   }
   $this->add_render_attribute('href', 'href', esc_url($settings['button_url']['url']));
   if($settings['button_url']['is_external']) {
      $this->add_render_attribute('href', 'target', '_blank');
   }
   if(!empty($settings['button_url']['nofollow'])) {
      $this->add_render_attribute('href', 'rel', 'nofollow');
   }
?>

<div <?php echo $this->get_render_attribute_string( 'block' ) ?>>
   <div class="content-inner">
       
     <?php if(!empty($settings['txt_label'])) { ?>
       <?php echo '<span class="pricing-best-label '.esc_html($settings['style']).'">'. $settings['txt_label'] .'</span>'; ?>
     <?php } ?> 

       <div class="pricing-title">
         <?php if(!empty($settings['title_text']) && $settings['style'] == 'style1' ) { ?>
            <h3 <?php echo $this->get_render_attribute_string( 'title_text' ); ?>><?php echo $settings['title_text'] ?></h3>
         <?php } ?>
         <?php if($image_url){ ?>
               <div class="content-img">
                  <div class="package-img">
                     <img src="<?php echo $image_url ?>" alt="<?php echo esc_html($settings['title_text']) ?>" />
                  </div>
               </div>
            <?php } ?> 
       </div>

		 <div class="pricing"> 
           <span class="pricing-currency">
              <span class="currency"><?php echo esc_html( $settings['currency'] ) ?> </span>
              <span class="price"><?php echo esc_html( $settings['price'] ) ?> </span>
            </span>
           <span class="pricing-period"><?php echo esc_html( $settings['period'] ) ?></span>
		 </div>

       <?php if(!empty($settings['title_text']) && $settings['style'] == 'style2' || !empty($settings['title_text']) && $settings['style'] == 'style3' || !empty($settings['title_text']) && $settings['style'] == 'style4') { ?>
         <h3 <?php echo $this->get_render_attribute_string( 'title_text' ); ?>><?php echo $settings['title_text'] ?></h3>
       <?php } ?>

       <?php if($settings['pricing_content']){ ?>
         <ul class="content">
            <?php foreach ($settings['pricing_content'] as $key => $item) { ?>
               <?php $has_icon = ! empty( $item['selected_icon']['value']); ?>
               <li>
                  <span class="text"><?php echo $item['pricing_features'] ?></span>
                  <?php if ( $has_icon ){ ?>
                     <span class="icon"><?php Icons_Manager::render_icon( $item['selected_icon'], [ 'aria-hidden' => 'true' ] ); ?></span>
                  <?php } ?>
               </li>  
            <?php } ?>
         </ul>
      <?php } ?>   

      <?php if($settings['button_url']['url']){ ?>
         <div class="text-center">
            <a class="button btn-solid dark hr_light bg_grey bg_hr_dark radius4 roll" <?php $this->print_render_attribute_string('href') ?>>
               <span class="mo_module_button__container"><span class="mo_module_button__cover front"><span class="mo_btn_text front"><?php echo esc_html($settings['button_text']) ?></span><span class="mo_btn_text back"><?php echo esc_html($settings['button_text']) ?></span></span></span>
            </a>
        </div>
      <?php } ?>

   </div>
</div>