<div class="project-filter-wrapper">
  <?php if( 'yes' === $settings['filter'] ) { ?>
	<ul class="project_filters">
		<?php if( $settings['all_text'] ) { ?>
			<li><a href="#" data-filter="*" class="selected"><?php echo esc_html( $settings['all_text'] ); ?></a></li>
		<?php } ?>
		<?php
		if( $settings['project_cat'] ){
			$categories = $settings['project_cat'];
			foreach( (array)$categories as $categorie){
				$cates = get_term_by('slug', $categorie, 'project-type');
				$cat_name = $cates->name;
				$cat_id   = 'category-' . $cates->term_id;

		?>
			<li><a href='#' data-filter='.<?php echo esc_attr( $cat_id ); ?>'><?php echo esc_html( $cat_name ); ?></a></li>	                   
		<?php } }else{
			$categories = get_terms('project-type');
			foreach( (array)$categories as $categorie){
				$cat_name = $categorie->name;
				$cat_id   = 'category-' . $categorie->term_id;
			?>
			<li><a href='#' data-title="<?php echo esc_attr($cat_name);?>" data-filter='.<?php echo esc_attr($cat_id);?>'><span><?php echo esc_html($cat_name); ?></span></a></li>	  
		<?php } } ?>
	</ul>
  <?php } ?>

<div class="projects-grid projects-<?php echo $settings['layout']; if( $settings['column'] == '5' ){ echo ' pf_5_cols'; }elseif( $settings['column'] == '4' ){ echo ' pf_4_cols'; }elseif( $settings['column'] == '2' ){ echo ' pf_2_cols'; }else{ echo ''; } ?>">
	<?php
	if( $settings['project_cat'] ){
		$args = array(	                    
			'post_type' => 'portfolio',
			'post_status' => 'publish',
			'posts_per_page' => $settings['project_num'],
			'tax_query' => array(
				array(
					'taxonomy' => 'project-type',
					'field' => 'slug',
					'terms' => $settings['project_cat'],
				),
			),              
		);
	}else{
		$args = array(
			'post_type' => 'portfolio',
			'post_status' => 'publish',
			'posts_per_page' => $settings['project_num'],
		);
	}
	$wp_query = new \WP_Query($args);
	while ($wp_query -> have_posts()) : $wp_query -> the_post();
		$cates 	   = get_the_terms(get_the_ID(),'project-type');
		$cate_id   = '';
		foreach((array)$cates as $cate){
			if($cates){
				$cate_id   .= 'category-' . $cate->term_id . ' ';
			}
		}
		global $post;
		$attachment = get_the_post_thumbnail( $post->ID , "saga-lg-heigh");
		$src_attachment = get_the_post_thumbnail_url();
	?>

   <div class="project-item <?php echo esc_attr( $cate_id ); ?>">
		<div class="portfolio-<?php echo $settings['style']; ?>">
	       <?php echo get_template_part('framework/shortcodes/portfolio/item', $settings['style'] ); ?>
		   </div>
		</div>
	<?php endwhile; wp_reset_postdata(); ?>
  </div>
</div>