<?php
   use Elementor\Icons_Manager;
   $this->add_render_attribute('wrapper', 'class', ['service iconbox' , 'icon-box-' . $settings['style'] ]);
   $i = 0;

   if ( ! empty( $settings['button_link']['url'] ) ) {
      $this->add_render_attribute( 'link', 'href', $settings['button_link']['url'] );
      $icon_tag = 'a';
      if ( $settings['button_link']['is_external'] ) {
         $this->add_render_attribute( 'link', 'target', '_blank' );
      }
      if ( $settings['button_link']['nofollow'] ) {
         $this->add_render_attribute( 'link', 'rel', 'nofollow' );
      }
   }
?>
<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
   <div class="content-inner">
      <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
      <div class="title-wrap">
         <h6  class="title" data-title="<?php echo $settings['title'] ?>"><span><?php echo $settings['title'] ?></span></h6>	
         <?php if($settings['content']){ ?> <div class="content"><?php echo $settings['content'] ?></div><?php } ?>
         <?php
            if ( ! empty( $settings['button_link']['url'] ) ) {
               if( $settings['style'] == 'style9' || $settings['style'] == 'style8' || $settings['style'] == 'style4') {
                  echo '<a class="button btn-absolute" '. $this->get_render_attribute_string( 'link' ). '><span class="mo_btn_text">'. esc_html($settings['button_title']) .'</span></a>';
               }
               if( $settings['style'] == 'style6' || $settings['style'] == 'style7' ) {
                  echo '<a class="button btn-txt btn-txt-arrow2 dark hr_dark" '. $this->get_render_attribute_string( 'link' ). '><span class="mo_module_button__container"><span class="mo_module_button__cover front"><span class="mo_btn_text front">'. esc_html($settings['button_title']) .'</span></span><span class="arrows"><span class="arrow"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="30px" height="18px" viewBox="0 0 30 18" enable-background="new 0 0 30 18" xml:space="preserve"><path class="handle" d="M20.305,16.212c-0.407,0.409-0.407,1.071,0,1.479s1.068,0.408,1.476,0l7.914-7.952c0.408-0.409,0.408-1.071,0-1.481l-7.914-7.952c-0.407-0.409-1.068-0.409-1.476,0s-0.407,1.071,0,1.48l7.185,7.221L20.305,16.212z"></path><path class="bar" fill-rule="evenodd" clip-rule="evenodd" d="M1,8h28.001c0.551,0,1,0.448,1,1c0,0.553-0.449,1-1,1H1c-0.553,0-1-0.447-1-1C0,8.448,0.447,8,1,8z"></path></svg> <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="30px" height="18px" viewBox="0 0 30 18" enable-background="new 0 0 30 18" xml:space="preserve"><path class="handle" d="M20.305,16.212c-0.407,0.409-0.407,1.071,0,1.479s1.068,0.408,1.476,0l7.914-7.952c0.408-0.409,0.408-1.071,0-1.481l-7.914-7.952c-0.407-0.409-1.068-0.409-1.476,0s-0.407,1.071,0,1.48l7.185,7.221L20.305,16.212z"></path><path class="bar" fill-rule="evenodd" clip-rule="evenodd" d="M1,8h28.001c0.551,0,1,0.448,1,1c0,0.553-0.449,1-1,1H1c-0.553,0-1-0.447-1-1C0,8.448,0.447,8,1,8z"></path></svg></span></span></span></a>';
               }
               if( $settings['style'] == 'style5' || $settings['style'] == 'style3') {
                  echo '<a '.$this->get_render_attribute_string( 'link' ).' class="btn_more_link"><span class="mo_btn_text">'. esc_html($settings['button_title']) .'</span><span class="link_icon"><svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="20px" height="20px" viewBox="0 0 30 18" enable-background="new 0 0 30 18" xml:space="preserve"><path class="handle" d="M20.305,16.212c-0.407,0.409-0.407,1.071,0,1.479s1.068,0.408,1.476,0l7.914-7.952c0.408-0.409,0.408-1.071,0-1.481l-7.914-7.952c-0.407-0.409-1.068-0.409-1.476,0s-0.407,1.071,0,1.48l7.185,7.221L20.305,16.212z"></path><path class="bar" fill-rule="evenodd" clip-rule="evenodd" d="M1,8h28.001c0.551,0,1,0.448,1,1c0,0.553-0.449,1-1,1H1c-0.553,0-1-0.447-1-1C0,8.448,0.447,8,1,8z"></path></svg></span></a>';
               }
               if( $settings['style'] == 'style1' || $settings['style'] == 'style2' ||  $settings['style'] == 'style10') {
                  echo '<a class="btn-arrow" '. $this->get_render_attribute_string( 'link' ).'><span class="mo_btn_text"><svg><path stroke="null" d="m26.875,13.1l-1.275,-1.275l3.625,-3.625l0.85,-0.575l-0.1,-0.3l-1.025,0.125l-29.45,0.125l-0.125,-1.7l29.575,-0.25l1.025,0.15l0.1,-0.3l-0.85,-0.575l-3.625,-3.625l1.275,-1.275l5.9,5.9l0,1.3l-5.9,5.9z"/></svg></span></a>';
               }
            }
         ?>
      </div>
   </div>   
</div>