<?php

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

$products_count = wc_get_default_products_per_row() * wc_get_default_product_rows_per_page();

$mo_shop_list_options = get_query_var( 'mo_shop_list_options_'.get_the_ID() );
if ( $mo_shop_list_options && $mo_shop_list_options['per_page'] ) $products_count = $mo_shop_list_options['per_page'];

$products_count = !empty($products_count) ? $products_count : 9;

$orderby = isset( $_GET['show'] ) ? wc_clean( $_GET['show'] ) : 'default';
$show_default_orderby    = 'menu_order' === apply_filters( 'woocommerce_default_catalog_orderby', get_option( 'woocommerce_default_catalog_orderby' ) );

$catalog_orderby_options = array(
	$products_count => esc_html__( 'Default', 'saga' ),
	$products_count*2 => $products_count*2,
	$products_count*4 => $products_count*4,
);

?>
<form class="woocommerce-ordering products-show" method="get">
	<p class="mo-products-header-sort_by"><?php esc_html_e('Show:', 'saga'); ?></p>
	<div class="mo-woocommerce-ordering-select">
		<select name="show" class="orderby" title="<?php esc_attr_e('orderby', 'saga'); ?>">
			<?php foreach ( $catalog_orderby_options as $id => $name ) : ?>
				<option value="<?php echo esc_attr( $id ); ?>" <?php selected( $orderby, $id ); ?>><?php echo esc_html( $name ); ?></option>
			<?php endforeach; ?>
		</select>
	</div>
	<?php wc_query_string_form_fields( null, array( 'show', 'submit' ) ); ?>
</form>