<?php
/**
 * Review order table
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/review-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you (the theme developer).
 * will need to copy the new files to your theme to maintain compatibility. We try to do this.
 * as little as possible, but it does happen. When this occurs the version of the template file will.
 * be bumped and the readme will list any important changes.
 *
 * @see 	    http://docs.woothemes.com/document/template-structure/
 * @author 		WooThemes
 * @package 	WooCommerce/Templates
 * @version     8.6.0
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
?>
<div class="shop_table woocommerce-checkout-review-order-table">
	<h3 class="order-review-heading"><?php esc_html_e( 'Your order', 'saga' ); ?></h3>
	<ul>
		<li class="header">
			<span class="col-left product-name"><?php esc_html_e( 'Product', 'saga' ); ?></span>
			<span class="col-right product-total"><?php esc_html_e( 'Total', 'saga' ); ?></span>
		</li>
		<?php
			do_action( 'woocommerce_review_order_before_cart_contents' );

			foreach ( WC()->cart->get_cart() as $cart_item_key => $cart_item ) {
				$_product     = apply_filters( 'woocommerce_cart_item_product', $cart_item['data'], $cart_item, $cart_item_key );

				if ( $_product && $_product->exists() && $cart_item['quantity'] > 0 && apply_filters( 'woocommerce_checkout_cart_item_visible', true, $cart_item, $cart_item_key ) ) {
					?>
					<li class="<?php echo esc_attr( apply_filters( 'woocommerce_cart_item_class', 'cart_item', $cart_item, $cart_item_key ) ); ?>">
						<span class="col-left product-name">
							<?php echo apply_filters( 'woocommerce_cart_item_name', $_product->get_title(), $cart_item, $cart_item_key ) . '&nbsp;'; 
							 echo apply_filters( 'woocommerce_checkout_cart_item_quantity', ' <strong class="product-quantity">' . sprintf( '&times; %s', $cart_item['quantity'] ) . '</strong>', $cart_item, $cart_item_key ); 
							echo wc_get_formatted_cart_item_data( $cart_item ); ?>
						</span>
						<span class="col-right product-total">
							<?php echo apply_filters( 'woocommerce_cart_item_subtotal', WC()->cart->get_product_subtotal( $_product, $cart_item['quantity'] ), $cart_item, $cart_item_key ); ?>
						</span>
					</li>
					<?php
				}
			}

			do_action( 'woocommerce_review_order_after_cart_contents' );
		?>

		<li class="cart-subtotal">
			<span class="col-left"><?php esc_html_e( 'Subtotal', 'saga' ); ?></span>
			<span class="col-right"><?php wc_cart_totals_subtotal_html(); ?></span>
		</li>

		<?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
			<li class="cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
				<span class="col-left"><?php wc_cart_totals_coupon_label( $coupon ); ?></span>
				<span class="col-right"><?php wc_cart_totals_coupon_html( $coupon ); ?></span>
			</li>
		<?php endforeach; 
		if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) :
		do_action( 'woocommerce_review_order_before_shipping' );
		 wc_cart_totals_shipping_html();
		 do_action( 'woocommerce_review_order_after_shipping' );
		 endif;
		 
		  foreach ( WC()->cart->get_fees() as $fee ) : ?>
			<li class="fee">
				<span class="col-left"><?php echo esc_html( $fee->name ); ?></span>
				<span class="col-right"><?php wc_cart_totals_fee_html( $fee ); ?></span>
			</li>
		<?php endforeach;
		
		if ( wc_tax_enabled() && 'excl' === WC()->cart->tax_display_cart ) : 
		 if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : 
		 foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : ?>
					<li class="tax-rate tax-rate-<?php echo sanitize_title( $code ); ?>">
						<span class="col-left"><?php echo esc_html( $tax->label ); ?></span>
						<span class="col-right"><?php echo wp_kses_post( $tax->formatted_amount ); ?></span>
					</li>
				<?php endforeach; 
				else : ?>
				<li class="tax-total">
					<span class="col-left"><?php echo esc_html( WC()->countries->tax_or_vat() ); ?></span>
					<span class="col-right"><?php wc_cart_totals_taxes_total_html(); ?></span>
				</li>
			<?php endif; 
			endif; 
			 do_action( 'woocommerce_review_order_before_order_total' ); ?>

		<li class="order-total">
			<span class="col-left"><?php esc_html_e( 'Total', 'saga' ); ?></span>
			<span class="col-right"><?php wc_cart_totals_order_total_html(); ?></span>
		</li>

		<?php do_action( 'woocommerce_review_order_after_order_total' ); ?>
	</ul>
</div>
