<?php
$title=get_the_title();
$th_is_lightbox = 'lightbox-gallery';
$thumb = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );
$full = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );
$permalink=get_the_permalink();

global $post;
$src_attachment = get_the_post_thumbnail_url();
									
$portfolio_type = get_post_meta($post->ID, 'link_type', true);
$video=get_post_meta(get_the_ID(),'link_url',true);
$url=get_post_meta(get_the_ID(),'url',true);
if($portfolio_type == 'direct' && !empty($video) )
{
	$full=$video;
	$th_is_lightbox = 'lightbox-video';
}
if( $portfolio_type == 'external' && !empty($url) )
{
	$full=$url;
	$th_is_lightbox = '';
}
if( $portfolio_type == 'single_page')
{
	$full= get_the_permalink();
	$th_is_lightbox = '';
}
?>
<a class="<?php echo esc_attr($th_is_lightbox); ?>" data-title="<?php echo esc_attr($title); ?>" href="<?php echo esc_url($full); ?>">
	<div class="img-inner"><div class="img-perspective" style="background-image: url(<?php echo esc_url($src_attachment); ?>)"></div></div>
	<div class="overlay-inner"></div>
	<div class="perspective-caption">
		<h5 class="portfolio-title"><?php echo esc_html($title);?> </h5>
		 <?php $terms = get_the_terms( get_the_ID(), 'project-type' );	
		 if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) :
			 echo '<p class="portfolio-cates">';	 
			 foreach ( $terms as $term ) {
				 // The $term is an object, so we don't need to specify the $taxonomy.
				 $term_link = get_term_link( $term );
				 // If there was an error, continue to the next term.
				 if ( is_wp_error( $term_link ) ) {
					 continue;
				 }
				 // We successfully got a link. Print it out.
				 echo '<span class="term">' . $term->name . '</span><span class="divider">/</span>';
			 }		                         
			 echo '</p>';    
		 endif; ?>  
	</div>
</a>