<?php
$th_is_lightbox = 'lightbox-gallery';
$thumb = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );
$full = wp_get_attachment_url( get_post_thumbnail_id(get_the_ID()) );
$permalink=get_the_permalink();

global $post;
$src_attachment = get_the_post_thumbnail_url();
									
$portfolio_type = get_post_meta($post->ID, 'link_type', true);
$video=get_post_meta(get_the_ID(),'link_url',true);
$url=get_post_meta(get_the_ID(),'url',true);

if($portfolio_type == 'direct' && !empty($video) ){
	$full=$video;
	$th_is_lightbox = 'lightbox-video';
}
if( $portfolio_type == 'external' && !empty($url) ){
	$full=$url;
	$th_is_lightbox = '';
}
if( $portfolio_type == 'single_page'){
	$full= get_the_permalink();
	$th_is_lightbox = '';
}?>
<div class="img-inner">
	<div class="img-portfolio" style="background-image: url(<?php echo esc_url($src_attachment); ?>)">
		<a class="portfolio-link <?php echo esc_attr($th_is_lightbox);?>" data-title="<?php echo esc_attr($title);?>" href="<?php echo esc_url($full);?>"></a>	
	</div>
</div>
<div class="caption-inner">
	<a class="portfolio-link <?php echo esc_attr($th_is_lightbox);?>" data-title="<?php echo esc_attr($title);?>" href="<?php echo esc_url($full);?>"><h5 class="portfolio-title"><?php the_title(); ?></h5></a>	
	<?php 
		$terms = get_the_terms( get_the_ID(), 'project-type' );	
		if ( ! is_wp_error( $terms ) && ! empty( $terms ) ) :
			echo '<p class="portfolio-cates">';	 
			foreach ( $terms as $term ) {
				$term_link = get_term_link( $term );
				if ( is_wp_error( $term_link ) ) {
					continue;
				}
				echo '<a class="term" data-title="'. $term->name .'" href="' . esc_url( $term_link ) . '"><span>'. $term->name .'</span></a><span class="divider">/</span>';
			}		                         
			echo '</p>';    
		endif; 
	 ?> 
</div>