<?php
   use Elementor\Icons_Manager;
   $this->add_render_attribute('wrapper', 'class', ['mo-team' , $settings['style'] ]);
   $i = 0;
?>
<div <?php echo $this->get_render_attribute_string('wrapper'); ?>>
   <figure class="team-member"> 
      <?php if (!empty($settings['image']['url'])) : 
         $image_url = $settings['image']['url']; 
         $image_html = '<div class="team-img"><img src="' . esc_url($image_url) .'" alt="'. esc_attr($settings['name']) . '"/><div class="overlay"></div></div>';
         $this->mo_render_link_html($image_html); 
      endif; ?>

      <div class="team-social social-icons style1">

         <?php if( $settings['style'] == 'tpl1' ) { ?>
            <span class="mo-team-icon-opener"><a href="#"><i class="fa-solid fa-share-nodes"></i></a></span>
         <?php } ?>
         <?php foreach ($settings['socials'] as $social): ?>
            <a class="mo-team-icon" href="<?php echo esc_url($social['social_link']) ?>" title="<?php echo esc_attr($social['social_title']) ?>"><i class="<?php echo esc_attr($social['social_icon']) ?>"></i></a>
         <?php endforeach; ?>
      </div>

      <div class="team-title">
         <h5 class="data-title" data-title="<?php echo $settings['name'] ?>"><span><?php echo $settings['name'] ?></span></h5>	
         <?php if($settings['position']){ ?> <h6><?php echo $settings['position'] ?></h6><?php } ?>
      </div>
   </figure>
</div>