<?php
   use Elementor\Icons_Manager;
   if ( empty( $settings['title_text'] ) ) {
      return;
   }
   $title_text = $settings['title_text'];
   $sub_title = $settings['sub_title'];
   $description_text = $settings['description_text'];
   $style = $settings['style'];
   
   $this->add_render_attribute( 'block', 'class', ['process-box', 'process-box-'.$settings['style']] );
   $this->add_render_attribute( 'title_text', 'class', 'title' );
   $this->add_render_attribute( 'description_text', 'class', 'desc' );

   $this->add_inline_editing_attributes( 'title_text', 'none' );
   $this->add_inline_editing_attributes( 'sub_title', 'none' );
   $this->add_inline_editing_attributes( 'description_text' );
?>
   <div <?php echo $this->get_render_attribute_string( 'block' ) ?>>

      <div class="process-wrap clearfix">

         <div class="number-icon-wrap">
            <?php if($sub_title){ ?> <div class="number-step"><h3><?php echo esc_html($sub_title); ?></h3></div> <?php } ?>
            <div class="icon-wrap"><?php Icons_Manager::render_icon( $settings['selected_icon'], [ 'aria-hidden' => 'true', 'class' => array('icon') ] ); ?></div>
         </div>

         <?php if($title_text){ ?>
            <h6 <?php echo $this->get_render_attribute_string( 'title_text' ); ?>>
               <span><?php echo $settings['title_text'] ?></span>
            </h6>
         <?php } ?>
         
         <?php if($description_text){ ?>
            <div class="content"><span <?php echo $this->get_render_attribute_string( 'description_text' ); ?>><?php echo wp_kses($description_text, true); ?></span></div>
         <?php } ?>
     
         <?php if($settings['button_url']['url']){
            if($style == 'style1' || $style == 'style3' || $style == 'style2' || $style == 'style3'){ 
               echo '<div class="process-link">
               <a class="btn-arrow" href="'.$settings['button_url']['url'].'"><span class="mo_btn_text"><svg><path stroke="null" d="m26.875,13.1l-1.275,-1.275l3.625,-3.625l0.85,-0.575l-0.1,-0.3l-1.025,0.125l-29.45,0.125l-0.125,-1.7l29.575,-0.25l1.025,0.15l0.1,-0.3l-0.85,-0.575l-3.625,-3.625l1.275,-1.275l5.9,5.9l0,1.3l-5.9,5.9z"></path></svg></span></a>
               </div>';
            }
            if($style == 'style4'){ 
               echo '<div class="process-link">
               <a class="button btn-txt btn-txt-arrow larg" href="'.$settings['button_url']['url'].'"> <span class="mo_module_button__container"><span class="mo_module_button__cover front"></span><svg class="svg-arrow" xmlns="http://www.w3.org/2000/svg" x="0" y="0" viewBox="0 0 11.9 11.9" xml:space="preserve"><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path><path d="M.4 11.5 11.4.6M11.4 10V.5H1.9"></path></svg></span></a>
               </div>';					
            } 
         } ?>

      </div>
   </div>